/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive1_2;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive1_3 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveVersion = "1.3";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache 2.0";
    private static final Date creationDate = new Date(1516313040008L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive1_3() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive1_3(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive1_2 previousTypes = new OpenMetadataTypesArchive1_2(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0205ConnectionLinkage();
        this.update0605OpenDiscoveryAnalysisReports();
        this.add0655AssetDeduplication();
    }

    private void update0205ConnectionLinkage() {
        this.archiveBuilder.addTypeDefPatch(this.updateEmbeddedConnection());
    }

    private TypeDefPatch updateEmbeddedConnection() {
        String typeName = "EmbeddedConnection";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("EmbeddedConnection");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "position";
        String attribute1Description = "Position that embedded connection should be processed.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("position", "Position that embedded connection should be processed.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0605OpenDiscoveryAnalysisReports() {
        this.archiveBuilder.addTypeDefPatch(this.updateOpenDiscoveryAnalysisReport());
    }

    private TypeDefPatch updateOpenDiscoveryAnalysisReport() {
        String typeName = "OpenDiscoveryAnalysisReport";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("OpenDiscoveryAnalysisReport");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "discoveryRequestStep";
        String attribute1Description = "Current Step that an in-progress discovery service request has reached.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("discoveryRequestStep", "Current Step that an in-progress discovery service request has reached.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0655AssetDeduplication() {
        this.archiveBuilder.addEntityDef(this.getSuspectDuplicateAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getDivergentDuplicateAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getDivergentValueAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getDivergentClassificationAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getDivergentRelationshipAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getDivergentAttachmentAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getDivergentAttachmentValueAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getDivergentAttachmentClassificationAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getDivergentAttachmentRelationshipAnnotationEntity());
    }

    private EntityDef getSuspectDuplicateAnnotationEntity() {
        String guid = "f703a621-4078-4c07-ab22-e7c334b94235";
        String name = "SuspectDuplicateAnnotation";
        String description = "Annotation linking referenceables that are suspected of being duplicates.";
        String descriptionGUID = null;
        String superTypeName = "Annotation";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("f703a621-4078-4c07-ab22-e7c334b94235", "SuspectDuplicateAnnotation", this.archiveBuilder.getEntityDef("Annotation"), "Annotation linking referenceables that are suspected of being duplicates.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "duplicateAnchorGUIDs";
        String attribute1Description = "List of unique identifiers for the suspects.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "matchingPropertyNames";
        String attribute2Description = "List of properties that are the same in the suspects.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "matchingClassificationNames";
        String attribute3Description = "List of classifications that are the same in the suspects.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "matchingAttachmentGUIDs";
        String attribute4Description = "List of attachments that are the same in the suspects.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "matchingRelationshipGUIDs";
        String attribute5Description = "List of direct relationships that are the same in the suspects.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute("duplicateAnchorGUIDs", "List of unique identifiers for the suspects.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("matchingPropertyNames", "List of properties that are the same in the suspects.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("matchingClassificationNames", "List of classifications that are the same in the suspects.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("matchingAttachmentGUIDs", "List of attachments that are the same in the suspects.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("matchingRelationshipGUIDs", "List of direct relationships that are the same in the suspects.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDivergentDuplicateAnnotationEntity() {
        String guid = "251e443c-dee0-47fa-8a73-1a9d511915a0";
        String name = "DivergentDuplicateAnnotation";
        String description = "Annotation documenting differences in the values of acknowledged duplicates.";
        String descriptionGUID = null;
        String superTypeName = "Annotation";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("251e443c-dee0-47fa-8a73-1a9d511915a0", "DivergentDuplicateAnnotation", this.archiveBuilder.getEntityDef("Annotation"), "Annotation documenting differences in the values of acknowledged duplicates.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "duplicateAnchorGUID";
        String attribute1Description = "Unique identifier of the duplicate where the differences have been found.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("duplicateAnchorGUID", "Unique identifier of the duplicate where the differences have been found.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDivergentValueAnnotationEntity() {
        String guid = "b86cdded-1078-4e42-b6ba-a718c2c67f62";
        String name = "DivergentValueAnnotation";
        String description = "Annotation documenting differences in the property values of acknowledged duplicates.";
        String descriptionGUID = null;
        String superTypeName = "DivergentDuplicateAnnotation";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("b86cdded-1078-4e42-b6ba-a718c2c67f62", "DivergentValueAnnotation", this.archiveBuilder.getEntityDef("DivergentDuplicateAnnotation"), "Annotation documenting differences in the property values of acknowledged duplicates.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "divergentPropertyNames";
        String attribute1Description = "Names of the properties where a difference has been found.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute("divergentPropertyNames", "Names of the properties where a difference has been found.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDivergentClassificationAnnotationEntity() {
        String guid = "8efd6257-a53e-451d-abfc-8e4899c38b1f";
        String name = "DivergentClassificationAnnotation";
        String description = "Annotation documenting differences in a classification of acknowledged duplicates.";
        String descriptionGUID = null;
        String superTypeName = "DivergentDuplicateAnnotation";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("8efd6257-a53e-451d-abfc-8e4899c38b1f", "DivergentClassificationAnnotation", this.archiveBuilder.getEntityDef("DivergentDuplicateAnnotation"), "Annotation documenting differences in a classification of acknowledged duplicates.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "divergentClassificationName";
        String attribute1Description = "Name of the classification where a difference has been found.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "divergentClassificationPropertyNames";
        String attribute2Description = "Names of the properties where a difference has been found.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("divergentClassificationName", "Name of the classification where a difference has been found.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("divergentClassificationPropertyNames", "Names of the properties where a difference has been found.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDivergentRelationshipAnnotationEntity() {
        String guid = "b6c6938a-fdc9-438f-893c-0b5b1d4a5bb3";
        String name = "DivergentRelationshipAnnotation";
        String description = "Annotation documenting differences in a relationships of acknowledged duplicates.";
        String descriptionGUID = null;
        String superTypeName = "DivergentDuplicateAnnotation";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("b6c6938a-fdc9-438f-893c-0b5b1d4a5bb3", "DivergentRelationshipAnnotation", this.archiveBuilder.getEntityDef("DivergentDuplicateAnnotation"), "Annotation documenting differences in a relationships of acknowledged duplicates.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "divergentRelationshipGUID";
        String attribute1Description = "Unique identifier of the relationship where a difference has been found.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "divergentRelationshipPropertyNames";
        String attribute2Description = "Names of the properties where a difference has been found.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("divergentRelationshipGUID", "Unique identifier of the relationship where a difference has been found.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("divergentRelationshipPropertyNames", "Names of the properties where a difference has been found.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDivergentAttachmentAnnotationEntity() {
        String guid = "f3ed48bc-b0ea-4e1f-a8ab-75f9f3cf87a6";
        String name = "DivergentAttachmentAnnotation";
        String description = "Annotation documenting differences in the attachments of acknowledged duplicates.";
        String descriptionGUID = null;
        String superTypeName = "DivergentDuplicateAnnotation";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("f3ed48bc-b0ea-4e1f-a8ab-75f9f3cf87a6", "DivergentAttachmentAnnotation", this.archiveBuilder.getEntityDef("DivergentDuplicateAnnotation"), "Annotation documenting differences in the attachments of acknowledged duplicates.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "attachmentGUID";
        String attribute1Description = "Unique identifier of the attachment where the differences have been found.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "duplicateAttachmentGUID";
        String attribute2Description = "Unique identifier of the attachment in the duplicate where the differences have been found.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("attachmentGUID", "Unique identifier of the attachment where the differences have been found.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("duplicateAttachmentGUID", "Unique identifier of the attachment in the duplicate where the differences have been found.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDivergentAttachmentValueAnnotationEntity() {
        String guid = "e22a1ffe-bd90-4faf-b6a1-13fafb7948a2";
        String name = "DivergentAttachmentValueAnnotation";
        String description = "Annotation documenting differences in the property values in attachments of acknowledged duplicates.";
        String descriptionGUID = null;
        String superTypeName = "DivergentAttachmentAnnotation";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("e22a1ffe-bd90-4faf-b6a1-13fafb7948a2", "DivergentAttachmentValueAnnotation", this.archiveBuilder.getEntityDef("DivergentAttachmentAnnotation"), "Annotation documenting differences in the property values in attachments of acknowledged duplicates.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "divergentPropertyNames";
        String attribute1Description = "Names of the properties where a difference has been found.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute("divergentPropertyNames", "Names of the properties where a difference has been found.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDivergentAttachmentClassificationAnnotationEntity() {
        String guid = "a2a5cb74-f8e0-470f-be71-26b7e32166a6";
        String name = "DivergentAttachmentClassificationAnnotation";
        String description = "Annotation documenting differences in a classification of an attachment of acknowledged duplicates.";
        String descriptionGUID = null;
        String superTypeName = "DivergentAttachmentAnnotation";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("a2a5cb74-f8e0-470f-be71-26b7e32166a6", "DivergentAttachmentClassificationAnnotation", this.archiveBuilder.getEntityDef("DivergentAttachmentAnnotation"), "Annotation documenting differences in a classification of an attachment of acknowledged duplicates.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "divergentClassificationName";
        String attribute1Description = "Name of the classification where a difference has been found.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "divergentClassificationPropertyNames";
        String attribute2Description = "Names of the properties where a difference has been found.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("divergentClassificationName", "Name of the classification where a difference has been found.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("divergentClassificationPropertyNames", "Names of the properties where a difference has been found.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDivergentAttachmentRelationshipAnnotationEntity() {
        String guid = "5613677a-865f-474e-8044-4167fa5a31b9";
        String name = "DivergentAttachmentRelationshipAnnotation";
        String description = "Annotation documenting differences in a relationships of an attachment of acknowledged duplicates.";
        String descriptionGUID = null;
        String superTypeName = "DivergentAttachmentAnnotation";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("5613677a-865f-474e-8044-4167fa5a31b9", "DivergentAttachmentRelationshipAnnotation", this.archiveBuilder.getEntityDef("DivergentAttachmentAnnotation"), "Annotation documenting differences in a relationships of an attachment of acknowledged duplicates.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "divergentRelationshipGUID";
        String attribute1Description = "Unique identifier of the relationship where a difference has been found.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "divergentRelationshipPropertyNames";
        String attribute2Description = "Names of the properties where a difference has been found.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("divergentRelationshipGUID", "Unique identifier of the relationship where a difference has been found.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("divergentRelationshipPropertyNames", "Names of the properties where a difference has been found.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }
}

