/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector;

import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.OMRSMetadataCollection;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSMetadataCollectionManager;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryValidator;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.RepositoryErrorException;

public abstract class OMRSRepositoryConnector
extends ConnectorBase
implements OMRSMetadataCollectionManager,
AuditLoggingComponent {
    protected OMRSRepositoryHelper repositoryHelper = null;
    protected OMRSRepositoryValidator repositoryValidator = null;
    protected String repositoryName = null;
    protected String serverName = null;
    protected String serverType = null;
    protected String organizationName = null;
    protected String serverUserId = null;
    protected int maxPageSize = 1000;
    protected String metadataCollectionId = null;
    protected String metadataCollectionName = null;
    protected OMRSMetadataCollection metadataCollection = null;
    protected AuditLog auditLog = null;

    @Override
    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
        if (this.metadataCollection != null) {
            this.metadataCollection.setAuditLog(auditLog);
        }
    }

    @Override
    public void setRepositoryHelper(OMRSRepositoryHelper repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public OMRSRepositoryHelper getRepositoryHelper() {
        return this.repositoryHelper;
    }

    @Override
    public void setRepositoryValidator(OMRSRepositoryValidator repositoryValidator) {
        this.repositoryValidator = repositoryValidator;
    }

    public OMRSRepositoryValidator getRepositoryValidator() {
        return this.repositoryValidator;
    }

    @Override
    public String getRepositoryName() {
        return this.repositoryName;
    }

    @Override
    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public String getServerType() {
        return this.serverType;
    }

    @Override
    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    @Override
    public String getOrganizationName() {
        return this.organizationName;
    }

    @Override
    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    @Override
    public String getServerUserId() {
        return this.serverUserId;
    }

    @Override
    public void setServerUserId(String localServerUserId) {
        this.serverUserId = localServerUserId;
    }

    @Override
    public String getMetadataCollectionId() {
        return this.metadataCollectionId;
    }

    @Override
    public void setMetadataCollectionId(String metadataCollectionId) {
        this.metadataCollectionId = metadataCollectionId;
    }

    public String getMetadataCollectionName() {
        if (this.metadataCollectionName != null) {
            return this.metadataCollectionName;
        }
        return this.serverName;
    }

    public void setMetadataCollectionName(String metadataCollectionName) {
        this.metadataCollectionName = metadataCollectionName;
    }

    @Override
    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    @Override
    public void setMaxPageSize(int maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public void validateRepositoryIsActive(String methodName) throws RepositoryErrorException {
        if (!super.isActive()) {
            throw new RepositoryErrorException(OMRSErrorCode.REPOSITORY_NOT_AVAILABLE.getMessageDefinition(this.serverName, methodName), this.getClass().getName(), methodName);
        }
    }

    @Override
    public OMRSMetadataCollection getMetadataCollection() throws RepositoryErrorException {
        if (this.metadataCollection == null) {
            String methodName = "getMetadataCollection";
            throw new RepositoryErrorException(OMRSErrorCode.NULL_METADATA_COLLECTION.getMessageDefinition(this.serverName), this.getClass().getName(), "getMetadataCollection");
        }
        return this.metadataCollection;
    }
}

