/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeTypeDef;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AttributeTypeDefListResponse
extends OMRSAPIResponse {
    private static final long serialVersionUID = 1L;
    private List<AttributeTypeDef> attributeTypeDefs = null;

    public AttributeTypeDefListResponse() {
    }

    public AttributeTypeDefListResponse(AttributeTypeDefListResponse template) {
        super(template);
        if (template != null) {
            this.attributeTypeDefs = template.getAttributeTypeDefs();
        }
    }

    public List<AttributeTypeDef> getAttributeTypeDefs() {
        if (this.attributeTypeDefs == null) {
            return null;
        }
        if (this.attributeTypeDefs.isEmpty()) {
            return null;
        }
        ArrayList<AttributeTypeDef> clonedTypeDefs = new ArrayList<AttributeTypeDef>();
        for (AttributeTypeDef attributeTypeDef : this.attributeTypeDefs) {
            clonedTypeDefs.add(attributeTypeDef.cloneFromSubclass());
        }
        return clonedTypeDefs;
    }

    public void setAttributeTypeDefs(List<AttributeTypeDef> attributeTypeDefs) {
        this.attributeTypeDefs = attributeTypeDefs;
    }

    @Override
    public String toString() {
        return "AttributeTypeDefListResponse{relatedHTTPCode=" + this.relatedHTTPCode + ", actionDescription='" + this.actionDescription + "', exceptionClassName='" + this.exceptionClassName + "', exceptionCausedBy='" + this.exceptionCausedBy + "', exceptionErrorMessage='" + this.exceptionErrorMessage + "', exceptionErrorMessageId='" + this.exceptionErrorMessageId + "', exceptionErrorMessageParameters=" + Arrays.toString(this.exceptionErrorMessageParameters) + ", exceptionSystemAction='" + this.exceptionSystemAction + "', exceptionUserAction='" + this.exceptionUserAction + "', exceptionProperties=" + this.exceptionProperties + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AttributeTypeDefListResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AttributeTypeDefListResponse that = (AttributeTypeDefListResponse)objectToCompare;
        return Objects.equals(this.getAttributeTypeDefs(), that.getAttributeTypeDefs());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAttributeTypeDefs());
    }
}

