/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.archiveutilities.catalogbuilder.CatalogTypesArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;

public class SimpleGovernanceCatalogArchiveBuilder
extends CatalogTypesArchiveBuilder {
    private static final String archiveGUID = "e915f2fa-aaac-4396-8bde-bcd65e642b1d";
    private static final String archiveRootName = "SimpleGovernanceCatalog";
    private static final String archiveName = "Simple Governance Catalog";
    private static final String archiveLicense = "Apache 2.0";
    private static final String archiveDescription = "Sample metadata showing governance definitions and linking relationships.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "Egeria";
    private static final Date creationDate = new Date(1632046251579L);
    private static final String glossaryQualifiedName = "MainGlossary";
    private static final String glossaryDisplayName = "Main Glossary";
    private static final String glossaryDescription = "Canonical glossary for the organization.";
    private static final String glossaryLanguage = "English";
    private static final String glossaryUsage = "For simple demos";
    private static final String glossaryScope = "Minimal for simple demos";
    private static final String uniqueCustomerIdentifierQualifiedName = "MainGlossary/Unique_Customer_Identifier";
    private static final String uniqueCustomerIdentifierDisplayName = "UniqueCustomerIdentifier";
    private static final String uniqueCustomerIdentifierDescription = "Unique identifier for a customer generated on first contact.";
    private static final String eventCustomerIdQualifiedName = "global-event-bus/CustomerDomain/EventAttributes/CustomerIdentifiers/customerId";
    private static final String apiCustomerNoRequestQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer/request/customerNo";
    private static final String apiCustomerNoResponseQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer/response/customerNo";
    private static final String dbCustIdQualifiedName = "V37B8752.FH567.sys/BRANCH.RETAILSCHEMA.CUSTOMER.CUSTID";
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";

    public SimpleGovernanceCatalogArchiveBuilder(List<OpenMetadataArchive> dependentArchives) {
        super(archiveGUID, archiveName, archiveDescription, archiveType, archiveRootName, originatorName, archiveLicense, creationDate, 1L, versionName, dependentArchives);
    }

    @Override
    public OpenMetadataArchive getOpenMetadataArchive() {
        String glossaryGUID = super.addGlossary(glossaryQualifiedName, glossaryDisplayName, glossaryDescription, glossaryLanguage, glossaryUsage, null, glossaryScope);
        String glossaryTermGUID = super.addTerm(glossaryGUID, null, uniqueCustomerIdentifierQualifiedName, uniqueCustomerIdentifierDisplayName, uniqueCustomerIdentifierDescription);
        String elementGUID = this.idToGUIDMap.getGUID(eventCustomerIdQualifiedName);
        super.linkTermToReferenceable(glossaryTermGUID, elementGUID);
        elementGUID = this.idToGUIDMap.getGUID(apiCustomerNoRequestQualifiedName);
        super.linkTermToReferenceable(glossaryTermGUID, elementGUID);
        elementGUID = this.idToGUIDMap.getGUID(apiCustomerNoResponseQualifiedName);
        super.linkTermToReferenceable(glossaryTermGUID, elementGUID);
        elementGUID = this.idToGUIDMap.getGUID(dbCustIdQualifiedName);
        super.linkTermToReferenceable(glossaryTermGUID, elementGUID);
        return super.getOpenMetadataArchive();
    }
}

