/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_4;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_5 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.5";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache 2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_5() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_5(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_4 previousTypes = new OpenMetadataTypesArchive2_4(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010BaseEntity();
        this.update0017ExternalIdentifiers();
        this.add0056AssetManager();
        this.add0395SupplementaryProperties();
        this.update0750DataPassing();
        this.update0770LineageMapping();
    }

    private void update0010BaseEntity() {
        this.archiveBuilder.addEntityDef(this.addOpenMetadataRootEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateReferenceable());
        this.archiveBuilder.addTypeDefPatch(this.updateLastAttachment());
        this.archiveBuilder.addTypeDefPatch(this.updateSearchKeyword());
        this.archiveBuilder.addTypeDefPatch(this.updateLike());
        this.archiveBuilder.addTypeDefPatch(this.updateRating());
        this.archiveBuilder.addTypeDefPatch(this.updateInformalTag());
        this.archiveBuilder.addTypeDefPatch(this.updateAnnotation());
        this.archiveBuilder.addTypeDefPatch(this.updateAnnotationReview());
        this.archiveBuilder.addTypeDefPatch(this.updateDataField());
        this.archiveBuilder.addTypeDefPatch(this.updateAnchorsClassification());
    }

    private EntityDef addOpenMetadataRootEntity() {
        String guid = "4e7761e8-3969-4627-8f40-bfe3cde85a1d";
        String name = "OpenMetadataRoot";
        String description = "Common root for all open metadata entity types.";
        String descriptionGUID = null;
        return this.archiveHelper.getDefaultEntityDef("4e7761e8-3969-4627-8f40-bfe3cde85a1d", "OpenMetadataRoot", null, "Common root for all open metadata entity types.", descriptionGUID);
    }

    private TypeDefPatch updateReferenceable() {
        String typeName = "Referenceable";
        String superTypeName = "OpenMetadataRoot";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Referenceable");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("OpenMetadataRoot"));
        return typeDefPatch;
    }

    private TypeDefPatch updateLastAttachment() {
        String typeName = "LastAttachment";
        String superTypeName = "OpenMetadataRoot";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("LastAttachment");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("OpenMetadataRoot"));
        return typeDefPatch;
    }

    private TypeDefPatch updateSearchKeyword() {
        String typeName = "SearchKeyword";
        String superTypeName = "OpenMetadataRoot";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SearchKeyword");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("OpenMetadataRoot"));
        return typeDefPatch;
    }

    private TypeDefPatch updateLike() {
        String typeName = "Like";
        String superTypeName = "OpenMetadataRoot";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Like");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("OpenMetadataRoot"));
        return typeDefPatch;
    }

    private TypeDefPatch updateRating() {
        String typeName = "Rating";
        String superTypeName = "OpenMetadataRoot";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Rating");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("OpenMetadataRoot"));
        return typeDefPatch;
    }

    private TypeDefPatch updateInformalTag() {
        String typeName = "InformalTag";
        String superTypeName = "OpenMetadataRoot";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("InformalTag");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("OpenMetadataRoot"));
        return typeDefPatch;
    }

    private TypeDefPatch updateAnnotation() {
        String typeName = "Annotation";
        String superTypeName = "OpenMetadataRoot";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Annotation");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("OpenMetadataRoot"));
        return typeDefPatch;
    }

    private TypeDefPatch updateAnnotationReview() {
        String typeName = "AnnotationReview";
        String superTypeName = "OpenMetadataRoot";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("AnnotationReview");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("OpenMetadataRoot"));
        return typeDefPatch;
    }

    private TypeDefPatch updateDataField() {
        String typeName = "DataField";
        String superTypeName = "OpenMetadataRoot";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataField");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("OpenMetadataRoot"));
        return typeDefPatch;
    }

    private TypeDefPatch updateAnchorsClassification() {
        String typeName = "Anchors";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Anchors");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("OpenMetadataRoot"));
        typeDefPatch.setValidEntityDefs(linkedToEntities);
        return typeDefPatch;
    }

    private void update0017ExternalIdentifiers() {
        this.archiveBuilder.addEnumDef(this.getPermittedSynchronizationEnum());
        this.archiveBuilder.addTypeDefPatch(this.updateExternalIdScopeRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateExternalIdLinkRelationship());
    }

    private EnumDef getPermittedSynchronizationEnum() {
        String guid = "973a9f4c-93fa-43a5-a0c5-d97dbd164e78";
        String name = "PermittedSynchronization";
        String description = "Defines the synchronization rules between a third party technology and open metadata.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("973a9f4c-93fa-43a5-a0c5-d97dbd164e78", "PermittedSynchronization", "Defines the synchronization rules between a third party technology and open metadata.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "BothDirections";
        String element1Description = "Metadata exchange is permitted in both directions.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "BothDirections", "Metadata exchange is permitted in both directions.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "ToThirdParty";
        String element2Description = "The third party technology is logically downstream of open metadata and is just receiving metadata.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "ToThirdParty", "The third party technology is logically downstream of open metadata and is just receiving metadata.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "FromThirdParty";
        String element3Description = "The third party technology is logically upstream and is publishing metadata to open metadata.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "FromThirdParty", "The third party technology is logically upstream and is publishing metadata to open metadata.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element8Ordinal = 99;
        String element8Value = "Other";
        String element8Description = "Another synchronization rule.";
        String element8DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another synchronization rule.", element8DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private TypeDefPatch updateExternalIdScopeRelationship() {
        String typeName = "ExternalIdScope";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ExternalIdScope");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "permittedSynchronization";
        String attribute1Description = "Defines the permitted directions of flow of metadata updates between open metadata and a third party technology.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Additional description of the type of synchronization occurring.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("PermittedSynchronization", "permittedSynchronization", "Defines the permitted directions of flow of metadata updates between open metadata and a third party technology.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Additional description of the type of synchronization occurring.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateExternalIdLinkRelationship() {
        String typeName = "ExternalIdLink";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ExternalIdLink");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "OpenMetadataRoot";
        String end1AttributeName = "resources";
        String end1AttributeDescription = "Resource being identified.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OpenMetadataRoot"), "resources", "Resource being identified.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "lastSynchronized";
        String attribute1Description = "Timestamp documenting the last time the metadata in the external metadata source was synchronized with open metadata element.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "mappingProperties";
        String attribute2Description = "Additional properties to aid the mapping to the the element in an external metadata source.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("lastSynchronized", "Timestamp documenting the last time the metadata in the external metadata source was synchronized with open metadata element.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("mappingProperties", "Additional properties to aid the mapping to the the element in an external metadata source.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0056AssetManager() {
        this.archiveBuilder.addClassificationDef(this.addAssetManagerClassification());
    }

    private ClassificationDef addAssetManagerClassification() {
        String guid = "03170ce7-edf1-4e94-b6ab-2d5cbbf1f13c";
        String name = "AssetManager";
        String description = "Defines a capability that manages metadata about assets.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        return this.archiveHelper.getClassificationDef("03170ce7-edf1-4e94-b6ab-2d5cbbf1f13c", "AssetManager", null, "Defines a capability that manages metadata about assets.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), false);
    }

    private void add0395SupplementaryProperties() {
        this.archiveBuilder.addClassificationDef(this.addElementSupplementClassification());
        this.archiveBuilder.addRelationshipDef(this.getSupplementaryPropertiesRelationship());
    }

    private ClassificationDef addElementSupplementClassification() {
        String guid = "58520015-ce6e-47b7-a1fd-864030544819";
        String name = "ElementSupplement";
        String description = "Identifies a glossary term that is being used to supplement asset descriptions.";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryTerm";
        return this.archiveHelper.getClassificationDef("58520015-ce6e-47b7-a1fd-864030544819", "ElementSupplement", null, "Identifies a glossary term that is being used to supplement asset descriptions.", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryTerm"), false);
    }

    private RelationshipDef getSupplementaryPropertiesRelationship() {
        String guid = "2bb10ba5-7aa2-456a-8b3a-8fdbd75c95cd";
        String name = "SupplementaryProperties";
        String description = "Provides additional descriptive properties to augment technical metadata extracted from a third party technology.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2bb10ba5-7aa2-456a-8b3a-8fdbd75c95cd", "SupplementaryProperties", null, "Provides additional descriptive properties to augment technical metadata extracted from a third party technology.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "supplementsElement";
        String end1AttributeDescription = "Describes this technical element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "supplementsElement", "Describes this technical element.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "supplementaryProperties";
        String end2AttributeDescription = "Provides more information about this element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "supplementaryProperties", "Provides more information about this element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0750DataPassing() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateProcessInputRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateProcessOutputRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateProcessCallRelationship());
        this.archiveBuilder.addRelationshipDef(this.addDataFlowRelationship());
        this.archiveBuilder.addRelationshipDef(this.addControlFlowRelationship());
    }

    private TypeDefPatch deprecateProcessInputRelationship() {
        String typeName = "ProcessInput";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProcessInput");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateProcessOutputRelationship() {
        String typeName = "ProcessInput";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProcessInput");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch updateProcessCallRelationship() {
        String typeName = "ProcessCall";
        String description = "Shows a request-response call between two elements.";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProcessCall");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setDescription("Shows a request-response call between two elements.");
        String end1EntityType = "Referenceable";
        String end1AttributeName = "caller";
        String end1AttributeDescription = "Call originator.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "caller", "Call originator.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "called";
        String end2AttributeDescription = "Called element that performs the processing.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "called", "Called element that performs the processing.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "qualifiedName";
        String attribute1Description = "Unique name of the call relationship.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description and purpose of the call.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "formula";
        String attribute3Description = "Function that determines the subset of the data that flows.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("qualifiedName", "Unique name of the call relationship.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description and purpose of the call.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("formula", "Function that determines the subset of the data that flows.", attribute3DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private RelationshipDef addDataFlowRelationship() {
        String guid = "d2490c0c-06cc-458a-add2-33cf2f5dd724";
        String name = "DataFlow";
        String description = "Shows that data flows in one direction from one element to another.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("d2490c0c-06cc-458a-add2-33cf2f5dd724", "DataFlow", null, "Shows that data flows in one direction from one element to another.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "dataSupplier";
        String end1AttributeDescription = "Caller element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "dataSupplier", "Caller element.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "dataConsumer";
        String end2AttributeDescription = "Called element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "dataConsumer", "Called element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "qualifiedName";
        String attribute1Description = "Unique name of the flow relationship.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description and purpose of the flow.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "formula";
        String attribute3Description = "Function that determines the subset of the data that flows.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("qualifiedName", "Unique name of the flow relationship.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description and purpose of the flow.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("formula", "Function that determines the subset of the data that flows.", attribute3DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef addControlFlowRelationship() {
        String guid = "35450726-1c32-4d41-b928-22db6d1ae2f4";
        String name = "ControlFlow";
        String description = "Shows that when one element completes processing, control passes to the next element.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("35450726-1c32-4d41-b928-22db6d1ae2f4", "ControlFlow", null, "Shows that when one element completes processing, control passes to the next element.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "currentStep";
        String end1AttributeDescription = "Element that executes first.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "currentStep", "Element that executes first.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "nextStep";
        String end2AttributeDescription = "Element that executes next.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "nextStep", "Element that executes next.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "qualifiedName";
        String attribute1Description = "Unique name of the control flow relationship.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description and purpose of the control flow.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "guard";
        String attribute3Description = "Function that must be true to travel down this control flow.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("qualifiedName", "Unique name of the control flow relationship.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description and purpose of the control flow.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("guard", "Function that must be true to travel down this control flow.", attribute3DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0770LineageMapping() {
        this.archiveBuilder.addTypeDefPatch(this.updateLineageMappingRelationship());
    }

    private TypeDefPatch updateLineageMappingRelationship() {
        String typeName = "LineageMapping";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("LineageMapping");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "sourceElement";
        String end1AttributeDescription = "Source Attribute.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "sourceElement", "Source Attribute.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "targetElement";
        String end2AttributeDescription = "Target Attribute.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "targetElement", "Target Attribute.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }
}

