/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_6;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_7 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.7";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache 2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_7() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_7(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_6 previousTypes = new OpenMetadataTypesArchive2_6(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0045ServersAndAssets();
        this.update0210DataStores();
        this.update0462GovernanceActionFlow();
        this.update0463GovernanceAction();
        this.update0512CalculatedValue();
    }

    private void update0045ServersAndAssets() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateAssetServerUse());
        this.archiveBuilder.addRelationshipDef(this.getServerAssetUseRelationship());
    }

    private TypeDefPatch deprecateAssetServerUse() {
        String typeName = "AssetServerUse";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("AssetServerUse");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private RelationshipDef getServerAssetUseRelationship() {
        String guid = "56315447-88a6-4235-ba91-fead86524ebf";
        String name = "ServerAssetUse";
        String description = "Defines that a server capability is using an asset.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("56315447-88a6-4235-ba91-fead86524ebf", "ServerAssetUse", null, "Defines that a server capability is using an asset.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SoftwareServerCapability";
        String end1AttributeName = "consumedIn";
        String end1AttributeDescription = "Capability consuming this asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareServerCapability"), "consumedIn", "Capability consuming this asset.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Asset";
        String end2AttributeName = "consumesAsset";
        String end2AttributeDescription = "Asset that this software server capability is dependent on.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Asset"), "consumesAsset", "Asset that this software server capability is dependent on.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "useType";
        String attribute1Description = "Describes how the software server capability uses the asset.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Additional information on how the asset is used by the software server capability.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("ServerAssetUseType", "useType", "Describes how the software server capability uses the asset.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Additional information on how the asset is used by the software server capability.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0210DataStores() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataStore());
    }

    private TypeDefPatch updateDataStore() {
        String typeName = "DataStore";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataStore");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "pathName";
        String attribute1Description = "The fully qualified physical location of the data store.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("pathName", "The fully qualified physical location of the data store.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0463GovernanceAction() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceActionEntity());
    }

    private TypeDefPatch updateGovernanceActionEntity() {
        String typeName = "GovernanceAction";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceAction");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "mandatoryGuards";
        String attribute1Description = "The list of guards that must be received before this governance action can progress.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute("mandatoryGuards", "The list of guards that must be received before this governance action can progress.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0462GovernanceActionFlow() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceActionFlowRelationship());
    }

    private TypeDefPatch updateGovernanceActionFlowRelationship() {
        String typeName = "GovernanceActionFlow";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceActionFlow");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "guard";
        String attribute1Description = "The guard passed to the first governance service to run in this process.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("guard", "The guard passed to the first governance service to run in this process.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0512CalculatedValue() {
        this.archiveBuilder.addTypeDefPatch(this.updateCalculatedValueClassification());
    }

    private TypeDefPatch updateCalculatedValueClassification() {
        String typeName = "CalculatedValue";
        String linkedToEntity = "SchemaElement";
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("SchemaElement"));
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CalculatedValue");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setValidEntityDefs(linkedToEntities);
        return typeDefPatch;
    }
}

