/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.properties.CohortDescription;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIPagedResponse;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class CohortListResponse
extends OMRSAPIPagedResponse {
    private static final long serialVersionUID = 1L;
    private List<CohortDescription> cohorts = null;

    public CohortListResponse() {
    }

    public CohortListResponse(CohortListResponse template) {
        super(template);
        if (template != null) {
            this.cohorts = template.getCohorts();
        }
    }

    public List<CohortDescription> getCohorts() {
        if (this.cohorts == null) {
            return null;
        }
        if (this.cohorts.isEmpty()) {
            return null;
        }
        return this.cohorts;
    }

    public void setCohorts(List<CohortDescription> cohorts) {
        this.cohorts = cohorts;
    }

    @Override
    public String toString() {
        return "CohortListResponse{cohorts=" + this.cohorts + ", nextPageURL='" + this.nextPageURL + "', offset=" + this.offset + ", pageSize=" + this.pageSize + ", relatedHTTPCode=" + this.relatedHTTPCode + ", actionDescription='" + this.actionDescription + "', exceptionClassName='" + this.exceptionClassName + "', exceptionCausedBy='" + this.exceptionCausedBy + "', exceptionErrorMessage='" + this.exceptionErrorMessage + "', exceptionErrorMessageId='" + this.exceptionErrorMessageId + "', exceptionErrorMessageParameters=" + Arrays.toString(this.exceptionErrorMessageParameters) + ", exceptionSystemAction='" + this.exceptionSystemAction + "', exceptionUserAction='" + this.exceptionUserAction + "', exceptionProperties=" + this.exceptionProperties + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof CohortListResponse)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        CohortListResponse that = (CohortListResponse)objectToCompare;
        return Objects.equals(this.getCohorts(), that.getCohorts());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getCohorts());
    }
}

