/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.simplecatalogs;

import java.util.ArrayList;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleAPICatalogArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleDataCatalogArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleEventCatalogArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleGovernanceCatalogArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;

public class SimpleCatalogsArchiveWriter
extends OMRSArchiveWriter {
    private static final String eventOpenMetadataArchiveFileName = "SimpleEventCatalog.json";
    private static final String apiOpenMetadataArchiveFileName = "SimpleAPICatalog.json";
    private static final String dataOpenMetadataArchiveFileName = "SimpleDataCatalog.json";
    private static final String governanceOpenMetadataArchiveFileName = "SimpleGovernanceCatalog.json";

    private SimpleCatalogsArchiveWriter() {
    }

    private void writeOpenMetadataArchives() {
        try {
            ArrayList<OpenMetadataArchive> dependentArchives = new ArrayList<OpenMetadataArchive>();
            SimpleEventCatalogArchiveBuilder eventArchiveBuilder = new SimpleEventCatalogArchiveBuilder();
            OpenMetadataArchive newArchive = eventArchiveBuilder.getOpenMetadataArchive();
            dependentArchives.add(newArchive);
            super.writeOpenMetadataArchive(eventOpenMetadataArchiveFileName, newArchive);
            SimpleAPICatalogArchiveBuilder apiArchiveBuilder = new SimpleAPICatalogArchiveBuilder();
            newArchive = apiArchiveBuilder.getOpenMetadataArchive();
            dependentArchives.add(newArchive);
            super.writeOpenMetadataArchive(apiOpenMetadataArchiveFileName, newArchive);
            SimpleDataCatalogArchiveBuilder dataArchiveBuilder = new SimpleDataCatalogArchiveBuilder();
            newArchive = dataArchiveBuilder.getOpenMetadataArchive();
            dependentArchives.add(newArchive);
            super.writeOpenMetadataArchive(dataOpenMetadataArchiveFileName, newArchive);
            SimpleGovernanceCatalogArchiveBuilder governanceArchiveBuilder = new SimpleGovernanceCatalogArchiveBuilder(dependentArchives);
            super.writeOpenMetadataArchive(governanceOpenMetadataArchiveFileName, governanceArchiveBuilder.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + error.toString());
        }
    }

    public static void main(String[] args) {
        try {
            SimpleCatalogsArchiveWriter archiveWriter = new SimpleCatalogsArchiveWriter();
            archiveWriter.writeOpenMetadataArchives();
        }
        catch (Exception error) {
            System.err.println("Exception: " + error.toString());
            System.exit(-1);
        }
    }
}

