/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.auditlogstore;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDevelopmentStatus;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OMRSAuditLogReportingComponent
implements Serializable,
ComponentDescription {
    private static final long serialVersionUID = 1L;
    private int componentId = 0;
    private ComponentDevelopmentStatus componentDevelopmentStatus = ComponentDevelopmentStatus.IN_DEVELOPMENT;
    private String componentName = null;
    private String componentDescription = null;
    private String componentWikiURL = null;

    public OMRSAuditLogReportingComponent(int componentId, ComponentDevelopmentStatus componentDevelopmentStatus, String componentName, String componentDescription, String componentWikiURL) {
        this.componentId = componentId;
        this.componentDevelopmentStatus = componentDevelopmentStatus;
        this.componentName = componentName;
        this.componentDescription = componentDescription;
        this.componentWikiURL = componentWikiURL;
    }

    public OMRSAuditLogReportingComponent(ComponentDescription template) {
        if (template != null) {
            this.componentId = template.getComponentId();
            this.componentDevelopmentStatus = template.getComponentDevelopmentStatus();
            this.componentName = template.getComponentName();
            this.componentDescription = template.getComponentType();
            this.componentWikiURL = template.getComponentWikiURL();
        }
    }

    @Override
    public int getComponentId() {
        return this.componentId;
    }

    @Override
    public ComponentDevelopmentStatus getComponentDevelopmentStatus() {
        return this.componentDevelopmentStatus;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public String getComponentType() {
        return this.componentDescription;
    }

    @Override
    public String getComponentWikiURL() {
        return this.componentWikiURL;
    }

    public String toString() {
        return "OMRSAuditLogReportingComponent{componentId=" + this.componentId + ", componentDevelopmentStatus=" + this.componentDevelopmentStatus + ", componentName='" + this.componentName + "', componentDescription='" + this.componentDescription + "', componentWikiURL='" + this.componentWikiURL + "', componentType='" + this.getComponentType() + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        OMRSAuditLogReportingComponent that = (OMRSAuditLogReportingComponent)objectToCompare;
        return this.componentId == that.componentId && this.componentDevelopmentStatus == that.componentDevelopmentStatus && Objects.equals(this.componentName, that.componentName) && Objects.equals(this.componentDescription, that.componentDescription) && Objects.equals(this.componentWikiURL, that.componentWikiURL);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getComponentId(), this.getComponentDevelopmentStatus(), this.getComponentName(), this.getComponentType(), this.getComponentWikiURL()});
    }
}

