/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent;

import java.util.Date;
import org.odpi.openmetadata.archiveutilities.catalogbuilder.CatalogTypesArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;

public class SimpleAPICatalogArchiveBuilder
extends CatalogTypesArchiveBuilder {
    private static final String archiveGUID = "9e594f24-2494-4000-ac20-59f374eaa0e6";
    private static final String archiveRootName = "SimpleAPICatalog";
    private static final String archiveName = "Simple API Catalog";
    private static final String archiveLicense = "Apache 2.0";
    private static final String archiveDescription = "Sample metadata showing API assets and their payloads.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "Egeria";
    private static final Date creationDate = new Date(1632046251579L);
    private static final String customerQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer";
    private static final String customerDisplayName = "Customer API";
    private static final String customerDescription = "API for interacting with customer master.";
    private static final String getCustomerQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer";
    private static final String getCustomerDisplayName = "Get Customer Operation";
    private static final String getCustomerDescription = "API operation to retrieved details about the customer.";
    private static final String getCustomerPath = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer";
    private static final String getCustomerCommand = "GET";
    private static final String customerNoRequestQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer/request/customerNo";
    private static final String customerNoResponseQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer/response/customerNo";
    private static final String customerNoDisplayName = "customerNo";
    private static final String customerNoDescription = "The unique identifier assigned internally for a customer.";
    private static final String customerNoDataType = "string";
    private static final int customerNoLength = 12;
    private static final String customerNameQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer/response/customerName";
    private static final String customerNameDisplayName = "customerName";
    private static final String customerNameDescription = "The name for a customer - as supplied by the customer.";
    private static final String customerNameDataType = "string";
    private static final int customerNameLength = 40;
    private static final String customerCardIdQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer/responses/customerCardId";
    private static final String customerCardIdDisplayName = "customerCardId";
    private static final String customerCardIdDescription = "The store card number for the customer.  Null if not issued.";
    private static final String customerCardIdDataType = "string";
    private static final int customerCardIdLength = 10;
    private static final String apiAssetTypeName = "DeployedAPI";
    private static final String apiSchemaTypeTypeName = "APISchemaType";
    private static final String apiSchemaAttributeTypeName = "APIParameter";
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";

    public SimpleAPICatalogArchiveBuilder() {
        super(archiveGUID, archiveName, archiveDescription, archiveType, archiveRootName, originatorName, archiveLicense, creationDate, 1L, versionName, null);
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String assetGUID = super.addAsset(apiAssetTypeName, customerQualifiedName, customerDisplayName, customerDescription, null);
        String apiSchemaTypeGUID = super.addTopLevelSchemaType(assetGUID, apiSchemaTypeTypeName, "global-api-gateway/CustomerDomain/APIs/Customer_api_schema_type", "Customer API API Schema Type", null, null);
        String apiOperationGUID = super.addAPIOperation(apiSchemaTypeGUID, "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer", getCustomerDisplayName, getCustomerDescription, "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer", getCustomerCommand, null);
        String requestGUID = super.addAPIParameterList(apiOperationGUID, "APIRequest", "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer_request", "Get Customer Operation Request Parameter List", null, true, null);
        String parameterGUID = super.addSchemaAttribute(apiSchemaAttributeTypeName, null, customerNoRequestQualifiedName, customerNoDisplayName, customerNoDescription, "string", 12, 0, null);
        super.addAttributeForSchemaType(requestGUID, parameterGUID);
        String responseGUID = super.addAPIParameterList(apiOperationGUID, "APIResponse", "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer_response", "Get Customer Operation Response Parameter List", null, true, null);
        parameterGUID = super.addSchemaAttribute(apiSchemaAttributeTypeName, null, customerNoResponseQualifiedName, customerNoDisplayName, customerNoDescription, "string", 12, 0, null);
        super.addAttributeForSchemaType(responseGUID, parameterGUID);
        parameterGUID = super.addSchemaAttribute(apiSchemaAttributeTypeName, null, customerNameQualifiedName, customerNameDisplayName, customerNameDescription, "string", 40, 1, null);
        super.addAttributeForSchemaType(responseGUID, parameterGUID);
        parameterGUID = super.addSchemaAttribute(apiSchemaAttributeTypeName, null, customerCardIdQualifiedName, customerCardIdDisplayName, customerCardIdDescription, "string", 10, 2, null);
        super.addAttributeForSchemaType(responseGUID, parameterGUID);
        return super.getOpenMetadataArchive();
    }
}

