/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.rest.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.rest.properties.OMRSAPIFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.PropertyMatchFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.RelatedEntitiesFindRequest;
import org.odpi.openmetadata.repositoryservices.rest.properties.TypeLimitedFindRequest;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=TypeLimitedFindRequest.class, name="TypeLimitedFindRequest"), @JsonSubTypes.Type(value=RelatedEntitiesFindRequest.class, name="RelatedEntitiesFindRequest"), @JsonSubTypes.Type(value=PropertyMatchFindRequest.class, name="PropertyMatchFindRequest")})
public class OMRSAPIPagedFindRequest
extends OMRSAPIFindRequest {
    private static final long serialVersionUID = 1L;
    private String sequencingProperty = null;
    private SequencingOrder sequencingOrder = null;
    private int offset = 0;
    private int pageSize = 0;

    public OMRSAPIPagedFindRequest() {
    }

    public OMRSAPIPagedFindRequest(OMRSAPIPagedFindRequest template) {
        super(template);
        if (template != null) {
            this.sequencingProperty = template.getSequencingProperty();
            this.sequencingOrder = template.getSequencingOrder();
            this.offset = template.getOffset();
            this.pageSize = this.getPageSize();
        }
    }

    public String getSequencingProperty() {
        return this.sequencingProperty;
    }

    public void setSequencingProperty(String sequencingProperty) {
        this.sequencingProperty = sequencingProperty;
    }

    public SequencingOrder getSequencingOrder() {
        return this.sequencingOrder;
    }

    public void setSequencingOrder(SequencingOrder sequencingOrder) {
        this.sequencingOrder = sequencingOrder;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public String toString() {
        return "OMRSAPIPagedFindRequest{sequencingProperty='" + this.sequencingProperty + "', sequencingOrder=" + this.sequencingOrder + ", offset=" + this.offset + ", pageSize=" + this.pageSize + ", limitResultsByStatus=" + this.getLimitResultsByStatus() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof OMRSAPIPagedFindRequest)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OMRSAPIPagedFindRequest that = (OMRSAPIPagedFindRequest)objectToCompare;
        return this.getOffset() == that.getOffset() && this.getPageSize() == that.getPageSize() && Objects.equals(this.getSequencingProperty(), that.getSequencingProperty()) && this.getSequencingOrder() == that.getSequencingOrder();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSequencingProperty(), this.getSequencingOrder(), this.getOffset(), this.getPageSize());
    }
}

