/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.samples.archiveutilities.SimpleCatalogArchiveHelper;

public class SimpleAPICatalogArchiveBuilder {
    private static final String archiveGUID = "9e594f24-2494-4000-ac20-59f374eaa0e6";
    private static final String archiveName = "SimpleAPICatalog";
    private static final String archiveLicense = "Apache 2.0";
    private static final String archiveDescription = "Sample metadata showing API assets and their payloads.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "Egeria";
    private static final Date creationDate = new Date(1632046251579L);
    private static final String customerQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer";
    private static final String customerDisplayName = "Customer API";
    private static final String customerDescription = "API for interacting with customer master.";
    private static final String getCustomerQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer";
    private static final String getCustomerDisplayName = "Get Customer Operation";
    private static final String getCustomerDescription = "API operation to retrieved details about the customer.";
    private static final String getCustomerPath = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer";
    private static final String getCustomerCommand = "GET";
    private static final String customerNoRequestQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer/request/customerNo";
    private static final String customerNoResponseQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer/response/customerNo";
    private static final String customerNoDisplayName = "customerNo";
    private static final String customerNoDescription = "The unique identifier assigned internally for a customer.";
    private static final String customerNoDataType = "string";
    private static final int customerNoLength = 12;
    private static final String customerNameQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer/response/customerName";
    private static final String customerNameDisplayName = "customerName";
    private static final String customerNameDescription = "The name for a customer - as supplied by the customer.";
    private static final String customerNameDataType = "string";
    private static final int customerNameLength = 40;
    private static final String customerCardIdQualifiedName = "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer/responses/customerCardId";
    private static final String customerCardIdDisplayName = "customerCardId";
    private static final String customerCardIdDescription = "The store card number for the customer.  Null if not issued.";
    private static final String customerCardIdDataType = "string";
    private static final int customerCardIdLength = 10;
    private static final String apiAssetTypeName = "DeployedAPI";
    private static final String apiSchemaTypeTypeName = "APISchemaType";
    private static final String apiSchemaAttributeTypeName = "APIParameter";
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final SimpleCatalogArchiveHelper archiveHelper;

    public SimpleAPICatalogArchiveBuilder(String archiveRootName) {
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, archiveLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new SimpleCatalogArchiveHelper(this.archiveBuilder, archiveGUID, archiveRootName, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String assetGUID = this.archiveHelper.addAsset(apiAssetTypeName, customerQualifiedName, customerDisplayName, customerDescription, null, null);
        String apiSchemaTypeGUID = this.archiveHelper.addTopLevelSchemaType(assetGUID, apiSchemaTypeTypeName, "global-api-gateway/CustomerDomain/APIs/Customer_api_schema_type", "Customer API API Schema Type", null, null);
        String apiOperationGUID = this.archiveHelper.addAPIOperation(apiSchemaTypeGUID, "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer", getCustomerDisplayName, getCustomerDescription, "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer", getCustomerCommand, null);
        String requestGUID = this.archiveHelper.addAPIParameterList(apiOperationGUID, "APIRequest", "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer_request", "Get Customer Operation Request Parameter List", null, true, null);
        String parameterGUID = this.archiveHelper.addSchemaAttribute(apiSchemaAttributeTypeName, null, customerNoRequestQualifiedName, customerNoDisplayName, customerNoDescription, "string", 12, 0, null);
        this.archiveHelper.addAttributeForSchemaType(requestGUID, parameterGUID);
        String responseGUID = this.archiveHelper.addAPIParameterList(apiOperationGUID, "APIResponse", "global-api-gateway/CustomerDomain/APIs/Customer/getCustomer_response", "Get Customer Operation Response Parameter List", null, true, null);
        parameterGUID = this.archiveHelper.addSchemaAttribute(apiSchemaAttributeTypeName, null, customerNoResponseQualifiedName, customerNoDisplayName, customerNoDescription, "string", 12, 0, null);
        this.archiveHelper.addAttributeForSchemaType(responseGUID, parameterGUID);
        parameterGUID = this.archiveHelper.addSchemaAttribute(apiSchemaAttributeTypeName, null, customerNameQualifiedName, customerNameDisplayName, customerNameDescription, "string", 40, 1, null);
        this.archiveHelper.addAttributeForSchemaType(responseGUID, parameterGUID);
        parameterGUID = this.archiveHelper.addSchemaAttribute(apiSchemaAttributeTypeName, null, customerCardIdQualifiedName, customerCardIdDisplayName, customerCardIdDescription, "string", 10, 2, null);
        this.archiveHelper.addAttributeForSchemaType(responseGUID, parameterGUID);
        this.archiveHelper.saveGUIDs();
        return this.archiveBuilder.getOpenMetadataArchive();
    }
}

