/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_8;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.9";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache 2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_8 previousTypes = new OpenMetadataTypesArchive3_8(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0015LinkedMediaTypes();
    }

    private void update0015LinkedMediaTypes() {
        this.archiveBuilder.addTypeDefPatch(this.updateExternalReferenceLinkRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateMediaReferenceRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateRelatedMediaEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateExternalReferenceEntity());
    }

    private TypeDefPatch updateExternalReferenceLinkRelationship() {
        String typeName = "ExternalReferenceLink";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ExternalReferenceLink");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "pages";
        String attribute1Description = "Range of pages in the external reference that this link refers.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("pages", "Range of pages in the external reference that this link refers.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateMediaReferenceRelationship() {
        String typeName = "MediaReference";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("MediaReference");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "mediaUsage";
        String attribute1Description = "Specific media usage by the consumer that overrides the media usage document in the related media.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "mediaUsageOtherId";
        String attribute2Description = "Unique identifier of the code (typically a valid value definition) that defines the media use.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("MediaUsage", "mediaUsage", "Specific media usage by the consumer that overrides the media usage document in the related media.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("mediaUsageOtherId", "Unique identifier of the code (typically a valid value definition) that defines the media use.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateRelatedMediaEntity() {
        String typeName = "RelatedMedia";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("RelatedMedia");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "defaultMediaUsage";
        String attribute1Description = "Default media usage by a consumer.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "defaultMediaUsageOtherId";
        String attribute2Description = "Unique identifier of the code (typically a valid value definition) that defines the media use.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "mediaUsage";
        String attribute3Description = "Type of recommended media usage.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "mediaTypeOtherId";
        String attribute4Description = "Unique identifier of the code (typically a valid value definition) that defines the media type.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("MediaUsage", "defaultMediaUsage", "Default media usage by a consumer.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("defaultMediaUsageOtherId", "Unique identifier of the code (typically a valid value definition) that defines the media use.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayIntTypeDefAttribute("mediaUsage", "Type of recommended media usage.", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("defaultMediaUsage");
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("mediaTypeOtherId", "Unique identifier of the code (typically a valid value definition) that defines the media type.", attribute4DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateExternalReferenceEntity() {
        String typeName = "ExternalReference";
        String description = "A link to an external reference source such as a web page, article or book.";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ExternalReference");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setDescription("A link to an external reference source such as a web page, article or book.");
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "displayName";
        String attribute1Description = "Name to use when displaying reference in a list.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "referenceTitle";
        String attribute2Description = "Full publication title of the external source.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "referenceAbstract";
        String attribute3Description = "Summary of the key messages in the external source.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "description";
        String attribute4Description = "Description of the external source.  For example, its significance and use.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "authors";
        String attribute5Description = "List of authors for the external source.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "numberOfPages";
        String attribute6Description = "Number of pages that this external source has.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "pageRange";
        String attribute7Description = "Range of pages that this reference covers. For example, if it is a journal article, this could be the range of pages for the article in the journal.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "organization";
        String attribute8Description = "Name of the organization that this external source is from.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "publicationSeries";
        String attribute9Description = "Name of the journal or series of publications that this external source is from.";
        String attribute9DescriptionGUID = null;
        String attribute10Name = "publicationSeriesVolume";
        String attribute10Description = "Name of the volume in the publication series that this external source is from.";
        String attribute10DescriptionGUID = null;
        String attribute11Name = "edition";
        String attribute11Description = "Name of the edition for this external source.";
        String attribute11DescriptionGUID = null;
        String attribute12Name = "referenceVersion";
        String attribute12Description = "Name of the revision or version of the external source.";
        String attribute12DescriptionGUID = null;
        String attribute13Name = "url";
        String attribute13Description = "Network address where this external source can be accessed from.";
        String attribute13DescriptionGUID = null;
        String attribute14Name = "publisher";
        String attribute14Description = "Name of the publisher responsible for producing this external source.";
        String attribute14DescriptionGUID = null;
        String attribute15Name = "firstPublicationDate";
        String attribute15Description = "Date of the first published version/edition of this external source.";
        String attribute15DescriptionGUID = null;
        String attribute16Name = "publicationDate";
        String attribute16Description = "Date when this version/edition of this external source was published.";
        String attribute16DescriptionGUID = null;
        String attribute17Name = "publicationCity";
        String attribute17Description = "City where the publishers are based.";
        String attribute17DescriptionGUID = null;
        String attribute18Name = "publicationYear";
        String attribute18Description = "Year when the publication of this version/edition of the external source was published.";
        String attribute18DescriptionGUID = null;
        String attribute19Name = "publicationNumbers";
        String attribute19Description = "List of unique numbers allocated by the publisher for this external source.  For example ISBN, ASIN, UNSPSC code.";
        String attribute19DescriptionGUID = null;
        String attribute20Name = "license";
        String attribute20Description = "Name of license associated with this external source.";
        String attribute20DescriptionGUID = null;
        String attribute21Name = "copyright";
        String attribute21Description = "Copyright statement associated with this external source.";
        String attribute21DescriptionGUID = null;
        String attribute22Name = "attribution";
        String attribute22Description = "Attribution statement to use when consuming this external resource.";
        String attribute22DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Name to use when displaying reference in a list.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("referenceTitle", "Full publication title of the external source.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("referenceAbstract", "Summary of the key messages in the external source.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the external source.  For example, its significance and use.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("authors", "List of authors for the external source.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("numberOfPages", "Number of pages that this external source has.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("pageRange", "Range of pages that this reference covers. For example, if it is a journal article, this could be the range of pages for the article in the journal.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("organization", "Name of the organization that this external source is from.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("publicationSeries", "Name of the journal or series of publications that this external source is from.", attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("publicationSeriesVolume", "Name of the volume in the publication series that this external source is from.", attribute10DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("edition", "Name of the edition for this external source.", attribute11DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("referenceVersion", "Name of the revision or version of the external source.", attribute12DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("url", "Network address where this external source can be accessed from.", attribute13DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("publisher", "Name of the publisher responsible for producing this external source.", attribute14DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("firstPublicationDate", "Date of the first published version/edition of this external source.", attribute15DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("publicationDate", "Date when this version/edition of this external source was published.", attribute16DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("publicationCity", "City where the publishers are based.", attribute17DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("publicationYear", "Year when the publication of this version/edition of the external source was published.", attribute18DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("publicationNumbers", "List of unique numbers allocated by the publisher for this external source.  For example ISBN, ASIN, UNSPSC code.", attribute19DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("license", "Name of license associated with this external source.", attribute20DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("copyright", "Copyright statement associated with this external source.", attribute21DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("attribution", "Attribution statement to use when consuming this external resource.", attribute22DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

