/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive1_6;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive1_7 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "1.7";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache 2.0";
    private static final Date creationDate = new Date(1516313040008L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive1_7() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive1_7(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive1_6 previousTypes = new OpenMetadataTypesArchive1_6(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0045ServersAndAssets();
        this.update0424GovernanceZones();
        this.update042SubjectAreas();
        this.add0435PolicyManagementCapabilities();
        this.update0438NamingStandards();
        this.update0440OrganizationalControls();
        this.update0450GovernanceRollout();
        this.update0534RelationalSchemas();
        this.update05454ReferenceData();
        this.addArea7Lineage();
    }

    private void update0045ServersAndAssets() {
        this.archiveBuilder.addTypeDefPatch(this.updateServerAssetUseRelationship());
    }

    private TypeDefPatch updateServerAssetUseRelationship() {
        String typeName = "AssetServerUse";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("AssetServerUse");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Additional information on how the asset is used by the software server capability.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Additional information on how the asset is used by the software server capability.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0424GovernanceZones() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceZoneEntity());
    }

    private TypeDefPatch updateGovernanceZoneEntity() {
        String typeName = "GovernanceZone";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceZone");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "displayName";
        String attribute1Description = "Consumable name of this zone for user interfaces and reports.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "scope";
        String attribute2Description = "Breadth of applicability of this zone to the assets matching the criteria.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "domain";
        String attribute3Description = "Primary governance domain controlling the asset in this zone.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Consumable name of this zone for user interfaces and reports.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("scope", "Breadth of applicability of this zone to the assets matching the criteria.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Primary governance domain controlling the asset in this zone.", attribute3DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update042SubjectAreas() {
        this.archiveBuilder.addEntityDef(this.addSubjectAreaDefinitionEntity());
        this.archiveBuilder.addRelationshipDef(this.getSubjectAreaGovernanceRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSubjectAreaHierarchyRelationship());
    }

    private EntityDef addSubjectAreaDefinitionEntity() {
        String guid = "d28c3839-bc6f-41ad-a882-5667e01fea72";
        String name = "SubjectAreaDefinition";
        String description = "Defines a collection of glossary elements that are related to a topic.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("d28c3839-bc6f-41ad-a882-5667e01fea72", "SubjectAreaDefinition", this.archiveBuilder.getEntityDef("Referenceable"), "Defines a collection of glossary elements that are related to a topic.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "displayName";
        String attribute1Description = "Consumable name for this subject area for user interfaces and reports.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description of this subject area.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "usage";
        String attribute3Description = "How and where the subject area contents should be used.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "scope";
        String attribute4Description = "Breadth of applicability of this subject area to the organization.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "domain";
        String attribute5Description = "Primary governance domain controlling the contents of this subject area.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Consumable name for this subject area for user interfaces and reports.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of this subject area.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("usage", "How and where the subject area contents should be used.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("scope", "Breadth of applicability of this subject area to the organization.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Primary governance domain controlling the contents of this subject area.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSubjectAreaGovernanceRelationship() {
        String guid = "ee8c78a1-a3ae-4824-a4e1-dcb64bc3a45b";
        String name = "SubjectAreaGovernance";
        String description = "Links a subject area definition to a governance definition that applies to all of the contents of the subject area.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("ee8c78a1-a3ae-4824-a4e1-dcb64bc3a45b", "SubjectAreaGovernance", null, "Links a subject area definition to a governance definition that applies to all of the contents of the subject area.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SubjectAreaDefinition";
        String end1AttributeName = "governedSubjectArea";
        String end1AttributeDescription = "The subject area governed by this definition.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SubjectAreaDefinition"), "governedSubjectArea", "The subject area governed by this definition.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceDefinition";
        String end2AttributeName = "governedBy";
        String end2AttributeDescription = "Governance definitions for this subject area.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceDefinition"), "governedBy", "Governance definitions for this subject area.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getSubjectAreaHierarchyRelationship() {
        String guid = "fd3b7eaf-969c-4c26-9e1e-f31c4c2d1e4b";
        String name = "SubjectAreaHierarchy";
        String description = "Creates a controlling hierarchy for subject areas.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("fd3b7eaf-969c-4c26-9e1e-f31c4c2d1e4b", "SubjectAreaHierarchy", null, "Creates a controlling hierarchy for subject areas.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SubjectAreaDefinition";
        String end1AttributeName = "broaderSubjectArea";
        String end1AttributeDescription = "The subject area that describes a broader topic.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SubjectAreaDefinition"), "broaderSubjectArea", "The subject area that describes a broader topic.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SubjectAreaDefinition";
        String end2AttributeName = "nestedSubjectArea";
        String end2AttributeDescription = "The subdivisions of the broader topic.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SubjectAreaDefinition"), "nestedSubjectArea", "The subdivisions of the broader topic.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0435PolicyManagementCapabilities() {
        this.archiveBuilder.addClassificationDef(this.getPolicyAdministrationPointClassification());
        this.archiveBuilder.addClassificationDef(this.getPolicyDecisionPointClassification());
        this.archiveBuilder.addClassificationDef(this.getPolicyEnforcementPointClassification());
        this.archiveBuilder.addClassificationDef(this.getPolicyInformationPointClassification());
        this.archiveBuilder.addClassificationDef(this.getPolicyRetrievalPointClassification());
    }

    private ClassificationDef getPolicyAdministrationPointClassification() {
        String guid = "4f13baa3-31b3-4a85-985e-2abc784900b8";
        String name = "PolicyAdministrationPoint";
        String description = "Describes the capability where policies are maintained.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("4f13baa3-31b3-4a85-985e-2abc784900b8", "PolicyAdministrationPoint", null, "Describes the capability where policies are maintained.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "name";
        String attribute1Description = "Unique name of the policy administration point.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description of the policy administration point.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "type";
        String attribute3Description = "Descriptive type information about the policy administration point.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("name", "Unique name of the policy administration point.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the policy administration point.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("type", "Descriptive type information about the policy administration point.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getPolicyDecisionPointClassification() {
        String guid = "bf521975-bfec-4115-a8e3-ed0fee7d4a43";
        String name = "PolicyDecisionPoint";
        String description = "Describes the capability where policies are evaluated for a specific situation.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("bf521975-bfec-4115-a8e3-ed0fee7d4a43", "PolicyDecisionPoint", null, "Describes the capability where policies are evaluated for a specific situation.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "name";
        String attribute1Description = "Unique name of the policy decision point.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description of the policy decision point.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "type";
        String attribute3Description = "Descriptive type information about the policy decision point.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("name", "Unique name of the policy decision point.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the policy decision point.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("type", "Descriptive type information about the policy decision point.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getPolicyEnforcementPointClassification() {
        String guid = "9a68b20b-3f84-4d7d-bc9e-790c4b27e685";
        String name = "PolicyEnforcementPoint";
        String description = "Describes the capability where the result of a policy decision are enforced.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("9a68b20b-3f84-4d7d-bc9e-790c4b27e685", "PolicyEnforcementPoint", null, "Describes the capability where the result of a policy decision are enforced.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "name";
        String attribute1Description = "Unique name of the policy enforcement point.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description of the policy enforcement point.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "type";
        String attribute3Description = "Descriptive type information about the policy enforcement point.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("name", "Unique name of the policy enforcement point.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the policy enforcement point.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("type", "Descriptive type information about the policy enforcement point.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getPolicyInformationPointClassification() {
        String guid = "2058ab6f-ddbf-45f9-9136-47354544e282";
        String name = "PolicyInformationPoint";
        String description = "Describes the capability where additional information used in a policy decision are stored.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("2058ab6f-ddbf-45f9-9136-47354544e282", "PolicyInformationPoint", null, "Describes the capability where additional information used in a policy decision are stored.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "name";
        String attribute1Description = "Unique name of the policy information point.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description of the policy information point.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "type";
        String attribute3Description = "Descriptive type information about the policy information point.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("name", "Unique name of the policy information point.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the policy information point.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("type", "Descriptive type information about the policy information point.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getPolicyRetrievalPointClassification() {
        String guid = "d7367412-7ba6-409f-84db-42b51e859367";
        String name = "PolicyRetrievalPoint";
        String description = "Describes the capability where policies are retrieved.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("d7367412-7ba6-409f-84db-42b51e859367", "PolicyRetrievalPoint", null, "Describes the capability where policies are retrieved.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "name";
        String attribute1Description = "Unique name of the policy retrieval point.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description of the policy retrieval point.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "type";
        String attribute3Description = "Descriptive type information about the policy retrieval point.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("name", "Unique name of the policy retrieval point.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the policy retrieval point.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("type", "Descriptive type information about the policy retrieval point.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0438NamingStandards() {
        this.archiveBuilder.addClassificationDef(this.getModifierClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateNamingConventionRuleClassification());
        this.archiveBuilder.addTypeDefPatch(this.updatePrimeWordClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateClassWordClassification());
    }

    private ClassificationDef getModifierClassification() {
        String guid = "f662c95a-ae3f-4f71-b442-78ab70f2ee47";
        String name = "Modifier";
        String description = "Describes modifying noun or adverb, used in naming standards.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        return this.archiveHelper.getClassificationDef("f662c95a-ae3f-4f71-b442-78ab70f2ee47", "Modifier", null, "Describes modifying noun or adverb, used in naming standards.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), false);
    }

    private TypeDefPatch updateNamingConventionRuleClassification() {
        String typeName = "NamingConventionRule";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("NamingConventionRule");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch updatePrimeWordClassification() {
        String typeName = "PrimeWord";
        String typeLinkName = "Referenceable";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("PrimeWord");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("Referenceable")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateClassWordClassification() {
        String typeName = "ClassWord";
        String typeLinkName = "Referenceable";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ClassWord");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("Referenceable")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private void update0440OrganizationalControls() {
        this.archiveBuilder.addTypeDefPatch(this.updateOrganizationalCapabilityRelationship());
    }

    private TypeDefPatch updateOrganizationalCapabilityRelationship() {
        String typeName = "OrganizationalCapability";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("OrganizationalCapability");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "scope";
        String attribute1Description = "Breadth of applicability in the organization.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("scope", "Breadth of applicability in the organization.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0450GovernanceRollout() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceMetricEntity());
    }

    private TypeDefPatch updateGovernanceMetricEntity() {
        String typeName = "GovernanceMetric";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceMetric");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "target";
        String attribute1Description = "Definition of the measurement values that the governance definitions are trying to achieve.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "domain";
        String attribute2Description = "Primary governance domain that this metric is measuring.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("target", "Definition of the measurement values that the governance definitions are trying to achieve.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Primary governance domain that this metric is measuring.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0534RelationalSchemas() {
        this.archiveBuilder.addTypeDefPatch(this.updateRelationalColumnEntity());
    }

    private TypeDefPatch updateRelationalColumnEntity() {
        String typeName = "RelationalColumn";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("RelationalColumn");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "fraction";
        String attribute1Description = "Number of significant digits to the right of decimal point (deprecated).";
        String attribute1DescriptionGUID = null;
        String attribute1ReplacedBy = "significantDigits";
        String attribute2Name = "isUnique";
        String attribute2Description = "Data is unique or not.";
        String attribute2DescriptionGUID = null;
        String attribute2ReplacedBy = "allowsDuplicateValues";
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("fraction", "Number of significant digits to the right of decimal point (deprecated).", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("significantDigits");
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("isUnique", "Data is unique or not.", attribute2DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("allowsDuplicateValues");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update05454ReferenceData() {
        this.archiveBuilder.addRelationshipDef(this.getValidValuesMappingRelationship());
        this.archiveBuilder.addRelationshipDef(this.getReferenceValueAssignmentRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateValidValuesImplementationRelationship());
    }

    private RelationshipDef getValidValuesMappingRelationship() {
        String guid = "203ce62c-3cbf-4542-bf82-81820cba718f";
        String name = "ValidValuesMapping";
        String description = "A link between two valid values from different valid value sets that have equivalent meanings.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("203ce62c-3cbf-4542-bf82-81820cba718f", "ValidValuesMapping", null, "A link between two valid values from different valid value sets that have equivalent meanings.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ValidValueDefinition";
        String end1AttributeName = "matchingValue";
        String end1AttributeDescription = "A valid value from a different valid value set that is equivalent.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ValidValueDefinition"), "matchingValue", "A valid value from a different valid value set that is equivalent.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ValidValueDefinition";
        String end2AttributeName = "matchingValue";
        String end2AttributeDescription = "A valid value from a different valid value set that is equivalent.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ValidValueDefinition"), "matchingValue", "A valid value from a different valid value set that is equivalent.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "associationDescription";
        String attribute1Description = "Brief description describing how they are related.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "confidence";
        String attribute2Description = "Number between 0 and 100 indicating the confidence that the match is correct.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "steward";
        String attribute3Description = "Person responsible for the mapping.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "notes";
        String attribute4Description = "Additional notes on the mapping.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("associationDescription", "Brief description describing how they are related.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("confidence", "Number between 0 and 100 indicating the confidence that the match is correct.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("steward", "Person responsible for the mapping.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("notes", "Additional notes on the mapping.", attribute4DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getReferenceValueAssignmentRelationship() {
        String guid = "111e6d2e-94e9-43ed-b4ed-f0d220668cbf";
        String name = "ReferenceValueAssignment";
        String description = "Enables valid values to be used as tags to help group and locate referenceables.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("111e6d2e-94e9-43ed-b4ed-f0d220668cbf", "ReferenceValueAssignment", null, "Enables valid values to be used as tags to help group and locate referenceables.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "assignedItem";
        String end1AttributeDescription = "An element that has been tagged by a valid value.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "assignedItem", "An element that has been tagged by a valid value.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ValidValueDefinition";
        String end2AttributeName = "referenceValue";
        String end2AttributeDescription = "A valid value that represents the meaning or classification of the assigned item.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ValidValueDefinition"), "referenceValue", "A valid value that represents the meaning or classification of the assigned item.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute2Name = "confidence";
        String attribute2Description = "Number between 0 and 100 indicating the confidence that the match is correct.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "steward";
        String attribute3Description = "Person responsible for the mapping.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "notes";
        String attribute4Description = "Additional notes on the mapping.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("confidence", "Number between 0 and 100 indicating the confidence that the match is correct.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("steward", "Person responsible for the mapping.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("notes", "Additional notes on the mapping.", attribute4DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch updateValidValuesImplementationRelationship() {
        String typeName = "ValidValuesImplementation";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ValidValuesImplementation");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "symbolicName";
        String attribute1Description = "Name of the value value used in code.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "additionalValues";
        String attribute2Description = "Additional values for additional columns or fields in the reference data store.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("symbolicName", "Name of the value value used in code.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("additionalValues", "Additional values for additional columns or fields in the reference data store.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void addArea7Lineage() {
        this.add0710DigitalServices();
        this.add0715DigitalServiceOwnership();
        this.add0717DigitalServiceImplementation();
        this.add0720InformationSupplyChains();
        this.add0730SolutionComponents();
        this.add0735SolutionPortsAndWires();
        this.add0740SolutionBlueprints();
        this.add0750DataPassing();
        this.add0760BusinessLineage();
    }

    private void add0710DigitalServices() {
        this.archiveBuilder.addEntityDef(this.getDigitalServiceEntity());
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceDependencyRelationship());
    }

    private EntityDef getDigitalServiceEntity() {
        String guid = "f671e1fc-b204-4ee6-a4e2-da1633ecf50e";
        String name = "DigitalService";
        String description = "A business function implemented using IT.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("f671e1fc-b204-4ee6-a4e2-da1633ecf50e", "DigitalService", this.archiveBuilder.getEntityDef("Referenceable"), "A business function implemented using IT.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "displayName";
        String attribute1Description = "Name of the digital service.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Brief description of the digital service.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "versionNumber";
        String attribute3Description = "Version number (major.minor) of the component.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Name of the digital service.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Brief description of the digital service.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("versionNumber", "Version number (major.minor) of the component.", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.APPROVED_CONCEPT);
        validInstanceStatusList.add(InstanceStatus.UNDER_DEVELOPMENT);
        validInstanceStatusList.add(InstanceStatus.DEVELOPMENT_COMPLETE);
        validInstanceStatusList.add(InstanceStatus.APPROVED_FOR_DEPLOYMENT);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private RelationshipDef getDigitalServiceDependencyRelationship() {
        String guid = "e8303911-ba1c-4640-974e-c4d57ee1b310";
        String name = "DigitalServiceDependency";
        String description = "Relationship identifying dependencies between digital services.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e8303911-ba1c-4640-974e-c4d57ee1b310", "DigitalServiceDependency", null, "Relationship identifying dependencies between digital services.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DigitalService";
        String end1AttributeName = "callsDigitalServices";
        String end1AttributeDescription = "The digital services dependent on the others.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalService"), "callsDigitalServices", "The digital services dependent on the others.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DigitalService";
        String end2AttributeName = "calledByDigitalServices";
        String end2AttributeDescription = "The digital services that the others depends on.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalService"), "calledByDigitalServices", "The digital services that the others depends on.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "delegationEscalationAuthority";
        String attribute1Description = "Can delegations and escalations flow on this relationship.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("delegationEscalationAuthority", "Can delegations and escalations flow on this relationship.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0715DigitalServiceOwnership() {
        this.archiveBuilder.addEntityDef(this.getDigitalServiceManagerEntity());
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceManagementRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDigitalSupportRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceOperatorRelationship());
    }

    private EntityDef getDigitalServiceManagerEntity() {
        String guid = "6dfba6ce-e925-4281-880d-d04100c5b991";
        String name = "DigitalServiceManager";
        String description = "Person managing a digital service.";
        String descriptionGUID = null;
        String superTypeName = "PersonRole";
        return this.archiveHelper.getDefaultEntityDef("6dfba6ce-e925-4281-880d-d04100c5b991", "DigitalServiceManager", this.archiveBuilder.getEntityDef("PersonRole"), "Person managing a digital service.", descriptionGUID);
    }

    private RelationshipDef getDigitalServiceManagementRelationship() {
        String guid = "91ff7542-c275-4cd3-b367-97eec3360422";
        String name = "DigitalServiceManagement";
        String description = "Relationship identifying the individual responsible for each digital service.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("91ff7542-c275-4cd3-b367-97eec3360422", "DigitalServiceManagement", null, "Relationship identifying the individual responsible for each digital service.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DigitalService";
        String end1AttributeName = "managesDigitalServices";
        String end1AttributeDescription = "The digital services that this individual manages.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalService"), "managesDigitalServices", "The digital services that this individual manages.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DigitalServiceManager";
        String end2AttributeName = "digitalServiceManager";
        String end2AttributeDescription = "The individual responsible for the digital services.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalServiceManager"), "digitalServiceManager", "The individual responsible for the digital services.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDigitalSupportRelationship() {
        String guid = "9e187e1e-2547-46bd-b0ee-c33ac6df4a1f";
        String name = "DigitalSupport";
        String description = "Relationship identifying the digital services supporting each business capability.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("9e187e1e-2547-46bd-b0ee-c33ac6df4a1f", "DigitalSupport", null, "Relationship identifying the digital services supporting each business capability.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DigitalService";
        String end1AttributeName = "usesDigitalServices";
        String end1AttributeDescription = "The digital services that this business capability depends on.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalService"), "usesDigitalServices", "The digital services that this business capability depends on.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "BusinessCapability";
        String end2AttributeName = "consumingBusinessCapabilities";
        String end2AttributeDescription = "The business capabilities that depend on the digital services.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("BusinessCapability"), "consumingBusinessCapabilities", "The business capabilities that depend on the digital services.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDigitalServiceOperatorRelationship() {
        String guid = "79ac27f6-be9c-489f-a7c2-b9add0bf705c";
        String name = "DigitalServiceOperator";
        String description = "Relationship identifying the organizations responsible for operating the digital services.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("79ac27f6-be9c-489f-a7c2-b9add0bf705c", "DigitalServiceOperator", null, "Relationship identifying the organizations responsible for operating the digital services.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DigitalService";
        String end1AttributeName = "operatesDigitalServices";
        String end1AttributeDescription = "The digital services that this organization operates.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalService"), "operatesDigitalServices", "The digital services that this organization operates.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Organization";
        String end2AttributeName = "digitalServiceOperators";
        String end2AttributeDescription = "The organizations that support the digital service's operations.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Organization"), "digitalServiceOperators", "The organizations that support the digital service's operations.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "scope";
        String attribute1Description = "The extent to which this operator is responsible for the digital service operations.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("scope", "The extent to which this operator is responsible for the digital service operations.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0717DigitalServiceImplementation() {
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceImplementationRelationship());
    }

    private RelationshipDef getDigitalServiceImplementationRelationship() {
        String guid = "873e29bd-ca14-4833-a6bb-9ebdf89b5b1b";
        String name = "DigitalServiceImplementation";
        String description = "Relationship identifying the implementation of a digital service.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("873e29bd-ca14-4833-a6bb-9ebdf89b5b1b", "DigitalServiceImplementation", null, "Relationship identifying the implementation of a digital service.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DigitalService";
        String end1AttributeName = "partOfDigitalServices";
        String end1AttributeDescription = "The digital services that use this capability.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalService"), "partOfDigitalServices", "The digital services that use this capability.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SoftwareServerCapability";
        String end2AttributeName = "implementedBy";
        String end2AttributeDescription = "The list of software server capabilities that support this digital service.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareServerCapability"), "implementedBy", "The list of software server capabilities that support this digital service.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Details of how the software server capability supports the needs of the digital service.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Details of how the software server capability supports the needs of the digital service.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0720InformationSupplyChains() {
        this.archiveBuilder.addEntityDef(this.getInformationSupplyChainEntity());
        this.archiveBuilder.addEntityDef(this.getInformationSupplyChainSegmentEntity());
        this.archiveBuilder.addRelationshipDef(this.getInformationSupplyChainCompositionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getInformationSupplyChainImplementationRelationship());
    }

    private EntityDef getInformationSupplyChainEntity() {
        String guid = "fa6de61d-98cb-48c4-b21f-ab7186235fd4";
        String name = "InformationSupplyChain";
        String description = "A description of a managed flow of information between multiple systems.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("fa6de61d-98cb-48c4-b21f-ab7186235fd4", "InformationSupplyChain", this.archiveBuilder.getEntityDef("Referenceable"), "A description of a managed flow of information between multiple systems.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "displayName";
        String attribute1Description = "Name of the information supply chain.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Brief description of the information supply chain.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "scope";
        String attribute3Description = "Breadth of applicability of the information supply chain to the organization.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "purposes";
        String attribute4Description = "Reasons to have this information supply chain.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Name of the information supply chain.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Brief description of the information supply chain.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("scope", "Breadth of applicability of the information supply chain to the organization.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("purposes", "Reasons to have this information supply chain.", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private EntityDef getInformationSupplyChainSegmentEntity() {
        String guid = "6d9980b2-5c0b-4314-8d8d-9fa45f8904d1";
        String name = "InformationSupplyChainSegment";
        String description = "A section of an information supply chain that has common characteristics.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("6d9980b2-5c0b-4314-8d8d-9fa45f8904d1", "InformationSupplyChainSegment", this.archiveBuilder.getEntityDef("Referenceable"), "A section of an information supply chain that has common characteristics.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "displayName";
        String attribute1Description = "Name of the segment.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Brief description of the segment.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "scope";
        String attribute3Description = "Breadth of applicability of this segment to the organization.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "integrationStyle";
        String attribute4Description = "Mechanism to flow data along the segment.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "estimatedVolumetrics";
        String attribute5Description = "Properties that describe the expected volumes of data flowing through this segment.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Name of the segment.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Brief description of the segment.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("scope", "Breadth of applicability of this segment to the organization.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("integrationStyle", "Mechanism to flow data along the segment.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("estimatedVolumetrics", "Properties that describe the expected volumes of data flowing through this segment.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private RelationshipDef getInformationSupplyChainCompositionRelationship() {
        String guid = "fcdccfa3-e9f0-4543-8720-1958799fb6dc";
        String name = "InformationSupplyChainComposition";
        String description = "Relationship identifying the segments in an information supply chain.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("fcdccfa3-e9f0-4543-8720-1958799fb6dc", "InformationSupplyChainComposition", null, "Relationship identifying the segments in an information supply chain.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "InformationSupplyChain";
        String end1AttributeName = "informationSupplyChains";
        String end1AttributeDescription = "Owning information supply chain.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("InformationSupplyChain"), "informationSupplyChains", "Owning information supply chain.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "InformationSupplyChainSegment";
        String end2AttributeName = "segments";
        String end2AttributeDescription = "A role performed by this person.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("InformationSupplyChainSegment"), "segments", "A role performed by this person.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getInformationSupplyChainImplementationRelationship() {
        String guid = "94715275-0520-43e9-81fe-4fe8ec3d8f3a";
        String name = "InformationSupplyChainImplementation";
        String description = "Implementation components for an information supply chain segment.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("94715275-0520-43e9-81fe-4fe8ec3d8f3a", "InformationSupplyChainImplementation", null, "Implementation components for an information supply chain segment.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "InformationSupplyChainSegment";
        String end1AttributeName = "partOfSegments";
        String end1AttributeDescription = "A related section of an information supply chain .";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("InformationSupplyChainSegment"), "partOfSegments", "A related section of an information supply chain .", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Process";
        String end2AttributeName = "implementedByProcesses";
        String end2AttributeDescription = "Processes that implement the information supply chain.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Process"), "implementedByProcesses", "Processes that implement the information supply chain.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0730SolutionComponents() {
        this.archiveBuilder.addEntityDef(this.getSolutionComponentEntity());
        this.archiveBuilder.addRelationshipDef(this.getSolutionCompositionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSolutionComponentImplementationRelationship());
    }

    private EntityDef getSolutionComponentEntity() {
        String guid = "b83f3d42-f3f7-4155-ae65-58fb44ea7644";
        String name = "SolutionComponent";
        String description = "Description of a well-defined capability within a solution.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("b83f3d42-f3f7-4155-ae65-58fb44ea7644", "SolutionComponent", this.archiveBuilder.getEntityDef("Referenceable"), "Description of a well-defined capability within a solution.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "displayName";
        String attribute1Description = "Name of the component.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Brief description of the component.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "versionNumber";
        String attribute3Description = "Version number (major.minor) of the component.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Name of the component.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Brief description of the component.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("versionNumber", "Version number (major.minor) of the component.", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private RelationshipDef getSolutionCompositionRelationship() {
        String guid = "2a9e56c3-bcf6-41de-bbe9-1e63b81d3114";
        String name = "SolutionComposition";
        String description = "Relationship showing the nesting structure of solution components.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2a9e56c3-bcf6-41de-bbe9-1e63b81d3114", "SolutionComposition", null, "Relationship showing the nesting structure of solution components.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SolutionComponent";
        String end1AttributeName = "usedInSolutionComponents";
        String end1AttributeDescription = "The solution components that embed this component.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionComponent"), "usedInSolutionComponents", "The solution components that embed this component.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SolutionComponent";
        String end2AttributeName = "nestedSolutionComponents";
        String end2AttributeDescription = "The sub-parts of this solution component.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionComponent"), "nestedSolutionComponents", "The sub-parts of this solution component.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getSolutionComponentImplementationRelationship() {
        String guid = "d0dd0ac7-01f4-48e0-ae4d-4f7268573fa8";
        String name = "SolutionComponentImplementation";
        String description = "Relationship identifying a solution component's implementation.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("d0dd0ac7-01f4-48e0-ae4d-4f7268573fa8", "SolutionComponentImplementation", null, "Relationship identifying a solution component's implementation.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SolutionComponent";
        String end1AttributeName = "partOfComponentDesigns";
        String end1AttributeDescription = "A person performing this role.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionComponent"), "partOfComponentDesigns", "A person performing this role.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SoftwareServerCapability";
        String end2AttributeName = "implementedBy";
        String end2AttributeDescription = "One of the implementation parts of the solution component.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareServerCapability"), "implementedBy", "One of the implementation parts of the solution component.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Description of how the software server capability supports the solution component.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of how the software server capability supports the solution component.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0735SolutionPortsAndWires() {
        this.archiveBuilder.addEnumDef(this.getSolutionPortDirectionEnum());
        this.archiveBuilder.addEntityDef(this.getSolutionPortEntity());
        this.archiveBuilder.addRelationshipDef(this.getSolutionLinkingWireRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSolutionComponentPortRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSolutionPortDelegationRelationship());
    }

    private EnumDef getSolutionPortDirectionEnum() {
        String guid = "4879c96e-26c7-48af-ba92-8277632be733";
        String name = "SolutionPortDirection";
        String description = "Defines the direction of flow of information through a solution port.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("4879c96e-26c7-48af-ba92-8277632be733", "SolutionPortDirection", "Defines the direction of flow of information through a solution port.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Unknown";
        String element1Description = "The direction of flow is unknown.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Unknown", "The direction of flow is unknown.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Output";
        String element2Description = "The process is producing information through this port.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Output", "The process is producing information through this port.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Input";
        String element3Description = "The process is consuming information through this port.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Input", "The process is consuming information through this port.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "InOut";
        String element4Description = "The process has a call interface attached to this port.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "InOut", "The process has a call interface attached to this port.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 4;
        String element5Value = "OutIn";
        String element5Description = "The process is issuing a call to an external API through this port.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(4, "OutIn", "The process is issuing a call to an external API through this port.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        int element6Ordinal = 99;
        String element6Value = "Other";
        String element6Description = "Another direction.";
        String element6DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another direction.", element6DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getSolutionPortEntity() {
        String guid = "62ef448c-d4c1-4c94-a565-5e5625f6a57b";
        String name = "SolutionPort";
        String description = "An external endpoint for a solution.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("62ef448c-d4c1-4c94-a565-5e5625f6a57b", "SolutionPort", this.archiveBuilder.getEntityDef("Referenceable"), "An external endpoint for a solution.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "displayName";
        String attribute1Description = "Name of the port.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description of the port.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "versionNumber";
        String attribute3Description = "Version number (major.minor) of the port.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "direction";
        String attribute4Description = "Which way is data flowing?";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Name of the port.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the port.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("versionNumber", "Version number (major.minor) of the port.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("SolutionPortDirection", "direction", "Which way is data flowing?", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private RelationshipDef getSolutionLinkingWireRelationship() {
        String guid = "892a3d1c-cfb8-431d-bd59-c4d38833bfb0";
        String name = "SolutionLinkingWire";
        String description = "Connection between two solution ports that shows how data flows.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("892a3d1c-cfb8-431d-bd59-c4d38833bfb0", "SolutionLinkingWire", null, "Connection between two solution ports that shows how data flows.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SolutionPort";
        String end1AttributeName = "connectedPorts";
        String end1AttributeDescription = "Port that the wire connects to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionPort"), "connectedPorts", "Port that the wire connects to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SolutionPort";
        String end2AttributeName = "connectedPorts";
        String end2AttributeDescription = "Port that the wire connects to.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionPort"), "connectedPorts", "Port that the wire connects to.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "informationSupplyChainSegmentGUIDs";
        String attribute1Description = "Unique identifier of information supply chain segments that this wire belongs to (typically only one).";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute("informationSupplyChainSegmentGUIDs", "Unique identifier of information supply chain segments that this wire belongs to (typically only one).", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getSolutionComponentPortRelationship() {
        String guid = "5652d03a-f6c9-411a-a3e4-f490d3856b64";
        String name = "SolutionComponentPort";
        String description = "Link between a solution component and its ports.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("5652d03a-f6c9-411a-a3e4-f490d3856b64", "SolutionComponentPort", null, "Link between a solution component and its ports.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SolutionComponent";
        String end1AttributeName = "solutionComponent";
        String end1AttributeDescription = "Owning solution component that this port belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionComponent"), "solutionComponent", "Owning solution component that this port belongs to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SolutionPort";
        String end2AttributeName = "solutionPorts";
        String end2AttributeDescription = "List ports for this solution component.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionPort"), "solutionPorts", "List ports for this solution component.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getSolutionPortDelegationRelationship() {
        String guid = "8335e6ed-fd86-4000-9bc5-5203062f28ba";
        String name = "SolutionPortDelegation";
        String description = "Aligns ports from nested components with the parent's.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("8335e6ed-fd86-4000-9bc5-5203062f28ba", "SolutionPortDelegation", null, "Aligns ports from nested components with the parent's.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SolutionPort";
        String end1AttributeName = "alignsToPort";
        String end1AttributeDescription = "Encapsulating solution component's port";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionPort"), "alignsToPort", "Encapsulating solution component's port", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SolutionPort";
        String end2AttributeName = "delegationPorts";
        String end2AttributeDescription = "Ports from nested components that align with the port from the encapsulating solution component.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionPort"), "delegationPorts", "Ports from nested components that align with the port from the encapsulating solution component.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0740SolutionBlueprints() {
        this.archiveBuilder.addEntityDef(this.getSolutionBlueprintEntity());
        this.archiveBuilder.addRelationshipDef(this.getSolutionBlueprintCompositionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDigitalServiceDesignRelationship());
    }

    private EntityDef getSolutionBlueprintEntity() {
        String guid = "4aa47799-5128-4eeb-bd72-e357b49f8bfe";
        String name = "SolutionBlueprint";
        String description = "Collection of solution components that make up a digital service.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("4aa47799-5128-4eeb-bd72-e357b49f8bfe", "SolutionBlueprint", this.archiveBuilder.getEntityDef("Referenceable"), "Collection of solution components that make up a digital service.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "displayName";
        String attribute1Description = "Name of the solution.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description of the solution.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "versionNumber";
        String attribute3Description = "Version number (major.minor) of the solution.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Name of the solution.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the solution.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("versionNumber", "Version number (major.minor) of the solution.", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PREPARED);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.REJECTED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DISABLED);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private RelationshipDef getSolutionBlueprintCompositionRelationship() {
        String guid = "f1ae975f-f11a-467b-8c7a-b023081e4712";
        String name = "SolutionBlueprintComposition";
        String description = "Link between a solution blueprint and a solution component.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("f1ae975f-f11a-467b-8c7a-b023081e4712", "SolutionBlueprintComposition", null, "Link between a solution blueprint and a solution component.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SolutionBlueprint";
        String end1AttributeName = "usedInSolutionBlueprints";
        String end1AttributeDescription = "The solutions where this component features.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionBlueprint"), "usedInSolutionBlueprints", "The solutions where this component features.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SolutionComponent";
        String end2AttributeName = "containsSolutionComponents";
        String end2AttributeDescription = "List of solution components that make up the solution.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionComponent"), "containsSolutionComponents", "List of solution components that make up the solution.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Description of the solution component's role in the solution.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the solution component's role in the solution.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getDigitalServiceDesignRelationship() {
        String guid = "a43b4c9c-52c2-4819-b3cc-9d07d49a11f2";
        String name = "DigitalServiceDesign";
        String description = "Relationship identifying the solution blueprint for a digital service.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("a43b4c9c-52c2-4819-b3cc-9d07d49a11f2", "DigitalServiceDesign", null, "Relationship identifying the solution blueprint for a digital service.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DigitalService";
        String end1AttributeName = "describesDigitalService";
        String end1AttributeDescription = "Digital service described by the blueprint.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DigitalService"), "describesDigitalService", "Digital service described by the blueprint.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SolutionBlueprint";
        String end2AttributeName = "digitalServiceDesigns";
        String end2AttributeDescription = "The difference versions of the digital service's designs.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionBlueprint"), "digitalServiceDesigns", "The difference versions of the digital service's designs.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0750DataPassing() {
        this.archiveBuilder.addRelationshipDef(this.getProcessCallRelationship());
        this.archiveBuilder.addRelationshipDef(this.getProcessInputRelationship());
        this.archiveBuilder.addRelationshipDef(this.getProcessOutputRelationship());
    }

    private RelationshipDef getProcessCallRelationship() {
        String guid = "af904501-6347-4f52-8378-da50e8d74828";
        String name = "ProcessCall";
        String description = "Shows a call between 2 assets.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("af904501-6347-4f52-8378-da50e8d74828", "ProcessCall", null, "Shows a call between 2 assets.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Asset";
        String end1AttributeName = "calls";
        String end1AttributeDescription = "Caller asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Asset"), "calls", "Caller asset.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Asset";
        String end2AttributeName = "calledBy";
        String end2AttributeDescription = "Called asset.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Asset"), "calledBy", "Called asset.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Description and purpose of the call.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Description and purpose of the call.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getProcessInputRelationship() {
        String guid = "d1a9a79f-4c9c-4dff-837e-1353ba51b607";
        String name = "ProcessInput";
        String description = "The feed of data into a process.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("d1a9a79f-4c9c-4dff-837e-1353ba51b607", "ProcessInput", null, "The feed of data into a process.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Process";
        String end1AttributeName = "consumedByProcess";
        String end1AttributeDescription = "Process that is receiving the information from the asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Process"), "consumedByProcess", "Process that is receiving the information from the asset.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Asset";
        String end2AttributeName = "processInputData";
        String end2AttributeDescription = "Asset supplying input data.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Asset"), "processInputData", "Asset supplying input data.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Description of the data feed.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the data feed.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getProcessOutputRelationship() {
        String guid = "e3e40f99-70fe-478c-9676-78a50cded70b";
        String name = "ProcessOutput";
        String description = "The feed of data from a process.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e3e40f99-70fe-478c-9676-78a50cded70b", "ProcessOutput", null, "The feed of data from a process.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Process";
        String end1AttributeName = "producedByProcess";
        String end1AttributeDescription = "Process that is creating and updating the information in the asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Process"), "producedByProcess", "Process that is creating and updating the information in the asset.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Asset";
        String end2AttributeName = "processOutputData";
        String end2AttributeDescription = "Asset receiving output data.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Asset"), "processOutputData", "Asset receiving output data.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Description of the data feed.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the data feed.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0760BusinessLineage() {
        this.archiveBuilder.addClassificationDef(this.getBusinessSignificantClassification());
    }

    private ClassificationDef getBusinessSignificantClassification() {
        String guid = "085febdd-f129-4f4b-99aa-01f3e6294e9f";
        String name = "BusinessSignificant";
        String description = "A referenceable item that is meaningful to business users.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("085febdd-f129-4f4b-99aa-01f3e6294e9f", "BusinessSignificant", null, "A referenceable item that is meaningful to business users.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "description";
        String attribute1Description = "Description of the item in business terms.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "scope";
        String attribute2Description = "Scope of where this item is meaningful.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "businessCapabilityGUID";
        String attribute3Description = "Unique identifier of the business capability that this relevant to.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the item in business terms.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("scope", "Scope of where this item is meaningful.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("businessCapabilityGUID", "Unique identifier of the business capability that this relevant to.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0217AutomatedProcesses() {
    }

    private void add0260Transformations() {
    }

    private void add0265AnalyticsAssets() {
    }

    private void add0270IoTAssets() {
    }

    private void add0280ModelAssets() {
    }

    private void add0435GovernanceRules() {
    }

    private void add0447GovernanceProcesses() {
    }

    private void add0452GovernanceDaemons() {
    }

    private void add0480RightsManagement() {
    }

    private void add0550LogicSpecificationModel() {
    }

    private void add0560MappingModel() {
    }
}

