/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_4;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_5 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.5";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache 2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_5() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_5(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_4 previousTypes = new OpenMetadataTypesArchive3_4(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0041ServerPurpose();
        this.update00420045SoftwareCapabilities();
        this.extend0112Person();
        this.update0130Projects();
        this.update0140Communities();
        this.update0461GovernanceEngines();
    }

    private void update00420045SoftwareCapabilities() {
        this.archiveBuilder.addEntityDef(this.getSoftwareCapabilityEntity());
        this.archiveBuilder.addRelationshipDef(this.getSupportedSoftwareCapabilityRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSoftwareServerSupportedCapabilityRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateSoftwareServerCapabilityEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateFileSystemClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateFileManagerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateNotificationManagerClassification());
        this.archiveBuilder.addClassificationDef(this.addSourceControlLibraryClassification());
        this.archiveBuilder.addClassificationDef(this.addChangeManagementLibraryClassification());
        this.archiveBuilder.addClassificationDef(this.addSoftwareLibraryClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateDatabaseManagerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateContentCollectionManagerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateCloudServiceClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateServerAssetUseRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateSoftwareServerDeploymentRelationship());
    }

    private EntityDef getSoftwareCapabilityEntity() {
        String guid = "54055c38-b9ad-4a66-a75b-14dc643d4c69";
        String name = "SoftwareCapability";
        String description = "A software capability such as an software service or engine.";
        String descriptionGUID = null;
        String superTypeName = "Referenceable";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("54055c38-b9ad-4a66-a75b-14dc643d4c69", "SoftwareCapability", this.archiveBuilder.getEntityDef("Referenceable"), "A software capability such as an software service or engine.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "name";
        String attribute1Description = "Name of the software capability.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description of the software capability.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "capabilityType";
        String attribute3Description = "Type of the software capability.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "capabilityVersion";
        String attribute4Description = "Version number of the software capability.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "patchLevel";
        String attribute5Description = "Patch level of the software server capability.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "source";
        String attribute6Description = "Supplier of the software server capability.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("name", "Name of the software capability.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the software capability.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("capabilityType", "Type of the software capability.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("capabilityVersion", "Version number of the software capability.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("patchLevel", "Patch level of the software server capability.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("source", "Supplier of the software server capability.", attribute6DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSupportedSoftwareCapabilityRelationship() {
        String guid = "2480aa71-44c5-414d-8b32-9c4340786d77";
        String name = "SupportedSoftwareCapability";
        String description = "Identifies a software capability that is deployed to an instance of IT infrastructure.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2480aa71-44c5-414d-8b32-9c4340786d77", "SupportedSoftwareCapability", null, "Identifies a software capability that is deployed to an instance of IT infrastructure.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ITInfrastructure";
        String end1AttributeName = "hostedByDeployedITInfrastructure";
        String end1AttributeDescription = "IT infrastructure hosting this capability.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ITInfrastructure"), "hostedByDeployedITInfrastructure", "IT infrastructure hosting this capability.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SoftwareCapability";
        String end2AttributeName = "capabilities";
        String end2AttributeDescription = "Capabilities deployed on this IT infrastructure.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareCapability"), "capabilities", "Capabilities deployed on this IT infrastructure.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "deploymentTime";
        String attribute1Description = "Time that the software capability was deployed to the IT Infrastructure.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "deployer";
        String attribute2Description = "Person, organization or engine that deployed the software capability.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "deployerTypeName";
        String attribute3Description = "Type name of deployer.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "deployerPropertyName";
        String attribute4Description = "Identifying property name of deployer.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "capabilityStatus";
        String attribute5Description = "The operational status of the software capability on this IT Infrastructure.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("deploymentTime", "Time that the software capability was deployed to the IT Infrastructure.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("deployer", "Person, organization or engine that deployed the software capability.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("deployerTypeName", "Type name of deployer.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("deployerPropertyName", "Identifying property name of deployer.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("OperationalStatus", "capabilityStatus", "The operational status of the software capability on this IT Infrastructure.", attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch deprecateSoftwareServerSupportedCapabilityRelationship() {
        String typeName = "SoftwareServerSupportedCapability";
        String superTypeName = "SupportedSoftwareCapability";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SoftwareServerSupportedCapability");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getRelationshipDef("SupportedSoftwareCapability"));
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch updateSoftwareServerCapabilityEntity() {
        String typeName = "SoftwareServerCapability";
        String superTypeName = "SoftwareCapability";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SoftwareServerCapability");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("SoftwareCapability"));
        return typeDefPatch;
    }

    private TypeDefPatch updateFileSystemClassification() {
        String typeName = "FileSystem";
        String attachToEntity = "Referenceable";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("FileSystem");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("Referenceable")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateFileManagerClassification() {
        String typeName = "FileManager";
        String attachToEntity = "Referenceable";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("FileManager");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("Referenceable")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateNotificationManagerClassification() {
        String typeName = "NotificationManager";
        String attachToEntity = "Referenceable";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("NotificationManager");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("Referenceable")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateContentCollectionManagerClassification() {
        String typeName = "ContentCollectionManager";
        String attachToEntity = "Referenceable";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ContentCollectionManager");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("Referenceable")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private ClassificationDef addSourceControlLibraryClassification() {
        String guid = "0ef3c90d-20d7-4259-8d66-9c8bb109f2ae";
        String name = "SourceControlLibrary";
        String description = "Defines a software source code library that provides version control.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("0ef3c90d-20d7-4259-8d66-9c8bb109f2ae", "SourceControlLibrary", null, "Defines a software source code library that provides version control.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "libraryType";
        String attribute1Description = "The type of library - may be a product name or open source project name.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("libraryType", "The type of library - may be a product name or open source project name.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef addChangeManagementLibraryClassification() {
        String guid = "4e236548-b802-4a1d-a329-4abdeaae5323";
        String name = "ChangeManagementLibrary";
        String description = "Defines a managed collection of requirements, defects and proposed changes to a project.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("4e236548-b802-4a1d-a329-4abdeaae5323", "ChangeManagementLibrary", null, "Defines a managed collection of requirements, defects and proposed changes to a project.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "libraryType";
        String attribute1Description = "The type of library - may be a product name or open source project name.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("libraryType", "The type of library - may be a product name or open source project name.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef addSoftwareLibraryClassification() {
        String guid = "5708fa1a-2b64-4706-8e14-a020e4567db3";
        String name = "SoftwareLibrary";
        String description = "Defines a collection of software modules.  Also known as the definitive software library.";
        String descriptionGUID = null;
        String linkedToEntity = "Referenceable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("5708fa1a-2b64-4706-8e14-a020e4567db3", "SoftwareLibrary", null, "Defines a collection of software modules.  Also known as the definitive software library.", descriptionGUID, this.archiveBuilder.getEntityDef("Referenceable"), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "libraryType";
        String attribute1Description = "The type of library - may be a product name or open source project name.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("libraryType", "The type of library - may be a product name or open source project name.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private TypeDefPatch updateCloudServiceClassification() {
        String typeName = "CloudService";
        String attachToEntity = "SoftwareCapability";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CloudService");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("SoftwareCapability")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateDatabaseManagerClassification() {
        String typeName = "DatabaseManager";
        String attachToEntity = "DataManager";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DatabaseManager");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("DataManager")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateServerAssetUseRelationship() {
        String typeName = "ServerAssetUse";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ServerAssetUse");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "SoftwareCapability";
        String end1AttributeName = "consumedBy";
        String end1AttributeDescription = "Capability consuming this asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareCapability"), "consumedBy", "Capability consuming this asset.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2EntityType = "Asset";
        String end2AttributeName = "consumedAsset";
        String end2AttributeDescription = "Asset that this software capability is dependent on.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Asset"), "consumedAsset", "Asset that this software capability is dependent on.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateSoftwareServerDeploymentRelationship() {
        String typeName = "SoftwareServerDeployment";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SoftwareServerDeployment");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "SoftwareServerPlatform";
        String end1AttributeName = "hostingPlatforms";
        String end1AttributeDescription = "Supporting platforms for the software server.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareServerPlatform"), "hostingPlatforms", "Supporting platforms for the software server.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0041ServerPurpose() {
        this.archiveBuilder.addClassificationDef(this.addServerPurposeClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateApplicationServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateWebserverClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateDatabaseServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateMetadataServerClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateRepositoryProxyClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceDaemonClassification());
        this.archiveBuilder.addTypeDefPatch(this.updateStewardshipServerClassification());
        this.archiveBuilder.addClassificationDef(this.addIntegrationServerClassification());
    }

    private ClassificationDef addServerPurposeClassification() {
        String guid = "78f68757-600f-4e8e-843b-00e77cdee37c";
        String name = "ServerPurpose";
        String description = "Adds more detail about the purpose of a deployed instance of IT infrastructure.";
        String descriptionGUID = null;
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("ITInfrastructure"));
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("78f68757-600f-4e8e-843b-00e77cdee37c", "ServerPurpose", null, "Adds more detail about the purpose of a deployed instance of IT infrastructure.", descriptionGUID, linkedToEntities, false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "deployedImplementationType";
        String attribute1Description = "Type of software deployed - such as product name.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("deployedImplementationType", "Type of software deployed - such as product name.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private TypeDefPatch updateApplicationServerClassification() {
        String typeName = "ApplicationServer";
        String superTypeName = "ServerPurpose";
        String attachToEntity = "ITInfrastructure";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ApplicationServer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName("ServerPurpose"));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("ITInfrastructure")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateWebserverClassification() {
        String typeName = "Webserver";
        String superTypeName = "ServerPurpose";
        String attachToEntity = "ITInfrastructure";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Webserver");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName("ServerPurpose"));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("ITInfrastructure")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateDatabaseServerClassification() {
        String typeName = "DatabaseServer";
        String superTypeName = "ServerPurpose";
        String attachToEntity = "ITInfrastructure";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DatabaseServer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName("ServerPurpose"));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("ITInfrastructure")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateMetadataServerClassification() {
        String typeName = "MetadataServer";
        String superTypeName = "ServerPurpose";
        String attachToEntity = "ITInfrastructure";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("MetadataServer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName("ServerPurpose"));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("ITInfrastructure")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateRepositoryProxyClassification() {
        String typeName = "RepositoryProxy";
        String superTypeName = "ServerPurpose";
        String attachToEntity = "ITInfrastructure";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("RepositoryProxy");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName("ServerPurpose"));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("ITInfrastructure")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceDaemonClassification() {
        String typeName = "GovernanceDaemon";
        String superTypeName = "ServerPurpose";
        String attachToEntity = "ITInfrastructure";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceDaemon");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName("ServerPurpose"));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("ITInfrastructure")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private TypeDefPatch updateStewardshipServerClassification() {
        String typeName = "StewardshipServer";
        String superTypeName = "ServerPurpose";
        String attachToEntity = "ITInfrastructure";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("StewardshipServer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getTypeDefByName("ServerPurpose"));
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName("ITInfrastructure")));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private ClassificationDef addIntegrationServerClassification() {
        String guid = "c165b760-d9ab-47ac-a2ee-7854ec74605a";
        String name = "IntegrationServer";
        String superTypeName = "ServerPurpose";
        String description = "Identifies a server that exchanges data between between other servers.";
        String descriptionGUID = null;
        ArrayList<TypeDefLink> linkedToEntities = new ArrayList<TypeDefLink>();
        linkedToEntities.add(this.archiveBuilder.getEntityDef("ITInfrastructure"));
        return this.archiveHelper.getClassificationDef("c165b760-d9ab-47ac-a2ee-7854ec74605a", "IntegrationServer", (TypeDefLink)this.archiveBuilder.getClassificationDef("ServerPurpose"), "Identifies a server that exchanges data between between other servers.", descriptionGUID, linkedToEntities, false);
    }

    private void extend0112Person() {
        this.archiveBuilder.addTypeDefPatch(this.updatePersonEntity());
    }

    private TypeDefPatch updatePersonEntity() {
        String typeName = "Person";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Person");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "title";
        String attribute1Description = "The courtesy title for the person.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "givenNames";
        String attribute2Description = "The name strings that are the part of a person's name that is not their surname.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "surname";
        String attribute3Description = "The family name of the person.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "employeeNumber";
        String attribute4Description = "The unique identifier of the person used by their employer.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "employeeType";
        String attribute5Description = "Code used by employer typically to describe the type of employment contract.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "preferredLanguage";
        String attribute6Description = "Spoken or written language preferred by the person.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "initials";
        String attribute7Description = "First letter of each of the person's given names.";
        String attribute7DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("title", "The courtesy title for the person.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("givenNames", "The name strings that are the part of a person's name that is not their surname.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("surname", "The family name of the person.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("employeeNumber", "The unique identifier of the person used by their employer.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("employeeType", "Code used by employer typically to describe the type of employment contract.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("preferredLanguage", "Spoken or written language preferred by the person.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("initials", "First letter of each of the person's given names.", attribute7DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0130Projects() {
        this.archiveBuilder.addTypeDefPatch(this.updateProjectManagementRelationship());
    }

    private TypeDefPatch updateProjectManagementRelationship() {
        String typeName = "ProjectManagement";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProjectManagement");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2EntityType = "PersonRole";
        String end2AttributeName = "projectManagers";
        String end2AttributeDescription = "The roles for managing this project.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("PersonRole"), "projectManagers", "The roles for managing this project.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0140Communities() {
        this.archiveBuilder.addTypeDefPatch(this.updateCommunityMembershipRelationship());
    }

    private TypeDefPatch updateCommunityMembershipRelationship() {
        String typeName = "CommunityMembership";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("CommunityMembership");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2EntityType = "PersonRole";
        String end2AttributeName = "communityMembers";
        String end2AttributeDescription = "Members of the community.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("PersonRole"), "communityMembers", "Members of the community.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0461GovernanceEngines() {
        this.archiveBuilder.addEntityDef(this.addArchiveEngineEntity());
        this.archiveBuilder.addEntityDef(this.addArchiveServiceEntity());
    }

    private EntityDef addArchiveEngineEntity() {
        String guid = "773298be-68ab-4b99-99ab-19eaa886261e";
        String name = "ArchiveEngine";
        String description = "A collection of related archive services.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceEngine";
        return this.archiveHelper.getDefaultEntityDef("773298be-68ab-4b99-99ab-19eaa886261e", "ArchiveEngine", this.archiveBuilder.getEntityDef("GovernanceEngine"), "A collection of related archive services.", descriptionGUID);
    }

    private EntityDef addArchiveServiceEntity() {
        String guid = "e6c049e2-56aa-4512-a634-20cd7085e534";
        String name = "ArchiveService";
        String description = "A governance service that maintains open metadata archives.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceService";
        return this.archiveHelper.getDefaultEntityDef("e6c049e2-56aa-4512-a634-20cd7085e534", "ArchiveService", this.archiveBuilder.getEntityDef("GovernanceService"), "A governance service that maintains open metadata archives.", descriptionGUID);
    }
}

