/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_7;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_8 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.8";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache 2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_8() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_8(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_7 previousTypes = new OpenMetadataTypesArchive3_7(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0011ManagingReferenceables();
        this.update0015LinkedMediaTypes();
        this.update0160NoteLogs();
        this.update0030OperatingPlatforms();
        this.update0057SoftwareServices();
        this.update0070NetworksAndGateways();
        this.update0461GovernanceEngines();
        this.update0566DesignModelOrganization();
        this.update0571ConceptModels();
        this.update0615SchemaExtraction();
    }

    private void update0011ManagingReferenceables() {
        this.archiveBuilder.addTypeDefPatch(this.updateSourcedFromRelationship());
    }

    private TypeDefPatch updateSourcedFromRelationship() {
        String typeName = "SourcedFrom";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SourcedFrom");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "Referenceable";
        String end1AttributeName = "resultingElement";
        String end1AttributeDescription = "Element created from the template.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "resultingElement", "Element created from the template.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2EntityType = "Referenceable";
        String end2AttributeName = "templateElement";
        String end2AttributeDescription = "Template element providing information.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Referenceable"), "templateElement", "Template element providing information.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0015LinkedMediaTypes() {
        this.archiveBuilder.addTypeDefPatch(this.updateExternalReferenceLinkRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateMediaReferenceRelationship());
    }

    private TypeDefPatch updateExternalReferenceLinkRelationship() {
        String typeName = "ExternalReferenceLink";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ExternalReferenceLink");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private TypeDefPatch updateMediaReferenceRelationship() {
        String typeName = "MediaReference";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("MediaReference");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private void update0057SoftwareServices() {
        this.archiveBuilder.addEntityDef(this.addMetadataRepositoryServiceEntity());
        this.archiveBuilder.addEntityDef(this.addSecurityServiceEntity());
    }

    private EntityDef addMetadataRepositoryServiceEntity() {
        String guid = "27891e52-1255-4a33-98a2-377717a25334";
        String name = "MetadataRepositoryService";
        String description = "Provides access to a metadata repository - either local or remote.";
        String descriptionGUID = null;
        String superTypeName = "SoftwareService";
        return this.archiveHelper.getDefaultEntityDef("27891e52-1255-4a33-98a2-377717a25334", "MetadataRepositoryService", this.archiveBuilder.getEntityDef("SoftwareService"), "Provides access to a metadata repository - either local or remote.", descriptionGUID);
    }

    private EntityDef addSecurityServiceEntity() {
        String guid = "2df2069f-6475-400c-bf8c-6d2072a55d47";
        String name = "SecurityService";
        String description = "Provides security services - classifications identify specific capabilities.";
        String descriptionGUID = null;
        String superTypeName = "SoftwareService";
        return this.archiveHelper.getDefaultEntityDef("2df2069f-6475-400c-bf8c-6d2072a55d47", "SecurityService", this.archiveBuilder.getEntityDef("SoftwareService"), "Provides security services - classifications identify specific capabilities.", descriptionGUID);
    }

    private void update0030OperatingPlatforms() {
        this.archiveBuilder.addRelationshipDef(this.addSoftwarePackageDependencyRelationship());
    }

    private RelationshipDef addSoftwarePackageDependencyRelationship() {
        String guid = "2c05beaf-e313-47f8-ac18-2298140b2ad9";
        String name = "SoftwarePackageDependency";
        String description = "Shows the software packages being used within an asset.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2c05beaf-e313-47f8-ac18-2298140b2ad9", "SoftwarePackageDependency", null, "Shows the software packages being used within an asset.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Asset";
        String end1AttributeName = "runningWithAsset";
        String end1AttributeDescription = "Assets making use of software package.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Asset"), "runningWithAsset", "Assets making use of software package.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Collection";
        String end2AttributeName = "dependsOnSoftwarePackages";
        String end2AttributeDescription = "Collection of software packages.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Collection"), "dependsOnSoftwarePackages", "Collection of software packages.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0070NetworksAndGateways() {
        this.archiveBuilder.addRelationshipDef(this.getVisibleEndpointRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateHostNetworkRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateNetworkGatewayLinkRelationship());
    }

    private RelationshipDef getVisibleEndpointRelationship() {
        String guid = "5e1722c7-0167-49a0-bd77-fbf9dc5eb5bb";
        String name = "VisibleEndpoint";
        String description = "Shows that network that an endpoint is visible through.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("5e1722c7-0167-49a0-bd77-fbf9dc5eb5bb", "VisibleEndpoint", null, "Shows that network that an endpoint is visible through.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Endpoint";
        String end1AttributeName = "visibleEndpoints";
        String end1AttributeDescription = "Endpoint callable through network.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Endpoint"), "visibleEndpoints", "Endpoint callable through network.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Network";
        String end2AttributeName = "visibleInNetwork";
        String end2AttributeDescription = "Networks from which the endpoint can be called.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Network"), "visibleInNetwork", "Networks from which the endpoint can be called.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch deprecateHostNetworkRelationship() {
        String typeName = "HostNetwork";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("HostNetwork");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch updateNetworkGatewayLinkRelationship() {
        String typeName = "NetworkGatewayLink";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("NetworkGatewayLink");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "name";
        String attribute1Description = "Name for the network mapping.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "description";
        String attribute2Description = "Description and purpose of the network mapping.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "externalEndpointAddress";
        String attribute3Description = "Network address used by callers to the network gateway.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "internalEndpointAddress";
        String attribute4Description = "Network address that the network gateway maps the request to.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("name", "Name for the network mapping.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description and purpose of the network mapping.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("externalEndpointAddress", "Network address used by callers to the network gateway.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("internalEndpointAddress", "Network address that the network gateway maps the request to.", attribute4DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0160NoteLogs() {
        this.archiveBuilder.addTypeDefPatch(this.updateNoteLogAuthorshipRelationship());
    }

    private TypeDefPatch updateNoteLogAuthorshipRelationship() {
        String typeName = "NoteLogAuthorship";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("NoteLogAuthorship");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "PersonRole";
        String end1AttributeName = "authors";
        String end1AttributeDescription = "Person contributing to the note log.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("PersonRole"), "authors", "Person contributing to the note log.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        String end2EntityType = "NoteLog";
        String end2AttributeName = "authoredNoteLogs";
        String end2AttributeDescription = "Note log containing contributions.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("NoteLog"), "authoredNoteLogs", "Note log containing contributions.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update0461GovernanceEngines() {
        this.archiveBuilder.addEntityDef(this.getRepositoryGovernanceEngineEntity());
        this.archiveBuilder.addEntityDef(this.getRepositoryGovernanceServiceEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateSupportedGovernanceServiceRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateArchiveEngine());
        this.archiveBuilder.addTypeDefPatch(this.deprecateArchiveService());
    }

    private TypeDefPatch updateSupportedGovernanceServiceRelationship() {
        String typeName = "SupportedGovernanceService";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SupportedGovernanceService");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateArchiveEngine() {
        String typeName = "ArchiveEngine";
        String superTypeName = "RepositoryGovernanceEngine";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ArchiveEngine");
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("RepositoryGovernanceEngine"));
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateArchiveService() {
        String typeName = "ArchiveService";
        String superTypeName = "RepositoryGovernanceService";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ArchiveService");
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("RepositoryGovernanceService"));
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private EntityDef getRepositoryGovernanceEngineEntity() {
        String guid = "2b3bed05-c227-47d7-87a3-139ab0568361";
        String name = "RepositoryGovernanceEngine";
        String description = "A governance engine for open metadata repositories.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceEngine";
        return this.archiveHelper.getDefaultEntityDef("2b3bed05-c227-47d7-87a3-139ab0568361", "RepositoryGovernanceEngine", this.archiveBuilder.getEntityDef("GovernanceEngine"), "A governance engine for open metadata repositories.", descriptionGUID);
    }

    private EntityDef getRepositoryGovernanceServiceEntity() {
        String guid = "978e7674-8231-4158-a4e3-a5ccdbcad60e";
        String name = "RepositoryGovernanceService";
        String description = "A governance service for open metadata repositories.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceService";
        return this.archiveHelper.getDefaultEntityDef("978e7674-8231-4158-a4e3-a5ccdbcad60e", "RepositoryGovernanceService", this.archiveBuilder.getEntityDef("GovernanceService"), "A governance service for open metadata repositories.", descriptionGUID);
    }

    private void update0566DesignModelOrganization() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateDesignModelElementOwnershipRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateDesignModelGroupOwnershipRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateDesignModelGroupHierarchyRelationship());
        this.archiveBuilder.addRelationshipDef(this.addDesignModelOwnershipRelationship());
    }

    private TypeDefPatch deprecateDesignModelElementOwnershipRelationship() {
        String typeName = "DesignModelElementOwnership";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DesignModelElementOwnership");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateDesignModelGroupOwnershipRelationship() {
        String typeName = "DesignModelGroupOwnership";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DesignModelGroupOwnership");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateDesignModelGroupHierarchyRelationship() {
        String typeName = "DesignModelGroupHierarchy";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DesignModelGroupHierarchy");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private RelationshipDef addDesignModelOwnershipRelationship() {
        String guid = "d57043c2-eeab-4167-8d0d-2223af8aee93";
        String name = "DesignModelOwnership";
        String description = "Links design model elements to their owning model.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("d57043c2-eeab-4167-8d0d-2223af8aee93", "DesignModelOwnership", null, "Links design model elements to their owning model.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DesignModel";
        String end1AttributeName = "owningDesignModel";
        String end1AttributeDescription = "Owning model.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModel"), "owningDesignModel", "Owning model.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DesignModelElement";
        String end2AttributeName = "designModelElements";
        String end2AttributeDescription = "List of elements that belong to this model.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModelElement"), "designModelElements", "List of elements that belong to this model.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void update0571ConceptModels() {
        this.archiveBuilder.addClassificationDef(this.addConceptModelClassification());
    }

    private ClassificationDef addConceptModelClassification() {
        String guid = "7149c2de-5f24-4959-9b24-9d5e67709fac";
        String name = "ConceptModel";
        String description = "Identifies that a design model as a concept model.";
        String descriptionGUID = null;
        String linkedToEntity = "DesignModel";
        return this.archiveHelper.getClassificationDef("7149c2de-5f24-4959-9b24-9d5e67709fac", "ConceptModel", null, "Identifies that a design model as a concept model.", descriptionGUID, this.archiveBuilder.getEntityDef("DesignModel"), false);
    }

    private void update0615SchemaExtraction() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateDataClassDefinitionRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateSchemaAttributeDefinition());
        this.archiveBuilder.addTypeDefPatch(this.updateRelationshipAnnotation());
    }

    private TypeDefPatch deprecateDataClassDefinitionRelationship() {
        String typeName = "DataClassDefinition";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataClassDefinition");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch updateSchemaAttributeDefinition() {
        String typeName = "SchemaAttributeDefinition";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SchemaAttributeDefinition");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "assetGUID";
        String attribute1Description = "Unique identifier for the analyzed asset.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("assetGUID", "Unique identifier for the analyzed asset.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateRelationshipAnnotation() {
        String typeName = "RelationshipAnnotation";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("RelationshipAnnotation");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "discoveryReportGUID";
        String attribute1Description = "Unique identifier for the discovery analysis report that this relationship belongs to.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("discoveryReportGUID", "Unique identifier for the discovery analysis report that this relationship belongs to.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

