/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class StructPropertyValue
extends InstancePropertyValue {
    private static final long serialVersionUID = 1L;
    private InstanceProperties attributes = null;

    public StructPropertyValue() {
        super(InstancePropertyCategory.STRUCT);
    }

    public StructPropertyValue(StructPropertyValue template) {
        super(template);
        if (template != null) {
            this.attributes = template.getAttributes();
        }
    }

    @Override
    public InstancePropertyValue cloneFromSubclass() {
        return new StructPropertyValue(this);
    }

    @Override
    public String valueAsString() {
        return this.mapValuesAsString(this.attributes.getInstanceProperties()).toString();
    }

    @Override
    public Object valueAsObject() {
        return this.mapValuesAsObject(this.attributes.getInstanceProperties());
    }

    public InstanceProperties getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        return new InstanceProperties(this.attributes);
    }

    public void setAttributes(InstanceProperties attributes) {
        this.attributes = attributes;
    }

    @Override
    public String toString() {
        return "StructPropertyValue{attributes=" + this.attributes + ", instancePropertyCategory=" + this.getInstancePropertyCategory() + ", typeGUID='" + this.getTypeGUID() + "', typeName='" + this.getTypeName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        StructPropertyValue that = (StructPropertyValue)objectToCompare;
        return Objects.equals(this.attributes, that.attributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attributes);
    }
}

