/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.archiveutilities;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProviderBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.samples.archiveutilities.SimpleCatalogArchiveHelper;

public class GovernanceArchiveHelper
extends SimpleCatalogArchiveHelper {
    private static final String GOVERNANCE_ENGINE_TYPE_NAME = "GovernanceEngine";
    private static final String GOVERNANCE_SERVICE_TYPE_NAME = "GovernanceService";
    private static final String SUPPORTED_GOVERNANCE_SERVICE_TYPE_NAME = "SupportedGovernanceService";
    private static final String REQUEST_TYPE_PROPERTY = "requestType";
    private static final String REQUEST_PARAMETERS_PROPERTY = "parameters";

    public GovernanceArchiveHelper(OpenMetadataArchiveBuilder archiveBuilder, String archiveGUID, String archiveRootName, String originatorName, Date creationDate, long versionNumber, String versionName) {
        super(archiveBuilder, archiveGUID, archiveRootName, originatorName, creationDate, versionNumber, versionName);
    }

    public String addGovernanceService(String typeName, String connectorProviderName, Map<String, Object> configurationProperties, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String serviceTypeName = GOVERNANCE_SERVICE_TYPE_NAME;
        if (typeName != null) {
            serviceTypeName = typeName;
        }
        try {
            Class<?> connectorProviderClass = Class.forName(connectorProviderName);
            Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ConnectorProviderBase serviceProvider = (ConnectorProviderBase)potentialConnectorProvider;
            ConnectorType connectorType = serviceProvider.getConnectorType();
            String connectorTypeGUID = this.addConnectorType(null, connectorType.getGUID(), connectorType.getQualifiedName(), connectorType.getDisplayName(), connectorType.getDescription(), connectorType.getSupportedAssetTypeName(), connectorType.getExpectedDataFormat(), connectorType.getConnectorProviderClassName(), connectorType.getConnectorFrameworkName(), connectorType.getConnectorInterfaceLanguage(), connectorType.getConnectorInterfaces(), connectorType.getTargetTechnologySource(), connectorType.getTargetTechnologyName(), connectorType.getTargetTechnologyInterfaces(), connectorType.getTargetTechnologyVersions(), connectorType.getRecognizedSecuredProperties(), connectorType.getRecognizedConfigurationProperties(), connectorType.getRecognizedAdditionalProperties(), connectorType.getAdditionalProperties());
            String connectionGUID = this.addConnection(qualifiedName + "_implementation", displayName + " Governance Service Provider Implementation", "Connection for governance service: " + qualifiedName, null, null, null, null, configurationProperties, null, connectorTypeGUID, null);
            String serviceGUID = super.addAsset(serviceTypeName, qualifiedName, displayName, description, additionalProperties, extendedProperties);
            if (serviceGUID != null && connectionGUID != null) {
                super.addConnectionForAsset(serviceGUID, null, connectionGUID);
            }
            return serviceGUID;
        }
        catch (Exception error) {
            System.out.println("Invalid connector type " + connectorProviderName + " for governance service.  Exception " + error.getClass().getName() + " with message " + error.getMessage());
            return null;
        }
    }

    public String addGovernanceEngine(String typeName, String qualifiedName, String displayName, String description, String capabilityType, String capabilityVersion, String patchLevel, String source, Map<String, String> additionalProperties, Map<String, Object> extendedProperties) {
        String engineTypeName = GOVERNANCE_ENGINE_TYPE_NAME;
        if (typeName != null) {
            engineTypeName = typeName;
        }
        return super.addSoftwareCapability(engineTypeName, qualifiedName, displayName, description, capabilityType, capabilityVersion, patchLevel, source, additionalProperties, extendedProperties);
    }

    public void addSupportedGovernanceService(String engineGUID, String requestType, Map<String, String> requestParameters, String serviceGUID) {
        String methodName = "addSupportedGovernanceService";
        EntityDetail engineEntity = this.archiveBuilder.getEntity(engineGUID);
        EntityDetail serviceEntity = this.archiveBuilder.getEntity(serviceGUID);
        EntityProxy end1 = this.archiveHelper.getEntityProxy(engineEntity);
        EntityProxy end2 = this.archiveHelper.getEntityProxy(serviceEntity);
        InstanceProperties properties = this.archiveHelper.addStringPropertyToInstance(this.archiveRootName, null, REQUEST_TYPE_PROPERTY, requestType, "addSupportedGovernanceService");
        properties = this.archiveHelper.addStringMapPropertyToInstance(this.archiveRootName, properties, REQUEST_PARAMETERS_PROPERTY, requestParameters, "addSupportedGovernanceService");
        this.archiveBuilder.addRelationship(this.archiveHelper.getRelationship(SUPPORTED_GOVERNANCE_SERVICE_TYPE_NAME, this.idToGUIDMap.getGUID(engineGUID + "_to_" + serviceGUID + "_supported_governance_service_relationship"), properties, InstanceStatus.ACTIVE, end1, end2));
    }
}

