/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Iterator;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFRuntimeException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.PagingIterator;
import org.odpi.openmetadata.frameworks.connectors.properties.PropertyIteratorBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;

public abstract class SchemaAttributes
extends PropertyIteratorBase
implements Iterator<SchemaAttribute> {
    private static final long serialVersionUID = 1L;

    public SchemaAttributes(int totalElementCount, int maxCacheSize) {
        super(totalElementCount, maxCacheSize);
        this.pagingIterator = new PagingIterator(this, totalElementCount, maxCacheSize){

            @Override
            public ElementBase next() {
                if (this.hasNext()) {
                    ElementBase retrievedElement = this.iterator.cloneElement((ElementBase)this.cachedElementList.get(this.cachedElementPointer));
                    ++this.cachedElementPointer;
                    ++this.cachedElementStart;
                    log.debug("Returning next element:");
                    log.debug("==> totalElementCount: " + this.totalElementCount);
                    log.debug("==> cachedElementPointer: " + this.cachedElementPointer);
                    log.debug("==> cachedElementStart:" + this.cachedElementStart);
                    log.debug("==> maxCacheSize:" + this.maxCacheSize);
                    return retrievedElement;
                }
                throw new OCFRuntimeException(OCFErrorCode.NO_MORE_ELEMENTS.getMessageDefinition(this.getClass().getName()), this.getClass().getName(), "next");
            }

            @Override
            public boolean hasNext() {
                if (this.cachedElementList == null) {
                    return false;
                }
                if (this.cachedElementPointer == this.cachedElementList.size()) {
                    try {
                        this.cachedElementList = this.iterator.getCachedList(this.cachedElementStart, this.maxCacheSize);
                        if (this.cachedElementList == null) {
                            return false;
                        }
                        this.cachedElementPointer = 0;
                    }
                    catch (PropertyServerException error) {
                        throw new OCFRuntimeException(OCFErrorCode.PROPERTIES_NOT_AVAILABLE.getMessageDefinition(error.getReportedErrorMessage(), this.toString()), this.getClass().getName(), "next", error);
                    }
                }
                return true;
            }
        };
    }

    public SchemaAttributes(SchemaAttributes template) {
        super(template);
    }

    @Override
    protected ElementBase cloneElement(ElementBase template) {
        if (template instanceof SchemaAttribute) {
            return new SchemaAttribute((SchemaAttribute)template);
        }
        return null;
    }

    protected abstract SchemaAttributes cloneIterator();

    @Override
    public boolean hasNext() {
        return this.pagingIterator.hasNext();
    }

    @Override
    public SchemaAttribute next() {
        return (SchemaAttribute)this.pagingIterator.next();
    }

    @Override
    public void remove() {
        throw new OCFRuntimeException(OCFErrorCode.UNABLE_TO_REMOVE.getMessageDefinition(this.getClass().getName()), this.getClass().getName(), "remove");
    }

    public String toString() {
        return "SchemaAttributes{pagingIterator=" + this.pagingIterator + "}";
    }
}

