/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive1_5;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive1_6 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "1.6";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1516313040008L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive1_6() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive1_6(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive1_5 previousTypes = new OpenMetadataTypesArchive1_5(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0501SchemaElements();
        this.update0505SchemaAttributes();
        this.update0512DerivedSchemaAttributes();
    }

    private void update0501SchemaElements() {
        this.archiveBuilder.addTypeDefPatch(this.updateSchemaElementEntity());
    }

    private TypeDefPatch updateSchemaElementEntity() {
        String typeName = "SchemaElement";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SchemaElement");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "isDeprecated";
        String attribute1Description = "This element may still be used but is flagged that it will be removed at some point in the future.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("isDeprecated", "This element may still be used but is flagged that it will be removed at some point in the future.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0505SchemaAttributes() {
        this.archiveBuilder.addTypeDefPatch(this.updateSchemaAttributeEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateTypeEmbeddedAttributeClassification());
    }

    private TypeDefPatch updateSchemaAttributeEntity() {
        String typeName = "SchemaAttribute";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SchemaAttribute");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "minimumLength";
        String attribute1Description = "Minimum length of the data value (zero means unlimited).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "length";
        String attribute2Description = "Length of the data field (zero means unlimited).";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "significantDigits";
        String attribute3Description = "Number of significant digits before the decimal point (zero means it is an integer).";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "isNullable";
        String attribute4Description = "Accepts null values or not.";
        String attribute4DescriptionGUID = null;
        String attribute6Name = "cardinality";
        String attribute6Description = "Number of occurrences of this attribute allowed (deprecated).";
        String attribute6DescriptionGUID = null;
        String attribute6ReplacedBy = "maxCardinality";
        String attribute7Name = "name";
        String attribute7Description = "Name of schema attribute (deprecated).";
        String attribute7DescriptionGUID = null;
        String attribute7ReplacedBy = "displayName";
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("minimumLength", "Minimum length of the data value (zero means unlimited).", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("length", "Length of the data field (zero means unlimited).", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("significantDigits", "Number of significant digits before the decimal point (zero means it is an integer).", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("isNullable", "Accepts null values or not.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("cardinality", "Number of occurrences of this attribute allowed (deprecated).", attribute6DescriptionGUID);
        property.setReplacedByAttribute("maxCardinality");
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("name", "Name of schema attribute (deprecated).", attribute7DescriptionGUID);
        property.setReplacedByAttribute("displayName");
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateTypeEmbeddedAttributeClassification() {
        String typeName = "TypeEmbeddedAttribute";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("TypeEmbeddedAttribute");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "schemaTypeName";
        String attribute1Description = "Type name for the schema type.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "qualifiedName";
        String attribute2Description = "Unique name for the schema type.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "displayName";
        String attribute3Description = "Display name for the schema type.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "description";
        String attribute4Description = "Description of the schema type.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "versionNumber";
        String attribute5Description = "Version of the schema type.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "author";
        String attribute6Description = "User name of the person or process that created the schema type.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "usage";
        String attribute7Description = "Guidance on how the schema should be used.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "defaultValue";
        String attribute8Description = "Initial value for data stored in this schema type (primitive and enum types).";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "fixedValue";
        String attribute9Description = "Fixed value for data stored in this schema type (literal schema type).";
        String attribute9DescriptionGUID = null;
        String attribute10Name = "additionalProperties";
        String attribute10Description = "Additional properties for the schema type.";
        String attribute10DescriptionGUID = null;
        String attribute11Name = "isDeprecated";
        String attribute11Description = "This element may still be used but is flagged that it will be removed at some point in the future.";
        String attribute11DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("schemaTypeName", "Type name for the schema type.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("qualifiedName", "Unique name for the schema type.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("displayName", "Display name for the schema type.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("description", "Description of the schema type.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("versionNumber", "Version of the schema type.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("author", "User name of the person or process that created the schema type.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("usage", "Guidance on how the schema should be used.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("defaultValue", "Initial value for data stored in this schema type (primitive and enum types).", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("fixedValue", "Fixed value for data stored in this schema type (literal schema type).", attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("additionalProperties", "Additional properties for the schema type.", attribute10DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("isDeprecated", "This element may still be used but is flagged that it will be removed at some point in the future.", attribute11DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0512DerivedSchemaAttributes() {
        this.archiveBuilder.addTypeDefPatch(this.updateDerivedSchemaAttributeEntity());
    }

    private TypeDefPatch updateDerivedSchemaAttributeEntity() {
        String typeName = "DerivedSchemaAttribute";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DerivedSchemaAttribute");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "comment";
        String attribute1Description = "Comment from source system (deprecated).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "id";
        String attribute2Description = "Id of derived schema attribute (deprecated).";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "aggregatingFunction";
        String attribute3Description = "Aggregating function of derived schema attribute (deprecated).";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("comment", "Comment from source system (deprecated).", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("id", "Id of derived schema attribute (deprecated).", attribute2DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("aggregatingFunction", "Aggregating function of derived schema attribute (deprecated).", attribute3DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

