/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleAPICatalogArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleDataCatalogArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleEventCatalogArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleGovernanceCatalogArchiveBuilder;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.OpenMetadataArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.samples.archiveutilities.SimpleCatalogArchiveHelper;

public class SimpleComboCatalogArchiveBuilder {
    private static final String archiveGUID = "83e785b1-5bcc-4714-8f89-f6639ec55ca0";
    private static final String archiveName = "SimpleCatalog";
    private static final String archiveLicense = "Apache-2.0";
    private static final String archiveDescription = "Sample metadata showing different types of asset.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "Egeria";
    private static final Date creationDate = new Date(1632046251579L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final SimpleCatalogArchiveHelper archiveHelper;

    public SimpleComboCatalogArchiveBuilder(String archiveName, String archiveRootName) {
        ArrayList<OpenMetadataArchive> dependentOpenMetadataArchives = new ArrayList<OpenMetadataArchive>();
        dependentOpenMetadataArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, originatorName, archiveLicense, creationDate, dependentOpenMetadataArchives);
        this.archiveHelper = new SimpleCatalogArchiveHelper((OpenMetadataArchiveBuilder)this.archiveBuilder, archiveGUID, archiveName, archiveRootName, originatorName, creationDate, 1L, versionName, InstanceProvenanceType.CONTENT_PACK, null);
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        SimpleAPICatalogArchiveBuilder simpleAPICatalogArchiveBuilder = new SimpleAPICatalogArchiveBuilder(this.archiveBuilder, this.archiveHelper);
        simpleAPICatalogArchiveBuilder.fillBuilder();
        SimpleDataCatalogArchiveBuilder simpleDataCatalogArchiveBuilder = new SimpleDataCatalogArchiveBuilder(this.archiveBuilder, this.archiveHelper);
        simpleDataCatalogArchiveBuilder.fillBuilder();
        SimpleEventCatalogArchiveBuilder simpleEventCatalogArchiveBuilder = new SimpleEventCatalogArchiveBuilder(this.archiveBuilder, this.archiveHelper);
        simpleEventCatalogArchiveBuilder.fillBuilder();
        SimpleGovernanceCatalogArchiveBuilder simpleGovernanceCatalogArchiveBuilder = new SimpleGovernanceCatalogArchiveBuilder(this.archiveBuilder, this.archiveHelper);
        simpleGovernanceCatalogArchiveBuilder.fillBuilder();
        this.archiveHelper.saveGUIDs();
        return this.archiveBuilder.getOpenMetadataArchive();
    }
}

