/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.controls.TemplateType;

public enum TemplateTypeEnum {
    EXAMPLE("exampleTemplateName", "Asset", "Supply the qualified name of the template that the ", null);

    private final String name;
    private final String typeName;
    private final String description;
    private final Map<String, String> otherPropertyValues;

    private TemplateTypeEnum(String name, String typeName, String description, Map<String, String> otherPropertyValues) {
        this.name = name;
        this.typeName = typeName;
        this.description = description;
        this.otherPropertyValues = otherPropertyValues;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getOtherPropertyValues() {
        return this.otherPropertyValues;
    }

    public static List<TemplateType> getTemplateTypes() {
        ArrayList<TemplateType> templateTypes = new ArrayList<TemplateType>();
        for (TemplateTypeEnum templateTypeEnum : TemplateTypeEnum.values()) {
            templateTypes.add(templateTypeEnum.getTemplateType());
        }
        return templateTypes;
    }

    public TemplateType getTemplateType() {
        TemplateType catalogTargetType = new TemplateType();
        catalogTargetType.setTemplateName(this.name);
        catalogTargetType.setTypeName(this.typeName);
        catalogTargetType.setTemplateDescription(this.description);
        catalogTargetType.setOtherPropertyValues(this.otherPropertyValues);
        return catalogTargetType;
    }

    public String toString() {
        return "TemplateTypeEnum{templateName='" + this.name + "'}";
    }
}

