/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueImplementationAsset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ValidValueImplementationDefinition;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ValidValueImplementationAsset.class, name="ValidValueImplementationAsset"), @JsonSubTypes.Type(value=ValidValueImplementationDefinition.class, name="ValidValueImplementationDefinition")})
public class ValidValueImplementation
extends PropertyBase {
    private String symbolicName = null;
    private String implementationValue = null;
    private Map<String, String> additionalValues = null;

    public ValidValueImplementation() {
    }

    public ValidValueImplementation(ValidValueImplementation template) {
        super(template);
        if (template != null) {
            this.symbolicName = template.getSymbolicName();
            this.implementationValue = template.getImplementationValue();
            this.additionalValues = template.getAdditionalValues();
        }
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    public String getImplementationValue() {
        return this.implementationValue;
    }

    public void setImplementationValue(String implementationValue) {
        this.implementationValue = implementationValue;
    }

    public Map<String, String> getAdditionalValues() {
        if (this.additionalValues == null) {
            return null;
        }
        if (this.additionalValues.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.additionalValues);
    }

    public void setAdditionalValues(Map<String, String> additionalValues) {
        this.additionalValues = additionalValues;
    }

    public String toString() {
        return "ValidValueImplementation{, symbolicName='" + this.getSymbolicName() + "', implementationValue='" + this.getImplementationValue() + "', additionalValues=" + this.getAdditionalValues() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ValidValueImplementation that = (ValidValueImplementation)objectToCompare;
        return Objects.equals(this.symbolicName, that.symbolicName) && Objects.equals(this.implementationValue, that.implementationValue) && Objects.equals(this.additionalValues, that.additionalValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.symbolicName, this.implementationValue, this.additionalValues);
    }
}

