/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.context;

import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;

public class ConnectedAssetContext {
    private final String userId;
    private final OpenIntegrationClient openIntegrationClient;

    public ConnectedAssetContext(String userId, OpenIntegrationClient openIntegrationClient) {
        this.userId = userId;
        this.openIntegrationClient = openIntegrationClient;
    }

    public String saveConnection(Connection connection) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectionCheckedException, ConnectorCheckedException {
        return this.openIntegrationClient.saveConnection(this.userId, connection);
    }

    public String saveConnection(String assetGUID, Connection connection) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectionCheckedException, ConnectorCheckedException {
        return this.openIntegrationClient.saveConnection(this.userId, assetGUID, connection);
    }

    public AssetUniverse getAssetProperties(String assetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.openIntegrationClient.getAssetProperties(this.userId, assetGUID);
    }

    public Connector getConnectorToAsset(String assetGUID) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, UserNotAuthorizedException, PropertyServerException {
        return this.openIntegrationClient.getConnectorToAsset(this.userId, assetGUID);
    }
}

