/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.context;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementClassification;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementHeader;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.fileclassifier.FileClassifier;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;
import org.odpi.openmetadata.frameworks.integration.context.ConnectedAssetContext;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationGovernanceContext;
import org.odpi.openmetadata.frameworks.integration.context.MultiLanguageManagement;
import org.odpi.openmetadata.frameworks.integration.context.OpenMetadataAccess;
import org.odpi.openmetadata.frameworks.integration.context.StewardshipAction;
import org.odpi.openmetadata.frameworks.integration.context.ValidMetadataValuesContext;
import org.odpi.openmetadata.frameworks.integration.contextmanager.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.integration.filelistener.FileDirectoryListenerInterface;
import org.odpi.openmetadata.frameworks.integration.filelistener.FileListenerInterface;
import org.odpi.openmetadata.frameworks.integration.filelistener.FilesListenerManager;
import org.odpi.openmetadata.frameworks.integration.properties.CatalogTarget;
import org.odpi.openmetadata.frameworks.integration.reports.IntegrationReportWriter;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public class IntegrationContext {
    protected final OpenIntegrationClient openIntegrationClient;
    protected final OpenMetadataClient openMetadataStoreClient;
    protected final String userId;
    protected final String connectorName;
    protected final String integrationConnectorGUID;
    protected final PermittedSynchronization permittedSynchronization;
    protected String externalSourceGUID;
    protected String externalSourceName;
    protected boolean externalSourceIsHome = true;
    protected final FileClassifier fileClassifier;
    private final ConnectedAssetContext connectedAssetContext;
    private final IntegrationGovernanceContext integrationGovernanceContext;
    protected final IntegrationReportWriter integrationReportWriter;
    private final Map<String, String> externalSourceCache = new HashMap<String, String>();
    protected final int maxPageSize;
    private final FilesListenerManager listenerManager;
    private boolean isRefreshInProgress = false;

    public IntegrationContext(String connectorId, String connectorName, String connectorUserId, String serverName, OpenIntegrationClient openIntegrationClient, OpenMetadataClient openMetadataStoreClient, boolean generateIntegrationReport, PermittedSynchronization permittedSynchronization, String externalSourceGUID, String externalSourceName, String integrationConnectorGUID, AuditLog auditLog, int maxPageSize) {
        this.openIntegrationClient = openIntegrationClient;
        this.openMetadataStoreClient = openMetadataStoreClient;
        this.permittedSynchronization = permittedSynchronization;
        this.userId = connectorUserId;
        this.connectorName = connectorName;
        this.externalSourceGUID = externalSourceGUID;
        this.externalSourceName = externalSourceName;
        this.integrationConnectorGUID = integrationConnectorGUID;
        this.maxPageSize = maxPageSize;
        this.fileClassifier = new FileClassifier(new OpenMetadataStore(openMetadataStoreClient, this.userId, integrationConnectorGUID));
        this.listenerManager = new FilesListenerManager(auditLog, connectorName);
        this.integrationReportWriter = generateIntegrationReport ? new IntegrationReportWriter(serverName, connectorId, connectorName, this.userId, openIntegrationClient, openMetadataStoreClient) : null;
        this.connectedAssetContext = new ConnectedAssetContext(connectorUserId, openIntegrationClient);
        this.integrationGovernanceContext = this.constructIntegrationGovernanceContext(openMetadataStoreClient, connectorUserId, externalSourceGUID, externalSourceName, integrationConnectorGUID, this.integrationReportWriter);
    }

    private IntegrationGovernanceContext constructIntegrationGovernanceContext(OpenMetadataClient openMetadataStore, String userId, String externalSourceGUID, String externalSourceName, String originatorGUID, IntegrationReportWriter integrationReportWriter) {
        if (this.openMetadataStoreClient != null) {
            OpenMetadataAccess openMetadataAccess = new OpenMetadataAccess(openMetadataStore, userId, externalSourceGUID, externalSourceName, originatorGUID, integrationReportWriter);
            MultiLanguageManagement multiLanguageManagement = new MultiLanguageManagement(openMetadataStore, userId);
            StewardshipAction stewardshipAction = new StewardshipAction(openMetadataStore, userId, originatorGUID);
            ValidMetadataValuesContext validMetadataValuesContext = new ValidMetadataValuesContext(openMetadataStore, userId);
            return new IntegrationGovernanceContext(openMetadataAccess, multiLanguageManagement, stewardshipAction, validMetadataValuesContext);
        }
        return null;
    }

    public FileClassifier getFileClassifier() {
        return this.fileClassifier;
    }

    public List<CatalogTarget> getCatalogTargets(int startingFrom, int maximumResults) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.openIntegrationClient != null && this.integrationConnectorGUID != null) {
            return this.openIntegrationClient.getCatalogTargets(this.userId, this.integrationConnectorGUID, startingFrom, maximumResults);
        }
        return null;
    }

    public String getMetadataSourceQualifiedName() {
        return this.externalSourceName;
    }

    public void setMetadataSourceQualifiedName(String metadataSourceQualifiedName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (metadataSourceQualifiedName == null) {
            this.externalSourceName = null;
            this.externalSourceGUID = null;
        } else if (this.externalSourceCache.get(metadataSourceQualifiedName) != null) {
            this.externalSourceName = metadataSourceQualifiedName;
            this.externalSourceGUID = this.externalSourceCache.get(metadataSourceQualifiedName);
        } else {
            String metadataSourceGUID = this.openMetadataStoreClient.getMetadataElementGUIDByUniqueName(this.userId, metadataSourceQualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, false, false, new Date());
            if (metadataSourceGUID != null) {
                this.externalSourceName = metadataSourceQualifiedName;
                this.externalSourceGUID = metadataSourceGUID;
                this.externalSourceCache.put(metadataSourceQualifiedName, metadataSourceGUID);
            }
        }
    }

    public boolean getExternalSourceIsHome() {
        return this.externalSourceIsHome;
    }

    public void setExternalSourceIsHome(boolean newValue) {
        this.externalSourceIsHome = newValue;
    }

    public PermittedSynchronization getPermittedSynchronization() {
        return this.permittedSynchronization;
    }

    public IntegrationGovernanceContext getIntegrationGovernanceContext() {
        return this.integrationGovernanceContext;
    }

    public ConnectedAssetContext getConnectedAssetContext() {
        return this.connectedAssetContext;
    }

    public void setActiveReportPublishing(boolean flag) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setActiveReportPublishing(flag);
        }
    }

    public void startRecording() {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.startRecording();
        }
    }

    protected void reportAnchorGUID(String elementGUID, String anchorGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(elementGUID, anchorGUID);
        }
    }

    protected void reportAnchorGUID(String elementGUID, String anchorGUID, String anchorTypeName) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setAnchor(elementGUID, anchorGUID, anchorTypeName);
        }
    }

    protected void reportParentGUID(String elementGUID, String parentGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.setParent(elementGUID, parentGUID);
        }
    }

    protected void reportElementCreation(String elementGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementCreation(elementGUID);
        }
    }

    protected void reportElementUpdate(String elementGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementUpdate(elementGUID);
        }
    }

    protected void reportElementDelete(String elementGUID) {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.reportElementDelete(elementGUID);
        }
    }

    public void publishReport() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (this.integrationReportWriter != null) {
            this.integrationReportWriter.publishReport();
        }
    }

    public boolean isRefreshInProgress() {
        return this.isRefreshInProgress;
    }

    void setRefreshInProgress(boolean refreshInProgress) {
        this.isRefreshInProgress = refreshInProgress;
    }

    public String getAnchorGUID(ElementHeader elementHeader) {
        if (elementHeader.getClassifications() != null) {
            for (ElementClassification classification : elementHeader.getClassifications()) {
                Object anchorGUID;
                Map<String, Object> properties;
                if (!classification.getClassificationName().equals("Anchors") || (properties = classification.getClassificationProperties()) == null || (anchorGUID = properties.get("anchorGUID")) == null) continue;
                return anchorGUID.toString();
            }
        }
        return null;
    }

    public void registerFileListener(FileListenerInterface listener, File fileToMonitor) throws InvalidParameterException {
        this.listenerManager.registerFileListener(listener, fileToMonitor);
    }

    public void unregisterFileListener(FileListenerInterface listener, File fileToMonitor) throws InvalidParameterException {
        this.listenerManager.unregisterFileListener(listener, fileToMonitor);
    }

    public void registerDirectoryListener(FileDirectoryListenerInterface listener, File directoryToMonitor, FileFilter fileFilter) throws InvalidParameterException {
        this.listenerManager.registerDirectoryListener(listener, directoryToMonitor, fileFilter);
    }

    public void unregisterDirectoryListener(FileDirectoryListenerInterface listener, File directoryToMonitor) throws InvalidParameterException {
        this.listenerManager.unregisterDirectoryListener(listener, directoryToMonitor);
    }

    public void registerDirectoryTreeListener(FileDirectoryListenerInterface listener, File directoryToMonitor, FileFilter fileFilter) throws InvalidParameterException {
        this.listenerManager.registerDirectoryTreeListener(listener, directoryToMonitor, fileFilter);
    }

    public void unregisterDirectoryTreeListener(FileDirectoryListenerInterface listener, File directoryToMonitor) throws InvalidParameterException {
        this.listenerManager.unregisterDirectoryTreeListener(listener, directoryToMonitor);
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public boolean isTypeOf(ElementHeader elementHeader, String typeName) {
        return this.isTypeOf(elementHeader.getType(), typeName);
    }

    public boolean isTypeOf(ElementType elementType, String typeName) {
        if (elementType != null) {
            ArrayList<String> elementTypeNames = new ArrayList<String>();
            elementTypeNames.add(elementType.getTypeName());
            if (elementType.getSuperTypeNames() != null) {
                elementTypeNames.addAll(elementType.getSuperTypeNames());
            }
            if (elementTypeNames.contains(typeName)) {
                return true;
            }
        }
        return false;
    }

    public void disconnect() throws ConnectorCheckedException {
        if (this.listenerManager != null) {
            this.listenerManager.disconnect();
        }
    }
}

