/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum GlossaryTermActivityType implements OpenMetadataEnum
{
    OPERATION("bbbc23c1-62b0-412a-a77e-6d41ada10c7c", 0, "Operation", "A small, well defined processing operation.", false),
    ACTION("7785980d-3d52-438d-9ece-09e28be5d09a", 1, "Action", "A requested or required change.", false),
    TASK("c202f631-dc9c-4bd7-ab9d-f6eb6c7d53d0", 2, "Task", "A piece of work for a person, organization or engine.", false),
    PROCESS("15039274-9069-4da1-a026-a15c7ba17b02", 3, "Process", "A sequence of tasks.", false),
    PROJECT("21d0f37e-398d-4418-9eb4-49f2d6ce556f", 4, "Project", "An organized activity to achieve a specific goal.", false),
    OTHER("e207c15f-e30e-4585-a483-032f46eb6b16", 99, "Other", "Another type of activity.", false);

    private static final String ENUM_TYPE_GUID = "af7e403d-9865-4ebb-8c1a-1fd57b4f4bca";
    private static final String ENUM_TYPE_NAME = "ActivityType";
    private static final String ENUM_DESCRIPTION = "Different types of activities.";
    private static final String ENUM_DESCRIPTION_GUID = "0b24f61f-5f13-4e8a-9b97-4fc3783b23e4";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/3/0340-Dictionary/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private GlossaryTermActivityType(String descriptionGUID, int ordinal, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.ACTIVITY_TYPE.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.ACTIVITY_TYPE.name, null);
    }

    public String toString() {
        return "GlossaryTermActivityType{name='" + this.name + "}";
    }
}

