/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;
import org.odpi.openmetadata.frameworks.openmetadata.mapper.OpenMetadataValidValues;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum ImpactSeverity implements OpenMetadataEnum
{
    UNCLASSIFIED(0, "8f4bcf4f-92f6-4a06-9993-dfb215aa1710", "Unclassified", "There is no assessment of the impact's severity on this data.", true),
    LOW(1, "f9a7dcad-fa5c-4ca5-a2d9-50cffc5fbfa4", "Low", "The impact is low.", false),
    MEDIUM(2, "0de22909-05ea-495a-bc0b-9a2d4bd5644e", "Medium", "The impact is medium.", false),
    HIGH(3, "82ea6edd-634a-44ea-9f62-add3bf948e2c", "High", "The impact is high.", false),
    OTHER(99, "5de21541-da3a-4f66-b387-badb15dc9551", "Other", "Another impact severity level.", false);

    private static final String ENUM_TYPE_GUID = "5b905856-90ec-4944-80c4-0d42bcad484a";
    private static final String ENUM_TYPE_NAME = "ImpactSeverity";
    private static final String ENUM_DESCRIPTION = "Defines how important a data item is to the organization.";
    private static final String ENUM_DESCRIPTION_GUID = "b0f03508-bb4f-4daf-9c35-616b4ab5c130";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/4/0421-Governance-Classification-Levels/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private ImpactSeverity(int ordinal, String descriptionGUID, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String getQualifiedName() {
        return OpenMetadataValidValues.constructValidValueQualifiedName(ENUM_TYPE_NAME, OpenMetadataProperty.SEVERITY_IDENTIFIER.name, null, this.name);
    }

    public String getCategory() {
        return OpenMetadataValidValues.constructValidValueCategory(ENUM_TYPE_NAME, OpenMetadataProperty.SEVERITY_IDENTIFIER.name, null);
    }

    public String toString() {
        return "ImpactSeverity{name='" + this.name + "}";
    }
}

