/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.enums;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OpenMetadataEnum;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum KeyPattern implements OpenMetadataEnum
{
    LOCAL_KEY("b5bcf0a5-19a3-4755-ac52-518bd4783952", 0, "Local Key", "Unique key allocated and used within the scope of a single system.", false),
    RECYCLED_KEY("fe1e739e-4825-49a2-84af-aeb5096c6a75", 1, "Recycled Key", "Key allocated and used within the scope of a single system that is periodically reused for different records.", false),
    NATURAL_KEY("8828af2a-dcaa-4024-8b14-3d4082779d5c", 2, "Natural Key", "Key derived from an attribute of the entity, such as email address, passport number.", false),
    MIRROR_KEY("840a9ccb-45d4-4569-b76b-b88c3a814d1a", 3, "Mirror Key", "Key value copied from another system.", false),
    AGGREGATE_KEY("d9a3e37f-6bd8-414b-a37c-f24b5af08d27", 4, "Aggregate Key", "Key formed by combining keys from multiple systems.", false),
    CALLERS_KEY("292fd669-f3c9-436e-af61-2a4ad184dbb7", 5, "Caller's Key", "Key from another system can bey used if system name provided.", false),
    STABLE_KEY("1820a91d-0d8a-4567-9fbd-d27d444f646a", 6, "Stable Key", "Key value will remain active even if records are merged.", false),
    OTHER("d97a668e-bfc9-4ed6-a3a9-b133a4c2ef49", 99, "Other", "Another key pattern.", false);

    private static final String ENUM_TYPE_GUID = "8904df8f-1aca-4de8-9abd-1ef2aadba300";
    private static final String ENUM_TYPE_NAME = "KeyPattern";
    private static final String ENUM_DESCRIPTION = "Defines the type of identifier used for a digital resource.";
    private static final String ENUM_DESCRIPTION_GUID = "c6812f55-cc75-4e60-af29-74b53f03ddb5";
    private static final String ENUM_DESCRIPTION_WIKI = "https://egeria-project.org/types/0/0017-External-Identifiers/";
    private final String descriptionGUID;
    private final int ordinal;
    private final String name;
    private final String description;
    private final boolean isDefault;

    private KeyPattern(String descriptionGUID, int ordinal, String name, String description, boolean isDefault) {
        this.ordinal = ordinal;
        this.name = name;
        this.descriptionGUID = descriptionGUID;
        this.description = description;
        this.isDefault = isDefault;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionGUID() {
        return this.descriptionGUID;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public static String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public static String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public static String getOpenTypeDescription() {
        return ENUM_DESCRIPTION;
    }

    public static String getOpenTypeDescriptionGUID() {
        return ENUM_DESCRIPTION_GUID;
    }

    public static String getOpenTypeDescriptionWiki() {
        return ENUM_DESCRIPTION_WIKI;
    }

    public String toString() {
        return "KeyPattern{keyPatternName='" + this.name + "}";
    }
}

