/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.openmetadata.refdata;

import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.FileType;

public enum FileExtension {
    CSV_FILE("csv", new FileType[]{FileType.CSV_FILE}),
    AVRO_FILE("avro", new FileType[]{FileType.AVRO_FILE}),
    JSN_FILE("jsn", new FileType[]{FileType.JSON_FILE}),
    JSON_FILE("json", new FileType[]{FileType.JSON_FILE}),
    OM_ARCHIVE_FILE("omarchive", new FileType[]{FileType.OM_ARCHIVE_FILE}),
    OM_CONFIG_DOC("config", new FileType[]{FileType.OM_CONFIG_DOC}),
    OM_COHORT_REGISTRY("cohortregistry", new FileType[]{FileType.OM_COHORT_REGISTRY}),
    OM_AUDIT_LOG_RECORD_FILE("omalrecord", new FileType[]{FileType.OM_AUDIT_LOG_RECORD_FILE}),
    OM_AUDIT_LOG_FOLDER("auditlog", new FileType[]{FileType.OM_AUDIT_LOG_FOLDER}),
    OL_EVENT_FILE("openlineageevent", new FileType[]{FileType.OL_EVENT_FILE}),
    XML_FILE("xml", new FileType[]{FileType.XML_FILE}),
    PQT_FILE("pqt", new FileType[]{FileType.PARQUET_FILE}),
    PARQUET_FILE("parquet", new FileType[]{FileType.PARQUET_FILE}),
    ORC_FILE("orc", new FileType[]{FileType.ORC_FILE}),
    XLSX_FILE("xlsx", new FileType[]{FileType.XLSX_FILE}),
    XLS_FILE("xls", new FileType[]{FileType.XLS_FILE}),
    NUMBER_FILE("numbers", new FileType[]{FileType.NUMBER_FILE}),
    OLD_WORD_DOC("doc", new FileType[]{FileType.OLD_WORD_DOC}),
    WORD_DOC("docx", new FileType[]{FileType.WORD_DOC}),
    ODT_DOC("odt", new FileType[]{FileType.ODT_DOC}),
    PAGES_DOC("pages", new FileType[]{FileType.PAGES_DOC}),
    DRAWIO_FILE("drawio", new FileType[]{FileType.DRAW_IO_FILE}),
    MD_FILE("md", new FileType[]{FileType.MARKDOWN_FILE}),
    TXT_FILE("txt", new FileType[]{FileType.TEXT_FILE}),
    TEX_FILE("tex", new FileType[]{FileType.TEXT_FILE}),
    RTF_FILE("rtf", new FileType[]{FileType.RICH_TEXT}),
    PDF_FILE("pdf", new FileType[]{FileType.PDF_FILE}),
    PPT_FILE("ppt", new FileType[]{FileType.PPT_FILE}),
    POT_FILE("pot", new FileType[]{FileType.POT_FILE}),
    PPTX_FILE("pptx", new FileType[]{FileType.PPTX_FILE}),
    POTX_FILE("potx", new FileType[]{FileType.POTX_FILE}),
    KEY_FILE("key", new FileType[]{FileType.KEYNOTE_FILE, FileType.ENCRYPT_KEYS_FILE}),
    P12_FILE("p12", new FileType[]{FileType.PIEF_FILE}),
    PFX_FILE("pfx", new FileType[]{FileType.PIEF_FILE}),
    JKS_FILE("jks", new FileType[]{FileType.JKS_FILE}),
    JCEKS_FILE("jceks", new FileType[]{FileType.JCEKS_FILE}),
    HTM_FILE("htm", new FileType[]{FileType.HTML_FILE}),
    HTML_FILE("html", new FileType[]{FileType.HTML_FILE}),
    TIF_FILE("tif", new FileType[]{FileType.TIF_FILE}),
    TIFF_FILE("tiff", new FileType[]{FileType.TIF_FILE}),
    TFF_FILE("tff", new FileType[]{FileType.TIF_FILE}),
    GTIFF_FILE("gtiff", new FileType[]{FileType.GEOTIFF_FILE}),
    BMP_FILE("bmp", new FileType[]{FileType.BMP_FILE}),
    JPG_FILE("jpg", new FileType[]{FileType.JPG_FILE}),
    JPEG_FILE("jpeg", new FileType[]{FileType.JPG_FILE}),
    GIF_FILE("gif", new FileType[]{FileType.GIF_FILE}),
    PNG_FILE("png", new FileType[]{FileType.PNG_FILE}),
    HEIC_FILE("heic", new FileType[]{FileType.HEIC_FILE}),
    ICO_FILE("ico", new FileType[]{FileType.ICO_FILE}),
    CSS_FILE("css", new FileType[]{FileType.CSS_FILE}),
    SCSS_FILE("sccs", new FileType[]{FileType.SCSS_FILE}),
    PY_FILE("py", new FileType[]{FileType.PY_FILE}),
    JS_FILE("js", new FileType[]{FileType.JS_FILE}),
    TS_FILE("ts", new FileType[]{FileType.TYPESCRIPT_FILE, FileType.VIDEO_TS_FILE}),
    SQL_FILE("sql", new FileType[]{FileType.SQL_FILE}),
    BAT_FILE("bat", new FileType[]{FileType.DOS_BAT_FILE}),
    COM_FILE("com", new FileType[]{FileType.DOS_COM_FILE}),
    WSF_FILE("wsf", new FileType[]{FileType.MS_WSF_FILE}),
    SH_FILE("sh", new FileType[]{FileType.BASH_SCRIPT_FILE}),
    KSH_FILE("ksh", new FileType[]{FileType.KORN_SCRIPT_FILE}),
    PROPERTIES_FILE("properties", new FileType[]{FileType.PROPERTIES_FILE}),
    CFG_FILE("cfg", new FileType[]{FileType.CONFIGURATION_FILE}),
    CONF_FILE("conf", new FileType[]{FileType.CONFIGURATION_FILE}),
    LOG_FILE("log", new FileType[]{FileType.LOG_FILE}),
    MSG_FILE("msg", new FileType[]{FileType.LOG_MESSAGE_FILE}),
    ERR_FILE("err", new FileType[]{FileType.STDERR_FILE}),
    STDOUT_FILE("out", new FileType[]{FileType.STDOUT_FILE}),
    JAVA_FILE("java", new FileType[]{FileType.JAVA_FILE}),
    CLASS_FILE("class", new FileType[]{FileType.CLASS_FILE}),
    APP_FILE("app", new FileType[]{FileType.APP_FILE}),
    EXE_FILE("exe", new FileType[]{FileType.EXE_FILE}),
    JAR_FILE("jar", new FileType[]{FileType.JAR_FILE}),
    TAR_FILE("tar", new FileType[]{FileType.TAR_FILE}),
    GZ_FILE("gz", new FileType[]{FileType.GZ_FILE}),
    ZIP_FILE("zip", new FileType[]{FileType.ZIP_FILE}),
    WAR_FILE("war", new FileType[]{FileType.WAR_FILE}),
    EAR_FILE("ear", new FileType[]{FileType.EAR_FILE}),
    DMG_FILE("dmg", new FileType[]{FileType.DMG_FILE}),
    ISO_FILE("iso", new FileType[]{FileType.ISO_FILE}),
    YML_FILE("yml", new FileType[]{FileType.YAML_FILE}),
    YAML_FILE("yaml", new FileType[]{FileType.YAML_FILE}),
    BIN_FILE("bin", new FileType[]{FileType.BIN_FILE}),
    DAT_FILE("dat", new FileType[]{FileType.DAT_FILE}),
    RPT_FILE("rpt", new FileType[]{FileType.RPT_FILE}),
    MPP_FILE("mpp", new FileType[]{FileType.MPP_FILE}),
    VCF_FILE("vcf", new FileType[]{FileType.VCF_FILE}),
    AIFF_FILE("aiff", new FileType[]{FileType.AIFF_FILE}),
    FLAC_FILE("flac", new FileType[]{FileType.FLAC_FILE}),
    WAV_FILE("wav", new FileType[]{FileType.WAV_FILE}),
    MP3_FILE("mp3", new FileType[]{FileType.MP3_FILE}),
    WMA_FILE("wma", new FileType[]{FileType.WMA_FILE}),
    MP4_FILE("mp4", new FileType[]{FileType.MP4_FILE}),
    THREE_GP_FILE("3gp", new FileType[]{FileType.MOBILE_VIDEO_FILE}),
    THREE_G2_FILE("3g2", new FileType[]{FileType.MOBILE_VIDEO_FILE}),
    MOV_FILE("mov", new FileType[]{FileType.MOV_FILE}),
    AVI_FILE("avi", new FileType[]{FileType.AVI_FILE}),
    M4V_FILE("m4v", new FileType[]{FileType.M4V_FILE}),
    WMV_FILE("wmv", new FileType[]{FileType.WMV_FILE}),
    AI_FILE("ai", new FileType[]{FileType.AI_FILE}),
    SVG_FILE("svg", new FileType[]{FileType.SVG_FILE}),
    EPS_FILE("eps", new FileType[]{FileType.EPS_FILE}),
    PS_FILE("ps", new FileType[]{FileType.PS_FILE}),
    OBJ_FILE("obj", new FileType[]{FileType.OBJ_FILE}),
    MTL_FILE("mtl", new FileType[]{FileType.MTL_FILE});

    private final String fileExtension;
    private final FileType[] fileTypes;

    private FileExtension(String fileExtension, FileType[] fileTypes) {
        this.fileExtension = fileExtension;
        this.fileTypes = fileTypes;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public List<FileType> getFileTypes() {
        if (this.fileTypes != null) {
            return Arrays.asList(this.fileTypes);
        }
        return null;
    }

    public String toString() {
        return "FileExtension{" + this.fileExtension + "}";
    }
}

