/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.measurements;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.FileMetric;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum RelationalColumnMetric implements SurveyMetric
{
    COLUMN_QNAME("columnQualifiedName", "string", "Column qualified name", "Qualified name of the column showing the database name, schema name and table name."),
    COLUMN_NAME("columnName", "string", "Column name", "Name of the column."),
    COLUMN_SIZE("columnSize", "long", "Column size", "Number of stored bytes in the column."),
    COLUMN_COUNT("columnCount", "long", "Number of columns", "Count of columns in the database table/view."),
    COLUMN_TYPE("columnDataType", "string", "Column data type", "Data type of column.");

    public final String propertyName;
    public final String dataType;
    public final String displayName;
    public final String description;

    private RelationalColumnMetric(String propertyName, String dataType, String displayName, String description) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static List<SurveyMetric> getMetrics() {
        return new ArrayList<SurveyMetric>(List.of(FileMetric.values()));
    }

    public String toString() {
        return "RelationalColumnMetric{" + this.displayName + "}";
    }
}

