/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.surveyaction.measurements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum RelationalDatabaseMetric implements SurveyMetric
{
    DATABASE_SIZE("databaseSize", "long", "Database size", "Number of stored bytes in the database."),
    ROWS_FETCHED("rowsFetched", "long", "Rows Fetched", "Number of rows retrieved from any table in the database."),
    ROWS_INSERTED("rowsInserted", "long", "Rows Inserted", "Number of rows inserted from any table in the database."),
    ROWS_UPDATED("rowsUpdated", "long", "Rows Updated", "Number of rows updated from any table in the database."),
    ROWS_DELETED("rowsDeleted", "long", "Rows Deleted", "Number of rows deleted from any table in the database.."),
    SESSION_TIME("totalSessionTime", "double", "Session Time", "The length of time (milliseconds) that the database had at least one open session from an external client."),
    ACTIVE_TIME("totalActiveTime", "double", "Active Time", "The length of time (milliseconds) that the database was being actively queried."),
    LAST_STATISTICS_RESET("lastStatisticsReset", "date", "Last statistics reset", "Last time that the statistics were reset in the database.");

    public final String propertyName;
    public final String dataType;
    public final String displayName;
    public final String description;

    private RelationalDatabaseMetric(String propertyName, String dataType, String displayName, String description) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.displayName = displayName;
        this.description = description;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static List<SurveyMetric> getMetrics() {
        return new ArrayList<SurveyMetric>(Arrays.asList(RelationalDatabaseMetric.values()));
    }

    public String toString() {
        return "RelationalDatabaseMetric{" + this.displayName + "}";
    }
}

