/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ByteOrdering;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CommentType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ConfidenceLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ConfidentialityLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ContactMethodType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.CriticalityLevel;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataClassAssignmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermActivityType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermAssignmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermRelationshipStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GovernanceClassificationStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.KeyPattern;
import org.odpi.openmetadata.frameworks.openmetadata.enums.MediaType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.MediaUsage;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OrderBy;
import org.odpi.openmetadata.frameworks.openmetadata.enums.RetentionBasis;
import org.odpi.openmetadata.frameworks.openmetadata.enums.StarRating;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ToDoStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.properties.AnnotationStatus;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.AttributeCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.CollectionDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EnumElementDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.PrimitiveDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;

public class OpenMetadataTypesArchive1_2 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveVersion = "1.2";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1577886131090L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive1_2() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive1_2(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public void getOriginalTypes() {
        this.addStandardPrimitiveDefs();
        this.addStandardCollectionDefs();
        this.addArea0Types();
        this.addArea1Types();
        this.addArea2Types();
        this.addArea3Types();
        this.addArea4Types();
        this.addArea5Types();
        this.addArea6Types();
    }

    public void addStandardPrimitiveDefs() {
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING));
        this.archiveBuilder.addPrimitiveDef(this.archiveHelper.getPrimitiveDef(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE));
    }

    public void addStandardCollectionDefs() {
        this.archiveBuilder.addCollectionDef(this.getMapStringStringCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringBooleanCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringIntCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringLongCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringDoubleCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringDateCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getMapStringObjectCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getArrayStringCollectionDef());
        this.archiveBuilder.addCollectionDef(this.getArrayIntCollectionDef());
    }

    private CollectionDef getMapStringStringCollectionDef() {
        String guid = "005c7c14-ac84-4136-beed-959401b041f8";
        String description = "A map from string to string.";
        String descriptionGUID = "f285d0ca-50ab-4564-b129-c7e3ba4e8545";
        return this.archiveHelper.getMapCollectionDef("005c7c14-ac84-4136-beed-959401b041f8", "A map from string to string.", "f285d0ca-50ab-4564-b129-c7e3ba4e8545", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
    }

    private CollectionDef getMapStringBooleanCollectionDef() {
        String guid = "8fa603dd-c2c5-43fc-8ff4-92141f2414ab";
        String description = "A map from string to Boolean.";
        String descriptionGUID = "72d76e44-350c-4ff3-baae-54b837f723c7";
        return this.archiveHelper.getMapCollectionDef("8fa603dd-c2c5-43fc-8ff4-92141f2414ab", "A map from string to Boolean.", "72d76e44-350c-4ff3-baae-54b837f723c7", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
    }

    private CollectionDef getMapStringIntCollectionDef() {
        String guid = "8fa603dd-c2c5-43fc-8ff4-92141f2414ac";
        String description = "A map from string to int.";
        String descriptionGUID = "47373fd6-be40-439b-97ca-881878eed1f4";
        return this.archiveHelper.getMapCollectionDef("8fa603dd-c2c5-43fc-8ff4-92141f2414ac", "A map from string to int.", "47373fd6-be40-439b-97ca-881878eed1f4", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
    }

    private CollectionDef getMapStringLongCollectionDef() {
        String guid = "8fa603dd-c2c5-43fc-8ff4-92141f2414ae";
        String description = "A map from string to long.";
        String descriptionGUID = "039b3466-e28b-4c73-8181-d9a57749c706";
        return this.archiveHelper.getMapCollectionDef("8fa603dd-c2c5-43fc-8ff4-92141f2414ae", "A map from string to long.", "039b3466-e28b-4c73-8181-d9a57749c706", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
    }

    private CollectionDef getMapStringDateCollectionDef() {
        String guid = "ee293c68-e34d-4885-a512-f927d35a5893";
        String description = "A map from string to date.";
        String descriptionGUID = "978b8ad1-c7c8-4892-bd83-98c9f07e8028";
        return this.archiveHelper.getMapCollectionDef("ee293c68-e34d-4885-a512-f927d35a5893", "A map from string to date.", "978b8ad1-c7c8-4892-bd83-98c9f07e8028", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
    }

    private CollectionDef getMapStringDoubleCollectionDef() {
        String guid = "17211869-ed39-4ba9-bead-ffd967df65a8";
        String description = "A map from string to double.";
        String descriptionGUID = "ee2cf3d5-3ff8-4d6a-82ed-35c0123dcc89";
        return this.archiveHelper.getMapCollectionDef("17211869-ed39-4ba9-bead-ffd967df65a8", "A map from string to double.", "ee2cf3d5-3ff8-4d6a-82ed-35c0123dcc89", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE);
    }

    private CollectionDef getMapStringObjectCollectionDef() {
        String guid = "8fa603dd-c2c5-43fc-8ff4-92141f2414ad";
        String description = "A map from string to object.";
        String descriptionGUID = "6dd2944b-9107-41c6-a10b-6a938fd6f2f5";
        return this.archiveHelper.getMapCollectionDef("8fa603dd-c2c5-43fc-8ff4-92141f2414ad", "A map from string to object.", "6dd2944b-9107-41c6-a10b-6a938fd6f2f5", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
    }

    private CollectionDef getArrayStringCollectionDef() {
        String guid = "0428b5d3-f824-459c-b7f5-f8151de59707";
        String description = "An array of strings.";
        String descriptionGUID = "4a384611-d8c1-4909-a6f8-1385ffe210e2";
        return this.archiveHelper.getArrayCollectionDef("0428b5d3-f824-459c-b7f5-f8151de59707", "An array of strings.", "4a384611-d8c1-4909-a6f8-1385ffe210e2", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
    }

    private CollectionDef getArrayIntCollectionDef() {
        String guid = "0103fe10-98b0-4910-8ee0-21d529f7ff6d";
        String description = "An array of integers.";
        String descriptionGUID = "ac772d8b-278e-4017-a7e8-1988c74c091e";
        return this.archiveHelper.getArrayCollectionDef("0103fe10-98b0-4910-8ee0-21d529f7ff6d", "An array of integers.", "ac772d8b-278e-4017-a7e8-1988c74c091e", PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
    }

    public void addArea0Types() {
        this.add0010BaseModel();
        this.add0015LinkedMediaTypes();
        this.add0017ExternalIdentifiers();
        this.add0019MoreInformation();
        this.add0020PropertyFacets();
        this.add0025Locations();
        this.add0030HostsAndPlatforms();
        this.add0035ComplexHosts();
        this.add0037SoftwareServerPlatforms();
        this.add0040SoftwareServers();
        this.add0042SoftwareServerCapabilities();
        this.add0045ServersAndAssets();
        this.add0050ApplicationsAndProcesses();
        this.add0055DataProcessingEngines();
        this.add0070NetworksAndGateways();
        this.add0090CloudPlatformsAndServices();
    }

    private void add0010BaseModel() {
        this.archiveBuilder.addEnumDef(this.getAssetOwnerTypeEnum());
        this.archiveBuilder.addEntityDef(this.getReferenceableEntity());
        this.archiveBuilder.addEntityDef(this.getAssetEntity());
        this.archiveBuilder.addEntityDef(this.getInfrastructureEntity());
        this.archiveBuilder.addEntityDef(this.getProcessEntity());
        this.archiveBuilder.addEntityDef(this.getDataAssetEntity());
        this.archiveBuilder.addEntityDef(this.getDataSetEntity());
    }

    private EntityDef getReferenceableEntity() {
        String guid = OpenMetadataType.REFERENCEABLE.typeGUID;
        String name = OpenMetadataType.REFERENCEABLE.typeName;
        String description = OpenMetadataType.REFERENCEABLE.description;
        String descriptionGUID = OpenMetadataType.REFERENCEABLE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.REFERENCEABLE.wikiURL;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, null, description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.QUALIFIED_NAME.name;
        String attribute1Description = OpenMetadataProperty.QUALIFIED_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.QUALIFIED_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.ADDITIONAL_PROPERTIES.name;
        String attribute2Description = OpenMetadataProperty.ADDITIONAL_PROPERTIES.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        property.setUnique(true);
        property.setValuesMaxCount(1);
        property.setValuesMinCount(1);
        property.setAttributeCardinality(AttributeCardinality.ONE_ONLY);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getAssetEntity() {
        String guid = OpenMetadataType.ASSET.typeGUID;
        String name = OpenMetadataType.ASSET.typeName;
        String description = OpenMetadataType.ASSET.description;
        String descriptionGUID = OpenMetadataType.ASSET.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ASSET.wikiURL;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.OWNER.name;
        String attribute3Description = OpenMetadataProperty.OWNER.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.OWNER.descriptionGUID;
        String attribute4Name = "ownerType";
        String attribute4Description = "Deprecated. Type of identifier used for owner property.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = OpenMetadataProperty.ZONE_MEMBERSHIP.name;
        String attribute5Description = OpenMetadataProperty.ZONE_MEMBERSHIP.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.ZONE_MEMBERSHIP.descriptionGUID;
        String attribute6Name = "latestChange";
        String attribute6Description = "Description of the last change to the asset's metadata.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("AssetOwnerType", "ownerType", "Deprecated. Type of identifier used for owner property.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("latestChange", "Description of the last change to the asset's metadata.", attribute6DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getInfrastructureEntity() {
        String guid = OpenMetadataType.INFRASTRUCTURE.typeGUID;
        String name = OpenMetadataType.INFRASTRUCTURE.typeName;
        String description = OpenMetadataType.INFRASTRUCTURE.description;
        String descriptionGUID = OpenMetadataType.INFRASTRUCTURE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.INFRASTRUCTURE.wikiURL;
        String superTypeName = OpenMetadataType.ASSET.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef getProcessEntity() {
        String guid = OpenMetadataType.PROCESS.typeGUID;
        String name = OpenMetadataType.PROCESS.typeName;
        String description = OpenMetadataType.PROCESS.description;
        String descriptionGUID = OpenMetadataType.PROCESS.descriptionGUID;
        String descriptionWiki = OpenMetadataType.PROCESS.wikiURL;
        String superTypeName = OpenMetadataType.ASSET.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.FORMULA.name;
        String attribute2Description = OpenMetadataProperty.FORMULA.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.FORMULA.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private EntityDef getDataAssetEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_ASSET.typeGUID, OpenMetadataType.DATA_ASSET.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.ASSET.typeName), OpenMetadataType.DATA_ASSET.description, OpenMetadataType.DATA_ASSET.descriptionGUID, OpenMetadataType.DATA_ASSET.wikiURL);
    }

    private EntityDef getDataSetEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_SET.typeGUID, OpenMetadataType.DATA_SET.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_ASSET.typeName), OpenMetadataType.DATA_SET.description, OpenMetadataType.DATA_SET.descriptionGUID, OpenMetadataType.DATA_SET.wikiURL);
    }

    private void add0015LinkedMediaTypes() {
        this.archiveBuilder.addEnumDef(this.getMediaTypeEnum());
        this.archiveBuilder.addEnumDef(this.getMediaUsageEnum());
        this.archiveBuilder.addEntityDef(this.getExternalReferenceEntity());
        this.archiveBuilder.addEntityDef(this.getRelatedMediaEntity());
        this.archiveBuilder.addRelationshipDef(this.getExternalReferenceLinkRelationship());
        this.archiveBuilder.addRelationshipDef(this.getMediaReferenceRelationship());
    }

    private EnumDef getMediaTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(MediaType.getOpenTypeGUID(), MediaType.getOpenTypeName(), MediaType.getOpenTypeDescription(), MediaType.getOpenTypeDescriptionGUID(), MediaType.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (MediaType enumValue : MediaType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getMediaUsageEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(MediaUsage.getOpenTypeGUID(), MediaUsage.getOpenTypeName(), MediaUsage.getOpenTypeDescription(), MediaUsage.getOpenTypeDescriptionGUID(), MediaUsage.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (MediaUsage enumValue : MediaUsage.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getExternalReferenceEntity() {
        String guid = "af536f20-062b-48ef-9c31-1ddd05b04c56";
        String name = "ExternalReference";
        String description = "A link to more information.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("af536f20-062b-48ef-9c31-1ddd05b04c56", "ExternalReference", this.archiveBuilder.getEntityDef(superTypeName), "A link to more information.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = "url";
        String attribute2Description = "Location of the external reference.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "version";
        String attribute3Description = "Version number of the external reference.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute4Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute5Name = "organization";
        String attribute5Description = "Organization supplying the reference.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("url", "Location of the external reference.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Version number of the external reference.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("organization", "Organization supplying the reference.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getRelatedMediaEntity() {
        String guid = "747f8b86-fe7c-4c9b-ba75-979e093cc307";
        String name = "RelatedMedia";
        String description = "Images, video or sound media.";
        String descriptionGUID = null;
        String superTypeName = "ExternalReference";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("747f8b86-fe7c-4c9b-ba75-979e093cc307", "RelatedMedia", this.archiveBuilder.getEntityDef("ExternalReference"), "Images, video or sound media.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "mediaUsage";
        String attribute1Description = "Type of recommended media usage.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "mediaType";
        String attribute2Description = "Type of media.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayIntTypeDefAttribute("mediaUsage", "Type of recommended media usage.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("MediaType", "mediaType", "Type of media.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getExternalReferenceLinkRelationship() {
        String guid = "7d818a67-ab45-481c-bc28-f6b1caf12f06";
        String name = "ExternalReferenceLink";
        String description = "Link to more information.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("7d818a67-ab45-481c-bc28-f6b1caf12f06", "ExternalReferenceLink", null, "Link to more information.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "relatedItem";
        String end1AttributeDescription = "Item that is referencing this work.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "relatedItem", "Item that is referencing this work.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ExternalReference";
        String end2AttributeName = "externalReference";
        String end2AttributeDescription = "Link to more information from an external source.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ExternalReference"), "externalReference", "Link to more information from an external source.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "referenceId";
        String attribute1Description = "Local identifier for the reference.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("referenceId", "Local identifier for the reference.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getMediaReferenceRelationship() {
        String guid = "1353400f-b0ab-4ab9-ab09-3045dd8a7140";
        String name = "MediaReference";
        String description = "Link to related media such as images, videos and audio.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("1353400f-b0ab-4ab9-ab09-3045dd8a7140", "MediaReference", null, "Link to related media such as images, videos and audio.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "consumingItem";
        String end1AttributeDescription = "Item that is referencing this work.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "consumingItem", "Item that is referencing this work.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "RelatedMedia";
        String end2AttributeName = "relatedMedia";
        String end2AttributeDescription = "Link to external media.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("RelatedMedia"), "relatedMedia", "Link to external media.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "mediaId";
        String attribute1Description = "Local identifier for the media.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("mediaId", "Local identifier for the media.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0017ExternalIdentifiers() {
        this.archiveBuilder.addEnumDef(this.getKeyPatternEnum());
        this.archiveBuilder.addEntityDef(this.getExternalIdEntity());
        this.archiveBuilder.addRelationshipDef(this.getExternalIdScopeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getExternalIdLinkRelationship());
    }

    private EnumDef getKeyPatternEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(KeyPattern.getOpenTypeGUID(), KeyPattern.getOpenTypeName(), KeyPattern.getOpenTypeDescription(), KeyPattern.getOpenTypeDescriptionGUID(), KeyPattern.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (KeyPattern enumValue : KeyPattern.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getExternalIdEntity() {
        String guid = OpenMetadataType.EXTERNAL_ID.typeGUID;
        String name = OpenMetadataType.EXTERNAL_ID.typeName;
        String description = OpenMetadataType.EXTERNAL_ID.description;
        String descriptionGUID = OpenMetadataType.EXTERNAL_ID.descriptionGUID;
        String descriptionWiki = OpenMetadataType.EXTERNAL_ID.wikiURL;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.IDENTIFIER.name;
        String attribute1Description = OpenMetadataProperty.IDENTIFIER.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.IDENTIFIER.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.KEY_PATTERN.name;
        String attribute2Description = OpenMetadataProperty.KEY_PATTERN.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.KEY_PATTERN.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(OpenMetadataProperty.KEY_PATTERN.type, attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getExternalIdScopeRelationship() {
        String guid = OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.typeName;
        String description = OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.EXTERNAL_ID_SCOPE_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "scopedTo";
        String end1AttributeDescription = "Identifies where this external identifier is known.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "scopedTo", "Identifies where this external identifier is known.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.EXTERNAL_ID.typeName;
        String end2AttributeName = "managedResources";
        String end2AttributeDescription = "Link to details of a resource that this component manages.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "managedResources", "Link to details of a resource that this component manages.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getExternalIdLinkRelationship() {
        String guid = OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.typeName;
        String description = OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.EXTERNAL_ID_LINK_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "resources";
        String end1AttributeDescription = "Resource being identified.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "resources", "Resource being identified.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.EXTERNAL_ID.typeName;
        String end2AttributeName = "alsoKnownAs";
        String end2AttributeDescription = "Identifier used in an external system.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "alsoKnownAs", "Identifier used in an external system.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.USAGE.name;
        String attribute2Description = OpenMetadataProperty.USAGE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.USAGE.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.SOURCE.name;
        String attribute3Description = OpenMetadataProperty.SOURCE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0019MoreInformation() {
        this.archiveBuilder.addRelationshipDef(this.getMoreInformationRelationship());
    }

    private RelationshipDef getMoreInformationRelationship() {
        String guid = OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeName;
        String description = OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "describes";
        String end1AttributeDescription = "Describes this core element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "describes", "Describes this core element.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "providesMoreInformation";
        String end2AttributeDescription = "Provides more information about this referenceable.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "providesMoreInformation", "Provides more information about this referenceable.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0020PropertyFacets() {
        this.archiveBuilder.addEntityDef(this.getPropertyFacetEntity());
        this.archiveBuilder.addRelationshipDef(this.getReferenceableFacetRelationship());
    }

    private EntityDef getPropertyFacetEntity() {
        String guid = "6403a704-aad6-41c2-8e08-b9525c006f85";
        String name = "PropertyFacet";
        String description = "Additional properties that support a particular vendor or service.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("6403a704-aad6-41c2-8e08-b9525c006f85", "PropertyFacet", this.archiveBuilder.getEntityDef(superTypeName), "Additional properties that support a particular vendor or service.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "version";
        String attribute1Description = "Version of the property facet schema.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "properties";
        String attribute3Description = "Properties for the property facet.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("version", "Version of the property facet schema.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("properties", "Properties for the property facet.", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getReferenceableFacetRelationship() {
        String guid = "58c87647-ada9-4c90-a3c3-a40ace46b1f7";
        String name = "ReferenceableFacet";
        String description = "Link between a property facet and the resource it relates to.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("58c87647-ada9-4c90-a3c3-a40ace46b1f7", "ReferenceableFacet", null, "Link between a property facet and the resource it relates to.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "relatedEntity";
        String end1AttributeDescription = "Identifies which element this property facet belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "relatedEntity", "Identifies which element this property facet belongs to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "PropertyFacet";
        String end2AttributeName = "facets";
        String end2AttributeDescription = "Additional properties from different sources.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("PropertyFacet"), "facets", "Additional properties from different sources.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.SOURCE.name;
        String attribute1Description = OpenMetadataProperty.SOURCE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0025Locations() {
        this.archiveBuilder.addEntityDef(this.getLocationEntity());
        this.archiveBuilder.addRelationshipDef(this.getNestedLocationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAdjacentLocationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAssetLocationRelationship());
        this.archiveBuilder.addClassificationDef(this.getMobileAssetClassification());
        this.archiveBuilder.addClassificationDef(this.getFixedLocationClassification());
        this.archiveBuilder.addClassificationDef(this.getSecureLocationClassification());
        this.archiveBuilder.addClassificationDef(this.getCyberLocationClassification());
    }

    private EntityDef getLocationEntity() {
        String guid = "3e09cb2b-5f15-4fd2-b004-fe0146ad8628";
        String name = "Location";
        String description = "A physical place, digital location or area.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("3e09cb2b-5f15-4fd2-b004-fe0146ad8628", "Location", this.archiveBuilder.getEntityDef(superTypeName), "A physical place, digital location or area.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getNestedLocationRelationship() {
        String guid = "f82a96c2-95a3-4223-88c0-9cbf2882b772";
        String name = "NestedLocation";
        String description = "Link between two locations to show one is nested inside another.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("f82a96c2-95a3-4223-88c0-9cbf2882b772", "NestedLocation", null, "Link between two locations to show one is nested inside another.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Location";
        String end1AttributeName = "groupingLocations";
        String end1AttributeDescription = "Location that is covering the broader area.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Location"), "groupingLocations", "Location that is covering the broader area.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Location";
        String end2AttributeName = "nestedLocations";
        String end2AttributeDescription = "Location that is nested in this location.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Location"), "nestedLocations", "Location that is nested in this location.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAdjacentLocationRelationship() {
        String guid = "017d0518-fc25-4e5e-985e-491d91e61e17";
        String name = "AdjacentLocation";
        String description = "Link between two locations that are next to one another.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("017d0518-fc25-4e5e-985e-491d91e61e17", "AdjacentLocation", null, "Link between two locations that are next to one another.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Location";
        String end1AttributeName = "peerLocations";
        String end1AttributeDescription = "Location that is adjacent to this location.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Location"), "peerLocations", "Location that is adjacent to this location.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Location";
        String end2AttributeName = "peerLocations";
        String end2AttributeDescription = "Location that is adjacent to this location.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Location"), "peerLocations", "Location that is adjacent to this location.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAssetLocationRelationship() {
        String guid = "bc236b62-d0e6-4c5c-93a1-3a35c3dba7b1";
        String name = "AssetLocation";
        String description = "Location of an Asset.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("bc236b62-d0e6-4c5c-93a1-3a35c3dba7b1", "AssetLocation", null, "Location of an Asset.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Location";
        String end1AttributeName = "knownLocations";
        String end1AttributeDescription = "Places where this asset is sited.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Location"), "knownLocations", "Places where this asset is sited.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ASSET.typeName;
        String end2AttributeName = "localAssets";
        String end2AttributeDescription = "Assets sited at this location.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "localAssets", "Assets sited at this location.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getMobileAssetClassification() {
        String guid = "b25fb90d-8fa2-4aa9-b884-ff0a6351a697";
        String name = "MobileAsset";
        String description = "An asset not restricted to a single physical location.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.ASSET.typeName;
        return this.archiveHelper.getClassificationDef("b25fb90d-8fa2-4aa9-b884-ff0a6351a697", "MobileAsset", null, "An asset not restricted to a single physical location.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getFixedLocationClassification() {
        String guid = "bc111963-80c7-444f-9715-946c03142dd2";
        String name = "FixedLocation";
        String description = "A location linked to a physical place.";
        String descriptionGUID = null;
        String linkedToEntity = "Location";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("bc111963-80c7-444f-9715-946c03142dd2", "FixedLocation", null, "A location linked to a physical place.", descriptionGUID, this.archiveBuilder.getEntityDef("Location"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "coordinates";
        String attribute1Description = "Geographical coordinates of this location.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "address";
        String attribute2Description = "Postal address of this location.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "timezone";
        String attribute3Description = "Timezone for the location.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("coordinates", "Geographical coordinates of this location.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("address", "Postal address of this location.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("timezone", "Timezone for the location.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getSecureLocationClassification() {
        String guid = "e7b563c0-fcdd-4ba7-a046-eecf5c4638b8";
        String name = "SecureLocation";
        String description = "A location that protects the assets in its care.";
        String descriptionGUID = null;
        String linkedToEntity = "Location";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("e7b563c0-fcdd-4ba7-a046-eecf5c4638b8", "SecureLocation", null, "A location that protects the assets in its care.", descriptionGUID, this.archiveBuilder.getEntityDef("Location"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "level";
        String attribute2Description = "Level of security at this location.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("level", "Level of security at this location.", attribute2DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getCyberLocationClassification() {
        String guid = "f9ec3633-8ac8-480b-aa6d-5e674b9e1b17";
        String name = "CyberLocation";
        String description = "A digital location.";
        String descriptionGUID = null;
        String linkedToEntity = "Location";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("f9ec3633-8ac8-480b-aa6d-5e674b9e1b17", "CyberLocation", null, "A digital location.", descriptionGUID, this.archiveBuilder.getEntityDef("Location"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "address";
        String attribute1Description = "Network address of the location.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("address", "Network address of the location.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0030HostsAndPlatforms() {
        this.archiveBuilder.addEnumDef(this.getEndiannessEnum());
        this.archiveBuilder.addEntityDef(this.getITInfrastructureEntity());
        this.archiveBuilder.addEntityDef(this.getHostEntity());
        this.archiveBuilder.addEntityDef(this.getOperatingPlatformEntity());
        this.archiveBuilder.addRelationshipDef(this.getHostLocationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getHostOperatingPlatformRelationship());
    }

    private EnumDef getEndiannessEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ByteOrdering.getOpenTypeGUID(), ByteOrdering.getOpenTypeName(), ByteOrdering.getOpenTypeDescription(), ByteOrdering.getOpenTypeDescriptionGUID(), ByteOrdering.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ByteOrdering byteOrdering : ByteOrdering.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(byteOrdering.getOrdinal(), byteOrdering.getName(), byteOrdering.getDescription(), byteOrdering.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!byteOrdering.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getITInfrastructureEntity() {
        String guid = OpenMetadataType.IT_INFRASTRUCTURE.typeGUID;
        String name = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        String description = OpenMetadataType.IT_INFRASTRUCTURE.description;
        String descriptionGUID = OpenMetadataType.IT_INFRASTRUCTURE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.IT_INFRASTRUCTURE.wikiURL;
        String superTypeName = OpenMetadataType.INFRASTRUCTURE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef getHostEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.HOST.typeGUID, OpenMetadataType.HOST.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.IT_INFRASTRUCTURE.typeName), OpenMetadataType.HOST.description, OpenMetadataType.HOST.descriptionGUID, OpenMetadataType.HOST.wikiURL);
    }

    private EntityDef getOperatingPlatformEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.OPERATING_PLATFORM.typeGUID, OpenMetadataType.OPERATING_PLATFORM.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.OPERATING_PLATFORM.description, OpenMetadataType.OPERATING_PLATFORM.descriptionGUID, OpenMetadataType.OPERATING_PLATFORM.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "operatingSystem";
        String attribute3Description = "Name of the operating system running on this operating platform.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "endianness";
        String attribute4Description = "Definition of byte ordering.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("operatingSystem", "Name of the operating system running on this operating platform.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("endianness", "Definition of byte ordering.", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getHostLocationRelationship() {
        String guid = "f3066075-9611-4886-9244-32cc6eb07ea9";
        String name = "HostLocation";
        String description = "Defines the location of a host.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("f3066075-9611-4886-9244-32cc6eb07ea9", "HostLocation", null, "Defines the location of a host.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Host";
        String end1AttributeName = "localHosts";
        String end1AttributeDescription = "Host sited at this location.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Host"), "localHosts", "Host sited at this location.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Location";
        String end2AttributeName = "locations";
        String end2AttributeDescription = "Locations for this host.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Location"), "locations", "Locations for this host.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getHostOperatingPlatformRelationship() {
        String guid = "b9179df5-6e23-4581-a8b0-2919e6322b12";
        String name = "HostOperatingPlatform";
        String description = "Identifies the operating platform for a host.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("b9179df5-6e23-4581-a8b0-2919e6322b12", "HostOperatingPlatform", null, "Identifies the operating platform for a host.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Host";
        String end1AttributeName = "hosts";
        String end1AttributeDescription = "Host supporting this operating platform.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Host"), "hosts", "Host supporting this operating platform.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "OperatingPlatform";
        String end2AttributeName = "operatingPlatform";
        String end2AttributeDescription = "Type of platform supported by this host.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OperatingPlatform"), "operatingPlatform", "Type of platform supported by this host.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0035ComplexHosts() {
        this.archiveBuilder.addEntityDef(this.getHostClusterEntity());
        this.archiveBuilder.addEntityDef(this.getVirtualContainerEntity());
        this.archiveBuilder.addRelationshipDef(this.getHostClusterMemberRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDeployedVirtualContainerRelationship());
    }

    private EntityDef getHostClusterEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.HOST_CLUSTER.typeGUID, OpenMetadataType.HOST_CLUSTER.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST.typeName), OpenMetadataType.HOST_CLUSTER.description, OpenMetadataType.HOST_CLUSTER.descriptionGUID, OpenMetadataType.HOST_CLUSTER.wikiURL);
    }

    private EntityDef getVirtualContainerEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.VIRTUAL_CONTAINER.typeGUID, OpenMetadataType.VIRTUAL_CONTAINER.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.HOST.typeName), OpenMetadataType.VIRTUAL_CONTAINER.description, OpenMetadataType.VIRTUAL_CONTAINER.descriptionGUID, OpenMetadataType.VIRTUAL_CONTAINER.wikiURL);
    }

    private RelationshipDef getHostClusterMemberRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.HOST_CLUSTER_MEMBER_RELATIONSHIP.typeGUID, OpenMetadataType.HOST_CLUSTER_MEMBER_RELATIONSHIP.typeName, null, OpenMetadataType.HOST_CLUSTER_MEMBER_RELATIONSHIP.description, OpenMetadataType.HOST_CLUSTER_MEMBER_RELATIONSHIP.descriptionGUID, OpenMetadataType.HOST_CLUSTER_MEMBER_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.HOST_CLUSTER.typeName;
        String end1AttributeName = "hostCluster";
        String end1AttributeDescription = "Cluster managing this host.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "hostCluster", "Cluster managing this host.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.HOST.typeName;
        String end2AttributeName = "managedHosts";
        String end2AttributeDescription = "Member of the host cluster.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "managedHosts", "Member of the host cluster.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDeployedVirtualContainerRelationship() {
        String guid = "4b981d89-e356-4d9b-8f17-b3a8d5a86676";
        String name = "DeployedVirtualContainer";
        String description = "Identifies the real host where a virtual container is deployed to.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4b981d89-e356-4d9b-8f17-b3a8d5a86676", "DeployedVirtualContainer", null, "Identifies the real host where a virtual container is deployed to.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Host";
        String end1AttributeName = "hosts";
        String end1AttributeDescription = "Deployed host for this container.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Host"), "hosts", "Deployed host for this container.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "VirtualContainer";
        String end2AttributeName = "hostedContainers";
        String end2AttributeDescription = "Virtual containers deployed on this host.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("VirtualContainer"), "hostedContainers", "Virtual containers deployed on this host.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0037SoftwareServerPlatforms() {
        this.archiveBuilder.addEnumDef(this.getOperationalStatusEnum());
        this.archiveBuilder.addEntityDef(this.getSoftwareServerPlatformEntity());
        this.archiveBuilder.addRelationshipDef(this.getSoftwareServerPlatformDeploymentRelationship());
    }

    private EnumDef getOperationalStatusEnum() {
        String guid = "24e1e33e-9250-4a6c-8b07-05c7adec3a1d";
        String name = "OperationalStatus";
        String description = "Defines whether a component is operational.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("24e1e33e-9250-4a6c-8b07-05c7adec3a1d", "OperationalStatus", "Defines whether a component is operational.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Disabled";
        String element1Description = "The component is not operational.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Disabled", "The component is not operational.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Enabled";
        String element2Description = "The component is operational.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Enabled", "The component is operational.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getSoftwareServerPlatformEntity() {
        String guid = OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeGUID;
        String name = OpenMetadataType.SOFTWARE_SERVER_PLATFORM.typeName;
        String description = OpenMetadataType.SOFTWARE_SERVER_PLATFORM.description;
        String descriptionGUID = OpenMetadataType.SOFTWARE_SERVER_PLATFORM.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SOFTWARE_SERVER_PLATFORM.wikiURL;
        String superTypeName = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Type of software server platform.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "version";
        String attribute2Description = "Version number of the software server platform.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.SOURCE.name;
        String attribute3Description = OpenMetadataProperty.SOURCE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        String attribute4Name = "userId";
        String attribute4Description = "Server platform's authentication name.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Type of software server platform.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Version number of the software server platform.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("userId", "Server platform's authentication name.", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSoftwareServerPlatformDeploymentRelationship() {
        String guid = "b909eb3b-5205-4180-9f63-122a65b30738";
        String name = "SoftwareServerPlatformDeployment";
        String description = "Defines the host that a software server platform is deployed to.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("b909eb3b-5205-4180-9f63-122a65b30738", "SoftwareServerPlatformDeployment", null, "Defines the host that a software server platform is deployed to.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Host";
        String end1AttributeName = "host";
        String end1AttributeDescription = "Supporting host.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Host"), "host", "Supporting host.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SoftwareServerPlatform";
        String end2AttributeName = "deployedServerPlatforms";
        String end2AttributeDescription = "Software server platforms deployed on this host.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareServerPlatform"), "deployedServerPlatforms", "Software server platforms deployed on this host.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "deploymentTime";
        String attribute1Description = "Time that the software server platform was deployed to the host.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "deployer";
        String attribute2Description = "Person, organization or engine that deployed the software server platform.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "platformStatus";
        String attribute3Description = "The operational status of the software server platform on this host.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("deploymentTime", "Time that the software server platform was deployed to the host.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("deployer", "Person, organization or engine that deployed the software server platform.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("OperationalStatus", "platformStatus", "The operational status of the software server platform on this host.", attribute3DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0040SoftwareServers() {
        this.archiveBuilder.addEntityDef(this.getSoftwareServerEntity());
        this.archiveBuilder.addEntityDef(this.getEndpointEntity());
        this.archiveBuilder.addRelationshipDef(this.getSoftwareServerDeploymentRelationship());
        this.archiveBuilder.addRelationshipDef(this.getServerEndpointRelationship());
    }

    private EntityDef getSoftwareServerEntity() {
        String guid = OpenMetadataType.SOFTWARE_SERVER.typeGUID;
        String name = OpenMetadataType.SOFTWARE_SERVER.typeName;
        String description = OpenMetadataType.SOFTWARE_SERVER.description;
        String descriptionGUID = OpenMetadataType.SOFTWARE_SERVER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SOFTWARE_SERVER.wikiURL;
        String superTypeName = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Type of software server.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "version";
        String attribute2Description = "Version number of the software server.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.SOURCE.name;
        String attribute3Description = OpenMetadataProperty.SOURCE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        String attribute4Name = "userId";
        String attribute4Description = "Server's authentication name.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Type of software server.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Version number of the software server.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("userId", "Server's authentication name.", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getEndpointEntity() {
        String guid = "dbc20663-d705-4ff0-8424-80c262c6b8e7";
        String name = "Endpoint";
        String description = "Description of the network address and related information needed to call a software service.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("dbc20663-d705-4ff0-8424-80c262c6b8e7", "Endpoint", this.archiveBuilder.getEntityDef(superTypeName), "Description of the network address and related information needed to call a software service.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "networkAddress";
        String attribute3Description = "Name used to connect to the endpoint.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "protocol";
        String attribute4Description = "Name of the protocol used to connect to the endpoint.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "encryptionMethod";
        String attribute5Description = "Type of encryption used at the endpoint (if any).";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("networkAddress", "Name used to connect to the endpoint.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("protocol", "Name of the protocol used to connect to the endpoint.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("encryptionMethod", "Type of encryption used at the endpoint (if any).", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSoftwareServerDeploymentRelationship() {
        String guid = "d909eb3b-5205-4180-9f63-122a65b30738";
        String name = "SoftwareServerDeployment";
        String description = "Defines the platform that a software server is deployed to.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("d909eb3b-5205-4180-9f63-122a65b30738", "SoftwareServerDeployment", null, "Defines the platform that a software server is deployed to.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SoftwareServerPlatform";
        String end1AttributeName = "hostingPlatform";
        String end1AttributeDescription = "Supporting platform for the software server.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareServerPlatform"), "hostingPlatform", "Supporting platform for the software server.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SoftwareServer";
        String end2AttributeName = "deployedSoftwareServers";
        String end2AttributeDescription = "Software servers deployed on this platform.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareServer"), "deployedSoftwareServers", "Software servers deployed on this platform.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "deploymentTime";
        String attribute1Description = "Time that the software server was deployed to the platform.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "deployer";
        String attribute2Description = "Person, organization or engine that deployed the software server.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "serverStatus";
        String attribute3Description = "The operational status of the software server on this platform.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("deploymentTime", "Time that the software server was deployed to the platform.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("deployer", "Person, organization or engine that deployed the software server.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("OperationalStatus", "serverStatus", "The operational status of the software server on this platform.", attribute3DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getServerEndpointRelationship() {
        String guid = "2b8bfab4-8023-4611-9833-82a0dc95f187";
        String name = "ServerEndpoint";
        String description = "Defines an endpoint associated with a server.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2b8bfab4-8023-4611-9833-82a0dc95f187", "ServerEndpoint", null, "Defines an endpoint associated with a server.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SoftwareServer";
        String end1AttributeName = "servers";
        String end1AttributeDescription = "Server supporting this endpoint.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareServer"), "servers", "Server supporting this endpoint.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Endpoint";
        String end2AttributeName = "endpoints";
        String end2AttributeDescription = "Endpoints supported by this server.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Endpoint"), "endpoints", "Endpoints supported by this server.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0042SoftwareServerCapabilities() {
        this.archiveBuilder.addEntityDef(this.getSoftwareServerCapabilityEntity());
        this.archiveBuilder.addRelationshipDef(this.getSoftwareServerSupportedCapabilityRelationship());
    }

    private EntityDef getSoftwareServerCapabilityEntity() {
        String guid = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeGUID;
        String name = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        String description = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.description;
        String descriptionGUID = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.wikiURL;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute3Name = "type";
        String attribute3Description = "Type of the software server capability.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "version";
        String attribute4Description = "Version number of the software server capability.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Type of the software server capability.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Version number of the software server capability.", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSoftwareServerSupportedCapabilityRelationship() {
        String guid = "8b7d7da5-0668-4174-a43b-8f8c6c068dd0";
        String name = "SoftwareServerSupportedCapability";
        String description = "Identifies a software capability that is deployed to a software server.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("8b7d7da5-0668-4174-a43b-8f8c6c068dd0", "SoftwareServerSupportedCapability", null, "Identifies a software capability that is deployed to a software server.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SoftwareServer";
        String end1AttributeName = "servers";
        String end1AttributeDescription = "Servers hosting this capability.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SoftwareServer"), "servers", "Servers hosting this capability.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        String end2AttributeName = "capabilities";
        String end2AttributeDescription = "Capabilities deployed on this software server.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "capabilities", "Capabilities deployed on this software server.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute3Name = "serverCapabilityStatus";
        String attribute3Description = "The operational status of the software server capability on this software server.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("OperationalStatus", "serverCapabilityStatus", "The operational status of the software server capability on this software server.", attribute3DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0045ServersAndAssets() {
        this.archiveBuilder.addEnumDef(this.getServerAssetUseTypeEnum());
        this.archiveBuilder.addRelationshipDef(this.getServerAssetUseRelationship());
    }

    private EnumDef getServerAssetUseTypeEnum() {
        String guid = "09439481-9489-467c-9ae5-178a6e0b6b5a";
        String name = "ServerAssetUseType";
        String description = "Defines how a software server capability may use an asset.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("09439481-9489-467c-9ae5-178a6e0b6b5a", "ServerAssetUseType", "Defines how a software server capability may use an asset.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Owns";
        String element1Description = "The software server capability is accountable for the maintenance and protection of the asset.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Owns", "The software server capability is accountable for the maintenance and protection of the asset.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setDefaultValue(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Governs";
        String element2Description = "The software server capability provides management or oversight of the asset.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Governs", "The software server capability provides management or oversight of the asset.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Maintains";
        String element3Description = "The software server capability keeps the asset up-to-date.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Maintains", "The software server capability keeps the asset up-to-date.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "Uses";
        String element4Description = "The software server capability consumes the content of the asset.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "Uses", "The software server capability consumes the content of the asset.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 99;
        String element5Value = "Other";
        String element5Description = "Another usage.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another usage.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private RelationshipDef getServerAssetUseRelationship() {
        String guid = "92b75926-8e9a-46c7-9d98-89009f622397";
        String name = "AssetServerUse";
        String description = "Defines that a server capability is using an asset.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("92b75926-8e9a-46c7-9d98-89009f622397", "AssetServerUse", null, "Defines that a server capability is using an asset.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        String end1AttributeName = "consumedBy";
        String end1AttributeDescription = "Capability consuming this asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "consumedBy", "Capability consuming this asset.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ASSET.typeName;
        String end2AttributeName = "consumedAsset";
        String end2AttributeDescription = "Asset that this software server capability is dependent on.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "consumedAsset", "Asset that this software server capability is dependent on.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.USE_TYPE.name;
        String attribute1Description = OpenMetadataProperty.USE_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.USE_TYPE.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("ServerAssetUseType", attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0050ApplicationsAndProcesses() {
        this.archiveBuilder.addEntityDef(this.getApplicationEntity());
        this.archiveBuilder.addRelationshipDef(this.getRuntimeForProcessRelationship());
        this.archiveBuilder.addClassificationDef(this.getApplicationServerClassification());
        this.archiveBuilder.addClassificationDef(this.getWebserverClassification());
    }

    private EntityDef getApplicationEntity() {
        String guid = OpenMetadataType.APPLICATION.typeGUID;
        String name = OpenMetadataType.APPLICATION.typeName;
        String description = OpenMetadataType.APPLICATION.description;
        String descriptionGUID = OpenMetadataType.APPLICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.APPLICATION.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private RelationshipDef getRuntimeForProcessRelationship() {
        String guid = "f6b5cf4f-7b88-47df-aeb0-d80d28ba1ec1";
        String name = "RuntimeForProcess";
        String description = "Identifies the deployed application that supports a specific automated process.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("f6b5cf4f-7b88-47df-aeb0-d80d28ba1ec1", "RuntimeForProcess", null, "Identifies the deployed application that supports a specific automated process.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Application";
        String end1AttributeName = "implementingApplication";
        String end1AttributeDescription = "Application that contains the process implementation.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Application"), "implementingApplication", "Application that contains the process implementation.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.PROCESS.typeName;
        String end2AttributeName = "implementedProcesses";
        String end2AttributeDescription = "Processes that are implemented by this application.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "implementedProcesses", "Processes that are implemented by this application.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getApplicationServerClassification() {
        String guid = "19196efb-2706-47bf-8e51-e8ba5b36d033";
        String name = "ApplicationServer";
        String description = "A server that hosts applications.";
        String descriptionGUID = null;
        String linkedToEntity = "SoftwareServer";
        return this.archiveHelper.getClassificationDef("19196efb-2706-47bf-8e51-e8ba5b36d033", "ApplicationServer", null, "A server that hosts applications.", descriptionGUID, this.archiveBuilder.getEntityDef("SoftwareServer"), false);
    }

    private ClassificationDef getWebserverClassification() {
        String guid = "d13e1cc5-bb7e-41ec-8233-9647fbf92a19";
        String name = "Webserver";
        String description = "A server that supports HTTP-based application such as websites and REST services.";
        String descriptionGUID = null;
        String linkedToEntity = "SoftwareServer";
        return this.archiveHelper.getClassificationDef("d13e1cc5-bb7e-41ec-8233-9647fbf92a19", "Webserver", null, "A server that supports HTTP-based application such as websites and REST services.", descriptionGUID, this.archiveBuilder.getEntityDef("SoftwareServer"), false);
    }

    private void add0055DataProcessingEngines() {
        this.archiveBuilder.addEntityDef(this.getEngineEntity());
        this.archiveBuilder.addClassificationDef(this.getWorkflowEngineClassification());
        this.archiveBuilder.addClassificationDef(this.getReportingEngineClassification());
        this.archiveBuilder.addClassificationDef(this.getAnalyticsEngineClassification());
        this.archiveBuilder.addClassificationDef(this.getDataMovementEngineClassification());
        this.archiveBuilder.addClassificationDef(this.getDataVirtualizationEngineClassification());
    }

    private EntityDef getEngineEntity() {
        String guid = OpenMetadataType.ENGINE.typeGUID;
        String name = OpenMetadataType.ENGINE.typeName;
        String description = OpenMetadataType.ENGINE.description;
        String descriptionGUID = OpenMetadataType.ENGINE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ENGINE.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private ClassificationDef getWorkflowEngineClassification() {
        String guid = OpenMetadataType.WORKFLOW_ENGINE_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.WORKFLOW_ENGINE_CLASSIFICATION.typeName;
        String description = OpenMetadataType.WORKFLOW_ENGINE_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.WORKFLOW_ENGINE_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.WORKFLOW_ENGINE_CLASSIFICATION.wikiURL;
        String linkedToEntity = OpenMetadataType.ENGINE.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getReportingEngineClassification() {
        String guid = OpenMetadataType.REPORTING_ENGINE_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.REPORTING_ENGINE_CLASSIFICATION.typeName;
        String description = OpenMetadataType.REPORTING_ENGINE_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.REPORTING_ENGINE_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.REPORTING_ENGINE_CLASSIFICATION.wikiURL;
        String linkedToEntity = OpenMetadataType.ENGINE.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getAnalyticsEngineClassification() {
        String guid = OpenMetadataType.ANALYTICS_ENGINE.typeGUID;
        String name = OpenMetadataType.ANALYTICS_ENGINE.typeName;
        String description = OpenMetadataType.ANALYTICS_ENGINE.description;
        String descriptionGUID = OpenMetadataType.ANALYTICS_ENGINE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ANALYTICS_ENGINE.wikiURL;
        String linkedToEntity = OpenMetadataType.ENGINE.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getDataMovementEngineClassification() {
        String guid = OpenMetadataType.DATA_MOVEMENT_ENGINE.typeGUID;
        String name = OpenMetadataType.DATA_MOVEMENT_ENGINE.typeName;
        String description = OpenMetadataType.DATA_MOVEMENT_ENGINE.description;
        String descriptionGUID = OpenMetadataType.DATA_MOVEMENT_ENGINE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_MOVEMENT_ENGINE.wikiURL;
        String linkedToEntity = OpenMetadataType.ENGINE.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getDataVirtualizationEngineClassification() {
        String guid = OpenMetadataType.DATA_VIRTUALIZATION_ENGINE.typeGUID;
        String name = OpenMetadataType.DATA_VIRTUALIZATION_ENGINE.typeName;
        String description = OpenMetadataType.DATA_VIRTUALIZATION_ENGINE.description;
        String descriptionGUID = OpenMetadataType.DATA_VIRTUALIZATION_ENGINE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_VIRTUALIZATION_ENGINE.wikiURL;
        String linkedToEntity = OpenMetadataType.ENGINE.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private void add0070NetworksAndGateways() {
        this.archiveBuilder.addEntityDef(this.getNetworkEntity());
        this.archiveBuilder.addEntityDef(this.getNetworkGatewayEntity());
        this.archiveBuilder.addRelationshipDef(this.getHostNetworkRelationship());
        this.archiveBuilder.addRelationshipDef(this.getNetworkGatewayLinkRelationship());
    }

    private EntityDef getNetworkEntity() {
        String guid = "e0430f59-f021-411a-9d81-883e1ff3f6f6";
        String name = "Network";
        String description = "Inter-connectivity for systems.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        return this.archiveHelper.getDefaultEntityDef("e0430f59-f021-411a-9d81-883e1ff3f6f6", "Network", this.archiveBuilder.getEntityDef(superTypeName), "Inter-connectivity for systems.", descriptionGUID);
    }

    private EntityDef getNetworkGatewayEntity() {
        String guid = "9bbae94d-e109-4c96-b072-4f97123f04fd";
        String name = "NetworkGateway";
        String description = "A connection point enabling network traffic to pass between two networks.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef("9bbae94d-e109-4c96-b072-4f97123f04fd", "NetworkGateway", this.archiveBuilder.getEntityDef(superTypeName), "A connection point enabling network traffic to pass between two networks.", descriptionGUID);
    }

    private RelationshipDef getHostNetworkRelationship() {
        String guid = "f2bd7401-c064-41ac-862c-e5bcdc98fa1e";
        String name = "HostNetwork";
        String description = "One of the hosts connected to a network.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("f2bd7401-c064-41ac-862c-e5bcdc98fa1e", "HostNetwork", null, "One of the hosts connected to a network.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Host";
        String end1AttributeName = "connectedHosts";
        String end1AttributeDescription = "Hosts connected to this network.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Host"), "connectedHosts", "Hosts connected to this network.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Network";
        String end2AttributeName = "networkConnections";
        String end2AttributeDescription = "Connections to different networks.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Network"), "networkConnections", "Connections to different networks.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getNetworkGatewayLinkRelationship() {
        String guid = "5bece460-1fa6-41fb-a29f-fdaf65ec8ce3";
        String name = "NetworkGatewayLink";
        String description = "Link from a network to one of its network gateways.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("5bece460-1fa6-41fb-a29f-fdaf65ec8ce3", "NetworkGatewayLink", null, "Link from a network to one of its network gateways.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "NetworkGateway";
        String end1AttributeName = "gateways";
        String end1AttributeDescription = "Gateways to other networks.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("NetworkGateway"), "gateways", "Gateways to other networks.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Network";
        String end2AttributeName = "networkConnections";
        String end2AttributeDescription = "Connections to different networks.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Network"), "networkConnections", "Connections to different networks.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0090CloudPlatformsAndServices() {
        this.archiveBuilder.addClassificationDef(this.getCloudProviderClassification());
        this.archiveBuilder.addClassificationDef(this.getCloudPlatformClassification());
        this.archiveBuilder.addClassificationDef(this.getCloudTenantClassification());
        this.archiveBuilder.addClassificationDef(this.getCloudServiceClassification());
    }

    private ClassificationDef getCloudProviderClassification() {
        String guid = "a2bfdd08-d0a8-49db-bc97-7f2406281046";
        String name = "CloudProvider";
        String description = "A host supporting cloud services.";
        String descriptionGUID = null;
        String linkedToEntity = "Host";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("a2bfdd08-d0a8-49db-bc97-7f2406281046", "CloudProvider", null, "A host supporting cloud services.", descriptionGUID, this.archiveBuilder.getEntityDef("Host"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "providerName";
        String attribute1Description = "Name of the cloud provider.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("providerName", "Name of the cloud provider.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getCloudPlatformClassification() {
        String guid = "1b8f8511-e606-4f65-86d3-84891706ad12";
        String name = "CloudPlatform";
        String description = "A software server platform supporting cloud services.";
        String descriptionGUID = null;
        String linkedToEntity = "SoftwareServerPlatform";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("1b8f8511-e606-4f65-86d3-84891706ad12", "CloudPlatform", null, "A software server platform supporting cloud services.", descriptionGUID, this.archiveBuilder.getEntityDef("SoftwareServerPlatform"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Type of cloud platform.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Type of cloud platform.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getCloudTenantClassification() {
        String guid = "1b8f8522-e606-4f65-86d3-84891706ad12";
        String name = "CloudTenant";
        String description = "A software server supporting cloud services.";
        String descriptionGUID = null;
        String linkedToEntity = "SoftwareServer";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("1b8f8522-e606-4f65-86d3-84891706ad12", "CloudTenant", null, "A software server supporting cloud services.", descriptionGUID, this.archiveBuilder.getEntityDef("SoftwareServer"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "tenantName";
        String attribute1Description = "Identifier of the tenant.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "type";
        String attribute2Description = "Description of the type of tenant.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("tenantName", "Identifier of the tenant.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("type", "Description of the type of tenant.", attribute2DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getCloudServiceClassification() {
        String guid = "337e7b1a-ad4b-4818-aa3e-0ff3307b2fbe";
        String name = "CloudService";
        String description = "A service running on a cloud platform.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("337e7b1a-ad4b-4818-aa3e-0ff3307b2fbe", "CloudService", null, "A service running on a cloud platform.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "offeringName";
        String attribute1Description = "Commercial name of the service.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "type";
        String attribute2Description = "Description of the type of the service.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("offeringName", "Commercial name of the service.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("type", "Description of the type of the service.", attribute2DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void addArea1Types() {
        this.add0110Actors();
        this.add0112People();
        this.add0115Teams();
        this.add0117EngineProfiles();
        this.add0120Collections();
        this.add0130Projects();
        this.add0135Meetings();
        this.add0137Actions();
        this.add0140Communities();
        this.add0150Feedback();
        this.add0155CrowdSourcing();
        this.add0160Notes();
    }

    private void add0110Actors() {
        this.archiveBuilder.addEnumDef(this.getContactMethodTypeEnum());
        this.archiveBuilder.addEntityDef(this.getActorProfileEntity());
        this.archiveBuilder.addEntityDef(this.getUserIdentityEntity());
        this.archiveBuilder.addEntityDef(this.getContactDetailsEntity());
        this.archiveBuilder.addRelationshipDef(this.getContactThroughRelationship());
        this.archiveBuilder.addRelationshipDef(this.getProfileIdentityRelationship());
    }

    private EnumDef getContactMethodTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ContactMethodType.getOpenTypeGUID(), ContactMethodType.getOpenTypeName(), ContactMethodType.getOpenTypeDescription(), ContactMethodType.getOpenTypeDescriptionGUID(), ContactMethodType.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ContactMethodType enumValues : ContactMethodType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getActorProfileEntity() {
        String guid = "5a2f38dc-d69d-4a6f-ad26-ac86f118fa35";
        String name = "ActorProfile";
        String description = "Description of a person, team or automated process that is working with data.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("5a2f38dc-d69d-4a6f-ad26-ac86f118fa35", "ActorProfile", this.archiveBuilder.getEntityDef(superTypeName), "Description of a person, team or automated process that is working with data.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getUserIdentityEntity() {
        String guid = "fbe95779-1f3c-4ac6-aa9d-24963ff16282";
        String name = "UserIdentity";
        String description = "Name of the security account for a person or automated process.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        return this.archiveHelper.getDefaultEntityDef("fbe95779-1f3c-4ac6-aa9d-24963ff16282", "UserIdentity", this.archiveBuilder.getEntityDef(superTypeName), "Name of the security account for a person or automated process.", descriptionGUID);
    }

    private EntityDef getContactDetailsEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.CONTACT_DETAILS.typeGUID, OpenMetadataType.CONTACT_DETAILS.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.CONTACT_DETAILS.description, OpenMetadataType.CONTACT_DETAILS.descriptionGUID, OpenMetadataType.CONTACT_DETAILS.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.CONTACT_METHOD_TYPE.name;
        String attribute1Description = OpenMetadataProperty.CONTACT_METHOD_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.CONTACT_METHOD_TYPE.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.CONTACT_METHOD_VALUE.name;
        String attribute2Description = OpenMetadataProperty.CONTACT_METHOD_VALUE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.CONTACT_METHOD_VALUE.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.CONTACT_METHOD_SERVICE.name;
        String attribute3Description = OpenMetadataProperty.CONTACT_METHOD_SERVICE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.CONTACT_METHOD_SERVICE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute(ContactMethodType.getOpenTypeName(), attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getContactThroughRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP.typeGUID, OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP.typeName, null, OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP.description, OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP.descriptionGUID, OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = "ActorProfile";
        String end1AttributeName = "contactDetails";
        String end1AttributeDescription = "Contact details owner.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ActorProfile"), "contactDetails", "Contact details owner.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.CONTACT_DETAILS.typeName;
        String end2AttributeName = "contacts";
        String end2AttributeDescription = "Contact information.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "contacts", "Contact information.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getProfileIdentityRelationship() {
        String guid = "01664609-e777-4079-b543-6baffe910ff1";
        String name = "ProfileIdentity";
        String description = "Correlates a user identity with an actor profile.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("01664609-e777-4079-b543-6baffe910ff1", "ProfileIdentity", null, "Correlates a user identity with an actor profile.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ActorProfile";
        String end1AttributeName = "profile";
        String end1AttributeDescription = "Description of the person, organization or engine that uses this user identity.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ActorProfile"), "profile", "Description of the person, organization or engine that uses this user identity.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "UserIdentity";
        String end2AttributeName = "userIdentities";
        String end2AttributeDescription = "Authentication identifiers in use by the owner of this profile.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("UserIdentity"), "userIdentities", "Authentication identifiers in use by the owner of this profile.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0112People() {
        this.archiveBuilder.addEntityDef(this.getPersonEntity());
        this.archiveBuilder.addEntityDef(this.getContributionRecordEntity());
        this.archiveBuilder.addEntityDef(this.getPersonRoleEntity());
        this.archiveBuilder.addRelationshipDef(this.getPersonRoleAppointmentRelationship());
        this.archiveBuilder.addRelationshipDef(this.getPersonalContributionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getPeerRelationship());
    }

    private EntityDef getPersonEntity() {
        String guid = "ac406bf8-e53e-49f1-9088-2af28bbbd285";
        String name = "Person";
        String description = "An individual.";
        String descriptionGUID = null;
        String superTypeName = "ActorProfile";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("ac406bf8-e53e-49f1-9088-2af28bbbd285", "Person", this.archiveBuilder.getEntityDef("ActorProfile"), "An individual.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "fullName";
        String attribute1Description = "Full or official name of the individual (if different from known name).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "jobTitle";
        String attribute2Description = "Role or level in the organization.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.IS_PUBLIC.name;
        String attribute3Description = "Is the profile visible to other collaborators?";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("fullName", "Full or official name of the individual (if different from known name).", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("jobTitle", "Role or level in the organization.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute(attribute3Name, "Is the profile visible to other collaborators?", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getContributionRecordEntity() {
        String guid = "ac406bf8-e53e-49f1-9088-2af28cccd285";
        String name = "ContributionRecord";
        String description = "A record of the contribution of an individual.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("ac406bf8-e53e-49f1-9088-2af28cccd285", "ContributionRecord", this.archiveBuilder.getEntityDef(superTypeName), "A record of the contribution of an individual.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.IS_PUBLIC.name;
        String attribute1Description = "Is the contribution visible to other collaborators?";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "karmaPoints";
        String attribute2Description = "Points capturing a person's engagement with open metadata.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute(attribute1Name, "Is the contribution visible to other collaborators?", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute("karmaPoints", "Points capturing a person's engagement with open metadata.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getPersonRoleEntity() {
        String guid = "ac406bf8-e53e-49f1-9088-2af28bcbd285";
        String name = "PersonRole";
        String description = "A role performed by one or more individuals.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("ac406bf8-e53e-49f1-9088-2af28bcbd285", "PersonRole", this.archiveBuilder.getEntityDef(superTypeName), "A role performed by one or more individuals.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "scope";
        String attribute3Description = "Breadth of responsibility.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "headCount";
        String attribute4Description = "Number of people that can be appointed to the role.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("scope", "Breadth of responsibility.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("headCount", "Number of people that can be appointed to the role.", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getPersonRoleAppointmentRelationship() {
        String guid = "4a316abe-bcce-4d11-ad5a-4bfb4079b80b";
        String name = "PersonRoleAppointment";
        String description = "Relationship identifying a person's roles.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4a316abe-bcce-4d11-ad5a-4bfb4079b80b", "PersonRoleAppointment", null, "Relationship identifying a person's roles.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Person";
        String end1AttributeName = "rolePerformers";
        String end1AttributeDescription = "A person performing this role.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Person"), "rolePerformers", "A person performing this role.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "PersonRole";
        String end2AttributeName = "performsRoles";
        String end2AttributeDescription = "A role performed by this person.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("PersonRole"), "performsRoles", "A role performed by this person.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.IS_PUBLIC.name;
        String attribute1Description = "Is the appointment visible to more than the role owner and appointee?";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute(attribute1Name, "Is the appointment visible to more than the role owner and appointee?", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getPersonalContributionRelationship() {
        String guid = "4a316abe-eeee-4d11-ad5a-4bfb4079b80b";
        String name = "PersonalContribution";
        String description = "Relationship identifying a person's contribution record.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4a316abe-eeee-4d11-ad5a-4bfb4079b80b", "PersonalContribution", null, "Relationship identifying a person's contribution record.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Person";
        String end1AttributeName = "contributor";
        String end1AttributeDescription = "The person behind the contribution.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Person"), "contributor", "The person behind the contribution.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ContributionRecord";
        String end2AttributeName = "contributionRecord";
        String end2AttributeDescription = "The record of activity by this person.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ContributionRecord"), "contributionRecord", "The record of activity by this person.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getPeerRelationship() {
        String guid = "4a316abe-bccd-4d11-ad5a-4bfb4079b80b";
        String name = "Peer";
        String description = "Relationship identifying a person's peer network.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4a316abe-bccd-4d11-ad5a-4bfb4079b80b", "Peer", null, "Relationship identifying a person's peer network.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Person";
        String end1AttributeName = "peers";
        String end1AttributeDescription = "List of this person's peer network.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Person"), "peers", "List of this person's peer network.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Person";
        String end2AttributeName = "peers";
        String end2AttributeDescription = "List of this person's peer network.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Person"), "peers", "List of this person's peer network.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0115Teams() {
        this.archiveBuilder.addEntityDef(this.getTeamEntity());
        this.archiveBuilder.addEntityDef(this.getTeamLeaderEntity());
        this.archiveBuilder.addEntityDef(this.getTeamMemberEntity());
        this.archiveBuilder.addRelationshipDef(this.getTeamLeadershipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTeamMembershipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTeamStructureRelationship());
    }

    private EntityDef getTeamEntity() {
        String guid = "36db26d5-aba2-439b-bc15-d62d373c5db6";
        String name = "Team";
        String description = "Group of people working together.";
        String descriptionGUID = null;
        String superTypeName = "ActorProfile";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("36db26d5-aba2-439b-bc15-d62d373c5db6", "Team", this.archiveBuilder.getEntityDef("ActorProfile"), "Group of people working together.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "teamType";
        String attribute1Description = "Type of team, such as department.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("teamType", "Type of team, such as department.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getTeamLeaderEntity() {
        String guid = "36db26d5-abb2-439b-bc15-d62d373c5db6";
        String name = "TeamLeader";
        String description = "Person leading a team.";
        String descriptionGUID = null;
        String superTypeName = "PersonRole";
        return this.archiveHelper.getDefaultEntityDef("36db26d5-abb2-439b-bc15-d62d373c5db6", "TeamLeader", this.archiveBuilder.getEntityDef("PersonRole"), "Person leading a team.", descriptionGUID);
    }

    private EntityDef getTeamMemberEntity() {
        String guid = "46db26d5-abb2-538b-bc15-d62d373c5db6";
        String name = "TeamMember";
        String description = "Person assigned to a team.";
        String descriptionGUID = null;
        String superTypeName = "PersonRole";
        return this.archiveHelper.getDefaultEntityDef("46db26d5-abb2-538b-bc15-d62d373c5db6", "TeamMember", this.archiveBuilder.getEntityDef("PersonRole"), "Person assigned to a team.", descriptionGUID);
    }

    private RelationshipDef getTeamStructureRelationship() {
        String guid = "5ebc4fb2-b62a-4269-8f18-e9237a2229ca";
        String name = "TeamStructure";
        String description = "Relationship identifying a team hierarchy.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("5ebc4fb2-b62a-4269-8f18-e9237a2229ca", "TeamStructure", null, "Relationship identifying a team hierarchy.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Team";
        String end1AttributeName = "superTeam";
        String end1AttributeDescription = "The aggregating team.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Team"), "superTeam", "The aggregating team.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Team";
        String end2AttributeName = "subTeam";
        String end2AttributeDescription = "The teams where work is delegated to.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Team"), "subTeam", "The teams where work is delegated to.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "delegationEscalationAuthority";
        String attribute1Description = "Can delegations and escalations flow on this relationship.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("delegationEscalationAuthority", "Can delegations and escalations flow on this relationship.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getTeamLeadershipRelationship() {
        String guid = "5ebc4fb2-b62a-4269-8f18-e9237a2119ca";
        String name = "TeamLeadership";
        String description = "Relationship identifying the leaders of teams.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("5ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamLeadership", null, "Relationship identifying the leaders of teams.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "TeamLeader";
        String end1AttributeName = "teamLeaders";
        String end1AttributeDescription = "The leaders of the team.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("TeamLeader"), "teamLeaders", "The leaders of the team.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Team";
        String end2AttributeName = "leadsTeam";
        String end2AttributeDescription = "The team lead by this team leader.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Team"), "leadsTeam", "The team lead by this team leader.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "position";
        String attribute1Description = "Details of the type of leadership position, eg deputy.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("position", "Details of the type of leadership position, eg deputy.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getTeamMembershipRelationship() {
        String guid = "1ebc4fb2-b62a-4269-8f18-e9237a2119ca";
        String name = "TeamMembership";
        String description = "Relationship identifying the members of teams.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("1ebc4fb2-b62a-4269-8f18-e9237a2119ca", "TeamMembership", null, "Relationship identifying the members of teams.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "TeamMember";
        String end1AttributeName = "teamMembers";
        String end1AttributeDescription = "The members of the team.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("TeamMember"), "teamMembers", "The members of the team.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Team";
        String end2AttributeName = "memberOfTeam";
        String end2AttributeDescription = "The team that this person is a member of.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Team"), "memberOfTeam", "The team that this person is a member of.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "position";
        String attribute1Description = "Details of the type of membership position, if any.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("position", "Details of the type of membership position, if any.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0117EngineProfiles() {
        this.archiveBuilder.addEntityDef(this.getITProfileEntity());
    }

    private EntityDef getITProfileEntity() {
        String guid = "81394f85-6008-465b-926e-b3fae4668937";
        String name = "ITProfile";
        String description = "Descriptive details about a processing engine or other IT infrastructure.";
        String descriptionGUID = null;
        String superTypeName = "ActorProfile";
        return this.archiveHelper.getDefaultEntityDef("81394f85-6008-465b-926e-b3fae4668937", "ITProfile", this.archiveBuilder.getEntityDef("ActorProfile"), "Descriptive details about a processing engine or other IT infrastructure.", descriptionGUID);
    }

    private void add0120Collections() {
        this.archiveBuilder.addEnumDef(this.getOrderByEnum());
        this.archiveBuilder.addEntityDef(this.getCollectionEntity());
        this.archiveBuilder.addRelationshipDef(this.getCollectionMembershipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getResourceListRelationship());
        this.archiveBuilder.addClassificationDef(this.getFolderClassification());
        this.archiveBuilder.addClassificationDef(this.getSetClassification());
    }

    private EnumDef getOrderByEnum() {
        String guid = OrderBy.getOpenTypeGUID();
        String name = OrderBy.getOpenTypeName();
        String description = OrderBy.getOpenTypeDescription();
        String descriptionGUID = OrderBy.getOpenTypeDescriptionGUID();
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(guid, name, description, descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (OrderBy orderBy : OrderBy.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(orderBy.getOrdinal(), orderBy.getName(), orderBy.getDescription(), orderBy.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!orderBy.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getCollectionEntity() {
        String guid = OpenMetadataType.COLLECTION.typeGUID;
        String name = OpenMetadataType.COLLECTION.typeName;
        String description = OpenMetadataType.COLLECTION.description;
        String descriptionGUID = OpenMetadataType.COLLECTION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.COLLECTION.wikiURL;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getCollectionMembershipRelationship() {
        String guid = OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName;
        String description = OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.COLLECTION.typeName;
        String end1AttributeName = "foundInCollections";
        String end1AttributeDescription = "Collections that link to this element.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "foundInCollections", "Collections that link to this element.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "collectionMembers";
        String end2AttributeDescription = "Members of this collection.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "collectionMembers", "Members of this collection.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.MEMBERSHIP_RATIONALE.name;
        String attribute1Description = OpenMetadataProperty.MEMBERSHIP_RATIONALE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.MEMBERSHIP_RATIONALE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getResourceListRelationship() {
        String guid = OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName;
        String description = OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "resourceListAnchors";
        String end1AttributeDescription = "Referenceable objects that are using the linked to resource.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "resourceListAnchors", "Referenceable objects that are using the linked to resource.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "supportingResources";
        String end2AttributeDescription = "Resources identified as of interest to the anchor.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "supportingResources", "Resources identified as of interest to the anchor.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "resourceUse";
        String attribute1Description = "Identifier that describes the type of resource use.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "resourceUseDescription";
        String attribute2Description = "Description of how the resource is used, or why it is useful.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "resourceUseProperties";
        String attribute3Description = "Additional properties that explains how to use the resource.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "watchResource";
        String attribute4Description = "Indicator whether the anchor should receive notifications of changes to the resource.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("resourceUse", "Identifier that describes the type of resource use.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("resourceUseDescription", "Description of how the resource is used, or why it is useful.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("resourceUseProperties", "Additional properties that explains how to use the resource.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("watchResource", "Indicator whether the anchor should receive notifications of changes to the resource.", attribute4DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getFolderClassification() {
        String guid = OpenMetadataType.FOLDER.typeGUID;
        String name = OpenMetadataType.FOLDER.typeName;
        String description = OpenMetadataType.FOLDER.description;
        String descriptionGUID = OpenMetadataType.FOLDER.descriptionGUID;
        String linkedToEntity = OpenMetadataType.COLLECTION.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "orderBy";
        String attribute1Description = "Definition for how elements in the collection should be ordered.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "orderPropertyName";
        String attribute2Description = "Name of property to use for ordering.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("OrderBy", "orderBy", "Definition for how elements in the collection should be ordered.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("orderPropertyName", "Name of property to use for ordering.", attribute2DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getSetClassification() {
        String guid = OpenMetadataType.RESULTS_SET.typeGUID;
        String name = OpenMetadataType.RESULTS_SET.typeName;
        String description = OpenMetadataType.RESULTS_SET.description;
        String descriptionGUID = OpenMetadataType.RESULTS_SET.descriptionGUID;
        String descriptionWiki = OpenMetadataType.RESULTS_SET.wikiURL;
        String linkedToEntity = OpenMetadataType.COLLECTION.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private void add0130Projects() {
        this.archiveBuilder.addEntityDef(this.getProjectEntity());
        this.archiveBuilder.addEntityDef(this.getProjectManagerEntity());
        this.archiveBuilder.addRelationshipDef(this.getProjectHierarchyRelationship());
        this.archiveBuilder.addRelationshipDef(this.getProjectDependencyRelationship());
        this.archiveBuilder.addRelationshipDef(this.getProjectTeamRelationship());
        this.archiveBuilder.addRelationshipDef(this.getProjectScopeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getProjectManagementRelationship());
        this.archiveBuilder.addClassificationDef(this.getTaskClassification());
        this.archiveBuilder.addClassificationDef(this.getCampaignClassification());
    }

    private EntityDef getProjectEntity() {
        String guid = OpenMetadataType.PROJECT.typeGUID;
        String name = OpenMetadataType.PROJECT.typeName;
        String description = OpenMetadataType.PROJECT.description;
        String descriptionGUID = OpenMetadataType.PROJECT.descriptionGUID;
        String descriptionWiki = OpenMetadataType.PROJECT.wikiURL;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "startDate";
        String attribute3Description = "Start date of the project.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "plannedEndDate";
        String attribute4Description = "Planned completion data for the project.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "status";
        String attribute5Description = "Short description on current status of the project.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("startDate", "Start date of the project.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("plannedEndDate", "Planned completion data for the project.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("status", "Short description on current status of the project.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getProjectManagerEntity() {
        String guid = OpenMetadataType.PROJECT_MANAGER.typeGUID;
        String name = OpenMetadataType.PROJECT_MANAGER.typeName;
        String description = OpenMetadataType.PROJECT_MANAGER.description;
        String descriptionGUID = OpenMetadataType.PROJECT_MANAGER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.PROJECT_MANAGER.wikiURL;
        String superTypeName = "PersonRole";
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef("PersonRole"), description, descriptionGUID, descriptionWiki);
    }

    private RelationshipDef getProjectHierarchyRelationship() {
        String guid = OpenMetadataType.PROJECT_HIERARCHY_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.PROJECT_HIERARCHY_RELATIONSHIP.typeName;
        String description = OpenMetadataType.PROJECT_HIERARCHY_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.PROJECT_HIERARCHY_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.PROJECT_HIERARCHY_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.PROJECT.typeName;
        String end1AttributeName = "managingProject";
        String end1AttributeDescription = "Project that oversees this project.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "managingProject", "Project that oversees this project.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.PROJECT.typeName;
        String end2AttributeName = "managedProject";
        String end2AttributeDescription = "Project that this project is responsible for managing.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "managedProject", "Project that this project is responsible for managing.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getProjectDependencyRelationship() {
        String guid = OpenMetadataType.PROJECT_DEPENDENCY_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.PROJECT_DEPENDENCY_RELATIONSHIP.typeName;
        String description = OpenMetadataType.PROJECT_DEPENDENCY_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.PROJECT_DEPENDENCY_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.PROJECT_DEPENDENCY_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.PROJECT.typeName;
        String end1AttributeName = "dependentProject";
        String end1AttributeDescription = "Projects that are dependent on this project.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "dependentProject", "Projects that are dependent on this project.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.PROJECT.typeName;
        String end2AttributeName = "dependsOnProjects";
        String end2AttributeDescription = "Projects that are delivering resources or outcomes needed by this project.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "dependsOnProjects", "Projects that are delivering resources or outcomes needed by this project.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "dependencySummary";
        String attribute1Description = "Reasons for the project dependency.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("dependencySummary", "Reasons for the project dependency.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getProjectTeamRelationship() {
        String guid = OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeName;
        String description = OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.PROJECT.typeName;
        String end1AttributeName = "projectFocus";
        String end1AttributeDescription = "Projects that a team is working on.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "projectFocus", "Projects that a team is working on.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ActorProfile";
        String end2AttributeName = "supportingActors";
        String end2AttributeDescription = "People and teams supporting this project.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ActorProfile"), "supportingActors", "People and teams supporting this project.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "teamRole";
        String attribute1Description = "Description of the role of the team in the project.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("teamRole", "Description of the role of the team in the project.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getProjectScopeRelationship() {
        String guid = "bc63ac45-b4d0-4fba-b583-92859de77dd8";
        String name = "ProjectScope";
        String description = "The documentation, assets and definitions that are affected by the project.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("bc63ac45-b4d0-4fba-b583-92859de77dd8", "ProjectScope", null, "The documentation, assets and definitions that are affected by the project.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.PROJECT.typeName;
        String end1AttributeName = "impactingProjects";
        String end1AttributeDescription = "The projects that are making changes to these elements.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "impactingProjects", "The projects that are making changes to these elements.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "projectScope";
        String end2AttributeDescription = "The elements that are being changed by this project.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "projectScope", "The elements that are being changed by this project.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "scopeDescription";
        String attribute1Description = "Description of how each item is being changed by the project.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("scopeDescription", "Description of how each item is being changed by the project.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getTaskClassification() {
        String guid = OpenMetadataType.TASK_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.TASK_CLASSIFICATION.typeName;
        String description = OpenMetadataType.TASK_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.TASK_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.TASK_CLASSIFICATION.wikiURL;
        String linkedToEntity = OpenMetadataType.PROJECT.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private RelationshipDef getProjectManagementRelationship() {
        String guid = OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeName;
        String description = OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.PROJECT.typeName;
        String end1AttributeName = "projectsManaged";
        String end1AttributeDescription = "The projects that are being managed by this project manager.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "projectsManaged", "The projects that are being managed by this project manager.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.PROJECT_MANAGER.typeName;
        String end2AttributeName = "projectManagers";
        String end2AttributeDescription = "The roles for managing this project.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "projectManagers", "The roles for managing this project.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getCampaignClassification() {
        String guid = OpenMetadataType.CAMPAIGN_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.CAMPAIGN_CLASSIFICATION.typeName;
        String description = OpenMetadataType.CAMPAIGN_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.CAMPAIGN_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.CAMPAIGN_CLASSIFICATION.wikiURL;
        String linkedToEntity = OpenMetadataType.COLLECTION.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private void add0135Meetings() {
        this.archiveBuilder.addEntityDef(this.getMeetingEntity());
        this.archiveBuilder.addRelationshipDef(this.getMeetingsRelationship());
    }

    private EntityDef getMeetingEntity() {
        String guid = "6bf90c79-32f4-47ad-959c-8fff723fe744";
        String name = "Meeting";
        String description = "Two or more people come together to discuss a topic, agree and action or exchange information.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("6bf90c79-32f4-47ad-959c-8fff723fe744", "Meeting", this.archiveBuilder.getEntityDef(superTypeName), "Two or more people come together to discuss a topic, agree and action or exchange information.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "title";
        String attribute1Description = "Title of the meeting.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "startTime";
        String attribute2Description = "Start time of the meeting.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "endTime";
        String attribute3Description = "End time of the meeting.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "objective";
        String attribute4Description = "Reason for the meeting and intended outcome.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "minutes";
        String attribute5Description = "Description of what happened at the meeting.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("title", "Title of the meeting.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("startTime", "Start time of the meeting.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("endTime", "End time of the meeting.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("objective", "Reason for the meeting and intended outcome.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("minutes", "Description of what happened at the meeting.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getMeetingsRelationship() {
        String guid = "a05f918e-e7e2-419d-8016-5b37406df63a";
        String name = "Meetings";
        String description = "A meeting about a specific project, deliverable, situation or plan of action.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("a05f918e-e7e2-419d-8016-5b37406df63a", "Meetings", null, "A meeting about a specific project, deliverable, situation or plan of action.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Meeting";
        String end1AttributeName = "meetings";
        String end1AttributeDescription = "Related meetings.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Meeting"), "meetings", "Related meetings.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "meetingOwner";
        String end2AttributeDescription = "Person, project, community or team that called the meeting.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "meetingOwner", "Person, project, community or team that called the meeting.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0137Actions() {
        this.archiveBuilder.addEnumDef(this.getToDoStatusEnum());
        this.archiveBuilder.addEntityDef(this.getToDoEntity());
        this.archiveBuilder.addRelationshipDef(this.getToDoSourceRelationship());
        this.archiveBuilder.addRelationshipDef(this.getActionSponsorRelationship());
        this.archiveBuilder.addRelationshipDef(this.getActionAssignment());
    }

    private EnumDef getToDoStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ToDoStatus.getOpenTypeGUID(), ToDoStatus.getOpenTypeName(), ToDoStatus.getOpenTypeDescription(), ToDoStatus.getOpenTypeDescriptionGUID(), ToDoStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ToDoStatus toDoStatus : ToDoStatus.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(toDoStatus.getOrdinal(), toDoStatus.getName(), toDoStatus.getDescription(), toDoStatus.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!toDoStatus.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getToDoEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.TO_DO.typeGUID, OpenMetadataType.TO_DO.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.TO_DO.description, OpenMetadataType.TO_DO.descriptionGUID, OpenMetadataType.TO_DO.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "creationTime";
        String attribute3Description = "When the requested action was identified.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.PRIORITY.name;
        String attribute4Description = OpenMetadataProperty.PRIORITY.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.PRIORITY.descriptionGUID;
        String attribute5Name = "dueTime";
        String attribute5Description = "When the requested action needs to be completed.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = OpenMetadataProperty.TO_DO_STATUS.name;
        String attribute6Description = OpenMetadataProperty.TO_DO_STATUS.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.TO_DO_STATUS.descriptionGUID;
        String attribute7Name = "completionTime";
        String attribute7Description = "When the requested action was completed.";
        String attribute7DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("creationTime", "When the requested action was identified.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("dueTime", "When the requested action needs to be completed.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(ToDoStatus.getOpenTypeName(), attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("completionTime", "When the requested action was completed.", attribute7DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getToDoSourceRelationship() {
        String guid = "a0b7ba50-4c97-4b76-9a7d-c6a00e1be646";
        String name = "ToDoSource";
        String description = "The source of the to do, such as a person, meeting or a governance action.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("a0b7ba50-4c97-4b76-9a7d-c6a00e1be646", "ToDoSource", null, "The source of the to do, such as a person, meeting or a governance action.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "actionSource";
        String end1AttributeDescription = "Source of the to do request.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "actionSource", "Source of the to do request.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ToDo";
        String end2AttributeName = "actions";
        String end2AttributeDescription = "Requests to perform actions related to this element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ToDo"), "actions", "Requests to perform actions related to this element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getActionSponsorRelationship() {
        String guid = "aca1277b-bf1c-42f5-9b3b-fbc2c9047325";
        String name = "ActionSponsor";
        String description = "Identifies the sponsor that requires the action (ToDo) to be completed.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("aca1277b-bf1c-42f5-9b3b-fbc2c9047325", "ActionSponsor", null, "Identifies the sponsor that requires the action (ToDo) to be completed.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "toDoSponsor";
        String end1AttributeDescription = "Element such as person, team, rule, incident, project, that is driving the need for the action.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "toDoSponsor", "Element such as person, team, rule, incident, project, that is driving the need for the action.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ToDo";
        String end2AttributeName = "trackedActions";
        String end2AttributeDescription = "Actions that need to be completed.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ToDo"), "trackedActions", "Actions that need to be completed.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getActionAssignment() {
        String guid = "af2b5fab-8f83-4a2b-b749-1e6219f61f79";
        String name = "ActionAssignment";
        String description = "A person who has been assigned to complete the to do (action).";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("af2b5fab-8f83-4a2b-b749-1e6219f61f79", "ActionAssignment", null, "A person who has been assigned to complete the to do (action).", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "PersonRole";
        String end1AttributeName = "assignedResources";
        String end1AttributeDescription = "One or more people assigned to complete the action (to do).";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("PersonRole"), "assignedResources", "One or more people assigned to complete the action (to do).", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ToDo";
        String end2AttributeName = "toDoList";
        String end2AttributeDescription = "List of toDos assigned to this person's role.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ToDo"), "toDoList", "List of toDos assigned to this person's role.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0140Communities() {
        this.archiveBuilder.addEnumDef(this.getCommunityMembershipTypeEnum());
        this.archiveBuilder.addEntityDef(this.getCommunityEntity());
        this.archiveBuilder.addEntityDef(this.getCommunityMemberEntity());
        this.archiveBuilder.addRelationshipDef(this.getCommunityMembershipRelationship());
    }

    private EnumDef getCommunityMembershipTypeEnum() {
        String guid = "b0ef45bf-d12b-4b6f-add6-59c14648d750";
        String name = "CommunityMembershipType";
        String description = "Type of membership to a community.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("b0ef45bf-d12b-4b6f-add6-59c14648d750", "CommunityMembershipType", "Type of membership to a community.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Contributor";
        String element1Description = "Participant in the community.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Contributor", "Participant in the community.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Administrator";
        String element2Description = "Administrator of the community.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Administrator", "Administrator of the community.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Leader";
        String element3Description = "Leader of the community.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Leader", "Leader of the community.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "Observer";
        String element4Description = "Observer of the community.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "Observer", "Observer of the community.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another role in the community.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another role in the community.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getCommunityEntity() {
        String guid = "fbd42379-f6c3-4f08-b6f7-378565cda993";
        String name = "Community";
        String description = "A group of people with a common interest or skill.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("fbd42379-f6c3-4f08-b6f7-378565cda993", "Community", this.archiveBuilder.getEntityDef(superTypeName), "A group of people with a common interest or skill.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "mission";
        String attribute3Description = "Purpose of the community.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("mission", "Purpose of the community.", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getCommunityMemberEntity() {
        String guid = "fbd42379-f6c3-4f09-b6f7-378565cda993";
        String name = "CommunityMember";
        String description = "A person who has joined a community.";
        String descriptionGUID = null;
        String superTypeName = "PersonRole";
        return this.archiveHelper.getDefaultEntityDef("fbd42379-f6c3-4f09-b6f7-378565cda993", "CommunityMember", this.archiveBuilder.getEntityDef("PersonRole"), "A person who has joined a community.", descriptionGUID);
    }

    private RelationshipDef getCommunityMembershipRelationship() {
        String guid = "7c7da1a3-01b3-473e-972e-606eff0cb112";
        String name = "CommunityMembership";
        String description = "Associates an actor profile with a community.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("7c7da1a3-01b3-473e-972e-606eff0cb112", "CommunityMembership", null, "Associates an actor profile with a community.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Community";
        String end1AttributeName = "memberOfCommunity";
        String end1AttributeDescription = "Communities that the person is a member of.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Community"), "memberOfCommunity", "Communities that the person is a member of.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "CommunityMember";
        String end2AttributeName = "communityMembers";
        String end2AttributeDescription = "Members of the community.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("CommunityMember"), "communityMembers", "Members of the community.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "membershipType";
        String attribute1Description = "Type of membership to the community.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("CommunityMembershipType", "membershipType", "Type of membership to the community.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0150Feedback() {
        this.archiveBuilder.addEnumDef(this.getStarRatingEnum());
        this.archiveBuilder.addEnumDef(this.getCommentTypeEnum());
        this.archiveBuilder.addEntityDef(this.getRatingEntity());
        this.archiveBuilder.addEntityDef(this.getCommentEntity());
        this.archiveBuilder.addEntityDef(this.getLikeEntity());
        this.archiveBuilder.addEntityDef(this.getInformalTagEntity());
        this.archiveBuilder.addRelationshipDef(this.getAttachedRatingRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAttachedCommentRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAttachedLikeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAcceptedAnswerRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAttachedTagRelationship());
    }

    private EnumDef getStarRatingEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(StarRating.getOpenTypeGUID(), StarRating.getOpenTypeName(), StarRating.getOpenTypeDescription(), StarRating.getOpenTypeDescriptionGUID(), StarRating.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (StarRating enumValue : StarRating.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValue.getOrdinal(), enumValue.getName(), enumValue.getDescription(), enumValue.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValue.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getCommentTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(CommentType.getOpenTypeGUID(), CommentType.getOpenTypeName(), CommentType.getOpenTypeDescription(), CommentType.getOpenTypeDescriptionGUID(), CommentType.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CommentType commentType : CommentType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(commentType.getOrdinal(), commentType.getName(), commentType.getDescription(), commentType.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!commentType.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getRatingEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.RATING.typeGUID, OpenMetadataType.RATING.typeName, null, OpenMetadataType.RATING.description, OpenMetadataType.RATING.descriptionGUID, OpenMetadataType.RATING.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "anchorGUID";
        String attribute1Description = "Optional identifier of the referenceable that this rating is connected to (either directly or indirectly).";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Optional identifier of the referenceable that this rating is connected to (either directly or indirectly).", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("StarRating", OpenMetadataProperty.STARS.name, OpenMetadataProperty.STARS.description, OpenMetadataProperty.STARS.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.REVIEW.name, OpenMetadataProperty.REVIEW.description, OpenMetadataProperty.REVIEW.descriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getCommentEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.COMMENT.typeGUID, OpenMetadataType.COMMENT.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.COMMENT.description, OpenMetadataType.COMMENT.descriptionGUID, OpenMetadataType.COMMENT.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "anchorGUID";
        String attribute1Description = "Optional identifier of the referenceable that this comment is connected to (either directly or indirectly).";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Optional identifier of the referenceable that this comment is connected to (either directly or indirectly).", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.TEXT.name, OpenMetadataProperty.TEXT.description, OpenMetadataProperty.TEXT.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("CommentType", OpenMetadataProperty.TYPE.name, OpenMetadataProperty.TYPE.description, OpenMetadataProperty.TYPE.descriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getLikeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.LIKE.typeGUID, OpenMetadataType.LIKE.typeName, null, OpenMetadataType.LIKE.description, OpenMetadataType.LIKE.descriptionGUID, OpenMetadataType.LIKE.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "anchorGUID";
        String attribute1Description = "Optional identifier of the referenceable that this comment is connected to (either directly or indirectly).";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Optional identifier of the referenceable that this comment is connected to (either directly or indirectly).", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getInformalTagEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.INFORMAL_TAG.typeGUID, OpenMetadataType.INFORMAL_TAG.typeName, null, OpenMetadataType.INFORMAL_TAG.description, OpenMetadataType.INFORMAL_TAG.descriptionGUID, OpenMetadataType.INFORMAL_TAG.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC.name, OpenMetadataProperty.IS_PUBLIC.description, OpenMetadataProperty.IS_PUBLIC.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.TAG_NAME.name, OpenMetadataProperty.TAG_NAME.description, OpenMetadataProperty.TAG_NAME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.TAG_DESCRIPTION.name, OpenMetadataProperty.TAG_DESCRIPTION.description, OpenMetadataProperty.TAG_DESCRIPTION.descriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getAttachedRatingRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName, null, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.description, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.descriptionGUID, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "ratingAnchor";
        String end1AttributeDescription = "Element that is rated.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "ratingAnchor", "Element that is rated.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.RATING.typeName;
        String end2AttributeName = "starRatings";
        String end2AttributeDescription = "Accumulated ratings.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "starRatings", "Accumulated ratings.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC.name, OpenMetadataProperty.IS_PUBLIC.description, OpenMetadataProperty.IS_PUBLIC.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAttachedCommentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, null, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.description, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.descriptionGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "commentAnchor";
        String end1AttributeDescription = "Element that this comment relates.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "commentAnchor", "Element that this comment relates.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.COMMENT.typeName;
        String end2AttributeName = "comments";
        String end2AttributeDescription = "Accumulated comments.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "comments", "Accumulated comments.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC.name, OpenMetadataProperty.IS_PUBLIC.description, OpenMetadataProperty.IS_PUBLIC.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAttachedLikeRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName, null, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.description, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.descriptionGUID, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "likeAnchor";
        String end1AttributeDescription = "Element that is liked.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "likeAnchor", "Element that is liked.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.LIKE.typeName;
        String end2AttributeName = "likes";
        String end2AttributeDescription = "Accumulated likes.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "likes", "Accumulated likes.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC.name, OpenMetadataProperty.IS_PUBLIC.description, OpenMetadataProperty.IS_PUBLIC.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAcceptedAnswerRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.typeGUID, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.typeName, null, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.description, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.descriptionGUID, OpenMetadataType.ACCEPTED_ANSWER_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.COMMENT.typeName;
        String end1AttributeName = "answeredQuestions";
        String end1AttributeDescription = "Questions that now has an accepted answer.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "answeredQuestions", "Questions that now has an accepted answer.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.COMMENT.typeName;
        String end2AttributeName = "acceptedAnswers";
        String end2AttributeDescription = "Accumulated answers.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "acceptedAnswers", "Accumulated answers.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC.name, OpenMetadataProperty.IS_PUBLIC.description, OpenMetadataProperty.IS_PUBLIC.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAttachedTagRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName, null, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.description, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.descriptionGUID, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "taggedElement";
        String end1AttributeDescription = "Element that is tagged.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "taggedElement", "Element that is tagged.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.INFORMAL_TAG.typeName;
        String end2AttributeName = "tags";
        String end2AttributeDescription = "Accumulated tags.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "tags", "Accumulated tags.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute(OpenMetadataProperty.IS_PUBLIC.name, OpenMetadataProperty.IS_PUBLIC.description, OpenMetadataProperty.IS_PUBLIC.descriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0155CrowdSourcing() {
        this.archiveBuilder.addEnumDef(this.getCrowdSourcingRoleEnum());
        this.archiveBuilder.addEntityDef(this.getCrowdSourcingContributorEntity());
        this.archiveBuilder.addRelationshipDef(this.getCrowdSourcingContributionRelationship());
    }

    private EnumDef getCrowdSourcingRoleEnum() {
        String guid = "0ded50c2-17cc-4ecf-915e-908e66dbb27f";
        String name = "CrowdSourcingRole";
        String description = "Type of contributor to new information and/or assets.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("0ded50c2-17cc-4ecf-915e-908e66dbb27f", "CrowdSourcingRole", "Type of contributor to new information and/or assets.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Proposer";
        String element1Description = "Actor that creates the initial version.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Proposer", "Actor that creates the initial version.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Reviewer";
        String element2Description = "Actor that provided feedback.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Reviewer", "Actor that provided feedback.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Supporter";
        String element3Description = "Actor that agrees with the definition.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Supporter", "Actor that agrees with the definition.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "Approver";
        String element4Description = "Actor that declares the definition should be used.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "Approver", "Actor that declares the definition should be used.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 99;
        String element5Value = "Other";
        String element5Description = "Another role.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another role.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getCrowdSourcingContributorEntity() {
        String guid = "3a84c94c-ac6f-4be1-a72a-07dcec7b1fe3";
        String name = "CrowdSourcingContributor";
        String description = "Person contributing new content.";
        String descriptionGUID = null;
        String superTypeName = "PersonRole";
        return this.archiveHelper.getDefaultEntityDef("3a84c94c-ac6f-4be1-a72a-07dcec7b1fe3", "CrowdSourcingContributor", this.archiveBuilder.getEntityDef("PersonRole"), "Person contributing new content.", descriptionGUID);
    }

    private RelationshipDef getCrowdSourcingContributionRelationship() {
        String guid = "4db83564-b200-4956-94a4-c95a5c30e65a";
        String name = "CrowdSourcingContribution";
        String description = "Defines one of the actors contributing content to a new description or asset.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4db83564-b200-4956-94a4-c95a5c30e65a", "CrowdSourcingContribution", null, "Defines one of the actors contributing content to a new description or asset.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "contributions";
        String end1AttributeDescription = "Items that this person has contributed.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "contributions", "Items that this person has contributed.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "CrowdSourcingContributor";
        String end2AttributeName = "contributors";
        String end2AttributeDescription = "Person contributing content.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("CrowdSourcingContributor"), "contributors", "Person contributing content.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "roleType";
        String attribute1Description = "Type of contribution.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("CrowdSourcingRole", "roleType", "Type of contribution.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0160Notes() {
        this.archiveBuilder.addEntityDef(this.getNoteEntryEntity());
        this.archiveBuilder.addEntityDef(this.getNoteLogEntity());
        this.archiveBuilder.addEntityDef(this.getNoteLogAuthorEntity());
        this.archiveBuilder.addRelationshipDef(this.getAttachedNoteLogRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAttachedNoteLogEntryRelationship());
        this.archiveBuilder.addRelationshipDef(this.getNoteLogAuthorshipRelationship());
    }

    private EntityDef getNoteEntryEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.NOTE_ENTRY.typeGUID, OpenMetadataType.NOTE_ENTRY.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.NOTE_ENTRY.description, OpenMetadataType.NOTE_ENTRY.descriptionGUID, OpenMetadataType.NOTE_ENTRY.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute3Name = OpenMetadataProperty.IS_PUBLIC.name;
        String attribute3Description = "Is the note visible to more than the note log authors?";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.TITLE.name, OpenMetadataProperty.TITLE.description, OpenMetadataProperty.TITLE.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(OpenMetadataProperty.TEXT.name, OpenMetadataProperty.TEXT.description, OpenMetadataProperty.TEXT.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute(attribute3Name, "Is the note visible to more than the note log authors?", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getNoteLogAuthorEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.NOTE_LOG_AUTHOR.typeGUID, OpenMetadataType.NOTE_LOG_AUTHOR.typeName, this.archiveBuilder.getEntityDef("PersonRole"), OpenMetadataType.NOTE_LOG_AUTHOR.description, OpenMetadataType.NOTE_LOG_AUTHOR.descriptionGUID, OpenMetadataType.NOTE_LOG_AUTHOR.wikiURL);
    }

    private EntityDef getNoteLogEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.NOTE_LOG.typeGUID, OpenMetadataType.NOTE_LOG.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.NOTE_LOG.description, OpenMetadataType.NOTE_LOG.descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.IS_PUBLIC.name;
        String attribute3Description = "Is the note log visible to more than the note log authors?";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute(attribute3Name, "Is the note log visible to more than the note log authors?", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getAttachedNoteLogRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_NOTE_LOG_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_NOTE_LOG_RELATIONSHIP.typeName, null, OpenMetadataType.ATTACHED_NOTE_LOG_RELATIONSHIP.description, OpenMetadataType.ATTACHED_NOTE_LOG_RELATIONSHIP.descriptionGUID, OpenMetadataType.ATTACHED_NOTE_LOG_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "describes";
        String end1AttributeDescription = "Subject of the note log.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "describes", "Subject of the note log.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.NOTE_LOG.typeName;
        String end2AttributeName = "noteLogs";
        String end2AttributeDescription = "Log of related notes.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "noteLogs", "Log of related notes.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.IS_PUBLIC.name;
        String attribute1Description = "Is the attached note log visible to more than the originator?";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute(attribute1Name, "Is the attached note log visible to more than the originator?", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getNoteLogAuthorshipRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.NOTE_LOG_AUTHORSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.NOTE_LOG_AUTHORSHIP_RELATIONSHIP.typeName, null, OpenMetadataType.NOTE_LOG_AUTHORSHIP_RELATIONSHIP.description, OpenMetadataType.NOTE_LOG_AUTHORSHIP_RELATIONSHIP.descriptionGUID, OpenMetadataType.NOTE_LOG_AUTHORSHIP_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.NOTE_LOG_AUTHOR.typeName;
        String end1AttributeName = "authors";
        String end1AttributeDescription = "Person contributing to the note log.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "authors", "Person contributing to the note log.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.NOTE_LOG.typeName;
        String end2AttributeName = "authoredNoteLogs";
        String end2AttributeDescription = "Note log containing contributions.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "authoredNoteLogs", "Note log containing contributions.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAttachedNoteLogEntryRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.ATTACHED_NOTE_LOG_ENTRY_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_NOTE_LOG_ENTRY_RELATIONSHIP.typeName, null, OpenMetadataType.ATTACHED_NOTE_LOG_ENTRY_RELATIONSHIP.description, OpenMetadataType.ATTACHED_NOTE_LOG_ENTRY_RELATIONSHIP.descriptionGUID, OpenMetadataType.ATTACHED_NOTE_LOG_ENTRY_RELATIONSHIP.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.NOTE_LOG.typeName;
        String end1AttributeName = "logs";
        String end1AttributeDescription = "Logs that this entry relates.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "logs", "Logs that this entry relates.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.NOTE_ENTRY.typeName;
        String end2AttributeName = "entries";
        String end2AttributeDescription = "Accumulated notes.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "entries", "Accumulated notes.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void addArea2Types() {
        this.add0201ConnectorsAndConnections();
        this.add0205ConnectionLinkage();
        this.add0210DataStores();
        this.add0212DeployedAPIs();
        this.add0215SoftwareComponents();
        this.add0220FilesAndFolders();
        this.add0221DocumentStores();
        this.add0222GraphStores();
        this.add0223EventsAndLogs();
        this.add0224Databases();
        this.add0225MetadataRepositories();
        this.add0227Keystores();
        this.add0230CodeTables();
        this.add0235InformationView();
        this.add0239Reports();
        this.add0290Ports();
    }

    private void add0201ConnectorsAndConnections() {
        this.archiveBuilder.addEntityDef(this.getConnectionEntity());
        this.archiveBuilder.addEntityDef(this.getConnectorTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getConnectionEndpointRelationship());
        this.archiveBuilder.addRelationshipDef(this.getConnectionConnectorTypeRelationship());
    }

    private EntityDef getConnectionEntity() {
        String guid = "114e9f8f-5ff3-4c32-bd37-a7eb42712253";
        String name = "Connection";
        String description = "A set of properties to identify and configure a connector instance.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("114e9f8f-5ff3-4c32-bd37-a7eb42712253", "Connection", this.archiveBuilder.getEntityDef(superTypeName), "A set of properties to identify and configure a connector instance.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "securedProperties";
        String attribute3Description = "Private properties accessible only to the connector.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "configurationProperties";
        String attribute4Description = "Specific configuration properties used to configure the behaviour of the connector.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "userId";
        String attribute5Description = "User identity that the connector should use.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "clearPassword";
        String attribute6Description = "Password for the userId in clear text.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "encryptedPassword";
        String attribute7Description = "Encrypted password that the connector needs to decrypt before use.";
        String attribute7DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringObjectTypeDefAttribute("securedProperties", "Private properties accessible only to the connector.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringObjectTypeDefAttribute("configurationProperties", "Specific configuration properties used to configure the behaviour of the connector.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("userId", "User identity that the connector should use.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("clearPassword", "Password for the userId in clear text.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("encryptedPassword", "Encrypted password that the connector needs to decrypt before use.", attribute7DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getConnectorTypeEntity() {
        String guid = "954421eb-33a6-462d-a8ca-b5709a1bd0d4";
        String name = "ConnectorType";
        String description = "A set of properties describing a type of connector.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("954421eb-33a6-462d-a8ca-b5709a1bd0d4", "ConnectorType", this.archiveBuilder.getEntityDef(superTypeName), "A set of properties describing a type of connector.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "connectorProviderClassName";
        String attribute3Description = "Name of the Java class that implements this connector type's open connector framework (OCF) connector provider.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "recognizedAdditionalProperties";
        String attribute4Description = "List of additional connection property names supported by the connector implementation.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "recognizedSecuredProperties";
        String attribute5Description = "List of secured connection property names supported by the connector implementation.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "recognizedConfigurationProperties";
        String attribute6Description = "List of secured connection property names supported by the connector implementation.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("connectorProviderClassName", "Name of the Java class that implements this connector type's open connector framework (OCF) connector provider.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("recognizedAdditionalProperties", "List of additional connection property names supported by the connector implementation.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("recognizedSecuredProperties", "List of secured connection property names supported by the connector implementation.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("recognizedConfigurationProperties", "List of secured connection property names supported by the connector implementation.", attribute6DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getConnectionEndpointRelationship() {
        String guid = "887a7132-d6bc-4b92-a483-e80b60c86fb2";
        String name = "ConnectionEndpoint";
        String description = "A link between a connection and the endpoint that the connector should use.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("887a7132-d6bc-4b92-a483-e80b60c86fb2", "ConnectionEndpoint", null, "A link between a connection and the endpoint that the connector should use.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Endpoint";
        String end1AttributeName = "connectionEndpoint";
        String end1AttributeDescription = "Server endpoint that provides access to the asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Endpoint"), "connectionEndpoint", "Server endpoint that provides access to the asset.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Connection";
        String end2AttributeName = "connections";
        String end2AttributeDescription = "Connections to this endpoint.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Connection"), "connections", "Connections to this endpoint.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getConnectionConnectorTypeRelationship() {
        String guid = "e542cfc1-0b4b-42b9-9921-f0a5a88aaf96";
        String name = "ConnectionConnectorType";
        String description = "A link between a connection and the connector type that should be used.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e542cfc1-0b4b-42b9-9921-f0a5a88aaf96", "ConnectionConnectorType", null, "A link between a connection and the connector type that should be used.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Connection";
        String end1AttributeName = "connections";
        String end1AttributeDescription = "Connections using this connector type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Connection"), "connections", "Connections using this connector type.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ConnectorType";
        String end2AttributeName = "connectorType";
        String end2AttributeDescription = "Type of connector to use for the asset.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ConnectorType"), "connectorType", "Type of connector to use for the asset.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0205ConnectionLinkage() {
        this.archiveBuilder.addEntityDef(this.getVirtualConnectionEntity());
        this.archiveBuilder.addRelationshipDef(this.getEmbeddedConnectionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getConnectionToAssetRelationship());
    }

    private EntityDef getVirtualConnectionEntity() {
        String guid = "82f9c664-e59d-484c-a8f3-17088c23a2f3";
        String name = "VirtualConnection";
        String description = "A connector for a virtual resource that needs to retrieve data from multiple places.";
        String descriptionGUID = null;
        String superTypeName = "Connection";
        return this.archiveHelper.getDefaultEntityDef("82f9c664-e59d-484c-a8f3-17088c23a2f3", "VirtualConnection", this.archiveBuilder.getEntityDef("Connection"), "A connector for a virtual resource that needs to retrieve data from multiple places.", descriptionGUID);
    }

    private RelationshipDef getEmbeddedConnectionRelationship() {
        String guid = "eb6dfdd2-8c6f-4f0d-a17d-f6ce4799f64f";
        String name = "EmbeddedConnection";
        String description = "A link between a virtual connection and one of the connections it depends on.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("eb6dfdd2-8c6f-4f0d-a17d-f6ce4799f64f", "EmbeddedConnection", null, "A link between a virtual connection and one of the connections it depends on.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "VirtualConnection";
        String end1AttributeName = "supportingVirtualConnections";
        String end1AttributeDescription = "Virtual connections using this connection.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("VirtualConnection"), "supportingVirtualConnections", "Virtual connections using this connection.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Connection";
        String end2AttributeName = "embeddedConnections";
        String end2AttributeDescription = "Connections embedded in this virtual connection.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Connection"), "embeddedConnections", "Connections embedded in this virtual connection.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = "arguments";
        String attribute2Description = "Additional arguments needed by the virtual connector when using each connection.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringObjectTypeDefAttribute("arguments", "Additional arguments needed by the virtual connector when using each connection.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getConnectionToAssetRelationship() {
        String guid = "e777d660-8dbe-453e-8b83-903771f054c0";
        String name = "ConnectionToAsset";
        String description = "Link between a connection and the description of the asset it can be used to access.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e777d660-8dbe-453e-8b83-903771f054c0", "ConnectionToAsset", null, "Link between a connection and the description of the asset it can be used to access.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Connection";
        String end1AttributeName = "connections";
        String end1AttributeDescription = "Connections to this asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Connection"), "connections", "Connections to this asset.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ASSET.typeName;
        String end2AttributeName = "asset";
        String end2AttributeDescription = "Asset that can be accessed with this connection.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "asset", "Asset that can be accessed with this connection.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "assetSummary";
        String attribute1Description = "Description of the asset that is retrieved through this connection.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("assetSummary", "Description of the asset that is retrieved through this connection.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0210DataStores() {
        this.archiveBuilder.addEntityDef(this.getDataStoreEntity());
        this.archiveBuilder.addRelationshipDef(this.getDataContentForDataSetRelationship());
        this.archiveBuilder.addClassificationDef(this.getDataStoreEncodingClassification());
    }

    private EntityDef getDataStoreEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_STORE.typeGUID, OpenMetadataType.DATA_STORE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_ASSET.typeName), OpenMetadataType.DATA_STORE.description, OpenMetadataType.DATA_STORE.descriptionGUID, OpenMetadataType.DATA_STORE.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute(OpenMetadataProperty.STORE_CREATE_TIME.name, OpenMetadataProperty.STORE_CREATE_TIME.description, OpenMetadataProperty.STORE_CREATE_TIME.descriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(OpenMetadataProperty.STORE_UPDATE_TIME.name, OpenMetadataProperty.STORE_UPDATE_TIME.description, OpenMetadataProperty.STORE_UPDATE_TIME.descriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getDataContentForDataSetRelationship() {
        String guid = OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.typeName;
        String description = OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.BOTH;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.ASSET.typeName;
        String end1AttributeName = "dataContent";
        String end1AttributeDescription = "Assets supporting a data set.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "dataContent", "Assets supporting a data set.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.DATA_SET.typeName;
        String end2AttributeName = "supportedDataSets";
        String end2AttributeDescription = "Data sets that use this asset.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "supportedDataSets", "Data sets that use this asset.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getDataStoreEncodingClassification() {
        String guid = OpenMetadataType.DATA_STORE_ENCODING_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.DATA_STORE_ENCODING_CLASSIFICATION.typeName;
        String description = OpenMetadataType.DATA_STORE_ENCODING_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.DATA_STORE_ENCODING_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_STORE_ENCODING_CLASSIFICATION.wikiURL;
        String linkedToEntity = OpenMetadataType.DATA_STORE.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.ENCODING.name;
        String attribute1Description = OpenMetadataProperty.ENCODING.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.ENCODING.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.ENCODING_LANGUAGE.name;
        String attribute2Description = OpenMetadataProperty.ENCODING_LANGUAGE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.ENCODING_LANGUAGE.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.ENCODING_DESCRIPTION.name;
        String attribute3Description = OpenMetadataProperty.ENCODING_DESCRIPTION.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.ENCODING_DESCRIPTION.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.ENCODING_PROPERTIES.name;
        String attribute4Description = OpenMetadataProperty.ENCODING_PROPERTIES.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.ENCODING_PROPERTIES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0212DeployedAPIs() {
        this.archiveBuilder.addEntityDef(this.getDeployedAPIEntity());
        this.archiveBuilder.addRelationshipDef(this.getAPIEndpointRelationship());
        this.archiveBuilder.addClassificationDef(this.getRequestResponseInterfaceClassification());
        this.archiveBuilder.addClassificationDef(this.getListenerInterfaceClassification());
        this.archiveBuilder.addClassificationDef(this.getPublisherInterfaceClassification());
    }

    private EntityDef getDeployedAPIEntity() {
        String guid = "7dbb3e63-138f-49f1-97b4-66313871fc14";
        String name = "DeployedAPI";
        String description = "A callable interface running at an endpoint.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.ASSET.typeName;
        return this.archiveHelper.getDefaultEntityDef("7dbb3e63-138f-49f1-97b4-66313871fc14", "DeployedAPI", this.archiveBuilder.getEntityDef(superTypeName), "A callable interface running at an endpoint.", descriptionGUID);
    }

    private RelationshipDef getAPIEndpointRelationship() {
        String guid = "de5b9501-3ad4-4803-a8b2-e311c72a4336";
        String name = "APIEndpoint";
        String description = "The endpoint for a deployed API.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("de5b9501-3ad4-4803-a8b2-e311c72a4336", "APIEndpoint", null, "The endpoint for a deployed API.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DeployedAPI";
        String end1AttributeName = "supportedAPIs";
        String end1AttributeDescription = "APIs that can be called from this endpoint.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DeployedAPI"), "supportedAPIs", "APIs that can be called from this endpoint.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Endpoint";
        String end2AttributeName = "accessEndpoints";
        String end2AttributeDescription = "Endpoints used to call this API.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Endpoint"), "accessEndpoints", "Endpoints used to call this API.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getRequestResponseInterfaceClassification() {
        String guid = "14a29330-e830-4343-a41e-d57e2cec82f8";
        String name = "RequestResponseInterface";
        String description = "Identifies an API that supports a request response interaction style.";
        String descriptionGUID = null;
        String linkedToEntity = "DeployedAPI";
        return this.archiveHelper.getClassificationDef("14a29330-e830-4343-a41e-d57e2cec82f8", "RequestResponseInterface", null, "Identifies an API that supports a request response interaction style.", descriptionGUID, this.archiveBuilder.getEntityDef("DeployedAPI"), false);
    }

    private ClassificationDef getListenerInterfaceClassification() {
        String guid = "4099d2ed-2a5e-4c44-8443-9de4e378a4ba";
        String name = "ListenerInterface";
        String description = "Identifies an API that listens for incoming events and processes them.";
        String descriptionGUID = null;
        String linkedToEntity = "DeployedAPI";
        return this.archiveHelper.getClassificationDef("4099d2ed-2a5e-4c44-8443-9de4e378a4ba", "ListenerInterface", null, "Identifies an API that listens for incoming events and processes them.", descriptionGUID, this.archiveBuilder.getEntityDef("DeployedAPI"), false);
    }

    private ClassificationDef getPublisherInterfaceClassification() {
        String guid = "4fdedcd5-b186-4bee-887a-02fa29a10750";
        String name = "PublisherInterface";
        String description = "Identifies an API that sends out events to other listening components.";
        String descriptionGUID = null;
        String linkedToEntity = "DeployedAPI";
        return this.archiveHelper.getClassificationDef("4fdedcd5-b186-4bee-887a-02fa29a10750", "PublisherInterface", null, "Identifies an API that sends out events to other listening components.", descriptionGUID, this.archiveBuilder.getEntityDef("DeployedAPI"), false);
    }

    private void add0215SoftwareComponents() {
        this.archiveBuilder.addEntityDef(this.getDeployedSoftwareComponentEntity());
    }

    private EntityDef getDeployedSoftwareComponentEntity() {
        String guid = "486af62c-dcfd-4859-ab24-eab2e380ecfd";
        String name = "DeployedSoftwareComponent";
        String description = "A packaged and deployed software component supporting a well-defined function.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.PROCESS.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("486af62c-dcfd-4859-ab24-eab2e380ecfd", "DeployedSoftwareComponent", this.archiveBuilder.getEntityDef(superTypeName), "A packaged and deployed software component supporting a well-defined function.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "implementationLanguage";
        String attribute1Description = "Name of the language used to implement this component.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("implementationLanguage", "Name of the language used to implement this component.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0220FilesAndFolders() {
        this.archiveBuilder.addEntityDef(this.getFileFolderEntity());
        this.archiveBuilder.addEntityDef(this.getDataFolderEntity());
        this.archiveBuilder.addEntityDef(this.getDataFileEntity());
        this.archiveBuilder.addEntityDef(this.getCSVFileEntity());
        this.archiveBuilder.addEntityDef(this.getAvroFileEntity());
        this.archiveBuilder.addEntityDef(this.getJSONFileEntity());
        this.archiveBuilder.addRelationshipDef(this.getFolderHierarchyRelationship());
        this.archiveBuilder.addRelationshipDef(this.getNestedFileRelationship());
        this.archiveBuilder.addRelationshipDef(this.getLinkedFileRelationship());
        this.archiveBuilder.addClassificationDef(this.getFileSystemClassification());
    }

    private EntityDef getFileFolderEntity() {
        String guid = OpenMetadataType.FILE_FOLDER.typeGUID;
        String name = OpenMetadataType.FILE_FOLDER.typeName;
        String description = OpenMetadataType.FILE_FOLDER.description;
        String descriptionGUID = OpenMetadataType.FILE_FOLDER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.FILE_FOLDER.wikiURL;
        String superTypeName = OpenMetadataType.DATA_STORE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef getDataFolderEntity() {
        String guid = OpenMetadataType.DATA_FOLDER.typeGUID;
        String name = OpenMetadataType.DATA_FOLDER.typeName;
        String description = OpenMetadataType.DATA_FOLDER.description;
        String descriptionGUID = OpenMetadataType.DATA_FOLDER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_FOLDER.wikiURL;
        String superTypeName = OpenMetadataType.FILE_FOLDER.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef getDataFileEntity() {
        String guid = OpenMetadataType.DATA_FILE.typeGUID;
        String name = OpenMetadataType.DATA_FILE.typeName;
        String description = OpenMetadataType.DATA_FILE.description;
        String descriptionGUID = OpenMetadataType.DATA_FILE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_FILE.wikiURL;
        String superTypeName = OpenMetadataType.DATA_STORE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.FILE_TYPE.name;
        String attribute1Description = OpenMetadataProperty.FILE_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.FILE_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getCSVFileEntity() {
        String guid = "2ccb2117-9cee-47ca-8150-9b3a543adcec";
        String name = "CSVFile";
        String description = "A description of a comma separated value (CSV) file";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_FILE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("2ccb2117-9cee-47ca-8150-9b3a543adcec", "CSVFile", this.archiveBuilder.getEntityDef(superTypeName), "A description of a comma separated value (CSV) file", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "delimiterCharacter";
        String attribute1Description = "Character used between each column.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "quoteCharacter";
        String attribute2Description = "The character used to group the content of the column that contains one or more delimiter characters.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("delimiterCharacter", "Character used between each column.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("quoteCharacter", "The character used to group the content of the column that contains one or more delimiter characters.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getAvroFileEntity() {
        String guid = OpenMetadataType.AVRO_FILE.typeGUID;
        String name = OpenMetadataType.AVRO_FILE.typeName;
        String description = OpenMetadataType.AVRO_FILE.description;
        String descriptionGUID = OpenMetadataType.AVRO_FILE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.AVRO_FILE.wikiURL;
        String superTypeName = OpenMetadataType.DATA_FILE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef getJSONFileEntity() {
        String guid = OpenMetadataType.JSON_FILE.typeGUID;
        String name = OpenMetadataType.JSON_FILE.typeName;
        String description = OpenMetadataType.JSON_FILE.description;
        String descriptionGUID = OpenMetadataType.JSON_FILE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.JSON_FILE.wikiURL;
        String superTypeName = OpenMetadataType.DATA_FILE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private RelationshipDef getFolderHierarchyRelationship() {
        String guid = "48ac9028-45dd-495d-b3e1-622685b54a01";
        String name = "FolderHierarchy";
        String description = "A nested relationship between two file folders.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("48ac9028-45dd-495d-b3e1-622685b54a01", "FolderHierarchy", null, "A nested relationship between two file folders.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "FileFolder";
        String end1AttributeName = "parentFolder";
        String end1AttributeDescription = "Parent folder.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("FileFolder"), "parentFolder", "Parent folder.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "FileFolder";
        String end2AttributeName = "nestedFolder";
        String end2AttributeDescription = "Folders embedded in this folder.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("FileFolder"), "nestedFolder", "Folders embedded in this folder.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getNestedFileRelationship() {
        String guid = "4cb88900-1446-4eb6-acea-29cd9da45e63";
        String name = "NestedFile";
        String description = "The link between a data file and its containing folder.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4cb88900-1446-4eb6-acea-29cd9da45e63", "NestedFile", null, "The link between a data file and its containing folder.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "FileFolder";
        String end1AttributeName = "homeFolder";
        String end1AttributeDescription = "Identifies the containing folder of this datafile.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("FileFolder"), "homeFolder", "Identifies the containing folder of this datafile.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.DATA_FILE.typeName;
        String end2AttributeName = "nestedFiles";
        String end2AttributeDescription = "Files stored in this folder.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "nestedFiles", "Files stored in this folder.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getLinkedFileRelationship() {
        String guid = "970a3405-fde1-4039-8249-9aa5f56d5151";
        String name = "LinkedFile";
        String description = "A data file that is linked to a file folder (rather than stored in it).";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("970a3405-fde1-4039-8249-9aa5f56d5151", "LinkedFile", null, "A data file that is linked to a file folder (rather than stored in it).", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "FileFolder";
        String end1AttributeName = "linkedFolders";
        String end1AttributeDescription = "Folders that this file is linked to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("FileFolder"), "linkedFolders", "Folders that this file is linked to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.DATA_FILE.typeName;
        String end2AttributeName = "linkedFiles";
        String end2AttributeDescription = "Files linked to the folder.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "linkedFiles", "Files linked to the folder.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getFileSystemClassification() {
        String guid = "cab5ba1d-cfd3-4fca-857d-c07711fc4157";
        String name = "FileSystem";
        String description = "A capability that supports a store of files organized into a hierarchy of file folders.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("cab5ba1d-cfd3-4fca-857d-c07711fc4157", "FileSystem", null, "A capability that supports a store of files organized into a hierarchy of file folders.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "format";
        String attribute1Description = "Format of the file system.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "encryption";
        String attribute2Description = "Level of encryption used on the filesystem (if any).";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("format", "Format of the file system.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("encryption", "Level of encryption used on the filesystem (if any).", attribute2DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0221DocumentStores() {
        this.archiveBuilder.addEntityDef(this.getMediaFileEntity());
        this.archiveBuilder.addEntityDef(this.getMediaCollectionEntity());
        this.archiveBuilder.addEntityDef(this.getDocumentEntity());
        this.archiveBuilder.addEntityDef(this.getDocumentStoreEntity());
        this.archiveBuilder.addRelationshipDef(this.getGroupedMediaRelationship());
        this.archiveBuilder.addRelationshipDef(this.getLinkedMediaRelationship());
        this.archiveBuilder.addClassificationDef(this.getContentManagerClassification());
    }

    private EntityDef getMediaFileEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.MEDIA_FILE.typeGUID, OpenMetadataType.MEDIA_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), OpenMetadataType.MEDIA_FILE.description, OpenMetadataType.MEDIA_FILE.descriptionGUID, OpenMetadataType.MEDIA_FILE.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.EMBEDDED_METADATA.name;
        String attribute1Description = OpenMetadataProperty.EMBEDDED_METADATA.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.EMBEDDED_METADATA.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getMediaCollectionEntity() {
        String guid = "0075d603-1627-41c5-8cae-f5458d1247fe";
        String name = "MediaCollection";
        String description = "A group of related media files.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_SET.typeName;
        return this.archiveHelper.getDefaultEntityDef("0075d603-1627-41c5-8cae-f5458d1247fe", "MediaCollection", this.archiveBuilder.getEntityDef(superTypeName), "A group of related media files.", descriptionGUID);
    }

    private EntityDef getDocumentEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DOCUMENT.typeGUID, OpenMetadataType.DOCUMENT.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.MEDIA_FILE.typeName), OpenMetadataType.DOCUMENT.description, OpenMetadataType.DOCUMENT.descriptionGUID, OpenMetadataType.DOCUMENT.wikiURL);
    }

    private EntityDef getDocumentStoreEntity() {
        String guid = "37156790-feac-4e1a-a42e-88858ae6f8e1";
        String name = "DocumentStore";
        String description = "Identifies a data store as one that contains documents.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_STORE.typeName;
        return this.archiveHelper.getDefaultEntityDef("37156790-feac-4e1a-a42e-88858ae6f8e1", "DocumentStore", this.archiveBuilder.getEntityDef(superTypeName), "Identifies a data store as one that contains documents.", descriptionGUID);
    }

    private RelationshipDef getGroupedMediaRelationship() {
        String guid = "7d881574-461d-475c-ab44-077451528cb8";
        String name = "GroupedMedia";
        String description = "Links a media file into a data set.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("7d881574-461d-475c-ab44-077451528cb8", "GroupedMedia", null, "Links a media file into a data set.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "MediaCollection";
        String end1AttributeName = "dataSetMembership";
        String end1AttributeDescription = "Identifies the data sets this media file belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("MediaCollection"), "dataSetMembership", "Identifies the data sets this media file belongs to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.MEDIA_FILE.typeName;
        String end2AttributeName = "dataSetMembers";
        String end2AttributeDescription = "Media files that make up this media collection.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "dataSetMembers", "Media files that make up this media collection.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getLinkedMediaRelationship() {
        String guid = "cee3a190-fc8d-4e53-908a-f1b9689581e0";
        String name = "LinkedMedia";
        String description = "Links a media file to another media file and describes relationship.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("cee3a190-fc8d-4e53-908a-f1b9689581e0", "LinkedMedia", null, "Links a media file to another media file and describes relationship.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.MEDIA_FILE.typeName;
        String end1AttributeName = "linkedMediaFiles";
        String end1AttributeDescription = "Link to related media files.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "linkedMediaFiles", "Link to related media files.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.MEDIA_FILE.typeName;
        String end2AttributeName = "linkedMediaFiles";
        String end2AttributeDescription = "Link to related media files.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "linkedMediaFiles", "Link to related media files.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getContentManagerClassification() {
        String guid = "fa4df7b5-cb6d-475c-889e-8f3b7ca564d3";
        String name = "ContentManager";
        String description = "Identifies a server as a manager of controlled documents and related media.";
        String descriptionGUID = null;
        String linkedToEntity = "SoftwareServer";
        return this.archiveHelper.getClassificationDef("fa4df7b5-cb6d-475c-889e-8f3b7ca564d3", "ContentManager", null, "Identifies a server as a manager of controlled documents and related media.", descriptionGUID, this.archiveBuilder.getEntityDef("SoftwareServer"), false);
    }

    private void add0222GraphStores() {
        this.archiveBuilder.addEntityDef(this.getGraphStoreEntity());
    }

    private EntityDef getGraphStoreEntity() {
        String guid = "86de3633-eec8-4bf9-aad1-e92df1ca2024";
        String name = "GraphStore";
        String description = "Identifies a data store as one that contains one or more graphs.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_STORE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("86de3633-eec8-4bf9-aad1-e92df1ca2024", "GraphStore", this.archiveBuilder.getEntityDef(superTypeName), "Identifies a data store as one that contains one or more graphs.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Type of graph store.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Type of graph store.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0223EventsAndLogs() {
        this.archiveBuilder.addEntityDef(this.getSubscriberListEntity());
        this.archiveBuilder.addEntityDef(this.getTopicEntity());
        this.archiveBuilder.addEntityDef(this.getLogFileEntity());
        this.archiveBuilder.addRelationshipDef(this.getTopicSubscribersRelationship());
        this.archiveBuilder.addClassificationDef(this.getNotificationManagerClassification());
    }

    private EntityDef getSubscriberListEntity() {
        String guid = "69751093-35f9-42b1-944b-ba6251ff513d";
        String name = "SubscriberList";
        String description = "A data set containing a list of endpoints registered to receive events from a topic.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_SET.typeName;
        return this.archiveHelper.getDefaultEntityDef("69751093-35f9-42b1-944b-ba6251ff513d", "SubscriberList", this.archiveBuilder.getEntityDef(superTypeName), "A data set containing a list of endpoints registered to receive events from a topic.", descriptionGUID);
    }

    private EntityDef getTopicEntity() {
        String guid = OpenMetadataType.TOPIC.typeGUID;
        String name = OpenMetadataType.TOPIC.typeName;
        String description = OpenMetadataType.TOPIC.description;
        String descriptionGUID = OpenMetadataType.TOPIC.descriptionGUID;
        String descriptionWiki = OpenMetadataType.TOPIC.wikiURL;
        String superTypeName = OpenMetadataType.DATA_SET.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.TOPIC_TYPE.name;
        String attribute1Description = OpenMetadataProperty.TOPIC_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.TOPIC_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getLogFileEntity() {
        String guid = OpenMetadataType.LOG_FILE.typeGUID;
        String name = OpenMetadataType.LOG_FILE.typeName;
        String description = OpenMetadataType.LOG_FILE.description;
        String descriptionGUID = OpenMetadataType.LOG_FILE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.LOG_FILE.wikiURL;
        String superTypeName = OpenMetadataType.DATA_FILE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Type of log file.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Type of log file.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getTopicSubscribersRelationship() {
        String guid = "bc91a28c-afb9-41a7-8eb2-fc8b5271fe9e";
        String name = "TopicSubscribers";
        String description = "Links the list of subscribers to a topic.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("bc91a28c-afb9-41a7-8eb2-fc8b5271fe9e", "TopicSubscribers", null, "Links the list of subscribers to a topic.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SubscriberList";
        String end1AttributeName = "subscribers";
        String end1AttributeDescription = "The endpoints subscribed to this topic.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SubscriberList"), "subscribers", "The endpoints subscribed to this topic.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Topic";
        String end2AttributeName = "topics";
        String end2AttributeDescription = "The topics used by this subscriber list.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Topic"), "topics", "The topics used by this subscriber list.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getNotificationManagerClassification() {
        String guid = "3e7502a7-396a-4737-a106-378c9c94c105";
        String name = "NotificationManager";
        String description = "Identifies a server capability that is distributing events from a topic to its subscriber list.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getClassificationDef("3e7502a7-396a-4737-a106-378c9c94c105", "NotificationManager", null, "Identifies a server capability that is distributing events from a topic to its subscriber list.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private void add0224Databases() {
        this.archiveBuilder.addEntityDef(this.getDeployedDatabaseSchemaEntity());
        this.archiveBuilder.addEntityDef(this.getDatabaseEntity());
        this.archiveBuilder.addClassificationDef(this.getDatabaseServerClassification());
    }

    private EntityDef getDeployedDatabaseSchemaEntity() {
        String guid = "eab811ec-556a-45f1-9091-bc7ac8face0f";
        String name = "DeployedDatabaseSchema";
        String description = "A collection of database tables and views running in a database server.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_SET.typeName;
        return this.archiveHelper.getDefaultEntityDef("eab811ec-556a-45f1-9091-bc7ac8face0f", "DeployedDatabaseSchema", this.archiveBuilder.getEntityDef(superTypeName), "A collection of database tables and views running in a database server.", descriptionGUID);
    }

    private EntityDef getDatabaseEntity() {
        String guid = "0921c83f-b2db-4086-a52c-0d10e52ca078";
        String name = "Database";
        String description = "A data store containing relational data.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_STORE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("0921c83f-b2db-4086-a52c-0d10e52ca078", "Database", this.archiveBuilder.getEntityDef(superTypeName), "A data store containing relational data.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Type of database.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "version";
        String attribute2Description = "Version of the database.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "instance";
        String attribute3Description = "Name of the database instance.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "importedFrom";
        String attribute4Description = "Name of the connector where database is imported from.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Type of database.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Version of the database.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("instance", "Name of the database instance.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("importedFrom", "Name of the connector where database is imported from.", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private ClassificationDef getDatabaseServerClassification() {
        String guid = "6bb58cc9-ed9e-4f75-b2f2-6d308554eb52";
        String name = "DatabaseServer";
        String description = "Identifies a server as one that manages one or more databases.";
        String descriptionGUID = null;
        String linkedToEntity = "SoftwareServer";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("6bb58cc9-ed9e-4f75-b2f2-6d308554eb52", "DatabaseServer", null, "Identifies a server as one that manages one or more databases.", descriptionGUID, this.archiveBuilder.getEntityDef("SoftwareServer"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Type of database server.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "version";
        String attribute2Description = "Version of the database server software.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.SOURCE.name;
        String attribute3Description = OpenMetadataProperty.SOURCE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Type of database server.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Version of the database server software.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0225MetadataRepositories() {
        this.archiveBuilder.addEntityDef(this.getEnterpriseAccessLayerEntity());
        this.archiveBuilder.addEntityDef(this.getCohortMemberEntity());
        this.archiveBuilder.addEntityDef(this.getMetadataRepositoryCohortEntity());
        this.archiveBuilder.addEntityDef(this.getMetadataCollectionEntity());
        this.archiveBuilder.addEntityDef(this.getMetadataRepositoryEntity());
        this.archiveBuilder.addEntityDef(this.getCohortRegistryStoreEntity());
        this.archiveBuilder.addRelationshipDef(this.getMetadataCohortPeerRelationship());
        this.archiveBuilder.addRelationshipDef(this.getCohortMemberMetadataCollectionRelationship());
        this.archiveBuilder.addClassificationDef(this.getMetadataServerClassification());
        this.archiveBuilder.addClassificationDef(this.getRepositoryProxyClassification());
    }

    private EntityDef getEnterpriseAccessLayerEntity() {
        String guid = "39444bf9-638e-4124-a5f9-1b8f3e1b008b";
        String name = "EnterpriseAccessLayer";
        String description = "Repository services for the Open Metadata Access Services (OMAS) supporting federated queries and aggregated events from the connected cohorts.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("39444bf9-638e-4124-a5f9-1b8f3e1b008b", "EnterpriseAccessLayer", this.archiveBuilder.getEntityDef(superTypeName), "Repository services for the Open Metadata Access Services (OMAS) supporting federated queries and aggregated events from the connected cohorts.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "topicRoot";
        String attribute1Description = "Root of topic names used by the Open Metadata access Services (OMASs).";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "metadataCollectionId";
        String attribute2Description = "Unique identifier for the metadata collection accessed through this enterprise access layer.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("topicRoot", "Root of topic names used by the Open Metadata access Services (OMASs).", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("metadataCollectionId", "Unique identifier for the metadata collection accessed through this enterprise access layer.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getCohortMemberEntity() {
        String guid = "42063797-a78a-4720-9353-52026c75f667";
        String name = "CohortMember";
        String description = "A capability enabling a server to access an open metadata repository cohort.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef("42063797-a78a-4720-9353-52026c75f667", "CohortMember", this.archiveBuilder.getEntityDef(superTypeName), "A capability enabling a server to access an open metadata repository cohort.", descriptionGUID);
    }

    private EntityDef getMetadataRepositoryCohortEntity() {
        String guid = "43e7dca2-c7b4-4cdf-a1ea-c9d4f7093893";
        String name = "MetadataRepositoryCohort";
        String description = "A group of collaborating open metadata repositories.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("43e7dca2-c7b4-4cdf-a1ea-c9d4f7093893", "MetadataRepositoryCohort", this.archiveBuilder.getEntityDef(superTypeName), "A group of collaborating open metadata repositories.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "topic";
        String attribute2Description = "Name of the topic used to exchange registration, type definitions and metadata instances between the members of the open metadata repository cohort.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("topic", "Name of the topic used to exchange registration, type definitions and metadata instances between the members of the open metadata repository cohort.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getMetadataCollectionEntity() {
        String guid = "ea3b15af-ed0e-44f7-91e4-bdb299dd4976";
        String name = "MetadataCollection";
        String description = "A data set containing metadata.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_SET.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("ea3b15af-ed0e-44f7-91e4-bdb299dd4976", "MetadataCollection", this.archiveBuilder.getEntityDef(superTypeName), "A data set containing metadata.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "metadataCollectionId";
        String attribute1Description = "Unique identifier for the metadata collection managed in the local repository.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("metadataCollectionId", "Unique identifier for the metadata collection managed in the local repository.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getMetadataRepositoryEntity() {
        String guid = "c40397bd-eab0-4b2e-bffb-e7fa0f93a5a9";
        String name = "MetadataRepository";
        String description = "A data store containing metadata.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_STORE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("c40397bd-eab0-4b2e-bffb-e7fa0f93a5a9", "MetadataRepository", this.archiveBuilder.getEntityDef(superTypeName), "A data store containing metadata.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Type of metadata repository.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Type of metadata repository.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getCohortRegistryStoreEntity() {
        String guid = "2bfdcd0d-68bb-42c3-ae75-e9fb6c3dff70";
        String name = "CohortRegistryStore";
        String description = "A data store containing cohort membership registration details.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_STORE.typeName;
        return this.archiveHelper.getDefaultEntityDef("2bfdcd0d-68bb-42c3-ae75-e9fb6c3dff70", "CohortRegistryStore", this.archiveBuilder.getEntityDef(superTypeName), "A data store containing cohort membership registration details.", descriptionGUID);
    }

    private RelationshipDef getMetadataCohortPeerRelationship() {
        String guid = "954cdba1-3d69-4db1-bf0e-d59fd2c25a27";
        String name = "MetadataCohortPeer";
        String description = "A metadata repository's registration with an open metadata cohort.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("954cdba1-3d69-4db1-bf0e-d59fd2c25a27", "MetadataCohortPeer", null, "A metadata repository's registration with an open metadata cohort.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "MetadataRepositoryCohort";
        String end1AttributeName = "registeredWithCohorts";
        String end1AttributeDescription = "Identifies which cohorts this cohort member is registered with.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("MetadataRepositoryCohort"), "registeredWithCohorts", "Identifies which cohorts this cohort member is registered with.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "CohortMember";
        String end2AttributeName = "cohortMembership";
        String end2AttributeDescription = "Members of this cohort.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("CohortMember"), "cohortMembership", "Members of this cohort.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "registrationDate";
        String attribute1Description = "Date first registered with the cohort.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("registrationDate", "Date first registered with the cohort.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getCohortMemberMetadataCollectionRelationship() {
        String guid = "8b9dd3ea-057b-4709-9b42-f16098523907";
        String name = "CohortMemberMetadataCollection";
        String description = "The local metadata collection associated with a cohort peer.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("8b9dd3ea-057b-4709-9b42-f16098523907", "CohortMemberMetadataCollection", null, "The local metadata collection associated with a cohort peer.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "CohortMember";
        String end1AttributeName = "cohortMember";
        String end1AttributeDescription = "Cohort registry representing this metadata collection on the metadata highway.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("CohortMember"), "cohortMember", "Cohort registry representing this metadata collection on the metadata highway.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "MetadataCollection";
        String end2AttributeName = "localMetadataCollection";
        String end2AttributeDescription = "Metadata to exchange with the cohorts.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("MetadataCollection"), "localMetadataCollection", "Metadata to exchange with the cohorts.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getMetadataServerClassification() {
        String guid = "74a256ad-4022-4518-a446-c65fe082d4d3";
        String name = "MetadataServer";
        String description = "A server hosting a metadata collection.";
        String descriptionGUID = null;
        String linkedToEntity = "SoftwareServer";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("74a256ad-4022-4518-a446-c65fe082d4d3", "MetadataServer", null, "A server hosting a metadata collection.", descriptionGUID, this.archiveBuilder.getEntityDef("SoftwareServer"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "format";
        String attribute1Description = "format of supported metadata.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "type";
        String attribute2Description = "Type of metadata server.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("format", "format of supported metadata.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("type", "Type of metadata server.", attribute2DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getRepositoryProxyClassification() {
        String guid = "ae81c35e-7078-46f0-9b2c-afc99accf3ec";
        String name = "RepositoryProxy";
        String description = "A server acting as an open metadata adapter for a metadata repository.";
        String descriptionGUID = null;
        String linkedToEntity = "SoftwareServer";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("ae81c35e-7078-46f0-9b2c-afc99accf3ec", "RepositoryProxy", null, "A server acting as an open metadata adapter for a metadata repository.", descriptionGUID, this.archiveBuilder.getEntityDef("SoftwareServer"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Type of repository proxy.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("type", "Type of repository proxy.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0227Keystores() {
        this.archiveBuilder.addEntityDef(this.getKeystoreFileEntity());
        this.archiveBuilder.addEntityDef(this.geSecretsCollectionEntity());
    }

    private EntityDef getKeystoreFileEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.KEYSTORE_FILE.typeGUID, OpenMetadataType.KEYSTORE_FILE.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_FILE.typeName), OpenMetadataType.KEYSTORE_FILE.description, OpenMetadataType.KEYSTORE_FILE.descriptionGUID, OpenMetadataType.KEYSTORE_FILE.wikiURL);
    }

    private EntityDef geSecretsCollectionEntity() {
        return this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SECRETS_COLLECTION.typeGUID, OpenMetadataType.SECRETS_COLLECTION.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.DATA_SET.typeName), OpenMetadataType.SECRETS_COLLECTION.description, OpenMetadataType.SECRETS_COLLECTION.descriptionGUID, OpenMetadataType.SECRETS_COLLECTION.wikiURL);
    }

    private void add0230CodeTables() {
        this.archiveBuilder.addEntityDef(this.getReferenceCodeTableEntity());
        this.archiveBuilder.addEntityDef(this.getReferenceCodeMappingTableEntity());
    }

    private EntityDef getReferenceCodeTableEntity() {
        String guid = "201f48c5-4e4b-41dc-9c5f-0bc9742190cf";
        String name = "ReferenceCodeTable";
        String description = "A data set containing code values and their translations.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_SET.typeName;
        return this.archiveHelper.getDefaultEntityDef("201f48c5-4e4b-41dc-9c5f-0bc9742190cf", "ReferenceCodeTable", this.archiveBuilder.getEntityDef(superTypeName), "A data set containing code values and their translations.", descriptionGUID);
    }

    private EntityDef getReferenceCodeMappingTableEntity() {
        String guid = "9c6ec0c6-0b26-4414-bffe-089144323213";
        String name = "ReferenceCodeMappingTable";
        String description = "A data set containing mappings between code values from different data sets.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_SET.typeName;
        return this.archiveHelper.getDefaultEntityDef("9c6ec0c6-0b26-4414-bffe-089144323213", "ReferenceCodeMappingTable", this.archiveBuilder.getEntityDef(superTypeName), "A data set containing mappings between code values from different data sets.", descriptionGUID);
    }

    private void add0235InformationView() {
        this.archiveBuilder.addEntityDef(this.getInformationViewEntity());
    }

    private EntityDef getInformationViewEntity() {
        String guid = "68d7b905-6438-43be-88cf-5de027b4aaaf";
        String name = "InformationView";
        String description = "A data set containing selected data items from one or more data stores or data sets.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_SET.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("68d7b905-6438-43be-88cf-5de027b4aaaf", "InformationView", this.archiveBuilder.getEntityDef(superTypeName), "A data set containing selected data items from one or more data stores or data sets.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "id";
        String attribute1Description = "Id of view.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "comment";
        String attribute2Description = "Comment";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "nativeClass";
        String attribute3Description = "Native class used by the client to represent this entity.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "createdTime";
        String attribute4Description = "Information View create time.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "lastModifiedTime";
        String attribute5Description = "Information View last modified time.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "lastModifier";
        String attribute6Description = "Information View last modifier.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("id", "Id of view.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("comment", "Comment", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("nativeClass", "Native class used by the client to represent this entity.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("createdTime", "Information View create time.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("lastModifiedTime", "Information View last modified time.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("lastModifier", "Information View last modifier.", attribute6DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0239Reports() {
        this.archiveBuilder.addEntityDef(this.getFormEntity());
        this.archiveBuilder.addEntityDef(this.getDeployedReportEntity());
    }

    private EntityDef getFormEntity() {
        String guid = "8078e3d1-0c63-4ace-aafa-68498b39ccd6";
        String name = "Form";
        String description = "A collection of data items used to request activity.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_SET.typeName;
        return this.archiveHelper.getDefaultEntityDef("8078e3d1-0c63-4ace-aafa-68498b39ccd6", "Form", this.archiveBuilder.getEntityDef(superTypeName), "A collection of data items used to request activity.", descriptionGUID);
    }

    private EntityDef getDeployedReportEntity() {
        String guid = "e9077f4f-955b-4d7b-b1f7-12ee769ff0c3";
        String name = "DeployedReport";
        String description = "A collection if data items that describe a situation.  This is an instance of a report.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.DATA_SET.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("e9077f4f-955b-4d7b-b1f7-12ee769ff0c3", "DeployedReport", this.archiveBuilder.getEntityDef(superTypeName), "A collection if data items that describe a situation.  This is an instance of a report.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "id";
        String attribute1Description = "Id of report.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "author";
        String attribute2Description = "Author of the report.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "url";
        String attribute3Description = "url of the report.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "createdTime";
        String attribute4Description = "Report create time.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "lastModifiedTime";
        String attribute5Description = "Report last modified time.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "lastModifier";
        String attribute6Description = "Report last modifier.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("id", "Id of report.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("author", "Author of the report.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("url", "url of the report.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("createdTime", "Report create time.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("lastModifiedTime", "Report last modified time.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("lastModifier", "Report last modifier.", attribute6DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0290Ports() {
        this.archiveBuilder.addEnumDef(this.getPortTypeEnum());
        this.archiveBuilder.addEntityDef(this.getPortEntity());
        this.archiveBuilder.addEntityDef(this.getPortAliasEntity());
        this.archiveBuilder.addEntityDef(this.getPortImplementationEntity());
        this.archiveBuilder.addRelationshipDef(this.getProcessPortRelationship());
        this.archiveBuilder.addRelationshipDef(this.getPortDelegationRelationship());
    }

    private EnumDef getPortTypeEnum() {
        String guid = "b57Fbce7-42ac-71D1-D6a6-9f62Cb7C6dc3";
        String name = "PortType";
        String description = "Descriptor for a port that indicates its type.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("b57Fbce7-42ac-71D1-D6a6-9f62Cb7C6dc3", "PortType", "Descriptor for a port that indicates its type.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "INPUT_PORT";
        String element1Description = "Data is passed into the process.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "INPUT_PORT", "Data is passed into the process.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "OUTPUT_PORT";
        String element2Description = "Data is produced by the process.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "OUTPUT_PORT", "Data is produced by the process.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "INOUT_PORT";
        String element3Description = "A request-response interface is provided by the process.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "INOUT_PORT", "A request-response interface is provided by the process.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "OUTIN_PORT";
        String element4Description = "A request-response call is made by the process.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "OUTIN_PORT", "A request-response call is made by the process.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 99;
        String element5Value = "OTHER";
        String element5Description = "None of the above.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "OTHER", "None of the above.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getPortEntity() {
        String guid = "e3d9FD9F-d5eD-2aed-CC98-0bc21aB6f71C";
        String name = "Port";
        String description = "An interface where data flows in and/or out of the process.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("e3d9FD9F-d5eD-2aed-CC98-0bc21aB6f71C", "Port", this.archiveBuilder.getEntityDef(superTypeName), "An interface where data flows in and/or out of the process.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = "portType";
        String attribute2Description = "Type of port";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("PortType", "portType", "Type of port", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getPortAliasEntity() {
        String guid = "DFa5aEb1-bAb4-c25B-bDBD-B95Ce6fAB7F5";
        String name = "PortAlias";
        String description = "Entity that describes the port for a composition process.";
        String descriptionGUID = null;
        String superTypeName = "Port";
        return this.archiveHelper.getDefaultEntityDef("DFa5aEb1-bAb4-c25B-bDBD-B95Ce6fAB7F5", "PortAlias", this.archiveBuilder.getEntityDef("Port"), "Entity that describes the port for a composition process.", descriptionGUID);
    }

    private EntityDef getPortImplementationEntity() {
        String guid = "ADbbdF06-a6A3-4D5F-7fA3-DB4Cb0eDeC0E";
        String name = "PortImplementation";
        String description = "Entity that describes a port with a concrete implementation.";
        String descriptionGUID = null;
        String superTypeName = "Port";
        return this.archiveHelper.getDefaultEntityDef("ADbbdF06-a6A3-4D5F-7fA3-DB4Cb0eDeC0E", "PortImplementation", this.archiveBuilder.getEntityDef("Port"), "Entity that describes a port with a concrete implementation.", descriptionGUID);
    }

    private RelationshipDef getPortDelegationRelationship() {
        String guid = "98bB8BA1-dc6A-eb9D-32Cf-F837bEbCbb8E";
        String name = "PortDelegation";
        String description = "A relationship between a more granular and a more abstract port";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("98bB8BA1-dc6A-eb9D-32Cf-F837bEbCbb8E", "PortDelegation", null, "A relationship between a more granular and a more abstract port", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Port";
        String end1AttributeName = "delegatingFrom";
        String end1AttributeDescription = "Higher level Port";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Port"), "delegatingFrom", "Higher level Port", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Port";
        String end2AttributeName = "delegatingTo";
        String end2AttributeDescription = "Lower level port";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Port"), "delegatingTo", "Lower level port", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getProcessPortRelationship() {
        String guid = "fB4E00CF-37e4-88CE-4a94-233BAdB84DA2";
        String name = "ProcessPort";
        String description = "A link between a process and one of its ports.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("fB4E00CF-37e4-88CE-4a94-233BAdB84DA2", "ProcessPort", null, "A link between a process and one of its ports.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.PROCESS.typeName;
        String end1AttributeName = "owningProcess";
        String end1AttributeDescription = "Process linked to the port";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "owningProcess", "Process linked to the port", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Port";
        String end2AttributeName = "ports";
        String end2AttributeDescription = "Port to the process";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Port"), "ports", "Port to the process", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void addArea3Types() {
        this.add0310Glossary();
        this.add0320CategoryHierarchy();
        this.add0330Terms();
        this.add0340Dictionary();
        this.add0350RelatedTerms();
        this.add0360Contexts();
        this.add0370SemanticAssignment();
        this.add0380SpineObjects();
        this.add0385ControlledGlossaryDevelopment();
        this.add0390GlossaryProject();
    }

    private void add0310Glossary() {
        this.archiveBuilder.addEntityDef(this.getGlossaryEntity());
        this.archiveBuilder.addEntityDef(this.getExternalGlossaryLinkEntity());
        this.archiveBuilder.addRelationshipDef(this.getExternalSourcedGlossaryRelationship());
        this.archiveBuilder.addClassificationDef(this.getTaxonomyClassification());
        this.archiveBuilder.addClassificationDef(this.getCanonicalVocabularyClassification());
    }

    private EntityDef getGlossaryEntity() {
        String guid = "36f66863-9726-4b41-97ee-714fd0dc6fe4";
        String name = "Glossary";
        String description = "A collection of related glossary terms.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("36f66863-9726-4b41-97ee-714fd0dc6fe4", "Glossary", this.archiveBuilder.getEntityDef(superTypeName), "A collection of related glossary terms.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "language";
        String attribute3Description = "Natural language used in the glossary.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.USAGE.name;
        String attribute4Description = OpenMetadataProperty.USAGE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.USAGE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("language", "Natural language used in the glossary.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getExternalGlossaryLinkEntity() {
        String guid = "183d2935-a950-4d74-b246-eac3664b5a9d";
        String name = "ExternalGlossaryLink";
        String description = "The location of a glossary stored outside of the open metadata ecosystem.";
        String descriptionGUID = null;
        String superTypeName = "ExternalReference";
        return this.archiveHelper.getDefaultEntityDef("183d2935-a950-4d74-b246-eac3664b5a9d", "ExternalGlossaryLink", this.archiveBuilder.getEntityDef("ExternalReference"), "The location of a glossary stored outside of the open metadata ecosystem.", descriptionGUID);
    }

    private RelationshipDef getExternalSourcedGlossaryRelationship() {
        String guid = "7786a39c-436b-4538-acc7-d595b5856add";
        String name = "ExternallySourcedGlossary";
        String description = "Link between an open metadata glossary and a related glossary stored outside of the open metadata ecosystem.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("7786a39c-436b-4538-acc7-d595b5856add", "ExternallySourcedGlossary", null, "Link between an open metadata glossary and a related glossary stored outside of the open metadata ecosystem.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Glossary";
        String end1AttributeName = "localGlossary";
        String end1AttributeDescription = "Local glossary that relates to this external glossary.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Glossary"), "localGlossary", "Local glossary that relates to this external glossary.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ExternalGlossaryLink";
        String end2AttributeName = "externalGlossaryLink";
        String end2AttributeDescription = "Link to a related external glossary.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ExternalGlossaryLink"), "externalGlossaryLink", "Link to a related external glossary.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getTaxonomyClassification() {
        String guid = "37116c51-e6c9-4c37-942e-35d48c8c69a0";
        String name = "Taxonomy";
        String description = "Identifies a glossary that includes a taxonomy.";
        String descriptionGUID = null;
        String linkedToEntity = "Glossary";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("37116c51-e6c9-4c37-942e-35d48c8c69a0", "Taxonomy", null, "Identifies a glossary that includes a taxonomy.", descriptionGUID, this.archiveBuilder.getEntityDef("Glossary"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "organizingPrinciple";
        String attribute1Description = "Characteristics that influence the organization of the taxonomy.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("organizingPrinciple", "Characteristics that influence the organization of the taxonomy.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getCanonicalVocabularyClassification() {
        String guid = "33ad3da2-0910-47be-83f1-daee018a4c05";
        String name = "CanonicalVocabulary";
        String description = "Identifies a glossary that contains unique terms.";
        String descriptionGUID = null;
        String linkedToEntity = "Glossary";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("33ad3da2-0910-47be-83f1-daee018a4c05", "CanonicalVocabulary", null, "Identifies a glossary that contains unique terms.", descriptionGUID, this.archiveBuilder.getEntityDef("Glossary"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "scope";
        String attribute1Description = "Scope of influence for this canonical glossary.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("scope", "Scope of influence for this canonical glossary.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0320CategoryHierarchy() {
        this.archiveBuilder.addEntityDef(this.getGlossaryCategoryEntity());
        this.archiveBuilder.addRelationshipDef(this.getCategoryAnchorRelationship());
        this.archiveBuilder.addRelationshipDef(this.getCategoryHierarchyLinkRelationship());
        this.archiveBuilder.addRelationshipDef(this.getLibraryCategoryReferenceRelationship());
        this.archiveBuilder.addClassificationDef(this.getSubjectAreaClassification());
    }

    private EntityDef getGlossaryCategoryEntity() {
        String guid = "e507485b-9b5a-44c9-8a28-6967f7ff3672";
        String name = "GlossaryCategory";
        String description = "A collection of related glossary terms.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("e507485b-9b5a-44c9-8a28-6967f7ff3672", "GlossaryCategory", this.archiveBuilder.getEntityDef(superTypeName), "A collection of related glossary terms.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getCategoryAnchorRelationship() {
        String guid = "c628938e-815e-47db-8d1c-59bb2e84e028";
        String name = "CategoryAnchor";
        String description = "Connects a glossary category with its owning glossary.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("c628938e-815e-47db-8d1c-59bb2e84e028", "CategoryAnchor", null, "Connects a glossary category with its owning glossary.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Glossary";
        String end1AttributeName = "anchor";
        String end1AttributeDescription = "Owning glossary for this category.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Glossary"), "anchor", "Owning glossary for this category.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryCategory";
        String end2AttributeName = "categories";
        String end2AttributeDescription = "Categories owned by this glossary.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryCategory"), "categories", "Categories owned by this glossary.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getCategoryHierarchyLinkRelationship() {
        String guid = "71e4b6fb-3412-4193-aff3-a16eccd87e8e";
        String name = "CategoryHierarchyLink";
        String description = "Relationship between two glossary categories used to create nested categories.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("71e4b6fb-3412-4193-aff3-a16eccd87e8e", "CategoryHierarchyLink", null, "Relationship between two glossary categories used to create nested categories.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryCategory";
        String end1AttributeName = "superCategory";
        String end1AttributeDescription = "Identifies the parent category.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryCategory"), "superCategory", "Identifies the parent category.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryCategory";
        String end2AttributeName = "subcategories";
        String end2AttributeDescription = "Glossary categories nested inside this category.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryCategory"), "subcategories", "Glossary categories nested inside this category.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getLibraryCategoryReferenceRelationship() {
        String guid = "3da21cc9-3cdc-4d87-89b5-c501740f00b2";
        String name = "LibraryCategoryReference";
        String description = "Links a glossary category to a corresponding category in an external glossary.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("3da21cc9-3cdc-4d87-89b5-c501740f00b2", "LibraryCategoryReference", null, "Links a glossary category to a corresponding category in an external glossary.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryCategory";
        String end1AttributeName = "localCategories";
        String end1AttributeDescription = "Related local glossary categories.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryCategory"), "localCategories", "Related local glossary categories.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ExternalGlossaryLink";
        String end2AttributeName = "externalGlossaryCategories";
        String end2AttributeDescription = "Links to related external glossaries.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ExternalGlossaryLink"), "externalGlossaryCategories", "Links to related external glossaries.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "identifier";
        String attribute1Description = "Identifier of the corresponding element from the external glossary.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.STEWARD.name;
        String attribute3Description = OpenMetadataProperty.STEWARD.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute4Name = "lastVerified";
        String attribute4Description = "Date when this reference was last checked.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("identifier", "Identifier of the corresponding element from the external glossary.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("lastVerified", "Date when this reference was last checked.", attribute4DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getSubjectAreaClassification() {
        String guid = "480e6993-35c5-433a-b50b-0f5c4063fb5d";
        String name = "SubjectArea";
        String description = "Identifies an element as part of a subject area definition.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("480e6993-35c5-433a-b50b-0f5c4063fb5d", "SubjectArea", null, "Identifies an element as part of a subject area definition.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0330Terms() {
        this.archiveBuilder.addEnumDef(this.getTermRelationshipStatusEnum());
        this.archiveBuilder.addEntityDef(this.getGlossaryTermEntity());
        this.archiveBuilder.addRelationshipDef(this.getTermAnchorRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTermCategorizationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getLibraryTermReferenceRelationship());
    }

    private EnumDef getTermRelationshipStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(GlossaryTermRelationshipStatus.getOpenTypeGUID(), GlossaryTermRelationshipStatus.getOpenTypeName(), GlossaryTermRelationshipStatus.getOpenTypeDescription(), GlossaryTermRelationshipStatus.getOpenTypeDescriptionGUID(), GlossaryTermRelationshipStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (GlossaryTermRelationshipStatus enumValues : GlossaryTermRelationshipStatus.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getGlossaryTermEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.GLOSSARY_TERM.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.GLOSSARY_TERM.description, OpenMetadataType.GLOSSARY_TERM.descriptionGUID, OpenMetadataType.GLOSSARY_TERM.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.SUMMARY.name;
        String attribute2Description = OpenMetadataProperty.SUMMARY.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.SUMMARY.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute3Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.EXAMPLES.name;
        String attribute4Description = OpenMetadataProperty.EXAMPLES.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.EXAMPLES.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.ABBREVIATION.name;
        String attribute5Description = OpenMetadataProperty.ABBREVIATION.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.ABBREVIATION.descriptionGUID;
        String attribute6Name = OpenMetadataProperty.USAGE.name;
        String attribute6Description = OpenMetadataProperty.USAGE.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.USAGE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getTermAnchorRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TERM_ANCHOR.typeGUID, OpenMetadataType.TERM_ANCHOR.typeName, null, OpenMetadataType.TERM_ANCHOR.description, OpenMetadataType.TERM_ANCHOR.descriptionGUID, OpenMetadataType.TERM_ANCHOR.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = "Glossary";
        String end1AttributeName = "anchor";
        String end1AttributeDescription = "Owning glossary.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Glossary"), "anchor", "Owning glossary.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.GLOSSARY_TERM.typeName;
        String end2AttributeName = "terms";
        String end2AttributeDescription = "Terms owned by this glossary.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "terms", "Terms owned by this glossary.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getTermCategorizationRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.TERM_CATEGORIZATION.typeGUID, OpenMetadataType.TERM_CATEGORIZATION.typeName, null, OpenMetadataType.TERM_CATEGORIZATION.description, OpenMetadataType.TERM_CATEGORIZATION.descriptionGUID, OpenMetadataType.TERM_CATEGORIZATION.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = "GlossaryCategory";
        String end1AttributeName = "categories";
        String end1AttributeDescription = "Glossary categories that this term is linked to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryCategory"), "categories", "Glossary categories that this term is linked to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.GLOSSARY_TERM.typeName;
        String end2AttributeName = "terms";
        String end2AttributeDescription = "Glossary terms linked to this category.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "terms", "Glossary terms linked to this category.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "status";
        String attribute2Description = "Status of the relationship.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "Status of the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getLibraryTermReferenceRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.LIBRARY_TERM_REFERENCE.typeGUID, OpenMetadataType.LIBRARY_TERM_REFERENCE.typeName, null, OpenMetadataType.LIBRARY_TERM_REFERENCE.description, OpenMetadataType.LIBRARY_TERM_REFERENCE.descriptionGUID, OpenMetadataType.LIBRARY_TERM_REFERENCE.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.GLOSSARY_TERM.typeName;
        String end1AttributeName = "localTerms";
        String end1AttributeDescription = "Related local glossary terms.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "localTerms", "Related local glossary terms.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ExternalGlossaryLink";
        String end2AttributeName = "externalGlossaryTerms";
        String end2AttributeDescription = "Links to related external glossaries.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ExternalGlossaryLink"), "externalGlossaryTerms", "Links to related external glossaries.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "identifier";
        String attribute1Description = "Identifier of the corresponding element from the external glossary.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.STEWARD.name;
        String attribute3Description = OpenMetadataProperty.STEWARD.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute4Name = "lastVerified";
        String attribute4Description = "Date when this reference was last checked.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("identifier", "Identifier of the corresponding element from the external glossary.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("lastVerified", "Date when this reference was last checked.", attribute4DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0340Dictionary() {
        this.archiveBuilder.addEnumDef(this.getActivityTypeEnum());
        this.archiveBuilder.addClassificationDef(this.getActivityDescriptionClassification());
        this.archiveBuilder.addClassificationDef(this.getAbstractConceptClassification());
        this.archiveBuilder.addClassificationDef(this.getDataValueClassification());
    }

    private EnumDef getActivityTypeEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(GlossaryTermActivityType.getOpenTypeGUID(), GlossaryTermActivityType.getOpenTypeName(), GlossaryTermActivityType.getOpenTypeDescription(), GlossaryTermActivityType.getOpenTypeDescriptionGUID(), GlossaryTermActivityType.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (GlossaryTermActivityType enumValues : GlossaryTermActivityType.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef getActivityDescriptionClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeGUID, OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeName, null, OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.description, OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.descriptionGUID, OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.wikiURL, this.archiveBuilder.getEntityDef("GlossaryTerm"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.ACTIVITY_TYPE.name;
        String attribute1Description = "Classification of the activity.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermActivityType.getOpenTypeName(), attribute1Name, "Classification of the activity.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getAbstractConceptClassification() {
        String guid = "9d725a07-4abf-4939-a268-419d200b69c2";
        String name = "AbstractConcept";
        String description = "Identifies that this glossary term describes an abstract concept.";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryTerm";
        return this.archiveHelper.getClassificationDef("9d725a07-4abf-4939-a268-419d200b69c2", "AbstractConcept", null, "Identifies that this glossary term describes an abstract concept.", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryTerm"), false);
    }

    private ClassificationDef getDataValueClassification() {
        String guid = "ab253e31-3d8a-45a7-8592-24329a189b9e";
        String name = "DataValue";
        String description = "Identifies that this glossary term describes a data value.";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryTerm";
        return this.archiveHelper.getClassificationDef("ab253e31-3d8a-45a7-8592-24329a189b9e", "DataValue", null, "Identifies that this glossary term describes a data value.", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryTerm"), false);
    }

    private void add0350RelatedTerms() {
        this.archiveBuilder.addRelationshipDef(this.getRelatedTermRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSynonymRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAntonymRelationship());
        this.archiveBuilder.addRelationshipDef(this.getPreferredTermRelationship());
        this.archiveBuilder.addRelationshipDef(this.getReplacementTermRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTranslationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getISARelationshipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getValidValueRelationship());
    }

    private RelationshipDef getRelatedTermRelationship() {
        String guid = "b1161696-e563-4cf9-9fd9-c0c76e47d063";
        String name = "RelatedTerm";
        String description = "Link between similar glossary terms.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("b1161696-e563-4cf9-9fd9-c0c76e47d063", "RelatedTerm", null, "Link between similar glossary terms.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "seeAlso";
        String end1AttributeDescription = "Related glossary terms.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "seeAlso", "Related glossary terms.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "seeAlso";
        String end2AttributeDescription = "Related glossary terms.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "seeAlso", "Related glossary terms.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "expression";
        String attribute2Description = "An expression that explains the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expression", "An expression that explains the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getSynonymRelationship() {
        String guid = "74f4094d-dba2-4ad9-874e-d422b69947e2";
        String name = "Synonym";
        String description = "Link between glossary terms that have the same meaning.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("74f4094d-dba2-4ad9-874e-d422b69947e2", "Synonym", null, "Link between glossary terms that have the same meaning.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "synonyms";
        String end1AttributeDescription = "Glossary terms with the same meaning.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "synonyms", "Glossary terms with the same meaning.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "synonyms";
        String end2AttributeDescription = "Glossary terms with the same meaning.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "synonyms", "Glossary terms with the same meaning.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "expression";
        String attribute2Description = "An expression that explains the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expression", "An expression that explains the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getAntonymRelationship() {
        String guid = "ea5e126a-a8fa-4a43-bcfa-309a98aa0185";
        String name = "Antonym";
        String description = "Link between glossary terms that have the opposite meaning.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("ea5e126a-a8fa-4a43-bcfa-309a98aa0185", "Antonym", null, "Link between glossary terms that have the opposite meaning.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "antonyms";
        String end1AttributeDescription = "Glossary terms with the opposite meaning.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "antonyms", "Glossary terms with the opposite meaning.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "antonyms";
        String end2AttributeDescription = "Glossary terms with the opposite meaning.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "antonyms", "Glossary terms with the opposite meaning.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "expression";
        String attribute2Description = "An expression that explains the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expression", "An expression that explains the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getPreferredTermRelationship() {
        String guid = "8ac8f9de-9cdd-4103-8a33-4cb204b78c2a";
        String name = "PreferredTerm";
        String description = "Link to an alternative term that the organization prefer is used.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("8ac8f9de-9cdd-4103-8a33-4cb204b78c2a", "PreferredTerm", null, "Link to an alternative term that the organization prefer is used.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "alternateTerms";
        String end1AttributeDescription = "Alternative glossary terms.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "alternateTerms", "Alternative glossary terms.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "preferredTerms";
        String end2AttributeDescription = "Related glossary terms.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "preferredTerms", "Related glossary terms.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "expression";
        String attribute2Description = "An expression that explains the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expression", "An expression that explains the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getReplacementTermRelationship() {
        String guid = "3bac5f35-328b-4bbd-bfc9-3b3c9ba5e0ed";
        String name = "ReplacementTerm";
        String description = "Link to a glossary term that is replacing an obsolete glossary term.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("3bac5f35-328b-4bbd-bfc9-3b3c9ba5e0ed", "ReplacementTerm", null, "Link to a glossary term that is replacing an obsolete glossary term.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "replacedTerms";
        String end1AttributeDescription = "Replaced glossary terms.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "replacedTerms", "Replaced glossary terms.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "replacementTerms";
        String end2AttributeDescription = "Replacement glossary terms.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "replacementTerms", "Replacement glossary terms.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "expression";
        String attribute2Description = "An expression that explains the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expression", "An expression that explains the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getTranslationRelationship() {
        String guid = "6ae42e95-efc5-4256-bfa8-801140a29d2a";
        String name = "Translation";
        String description = "Link between glossary terms that provide different natural language translation of the same concept.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("6ae42e95-efc5-4256-bfa8-801140a29d2a", "Translation", null, "Link between glossary terms that provide different natural language translation of the same concept.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "translations";
        String end1AttributeDescription = "Translations of glossary term.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "translations", "Translations of glossary term.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "translations";
        String end2AttributeDescription = "Translations of glossary term.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "translations", "Translations of glossary term.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "expression";
        String attribute2Description = "An expression that explains the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expression", "An expression that explains the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getISARelationshipRelationship() {
        String guid = "50fab7c7-68bc-452f-b8eb-ec76829cac85";
        String name = "ISARelationship";
        String description = "Link between a more general glossary term and a more specific definition.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("50fab7c7-68bc-452f-b8eb-ec76829cac85", "ISARelationship", null, "Link between a more general glossary term and a more specific definition.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "classifies";
        String end1AttributeDescription = "More specific glossary terms.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "classifies", "More specific glossary terms.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "isA";
        String end2AttributeDescription = "More general glossary terms.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "isA", "More general glossary terms.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "expression";
        String attribute2Description = "An expression that explains the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expression", "An expression that explains the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getValidValueRelationship() {
        String guid = "707a156b-e579-4482-89a5-de5889da1971";
        String name = "ValidValue";
        String description = "Link between glossary terms where one defines one of the data values for the another.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("707a156b-e579-4482-89a5-de5889da1971", "ValidValue", null, "Link between glossary terms where one defines one of the data values for the another.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "validValueFor";
        String end1AttributeDescription = "Glossary terms for data items that can be set to this value.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "validValueFor", "Glossary terms for data items that can be set to this value.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "validValues";
        String end2AttributeDescription = "Glossary terms for data values that can be used with data items represented by this glossary term.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "validValues", "Glossary terms for data values that can be used with data items represented by this glossary term.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "expression";
        String attribute2Description = "An expression that explains the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expression", "An expression that explains the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0360Contexts() {
        this.archiveBuilder.addRelationshipDef(this.getUsedInContextRelationship());
        this.archiveBuilder.addClassificationDef(this.getContextDefinitionClassification());
    }

    private RelationshipDef getUsedInContextRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.USED_IN_CONTEXT.typeGUID, OpenMetadataType.USED_IN_CONTEXT.typeName, null, OpenMetadataType.USED_IN_CONTEXT.description, OpenMetadataType.USED_IN_CONTEXT.descriptionGUID, OpenMetadataType.USED_IN_CONTEXT.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "contextRelevantTerms";
        String end1AttributeDescription = "Glossary terms used in this specific context.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "contextRelevantTerms", "Glossary terms used in this specific context.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "usedInContexts";
        String end2AttributeDescription = "Glossary terms describing the contexts where this term is used.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "usedInContexts", "Glossary terms describing the contexts where this term is used.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "expression";
        String attribute2Description = "An expression that explains the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expression", "An expression that explains the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getContextDefinitionClassification() {
        String guid = "54f9f41a-3871-4650-825d-59a41de01330";
        String name = "ContextDefinition";
        String description = "Identifies a glossary term that describes a context where processing or decisions occur.";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryTerm";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("54f9f41a-3871-4650-825d-59a41de01330", "ContextDefinition", null, "Identifies a glossary term that describes a context where processing or decisions occur.", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryTerm"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "scope";
        String attribute2Description = "Scope of influence of the context.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("scope", "Scope of influence of the context.", attribute2DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0370SemanticAssignment() {
        this.archiveBuilder.addEnumDef(this.getTermAssignmentStatusEnum());
        this.archiveBuilder.addRelationshipDef(this.getSemanticAssignmentRelationship());
    }

    private EnumDef getTermAssignmentStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(GlossaryTermAssignmentStatus.getOpenTypeGUID(), GlossaryTermAssignmentStatus.getOpenTypeName(), GlossaryTermAssignmentStatus.getOpenTypeDescription(), GlossaryTermAssignmentStatus.getOpenTypeDescriptionGUID(), GlossaryTermAssignmentStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (GlossaryTermAssignmentStatus enumValues : GlossaryTermAssignmentStatus.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private RelationshipDef getSemanticAssignmentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.SEMANTIC_ASSIGNMENT.typeGUID, OpenMetadataType.SEMANTIC_ASSIGNMENT.typeName, null, OpenMetadataType.SEMANTIC_ASSIGNMENT.description, OpenMetadataType.SEMANTIC_ASSIGNMENT.descriptionGUID, OpenMetadataType.SEMANTIC_ASSIGNMENT.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "assignedElements";
        String end1AttributeDescription = "Elements identified as managing data that has the same meaning as this glossary term.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "assignedElements", "Elements identified as managing data that has the same meaning as this glossary term.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Glossary";
        String end2AttributeName = "meaning";
        String end2AttributeDescription = "Semantic definition for this element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Glossary"), "meaning", "Semantic definition for this element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = "expression";
        String attribute2Description = "Expression describing the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.TERM_ASSIGNMENT_STATUS.name;
        String attribute3Description = OpenMetadataProperty.TERM_ASSIGNMENT_STATUS.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.TERM_ASSIGNMENT_STATUS.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.CONFIDENCE.name;
        String attribute4Description = OpenMetadataProperty.CONFIDENCE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.CONFIDENCE.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.STEWARD.name;
        String attribute5Description = OpenMetadataProperty.STEWARD.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute6Name = OpenMetadataProperty.SOURCE.name;
        String attribute6Description = OpenMetadataProperty.SOURCE.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("expression", "Expression describing the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermAssignmentStatus.getOpenTypeName(), attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0380SpineObjects() {
        this.archiveBuilder.addRelationshipDef(this.getTermHASARelationshipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTermISATYPEOFRelationshipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getTermTYPEDBYRelationshipRelationship());
        this.archiveBuilder.addClassificationDef(this.getSpineObjectClassification());
        this.archiveBuilder.addClassificationDef(this.getSpineAttributeClassification());
        this.archiveBuilder.addClassificationDef(this.getObjectIdentifierClassification());
    }

    private RelationshipDef getTermHASARelationshipRelationship() {
        String guid = "d67f16d1-5348-419e-ba38-b0bb6fe4ad6c";
        String name = "TermHASARelationship";
        String description = "Defines the relationship between a spine object and a spine attribute.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("d67f16d1-5348-419e-ba38-b0bb6fe4ad6c", "TermHASARelationship", null, "Defines the relationship between a spine object and a spine attribute.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "objects";
        String end1AttributeDescription = "Objects where this attribute may occur.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "objects", "Objects where this attribute may occur.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "attributes";
        String end2AttributeDescription = "Typical attributes for this object.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "attributes", "Typical attributes for this object.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getTermISATYPEOFRelationshipRelationship() {
        String guid = "d5d588c3-46c9-420c-adff-6031802a7e51";
        String name = "TermISATypeOFRelationship";
        String description = "Defines an inheritance relationship between two spine objects.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("d5d588c3-46c9-420c-adff-6031802a7e51", "TermISATypeOFRelationship", null, "Defines an inheritance relationship between two spine objects.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "supertypes";
        String end1AttributeDescription = "Supertypes for this object.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "supertypes", "Supertypes for this object.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "subtypes";
        String end2AttributeDescription = "Subtypes for this object.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "subtypes", "Subtypes for this object.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getTermTYPEDBYRelationshipRelationship() {
        String guid = "669e8aa4-c671-4ee7-8d03-f37d09b9d006";
        String name = "TermTYPEDBYRelationship";
        String description = "Defines the relationship between a spine attribute and its type.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("669e8aa4-c671-4ee7-8d03-f37d09b9d006", "TermTYPEDBYRelationship", null, "Defines the relationship between a spine attribute and its type.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GlossaryTerm";
        String end1AttributeName = "attributesTypedBy";
        String end1AttributeDescription = "Attributes of this type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "attributesTypedBy", "Attributes of this type.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GlossaryTerm";
        String end2AttributeName = "types";
        String end2AttributeDescription = "Types for this attribute.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GlossaryTerm"), "types", "Types for this attribute.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "status";
        String attribute3Description = "The status of or confidence in the relationship.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.STEWARD.name;
        String attribute4Description = OpenMetadataProperty.STEWARD.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.SOURCE.name;
        String attribute5Description = OpenMetadataProperty.SOURCE.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute(GlossaryTermRelationshipStatus.getOpenTypeName(), "status", "The status of or confidence in the relationship.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getSpineObjectClassification() {
        String guid = "a41ee152-de1e-4533-8535-2f8b37897cac";
        String name = "SpineObject";
        String description = "Identifies a glossary term that describes a type of spine object.";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryTerm";
        return this.archiveHelper.getClassificationDef("a41ee152-de1e-4533-8535-2f8b37897cac", "SpineObject", null, "Identifies a glossary term that describes a type of spine object.", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryTerm"), false);
    }

    private ClassificationDef getSpineAttributeClassification() {
        String guid = "ccb749ba-34ec-4f71-8755-4d8b383c34c3";
        String name = "SpineAttribute";
        String description = "Identifies a glossary term that describes an attribute of a spine object.";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryTerm";
        return this.archiveHelper.getClassificationDef("ccb749ba-34ec-4f71-8755-4d8b383c34c3", "SpineAttribute", null, "Identifies a glossary term that describes an attribute of a spine object.", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryTerm"), false);
    }

    private ClassificationDef getObjectIdentifierClassification() {
        String guid = "3d1e4389-27de-44fa-8df4-d57bfaf809ea";
        String name = "ObjectIdentifier";
        String description = "Identifies a glossary term that describes an attribute that can be used to identify an instance.";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryTerm";
        return this.archiveHelper.getClassificationDef("3d1e4389-27de-44fa-8df4-d57bfaf809ea", "ObjectIdentifier", null, "Identifies a glossary term that describes an attribute that can be used to identify an instance.", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryTerm"), false);
    }

    private void add0385ControlledGlossaryDevelopment() {
        this.archiveBuilder.addEntityDef(this.getControlledGlossaryTermEntity());
    }

    private EntityDef getControlledGlossaryTermEntity() {
        String guid = "c04e29b2-2d66-48fc-a20d-e59895de6040";
        String name = "ControlledGlossaryTerm";
        String description = "Defines a glossary term that is developed through a controlled workflow.";
        String descriptionGUID = null;
        String superTypeName = "GlossaryTerm";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("c04e29b2-2d66-48fc-a20d-e59895de6040", "ControlledGlossaryTerm", this.archiveBuilder.getEntityDef("GlossaryTerm"), "Defines a glossary term that is developed through a controlled workflow.", descriptionGUID);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private void add0390GlossaryProject() {
        this.archiveBuilder.addClassificationDef(this.getGlossaryProjectClassification());
    }

    private ClassificationDef getGlossaryProjectClassification() {
        String guid = "43be51a9-2d19-4044-b399-3ba36af10929";
        String name = "GlossaryProject";
        String description = "Identifies a project that is defining new glossary terms and categories or maintaining an existing glossary.";
        String descriptionGUID = null;
        String linkedToEntity = "Project";
        return this.archiveHelper.getClassificationDef("43be51a9-2d19-4044-b399-3ba36af10929", "GlossaryProject", null, "Identifies a project that is defining new glossary terms and categories or maintaining an existing glossary.", descriptionGUID, this.archiveBuilder.getEntityDef("Project"), false);
    }

    private void addArea4Types() {
        this.add0401GovernanceDefinitions();
        this.add0405GovernanceDrivers();
        this.add0415GovernanceResponses();
        this.add0417GovernanceProject();
        this.add0420GovernanceControls();
        this.add0421GovernanceConfidentialityLevels();
        this.add0422GovernanceActionClassifications();
        this.add0423SecurityTags();
        this.add0424GovernanceZones();
        this.add0430TechnicalControls();
        this.add0438NamingStandards();
        this.add0440OrganizationalControls();
        this.add0442ProjectCharter();
        this.add0445GovernanceRoles();
        this.add0450GovernanceRollout();
        this.add0455ExceptionManagement();
        this.add0460GovernanceControls();
        this.add0481Licenses();
        this.add0482Certifications();
    }

    private void add0401GovernanceDefinitions() {
        this.archiveBuilder.addEnumDef(this.getGovernanceDomainEnum());
        this.archiveBuilder.addEntityDef(this.getGovernanceDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceOfficerEntity());
    }

    private EnumDef getGovernanceDomainEnum() {
        String guid = "baa31998-f3cb-47b0-9123-674a701e87bc";
        String name = "GovernanceDomain";
        String description = "Defines the governance domains that open metadata seeks to unite.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("baa31998-f3cb-47b0-9123-674a701e87bc", "GovernanceDomain", "Defines the governance domains that open metadata seeks to unite.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "All";
        String element1Description = "Relevant to all governance domains.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "All", "Relevant to all governance domains.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Data";
        String element2Description = "The data (information) governance domain.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Data", "The data (information) governance domain.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Privacy";
        String element3Description = "The data privacy domain.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Privacy", "The data privacy domain.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "Security";
        String element4Description = "The security governance domain.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "Security", "The security governance domain.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 4;
        String element5Value = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        String element5Description = "The IT infrastructure governance domain.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(4, element5Value, "The IT infrastructure governance domain.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        int element6Ordinal = 5;
        String element6Value = "SoftwareDevelopment";
        String element6Description = "The software development lifecycle governance domain.";
        String element6DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(5, "SoftwareDevelopment", "The software development lifecycle governance domain.", element6DescriptionGUID);
        elementDefs.add(elementDef);
        int element7Ordinal = 6;
        String element7Value = "Corporate";
        String element7Description = "The corporate governance domain.";
        String element7DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(6, "Corporate", "The corporate governance domain.", element7DescriptionGUID);
        elementDefs.add(elementDef);
        int element8Ordinal = 7;
        String element8Value = "AssetManagement";
        String element8Description = "The physical asset management governance domain.";
        String element8DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(7, "AssetManagement", "The physical asset management governance domain.", element8DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another governance domain.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another governance domain.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getGovernanceDefinitionEntity() {
        String guid = "578a3500-9ad3-45fe-8ada-e4e9572c37c8";
        String name = "GovernanceDefinition";
        String description = "Defines an aspect of the governance program.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("578a3500-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceDefinition", this.archiveBuilder.getEntityDef(superTypeName), "Defines an aspect of the governance program.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "title";
        String attribute1Description = "Title describing the governance definition.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "summary";
        String attribute2Description = "Short summary of the governance definition.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute3Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute4Name = "scope";
        String attribute4Description = "Scope of impact for this governance definition.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "domain";
        String attribute5Description = "Governance domain for this governance definition.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "importance";
        String attribute6Description = "Relative importance of this governance definition compared to its peers.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "implications";
        String attribute7Description = "Impact on the organization, people and services when adopting the recommendation in this governance definition.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "outcomes";
        String attribute8Description = "Expected outcomes.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "results";
        String attribute9Description = "Actual results.";
        String attribute9DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("title", "Title describing the governance definition.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("summary", "Short summary of the governance definition.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("scope", "Scope of impact for this governance definition.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Governance domain for this governance definition.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("importance", "Relative importance of this governance definition compared to its peers.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("implications", "Impact on the organization, people and services when adopting the recommendation in this governance definition.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("outcomes", "Expected outcomes.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("results", "Actual results.", attribute9DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        ArrayList<InstanceStatus> validInstanceStatusList = new ArrayList<InstanceStatus>();
        validInstanceStatusList.add(InstanceStatus.DRAFT);
        validInstanceStatusList.add(InstanceStatus.PROPOSED);
        validInstanceStatusList.add(InstanceStatus.APPROVED);
        validInstanceStatusList.add(InstanceStatus.ACTIVE);
        validInstanceStatusList.add(InstanceStatus.DEPRECATED);
        validInstanceStatusList.add(InstanceStatus.OTHER);
        validInstanceStatusList.add(InstanceStatus.DELETED);
        entityDef.setValidInstanceStatusList(validInstanceStatusList);
        entityDef.setInitialStatus(InstanceStatus.DRAFT);
        return entityDef;
    }

    private EntityDef getGovernanceOfficerEntity() {
        String guid = "578a3510-9ad3-45fe-8ada-e4e9572c37c8";
        String name = "GovernanceOfficer";
        String description = "Person responsible for a governance domain.";
        String descriptionGUID = null;
        String superTypeName = "PersonRole";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("578a3510-9ad3-45fe-8ada-e4e9572c37c8", "GovernanceOfficer", this.archiveBuilder.getEntityDef("PersonRole"), "Person responsible for a governance domain.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "domain";
        String attribute1Description = "Governance domain for this governance officer.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Governance domain for this governance officer.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0405GovernanceDrivers() {
        this.archiveBuilder.addEntityDef(this.getGovernanceDriverEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceStrategyEntity());
        this.archiveBuilder.addEntityDef(this.getRegulationEntity());
    }

    private EntityDef getGovernanceDriverEntity() {
        String guid = "c403c109-7b6b-48cd-8eee-df445b258b33";
        String name = "GovernanceDriver";
        String description = "Defines a reason for having the governance program.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceDefinition";
        return this.archiveHelper.getDefaultEntityDef("c403c109-7b6b-48cd-8eee-df445b258b33", "GovernanceDriver", this.archiveBuilder.getEntityDef("GovernanceDefinition"), "Defines a reason for having the governance program.", descriptionGUID);
    }

    private EntityDef getGovernanceStrategyEntity() {
        String guid = "3c34f121-07a6-4e95-a07d-9b0ef17b7bbf";
        String name = "GovernanceStrategy";
        String description = "Defines how the governance program and the supporting capabilities are supporting the business strategy.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceDriver";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("3c34f121-07a6-4e95-a07d-9b0ef17b7bbf", "GovernanceStrategy", this.archiveBuilder.getEntityDef("GovernanceDriver"), "Defines how the governance program and the supporting capabilities are supporting the business strategy.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "businessImperatives";
        String attribute1Description = "Goals or required outcomes from the business strategy that is supported by the data strategy.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute("businessImperatives", "Goals or required outcomes from the business strategy that is supported by the data strategy.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getRegulationEntity() {
        String guid = "e3c4293d-8846-4500-b0c0-197d73aba8b0";
        String name = "Regulation";
        String description = "Identifies a regulation related to data that must be supported.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceDriver";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("e3c4293d-8846-4500-b0c0-197d73aba8b0", "Regulation", this.archiveBuilder.getEntityDef("GovernanceDriver"), "Identifies a regulation related to data that must be supported.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "jurisdiction";
        String attribute1Description = "Issuing authority for the regulation.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("jurisdiction", "Issuing authority for the regulation.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0415GovernanceResponses() {
        this.archiveBuilder.addEntityDef(this.getGovernancePolicyEntity());
        this.archiveBuilder.addEntityDef(this.getGovernancePrincipleEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceObligationEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceApproachEntity());
        this.archiveBuilder.addRelationshipDef(this.getGovernancePolicyLinkRelationship());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceResponseRelationship());
    }

    private EntityDef getGovernancePolicyEntity() {
        String guid = "a7defa41-9cfa-4be5-9059-359022bb016d";
        String name = "GovernancePolicy";
        String description = "Defines a goal or outcome expected from the organization.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceDefinition";
        return this.archiveHelper.getDefaultEntityDef("a7defa41-9cfa-4be5-9059-359022bb016d", "GovernancePolicy", this.archiveBuilder.getEntityDef("GovernanceDefinition"), "Defines a goal or outcome expected from the organization.", descriptionGUID);
    }

    private EntityDef getGovernancePrincipleEntity() {
        String guid = "3b7d1325-ec2c-44cb-8db0-ce207beb78cf";
        String name = "GovernancePrinciple";
        String description = "Defines a principle related to how data is managed or used that the organization should ensure remains true.";
        String descriptionGUID = null;
        String superTypeName = "GovernancePolicy";
        return this.archiveHelper.getDefaultEntityDef("3b7d1325-ec2c-44cb-8db0-ce207beb78cf", "GovernancePrinciple", this.archiveBuilder.getEntityDef("GovernancePolicy"), "Defines a principle related to how data is managed or used that the organization should ensure remains true.", descriptionGUID);
    }

    private EntityDef getGovernanceObligationEntity() {
        String guid = "0cec20d3-aa29-41b7-96ea-1c544ed32537";
        String name = "GovernanceObligation";
        String description = "Defines a capability, rule or action that is required by a regulation or external party.";
        String descriptionGUID = null;
        String superTypeName = "GovernancePolicy";
        return this.archiveHelper.getDefaultEntityDef("0cec20d3-aa29-41b7-96ea-1c544ed32537", "GovernanceObligation", this.archiveBuilder.getEntityDef("GovernancePolicy"), "Defines a capability, rule or action that is required by a regulation or external party.", descriptionGUID);
    }

    private EntityDef getGovernanceApproachEntity() {
        String guid = "2d03ec9d-bd6b-4be9-8e17-95a7ecdbaa67";
        String name = "GovernanceApproach";
        String description = "Defines a preferred approach to managing or using data.";
        String descriptionGUID = null;
        String superTypeName = "GovernancePolicy";
        return this.archiveHelper.getDefaultEntityDef("2d03ec9d-bd6b-4be9-8e17-95a7ecdbaa67", "GovernanceApproach", this.archiveBuilder.getEntityDef("GovernancePolicy"), "Defines a preferred approach to managing or using data.", descriptionGUID);
    }

    private RelationshipDef getGovernancePolicyLinkRelationship() {
        String guid = "0c42c999-4cac-4da4-afab-0e381f3a818e";
        String name = "GovernancePolicyLink";
        String description = "Links related governance policies together.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("0c42c999-4cac-4da4-afab-0e381f3a818e", "GovernancePolicyLink", null, "Links related governance policies together.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernancePolicy";
        String end1AttributeName = "linkingPolicies";
        String end1AttributeDescription = "Policies that are dependent on this policy.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernancePolicy"), "linkingPolicies", "Policies that are dependent on this policy.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernancePolicy";
        String end2AttributeName = "linkedPolicies";
        String end2AttributeDescription = "Policies that further define aspects of this policy.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernancePolicy"), "linkedPolicies", "Policies that further define aspects of this policy.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getGovernanceResponseRelationship() {
        String guid = "8845990e-7fd9-4b79-a19d-6c4730dadd6b";
        String name = "GovernanceResponse";
        String description = "Links a governance policy to a governance driver that it is supporting.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("8845990e-7fd9-4b79-a19d-6c4730dadd6b", "GovernanceResponse", null, "Links a governance policy to a governance driver that it is supporting.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceDriver";
        String end1AttributeName = "drivers";
        String end1AttributeDescription = "Drivers that justify this policy.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceDriver"), "drivers", "Drivers that justify this policy.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernancePolicy";
        String end2AttributeName = "policies";
        String end2AttributeDescription = "Governance policies that support this governance driver.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernancePolicy"), "policies", "Governance policies that support this governance driver.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "rationale";
        String attribute1Description = "Describes the reasoning for defining the policy in support of the driver.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("rationale", "Describes the reasoning for defining the policy in support of the driver.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0417GovernanceProject() {
        this.archiveBuilder.addClassificationDef(this.getGovernanceProjectClassification());
    }

    private ClassificationDef getGovernanceProjectClassification() {
        String guid = "37142317-4125-4046-9514-71dc5031563f";
        String name = "GovernanceProject";
        String description = "Identifies that a project is rolling out capability to support the governance program.";
        String descriptionGUID = null;
        String linkedToEntity = "Project";
        return this.archiveHelper.getClassificationDef("37142317-4125-4046-9514-71dc5031563f", "GovernanceProject", null, "Identifies that a project is rolling out capability to support the governance program.", descriptionGUID, this.archiveBuilder.getEntityDef("Project"), false);
    }

    private void add0420GovernanceControls() {
        this.archiveBuilder.addEntityDef(this.getGovernanceControlEntity());
        this.archiveBuilder.addEntityDef(this.getTechnicalControlEntity());
        this.archiveBuilder.addEntityDef(this.getOrganizationalControlEntity());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceImplementationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceControlLinkRelationship());
    }

    private EntityDef getGovernanceControlEntity() {
        String guid = "c794985e-a10b-4b6c-9dc2-6b2e0a2901d3";
        String name = "GovernanceControl";
        String description = "An implementation of a governance capability.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceDefinition";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("c794985e-a10b-4b6c-9dc2-6b2e0a2901d3", "GovernanceControl", this.archiveBuilder.getEntityDef("GovernanceDefinition"), "An implementation of a governance capability.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "implementationDescription";
        String attribute1Description = "Description of how this governance control should be implemented.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("implementationDescription", "Description of how this governance control should be implemented.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getTechnicalControlEntity() {
        String guid = "d8f6eb5b-36f0-49bd-9b25-bf16f370d1ec";
        String name = "TechnicalControl";
        String description = "A governance control that is implemented using technology.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceControl";
        return this.archiveHelper.getDefaultEntityDef("d8f6eb5b-36f0-49bd-9b25-bf16f370d1ec", "TechnicalControl", this.archiveBuilder.getEntityDef("GovernanceControl"), "A governance control that is implemented using technology.", descriptionGUID);
    }

    private EntityDef getOrganizationalControlEntity() {
        String guid = "befa1458-79b8-446a-b813-536700e60fa8";
        String name = "OrganizationalControl";
        String description = "A governance control that is implemented using organization structure, training, roles manual procedures and reviews.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceControl";
        return this.archiveHelper.getDefaultEntityDef("befa1458-79b8-446a-b813-536700e60fa8", "OrganizationalControl", this.archiveBuilder.getEntityDef("GovernanceControl"), "A governance control that is implemented using organization structure, training, roles manual procedures and reviews.", descriptionGUID);
    }

    private RelationshipDef getGovernanceImplementationRelationship() {
        String guid = "787eaf46-7cf2-4096-8d6e-671a0819d57e";
        String name = "GovernanceImplementation";
        String description = "A link between a governance control and the governance driver it is implementing.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("787eaf46-7cf2-4096-8d6e-671a0819d57e", "GovernanceImplementation", null, "A link between a governance control and the governance driver it is implementing.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernancePolicy";
        String end1AttributeName = "policies";
        String end1AttributeDescription = "The policies that are supported by this control.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernancePolicy"), "policies", "The policies that are supported by this control.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceControl";
        String end2AttributeName = "implementations";
        String end2AttributeDescription = "The governance controls that implement this policy.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceControl"), "implementations", "The governance controls that implement this policy.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "rationale";
        String attribute1Description = "The reasons for implementing the policy using this control.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("rationale", "The reasons for implementing the policy using this control.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getGovernanceControlLinkRelationship() {
        String guid = "806933fb-7925-439b-9876-922a960d2ba1";
        String name = "GovernanceControlLink";
        String description = "A link between two related governance controls.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("806933fb-7925-439b-9876-922a960d2ba1", "GovernanceControlLink", null, "A link between two related governance controls.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceControl";
        String end1AttributeName = "linkingControls";
        String end1AttributeDescription = "Governance controls that ate dependent on this control.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceControl"), "linkingControls", "Governance controls that ate dependent on this control.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceControl";
        String end2AttributeName = "linkedControls";
        String end2AttributeDescription = "Governance controls that support the implementation of this control.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceControl"), "linkedControls", "Governance controls that support the implementation of this control.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0421GovernanceConfidentialityLevels() {
        this.archiveBuilder.addEntityDef(this.getGovernanceConfidentialityLevelEntity());
    }

    private EntityDef getGovernanceConfidentialityLevelEntity() {
        String guid = "49dd320b-4850-4838-9b78-f1285f0e6d2f";
        String name = "GovernanceConfidentialityLevel";
        String description = "A definition of a confidentiality level.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("49dd320b-4850-4838-9b78-f1285f0e6d2f", "GovernanceConfidentialityLevel", this.archiveBuilder.getEntityDef(superTypeName), "A definition of a confidentiality level.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "level";
        String attribute1Description = "Numeric value for the confidentiality - the higher the number, the more confidential";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute2Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute3Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("level", "Numeric value for the confidentiality - the higher the number, the more confidential", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0422GovernanceActionClassifications() {
        this.archiveBuilder.addEnumDef(this.getGovernanceClassificationStatusEnum());
        this.archiveBuilder.addEnumDef(this.getConfidentialityLevelEnum());
        this.archiveBuilder.addEnumDef(this.getConfidenceLevelEnum());
        this.archiveBuilder.addEnumDef(this.getRetentionBasisEnum());
        this.archiveBuilder.addEnumDef(this.getCriticalityLevelEnum());
        this.archiveBuilder.addClassificationDef(this.getConfidentialityClassification());
        this.archiveBuilder.addClassificationDef(this.getConfidenceClassification());
        this.archiveBuilder.addClassificationDef(this.getRetentionClassification());
        this.archiveBuilder.addClassificationDef(this.getCriticalityClassification());
    }

    private EnumDef getGovernanceClassificationStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(GovernanceClassificationStatus.getOpenTypeGUID(), GovernanceClassificationStatus.getOpenTypeName(), GovernanceClassificationStatus.getOpenTypeDescription(), GovernanceClassificationStatus.getOpenTypeDescriptionGUID(), GovernanceClassificationStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CriticalityLevel enumValues : CriticalityLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getConfidentialityLevelEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ConfidentialityLevel.getOpenTypeGUID(), ConfidentialityLevel.getOpenTypeName(), ConfidentialityLevel.getOpenTypeDescription(), ConfidentialityLevel.getOpenTypeDescriptionGUID(), ConfidentialityLevel.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ConfidentialityLevel enumValues : ConfidentialityLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getConfidenceLevelEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(ConfidenceLevel.getOpenTypeGUID(), ConfidenceLevel.getOpenTypeName(), ConfidenceLevel.getOpenTypeDescription(), ConfidenceLevel.getOpenTypeDescriptionGUID(), ConfidenceLevel.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (ConfidenceLevel enumValues : ConfidenceLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getRetentionBasisEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(RetentionBasis.getOpenTypeGUID(), RetentionBasis.getOpenTypeName(), RetentionBasis.getOpenTypeDescription(), RetentionBasis.getOpenTypeDescriptionGUID(), RetentionBasis.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (RetentionBasis enumValues : RetentionBasis.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getCriticalityLevelEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(CriticalityLevel.getOpenTypeGUID(), CriticalityLevel.getOpenTypeName(), CriticalityLevel.getOpenTypeDescription(), CriticalityLevel.getOpenTypeDescriptionGUID(), CriticalityLevel.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CriticalityLevel enumValues : CriticalityLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef getConfidentialityClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.typeName, null, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.description, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.descriptionGUID, OpenMetadataType.CONFIDENTIALITY_CLASSIFICATION.wikiURL, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "Status of this classification.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.CONFIDENCE.name;
        String attribute2Description = OpenMetadataProperty.CONFIDENCE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.CONFIDENCE.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.STEWARD.name;
        String attribute3Description = OpenMetadataProperty.STEWARD.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.SOURCE.name;
        String attribute4Description = OpenMetadataProperty.SOURCE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.NOTES.name;
        String attribute5Description = OpenMetadataProperty.NOTES.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.NOTES.descriptionGUID;
        String attribute6Name = "level";
        String attribute6Description = "Level of confidentiality.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Status of this classification.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("level", "Level of confidentiality.", attribute6DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getConfidenceClassification() {
        String guid = "25d8f8d5-2998-4983-b9ef-265f58732965";
        String name = "Confidence";
        String description = "Defines the level of confidence that should be placed in the accuracy of related data items.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("25d8f8d5-2998-4983-b9ef-265f58732965", "Confidence", null, "Defines the level of confidence that should be placed in the accuracy of related data items.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "Status of this classification.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.CONFIDENCE.name;
        String attribute2Description = OpenMetadataProperty.CONFIDENCE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.CONFIDENCE.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.STEWARD.name;
        String attribute3Description = OpenMetadataProperty.STEWARD.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.SOURCE.name;
        String attribute4Description = OpenMetadataProperty.SOURCE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.NOTES.name;
        String attribute5Description = OpenMetadataProperty.NOTES.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.NOTES.descriptionGUID;
        String attribute6Name = "level";
        String attribute6Description = "Level of confidence in the quality of this data.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Status of this classification.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("ConfidenceLevel", "level", "Level of confidence in the quality of this data.", attribute6DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getRetentionClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.RETENTION_CLASSIFICATION.typeGUID, OpenMetadataType.RETENTION_CLASSIFICATION.typeName, null, OpenMetadataType.RETENTION_CLASSIFICATION.description, OpenMetadataType.RETENTION_CLASSIFICATION.descriptionGUID, OpenMetadataType.RETENTION_CLASSIFICATION.wikiURL, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "Status of this classification.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.CONFIDENCE.name;
        String attribute2Description = OpenMetadataProperty.CONFIDENCE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.CONFIDENCE.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.STEWARD.name;
        String attribute3Description = OpenMetadataProperty.STEWARD.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.SOURCE.name;
        String attribute4Description = OpenMetadataProperty.SOURCE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.NOTES.name;
        String attribute5Description = OpenMetadataProperty.NOTES.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.NOTES.descriptionGUID;
        String attribute6Name = "basis";
        String attribute6Description = "Basis on which the retention period is defined.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "associatedGUID";
        String attribute7Description = "Related entity used to determine the retention period.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "archiveAfter";
        String attribute8Description = "Date when archiving can take place.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "deleteAfter";
        String attribute9Description = "Date when delete can take place.";
        String attribute9DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Status of this classification.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("RetentionBasis", "basis", "Basis on which the retention period is defined.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("associatedGUID", "Related entity used to determine the retention period.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("archiveAfter", "Date when archiving can take place.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("deleteAfter", "Date when delete can take place.", attribute9DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getCriticalityClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.CRITICALITY_CLASSIFICATION.typeGUID, OpenMetadataType.CRITICALITY_CLASSIFICATION.typeName, null, OpenMetadataType.CRITICALITY_CLASSIFICATION.description, OpenMetadataType.CRITICALITY_CLASSIFICATION.descriptionGUID, OpenMetadataType.CRITICALITY_CLASSIFICATION.wikiURL, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "status";
        String attribute1Description = "Status of this classification.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.CONFIDENCE.name;
        String attribute2Description = OpenMetadataProperty.CONFIDENCE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.CONFIDENCE.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.STEWARD.name;
        String attribute3Description = OpenMetadataProperty.STEWARD.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.SOURCE.name;
        String attribute4Description = OpenMetadataProperty.SOURCE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.NOTES.name;
        String attribute5Description = OpenMetadataProperty.NOTES.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.NOTES.descriptionGUID;
        String attribute6Name = "level";
        String attribute6Description = "How critical is this data to the organization.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceClassificationStatus", "status", "Status of this classification.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("CriticalityLevel", "level", "How critical is this data to the organization.", attribute6DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0423SecurityTags() {
        this.archiveBuilder.addClassificationDef(this.getSecurityTagsClassification());
    }

    private ClassificationDef getSecurityTagsClassification() {
        String guid = "a0b07a86-9fd3-40ca-bb9b-fe83c6981deb";
        String name = "SecurityTags";
        String description = "Defines labels and properties used by a security engine.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("a0b07a86-9fd3-40ca-bb9b-fe83c6981deb", "SecurityTags", null, "Defines labels and properties used by a security engine.", descriptionGUID, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "securityLabels";
        String attribute1Description = "Labels that apply to the referenceable.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "securityProperties";
        String attribute2Description = "Properties that apply to the referenceable.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute("securityLabels", "Labels that apply to the referenceable.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringObjectTypeDefAttribute("securityProperties", "Properties that apply to the referenceable.", attribute2DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0424GovernanceZones() {
        this.archiveBuilder.addClassificationDef(this.getAssetZoneMembershipClassification());
        this.archiveBuilder.addEntityDef(this.getGovernanceZoneEntity());
        this.archiveBuilder.addRelationshipDef(this.getZoneGovernanceRelationship());
        this.archiveBuilder.addRelationshipDef(this.getZoneHierarchyRelationship());
    }

    private ClassificationDef getAssetZoneMembershipClassification() {
        String guid = "a1c17a86-9fd3-40ca-bb9b-fe83c6981deb";
        String name = "AssetZoneMembership";
        String description = "Defines the asset's membership of the governance zones.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.ASSET.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("a1c17a86-9fd3-40ca-bb9b-fe83c6981deb", "AssetZoneMembership", null, "Defines the asset's membership of the governance zones.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "zoneMembership";
        String attribute1Description = "List of governance zones for the asset.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute("zoneMembership", "List of governance zones for the asset.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private EntityDef getGovernanceZoneEntity() {
        String guid = "290a192b-42a7-449a-935a-269ca62cfdac";
        String name = "GovernanceZone";
        String description = "Defines a collection of assets that are suitable for a particular usage or are governed by a particular process.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("290a192b-42a7-449a-935a-269ca62cfdac", "GovernanceZone", this.archiveBuilder.getEntityDef(superTypeName), "Defines a collection of assets that are suitable for a particular usage or are governed by a particular process.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "criteria";
        String attribute3Description = "Definition of the types of assets that belong in this zone.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("criteria", "Definition of the types of assets that belong in this zone.", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getZoneGovernanceRelationship() {
        String guid = "4c4d1d9c-a9fc-4305-8b71-4e891c0f9ae0";
        String name = "ZoneGovernance";
        String description = "Links a governance zone to a governance definition that applies to all of the members of the zone.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4c4d1d9c-a9fc-4305-8b71-4e891c0f9ae0", "ZoneGovernance", null, "Links a governance zone to a governance definition that applies to all of the members of the zone.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceZone";
        String end1AttributeName = "governedZones";
        String end1AttributeDescription = "The collections of assets governed by this definition.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceZone"), "governedZones", "The collections of assets governed by this definition.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceDefinition";
        String end2AttributeName = "governedBy";
        String end2AttributeDescription = "Governance definitions for this zone.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceDefinition"), "governedBy", "Governance definitions for this zone.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getZoneHierarchyRelationship() {
        String guid = "ee6cf469-cb4d-4c3b-a4c7-e2da1236d139";
        String name = "ZoneHierarchy";
        String description = "Creates a controlling hierarchy for governance zones.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("ee6cf469-cb4d-4c3b-a4c7-e2da1236d139", "ZoneHierarchy", null, "Creates a controlling hierarchy for governance zones.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceZone";
        String end1AttributeName = "inheritsFromZone";
        String end1AttributeDescription = "The zone that provides additional governance requirements.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceZone"), "inheritsFromZone", "The zone that provides additional governance requirements.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceZone";
        String end2AttributeName = "controlsZone";
        String end2AttributeDescription = "The zones that are also governed in the same way.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceZone"), "controlsZone", "The zones that are also governed in the same way.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0430TechnicalControls() {
        this.archiveBuilder.addEntityDef(this.getGovernanceRuleEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceProcessEntity());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceRuleImplementationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceProcessImplementationRelationship());
    }

    private EntityDef getGovernanceRuleEntity() {
        String guid = "8f954380-12ce-4a2d-97c6-9ebe250fecf8";
        String name = "GovernanceRule";
        String description = "Technical control expressed as a logic expression.";
        String descriptionGUID = null;
        String superTypeName = "TechnicalControl";
        return this.archiveHelper.getDefaultEntityDef("8f954380-12ce-4a2d-97c6-9ebe250fecf8", "GovernanceRule", this.archiveBuilder.getEntityDef("TechnicalControl"), "Technical control expressed as a logic expression.", descriptionGUID);
    }

    private EntityDef getGovernanceProcessEntity() {
        String guid = "b68b5d9d-6b79-4f3a-887f-ec0f81c54aea";
        String name = "GovernanceProcess";
        String description = "Technical control expressed as a sequence of tasks.";
        String descriptionGUID = null;
        String superTypeName = "TechnicalControl";
        return this.archiveHelper.getDefaultEntityDef("b68b5d9d-6b79-4f3a-887f-ec0f81c54aea", "GovernanceProcess", this.archiveBuilder.getEntityDef("TechnicalControl"), "Technical control expressed as a sequence of tasks.", descriptionGUID);
    }

    private RelationshipDef getGovernanceRuleImplementationRelationship() {
        String guid = "e701a5c8-c1ba-4b75-8257-e0a6569eda48";
        String name = "GovernanceRuleImplementation";
        String description = "Identifies the implementation of a governance rule.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e701a5c8-c1ba-4b75-8257-e0a6569eda48", "GovernanceRuleImplementation", null, "Identifies the implementation of a governance rule.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceRule";
        String end1AttributeName = "implementsGovernanceRules";
        String end1AttributeDescription = "The rules that are implemented by this component.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceRule"), "implementsGovernanceRules", "The rules that are implemented by this component.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DeployedSoftwareComponent";
        String end2AttributeName = "implementations";
        String end2AttributeDescription = "The software components that implement this governance rule.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DeployedSoftwareComponent"), "implementations", "The software components that implement this governance rule.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NOTES.name;
        String attribute1Description = OpenMetadataProperty.NOTES.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NOTES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getGovernanceProcessImplementationRelationship() {
        String guid = "a5a7b08a-73fd-4026-a9dd-d0fe55bea8a4";
        String name = "GovernanceProcessImplementation";
        String description = "Identifies the implementation of a governance process.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("a5a7b08a-73fd-4026-a9dd-d0fe55bea8a4", "GovernanceProcessImplementation", null, "Identifies the implementation of a governance process.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceProcess";
        String end1AttributeName = "implementsGovernanceProcesses";
        String end1AttributeDescription = "The processes that are implemented by this component.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceProcess"), "implementsGovernanceProcesses", "The processes that are implemented by this component.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.PROCESS.typeName;
        String end2AttributeName = "implementations";
        String end2AttributeDescription = "The processes that implement this governance process.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "implementations", "The processes that implement this governance process.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NOTES.name;
        String attribute1Description = OpenMetadataProperty.NOTES.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NOTES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0438NamingStandards() {
        this.archiveBuilder.addEntityDef(this.getNamingStandardRuleEntity());
        this.archiveBuilder.addEntityDef(this.getNamingStandardRuleSetEntity());
        this.archiveBuilder.addClassificationDef(this.getPrimeWordClassification());
        this.archiveBuilder.addClassificationDef(this.getClassWordClassification());
        this.archiveBuilder.addClassificationDef(this.getModifierClassification());
    }

    private EntityDef getNamingStandardRuleEntity() {
        String guid = "52505b06-98a5-481f-8a32-db9b02afabfc";
        String name = "NamingStandardRule";
        String description = "Describes a parsing rule used to create compliant names.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceRule";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("52505b06-98a5-481f-8a32-db9b02afabfc", "NamingStandardRule", this.archiveBuilder.getEntityDef("GovernanceRule"), "Describes a parsing rule used to create compliant names.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "namePattern";
        String attribute1Description = "Format of the naming standard rule.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("namePattern", "Format of the naming standard rule.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getNamingStandardRuleSetEntity() {
        String guid = "ba70f506-1f81-4890-bb4f-1cb1d99c939e";
        String name = "NamingStandardRuleSet";
        String description = "Describes a collection of related naming standard rules.";
        String descriptionGUID = null;
        String superTypeName = "Collection";
        return this.archiveHelper.getDefaultEntityDef("ba70f506-1f81-4890-bb4f-1cb1d99c939e", "NamingStandardRuleSet", this.archiveBuilder.getEntityDef("Collection"), "Describes a collection of related naming standard rules.", descriptionGUID);
    }

    private ClassificationDef getPrimeWordClassification() {
        String guid = "3ea1ea66-8923-4662-8628-0bacef3e9c5f";
        String name = "PrimeWord";
        String description = "Describes a primary noun, used in naming standards.";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryTerm";
        return this.archiveHelper.getClassificationDef("3ea1ea66-8923-4662-8628-0bacef3e9c5f", "PrimeWord", null, "Describes a primary noun, used in naming standards.", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryTerm"), false);
    }

    private ClassificationDef getClassWordClassification() {
        String guid = "feac4bd9-37d9-4437-82f6-618ce3e2793e";
        String name = "ClassWord";
        String description = "Describes classifying or grouping noun, using in naming standards.";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryTerm";
        return this.archiveHelper.getClassificationDef("feac4bd9-37d9-4437-82f6-618ce3e2793e", "ClassWord", null, "Describes classifying or grouping noun, using in naming standards.", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryTerm"), false);
    }

    private ClassificationDef getModifierClassification() {
        String guid = "dfc70bed-7e8b-4060-910c-59c7473f23a3";
        String name = "NamingConventionRule";
        String description = "Describes modifying noun or adverb, used in naming standards.";
        String descriptionGUID = null;
        String linkedToEntity = "GlossaryTerm";
        return this.archiveHelper.getClassificationDef("dfc70bed-7e8b-4060-910c-59c7473f23a3", "NamingConventionRule", null, "Describes modifying noun or adverb, used in naming standards.", descriptionGUID, this.archiveBuilder.getEntityDef("GlossaryTerm"), false);
    }

    private void add0440OrganizationalControls() {
        this.archiveBuilder.addEnumDef(this.getBusinessCapabilityTypeEnum());
        this.archiveBuilder.addEntityDef(this.getOrganizationEntity());
        this.archiveBuilder.addEntityDef(this.getBusinessCapabilityEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceResponsibilityEntity());
        this.archiveBuilder.addEntityDef(this.getGovernanceProcedureEntity());
        this.archiveBuilder.addClassificationDef(this.getAssetOriginClassification());
        this.archiveBuilder.addRelationshipDef(this.getOrganizationCapabilityRelationship());
        this.archiveBuilder.addRelationshipDef(this.getResponsibilityStaffContactRelationship());
        this.archiveBuilder.addRelationshipDef(this.getBusinessCapabilityControlsRelationship());
    }

    private EnumDef getBusinessCapabilityTypeEnum() {
        String guid = "fb7c40cf-8d95-48ff-ba8b-e22bff6f5a91";
        String name = "BusinessCapabilityType";
        String description = "Defines the type or category of business capability.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("fb7c40cf-8d95-48ff-ba8b-e22bff6f5a91", "BusinessCapabilityType", "Defines the type or category of business capability.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Unclassified";
        String element1Description = "The business capability has not been classified.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Unclassified", "The business capability has not been classified.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setDefaultValue(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "BusinessService";
        String element2Description = "A functional business capability.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "BusinessService", "A functional business capability.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "BusinessArea";
        String element3Description = "A collection of related business services.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "BusinessArea", "A collection of related business services.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another governance definition status.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another governance definition status.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getOrganizationEntity() {
        String guid = "50a61105-35be-4ee3-8b99-bdd958ed0685";
        String name = "Organization";
        String description = "Describes a specific organization.";
        String descriptionGUID = null;
        String superTypeName = "Team";
        return this.archiveHelper.getDefaultEntityDef("50a61105-35be-4ee3-8b99-bdd958ed0685", "Organization", this.archiveBuilder.getEntityDef("Team"), "Describes a specific organization.", descriptionGUID);
    }

    private EntityDef getBusinessCapabilityEntity() {
        String guid = "7cc6bcb2-b573-4719-9412-cf6c3f4bbb15";
        String name = "BusinessCapability";
        String description = "Describes a function, capability or skill set.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("7cc6bcb2-b573-4719-9412-cf6c3f4bbb15", "BusinessCapability", this.archiveBuilder.getEntityDef(superTypeName), "Describes a function, capability or skill set.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "type";
        String attribute1Description = "Type of business capability.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("BusinessCapabilityType", "type", "Type of business capability.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getGovernanceResponsibilityEntity() {
        String guid = "89a76b24-deb8-45bf-9304-a578a610326f";
        String name = "GovernanceResponsibility";
        String description = "Describes a responsibility of a person, team or organization that supports the implementation of a governance driver.";
        String descriptionGUID = null;
        String superTypeName = "OrganizationalControl";
        return this.archiveHelper.getDefaultEntityDef("89a76b24-deb8-45bf-9304-a578a610326f", "GovernanceResponsibility", this.archiveBuilder.getEntityDef("OrganizationalControl"), "Describes a responsibility of a person, team or organization that supports the implementation of a governance driver.", descriptionGUID);
    }

    private EntityDef getGovernanceProcedureEntity() {
        String guid = "69055d10-51dc-4c2b-b21f-d76fad3f8ef3";
        String name = "GovernanceProcedure";
        String description = "Describes set of tasks that a person, team or organization performs to support the implementation of a governance driver.";
        String descriptionGUID = null;
        String superTypeName = "OrganizationalControl";
        return this.archiveHelper.getDefaultEntityDef("69055d10-51dc-4c2b-b21f-d76fad3f8ef3", "GovernanceProcedure", this.archiveBuilder.getEntityDef("OrganizationalControl"), "Describes set of tasks that a person, team or organization performs to support the implementation of a governance driver.", descriptionGUID);
    }

    private ClassificationDef getAssetOriginClassification() {
        String guid = "e530c566-03d2-470a-be69-6f52bfbd5fb7";
        String name = "AssetOrigin";
        String description = "Describes the origin of an asset.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.ASSET.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("e530c566-03d2-470a-be69-6f52bfbd5fb7", "AssetOrigin", null, "Describes the origin of an asset.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "organization";
        String attribute1Description = "Unique identifier (GUID) of the organization where this asset originated from.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "businessCapability";
        String attribute2Description = "Unique identifier (GUID) of the business capability where this asset originated from.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "otherOriginValues";
        String attribute3Description = "Descriptive labels describing origin of the asset.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("organization", "Unique identifier (GUID) of the organization where this asset originated from.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("businessCapability", "Unique identifier (GUID) of the business capability where this asset originated from.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("otherOriginValues", "Descriptive labels describing origin of the asset.", attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private RelationshipDef getOrganizationCapabilityRelationship() {
        String guid = "47f0ad39-db77-41b0-b406-36b1598e0ba7";
        String name = "OrganizationalCapability";
        String description = "Describes the relationship between a team and the business capabilities it supports.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("47f0ad39-db77-41b0-b406-36b1598e0ba7", "OrganizationalCapability", null, "Describes the relationship between a team and the business capabilities it supports.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "BusinessCapability";
        String end1AttributeName = "supportsBusinessCapabilities";
        String end1AttributeDescription = "The business capabilities that this team supports.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("BusinessCapability"), "supportsBusinessCapabilities", "The business capabilities that this team supports.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Team";
        String end2AttributeName = "supportingTeams";
        String end2AttributeDescription = "The teams that support this business capability.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Team"), "supportingTeams", "The teams that support this business capability.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getResponsibilityStaffContactRelationship() {
        String guid = "49f2ecb5-6bf7-4324-9824-ac98d595c404";
        String name = "ResponsibilityStaffContact";
        String description = "Identifies a person, team or engine assigned to a governance responsibility.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("49f2ecb5-6bf7-4324-9824-ac98d595c404", "ResponsibilityStaffContact", null, "Identifies a person, team or engine assigned to a governance responsibility.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceResponsibility";
        String end1AttributeName = "contactFor";
        String end1AttributeDescription = "The governance responsibilities that this team or person is assigned to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceResponsibility"), "contactFor", "The governance responsibilities that this team or person is assigned to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ActorProfile";
        String end2AttributeName = "assignedStaff";
        String end2AttributeDescription = "The people, teams and/or engines that are supporting this governance responsibility.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ActorProfile"), "assignedStaff", "The people, teams and/or engines that are supporting this governance responsibility.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "context";
        String attribute1Description = "The context in which this person, team or engine is to be contacted.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("context", "The context in which this person, team or engine is to be contacted.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getBusinessCapabilityControlsRelationship() {
        String guid = "b5de932a-738c-4c69-b852-09fec2b9c678";
        String name = "BusinessCapabilityControls";
        String description = "Identifies a business capability that supports a governance control.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("b5de932a-738c-4c69-b852-09fec2b9c678", "BusinessCapabilityControls", null, "Identifies a business capability that supports a governance control.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceControl";
        String end1AttributeName = "implementsControls";
        String end1AttributeDescription = "The governance controls that this business capability supports.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceControl"), "implementsControls", "The governance controls that this business capability supports.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "BusinessCapability";
        String end2AttributeName = "affectedBusinessCapabilities";
        String end2AttributeDescription = "The business capabilities that implement or support this governance responsibility.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("BusinessCapability"), "affectedBusinessCapabilities", "The business capabilities that implement or support this governance responsibility.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "rationale";
        String attribute1Description = "Documents reasons for assigning the control to this business capability.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("rationale", "Documents reasons for assigning the control to this business capability.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0442ProjectCharter() {
        this.archiveBuilder.addEntityDef(this.getProjectCharterEntity());
        this.archiveBuilder.addRelationshipDef(this.getProjectCharterLinkRelationship());
    }

    private EntityDef getProjectCharterEntity() {
        String guid = "f96b5a32-42c1-4a74-8f77-70a81cec783d";
        String name = "ProjectCharter";
        String description = "Describes the goals, scope and authority of a project.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("f96b5a32-42c1-4a74-8f77-70a81cec783d", "ProjectCharter", this.archiveBuilder.getEntityDef(superTypeName), "Describes the goals, scope and authority of a project.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "mission";
        String attribute1Description = "The high-level goal of the project.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "projectType";
        String attribute2Description = "Short description of type of the project.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "purposes";
        String attribute3Description = "List of purposes for having the project.";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("mission", "The high-level goal of the project.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("projectType", "Short description of type of the project.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("purposes", "List of purposes for having the project.", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getProjectCharterLinkRelationship() {
        String guid = "f081808d-545a-41cb-a9aa-c4f074a16c78";
        String name = "ProjectCharterLink";
        String description = "Links a Project with its Charter.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("f081808d-545a-41cb-a9aa-c4f074a16c78", "ProjectCharterLink", null, "Links a Project with its Charter.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Project";
        String end1AttributeName = "projects";
        String end1AttributeDescription = "The projects guided by this charter.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Project"), "projects", "The projects guided by this charter.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ProjectCharter";
        String end2AttributeName = "charter";
        String end2AttributeDescription = "The charter guiding this project.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ProjectCharter"), "charter", "The charter guiding this project.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0445GovernanceRoles() {
        this.archiveBuilder.addClassificationDef(this.getAssetOwnershipClassification());
        this.archiveBuilder.addEntityDef(this.getGovernanceRoleEntity());
        this.archiveBuilder.addEntityDef(this.getAssetOwnerEntity());
        this.archiveBuilder.addEntityDef(this.getSubjectAreaOwnerEntity());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceRoleAssignmentRelationship());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceResponsibilityAssignmentRelationship());
    }

    private EnumDef getAssetOwnerTypeEnum() {
        String guid = "9548390c-69f5-4dc6-950d-6feeee257b56";
        String name = "AssetOwnerType";
        String description = "Defines the type of identifier for an asset's owner.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("9548390c-69f5-4dc6-950d-6feeee257b56", "AssetOwnerType", "Defines the type of identifier for an asset's owner.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "UserId";
        String element1Description = "The owner's userId is specified (default).";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "UserId", "The owner's userId is specified (default).", element1DescriptionGUID);
        elementDefs.add(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "ProfileId";
        String element2Description = "The unique identifier (guid) of the profile of the owner.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "ProfileId", "The unique identifier (guid) of the profile of the owner.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Other";
        String element99Description = "Another type of owner identifier, probably not supported by open metadata.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Other", "Another type of owner identifier, probably not supported by open metadata.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private ClassificationDef getAssetOwnershipClassification() {
        String guid = "d531c566-03d2-470a-be69-6f52cabd5fb9";
        String name = "AssetOwnership";
        String description = "Describes the ownership of an asset.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.ASSET.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("d531c566-03d2-470a-be69-6f52cabd5fb9", "AssetOwnership", null, "Describes the ownership of an asset.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "owner";
        String attribute1Description = "Identifier of the person or process that owns the asset.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "ownerType";
        String attribute2Description = "Type of identifier used for owner property.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("owner", "Identifier of the person or process that owns the asset.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("AssetOwnerType", "ownerType", "Type of identifier used for owner property.", attribute2DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private EntityDef getGovernanceRoleEntity() {
        String guid = "de2d7f2e-1759-44e3-b8a6-8af53e8fb0ee";
        String name = "GovernanceRole";
        String description = "Describes a set of goals, tasks and skills that can be assigned a person and contribute to the governance of a resource.";
        String descriptionGUID = null;
        String superTypeName = "PersonRole";
        return this.archiveHelper.getDefaultEntityDef("de2d7f2e-1759-44e3-b8a6-8af53e8fb0ee", "GovernanceRole", this.archiveBuilder.getEntityDef("PersonRole"), "Describes a set of goals, tasks and skills that can be assigned a person and contribute to the governance of a resource.", descriptionGUID);
    }

    private EntityDef getAssetOwnerEntity() {
        String guid = "ac406bf8-e53e-49f1-9088-2af28eeee285";
        String name = "AssetOwner";
        String description = "A role defining a responsibility to manage an asset.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceRole";
        return this.archiveHelper.getDefaultEntityDef("ac406bf8-e53e-49f1-9088-2af28eeee285", "AssetOwner", this.archiveBuilder.getEntityDef("GovernanceRole"), "A role defining a responsibility to manage an asset.", descriptionGUID);
    }

    private EntityDef getSubjectAreaOwnerEntity() {
        String guid = "c6fe40af-cdd6-4ca7-98c4-353d2612921f";
        String name = "SubjectAreaOwner";
        String description = "A role defining a responsibility to manage the development and maintenance of a subject area.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceRole";
        return this.archiveHelper.getDefaultEntityDef("c6fe40af-cdd6-4ca7-98c4-353d2612921f", "SubjectAreaOwner", this.archiveBuilder.getEntityDef("GovernanceRole"), "A role defining a responsibility to manage the development and maintenance of a subject area.", descriptionGUID);
    }

    private RelationshipDef getGovernanceRoleAssignmentRelationship() {
        String guid = "cb10c107-b7af-475d-aab0-d78b8297b982";
        String name = "GovernanceRoleAssignment";
        String description = "Identifies a person assigned to perform a specific responsibility for a specific resource.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("cb10c107-b7af-475d-aab0-d78b8297b982", "GovernanceRoleAssignment", null, "Identifies a person assigned to perform a specific responsibility for a specific resource.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "governanceAssignments";
        String end1AttributeDescription = "The resources assigned to this person.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "governanceAssignments", "The resources assigned to this person.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "PersonRole";
        String end2AttributeName = "governedByRoles";
        String end2AttributeDescription = "The roles assigned to this element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("PersonRole"), "governedByRoles", "The roles assigned to this element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getGovernanceResponsibilityAssignmentRelationship() {
        String guid = "cb15c107-b7af-475d-aab0-d78b8297b982";
        String name = "GovernanceResponsibilityAssignment";
        String description = "Identifies a role that will perform a governance responsibility.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("cb15c107-b7af-475d-aab0-d78b8297b982", "GovernanceResponsibilityAssignment", null, "Identifies a role that will perform a governance responsibility.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceRole";
        String end1AttributeName = "performedByRoles";
        String end1AttributeDescription = "The roles assigned to this responsibility.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceRole"), "performedByRoles", "The roles assigned to this responsibility.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceResponsibility";
        String end2AttributeName = "governanceResponsibilities";
        String end2AttributeDescription = "The responsibilities performed by this role.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceResponsibility"), "governanceResponsibilities", "The responsibilities performed by this role.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0450GovernanceRollout() {
        this.archiveBuilder.addEntityDef(this.getGovernanceMetricEntity());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceDefinitionMetricRelationship());
        this.archiveBuilder.addRelationshipDef(this.getGovernanceResultsRelationship());
        this.archiveBuilder.addClassificationDef(this.getGovernanceMeasurementsDataSetClassification());
    }

    private EntityDef getGovernanceMetricEntity() {
        String guid = "9ada8e7b-823c-40f7-adf8-f164aabda77e";
        String name = "GovernanceMetric";
        String description = "A definition for how the effectiveness of the governance program is measured.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("9ada8e7b-823c-40f7-adf8-f164aabda77e", "GovernanceMetric", this.archiveBuilder.getEntityDef(superTypeName), "A definition for how the effectiveness of the governance program is measured.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "measurement";
        String attribute3Description = "Format or description of the measurements captured for this metric.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "target";
        String attribute4Description = "Definition of the measurement values that the governance definitions are trying to achieve.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("measurement", "Format or description of the measurements captured for this metric.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("target", "Definition of the measurement values that the governance definitions are trying to achieve.", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getGovernanceDefinitionMetricRelationship() {
        String guid = "e076fbb3-54f5-46b8-8f1e-a7cb7e792673";
        String name = "GovernanceDefinitionMetric";
        String description = "Link between a governance definition and a governance metric used to measure this definition.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e076fbb3-54f5-46b8-8f1e-a7cb7e792673", "GovernanceDefinitionMetric", null, "Link between a governance definition and a governance metric used to measure this definition.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceMetric";
        String end1AttributeName = "metrics";
        String end1AttributeDescription = "The metrics that measure the landscape against this governance definition.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceMetric"), "metrics", "The metrics that measure the landscape against this governance definition.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceDefinition";
        String end2AttributeName = "measuredDefinitions";
        String end2AttributeDescription = "The governance definitions that are measured by this metric.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceDefinition"), "measuredDefinitions", "The governance definitions that are measured by this metric.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "rationale";
        String attribute1Description = "Documents reasons for using the metric to measure the governance definition.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("rationale", "Documents reasons for using the metric to measure the governance definition.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getGovernanceResultsRelationship() {
        String guid = "89c3c695-9e8d-4660-9f44-ed971fd55f88";
        String name = "GovernanceResults";
        String description = "Link between a governance metric and a data set used to gather measurements from the landscape.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("89c3c695-9e8d-4660-9f44-ed971fd55f88", "GovernanceResults", null, "Link between a governance metric and a data set used to gather measurements from the landscape.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceMetric";
        String end1AttributeName = "metrics";
        String end1AttributeDescription = "The governance metrics that are captured in this data set.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceMetric"), "metrics", "The governance metrics that are captured in this data set.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.DATA_SET.typeName;
        String end2AttributeName = "measurements";
        String end2AttributeDescription = "The data set that captures the measurements for this governance metric.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "measurements", "The data set that captures the measurements for this governance metric.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "query";
        String attribute1Description = "Defines how the data items from the data set are converted in measurements for the metric.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("query", "Defines how the data items from the data set are converted in measurements for the metric.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getGovernanceMeasurementsDataSetClassification() {
        String guid = "789f2e89-accd-4489-8eca-dc43b432c022";
        String name = "GovernanceMeasurementsResultsDataSet";
        String description = "A data file containing measurements for a governance metric.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.DATA_SET.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("789f2e89-accd-4489-8eca-dc43b432c022", "GovernanceMeasurementsResultsDataSet", null, "A data file containing measurements for a governance metric.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0455ExceptionManagement() {
        this.archiveBuilder.addClassificationDef(this.getExceptionBacklogClassification());
        this.archiveBuilder.addClassificationDef(this.getAuditLogClassification());
        this.archiveBuilder.addClassificationDef(this.getMeteringLogClassification());
        this.archiveBuilder.addClassificationDef(this.getStewardshipServerClassification());
        this.archiveBuilder.addClassificationDef(this.getGovernanceDaemonClassification());
    }

    private ClassificationDef getExceptionBacklogClassification() {
        String guid = "b3eceea3-aa02-4d84-8f11-da4953e64b5f";
        String name = "ExceptionBacklog";
        String description = "A data set containing exceptions that need to be resolved";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.DATA_SET.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("b3eceea3-aa02-4d84-8f11-da4953e64b5f", "ExceptionBacklog", null, "A data set containing exceptions that need to be resolved", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NOTES.name;
        String attribute1Description = OpenMetadataProperty.NOTES.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NOTES.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.STEWARD.name;
        String attribute2Description = OpenMetadataProperty.STEWARD.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute3Name = "process";
        String attribute3Description = "Unique identifier of the automated process that processes this exception backlog.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.SOURCE.name;
        String attribute4Description = OpenMetadataProperty.SOURCE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("process", "Unique identifier of the automated process that processes this exception backlog.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getAuditLogClassification() {
        String guid = "449be034-6cc8-4f1b-859f-a8b9ff8ee7a1";
        String name = "AuditLog";
        String description = "A data set of related audit log records.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.DATA_SET.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("449be034-6cc8-4f1b-859f-a8b9ff8ee7a1", "AuditLog", null, "A data set of related audit log records.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NOTES.name;
        String attribute1Description = OpenMetadataProperty.NOTES.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NOTES.descriptionGUID;
        String attribute2Name = "process";
        String attribute2Description = "Unique identifier of the automated process that processes this exception backlog.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.SOURCE.name;
        String attribute3Description = OpenMetadataProperty.SOURCE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("process", "Unique identifier of the automated process that processes this exception backlog.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getMeteringLogClassification() {
        String guid = "161b37c9-1d51-433b-94ce-5a760a198236";
        String name = "MeteringLog";
        String description = "A data set containing records that can be used to identify usage of resources.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.DATA_SET.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("161b37c9-1d51-433b-94ce-5a760a198236", "MeteringLog", null, "A data set containing records that can be used to identify usage of resources.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NOTES.name;
        String attribute1Description = OpenMetadataProperty.NOTES.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NOTES.descriptionGUID;
        String attribute2Name = "process";
        String attribute2Description = "Unique identifier of the automated process that processes this exception backlog.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.SOURCE.name;
        String attribute3Description = OpenMetadataProperty.SOURCE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("process", "Unique identifier of the automated process that processes this exception backlog.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getStewardshipServerClassification() {
        String guid = "eaaeaa31-6f8b-4ed5-88fe-422ed3733158";
        String name = "StewardshipServer";
        String description = "A server dedicated to managing stewardship activity relating to governance of data.";
        String descriptionGUID = null;
        String linkedToEntity = "SoftwareServer";
        return this.archiveHelper.getClassificationDef("eaaeaa31-6f8b-4ed5-88fe-422ed3733158", "StewardshipServer", null, "A server dedicated to managing stewardship activity relating to governance of data.", descriptionGUID, this.archiveBuilder.getEntityDef("SoftwareServer"), false);
    }

    private ClassificationDef getGovernanceDaemonClassification() {
        String guid = "7815f222-529d-4902-8f0b-e37cbc779885";
        String name = "GovernanceDaemon";
        String description = "A server dedicated to managing activity relating to governance of data.";
        String descriptionGUID = null;
        String linkedToEntity = "SoftwareServer";
        return this.archiveHelper.getClassificationDef("7815f222-529d-4902-8f0b-e37cbc779885", "GovernanceDaemon", null, "A server dedicated to managing activity relating to governance of data.", descriptionGUID, this.archiveBuilder.getEntityDef("SoftwareServer"), false);
    }

    private void add0460GovernanceControls() {
        this.archiveBuilder.addClassificationDef(this.getControlPointClassification());
        this.archiveBuilder.addClassificationDef(this.getVerificationPointClassification());
        this.archiveBuilder.addClassificationDef(this.getEnforcementPointClassification());
    }

    private ClassificationDef getControlPointClassification() {
        String guid = "acf8b73e-3545-435d-ba16-fbfae060dd28";
        String name = "ControlPoint";
        String description = "A task in a process where a person must make a decision on the right action to take.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        return this.archiveHelper.getClassificationDef("acf8b73e-3545-435d-ba16-fbfae060dd28", "ControlPoint", null, "A task in a process where a person must make a decision on the right action to take.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getVerificationPointClassification() {
        String guid = "12d78c95-3879-466d-883f-b71f6477a741";
        String name = "VerificationPoint";
        String description = "A governance rule that tests if a required condition is true or raises an exception if not.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        return this.archiveHelper.getClassificationDef("12d78c95-3879-466d-883f-b71f6477a741", "VerificationPoint", null, "A governance rule that tests if a required condition is true or raises an exception if not.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private ClassificationDef getEnforcementPointClassification() {
        String guid = "f4ce104e-7430-4c30-863d-60f6af6394d9";
        String name = "EnforcementPoint";
        String description = "A governance rule that ensures a required condition is true.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        return this.archiveHelper.getClassificationDef("f4ce104e-7430-4c30-863d-60f6af6394d9", "EnforcementPoint", null, "A governance rule that ensures a required condition is true.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private void add0481Licenses() {
        this.archiveBuilder.addEntityDef(this.getLicenseTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getLicenseRelationship());
    }

    private EntityDef getLicenseTypeEntity() {
        String guid = "046a049d-5f80-4e5b-b0ae-f3cf6009b513";
        String name = "LicenseType";
        String description = "A type of license that sets out specific terms and conditions for the use of an asset.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceDefinition";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("046a049d-5f80-4e5b-b0ae-f3cf6009b513", "LicenseType", this.archiveBuilder.getEntityDef("GovernanceDefinition"), "A type of license that sets out specific terms and conditions for the use of an asset.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "details";
        String attribute1Description = "Description of the rights, terms and conditions associated with the licence.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("details", "Description of the rights, terms and conditions associated with the licence.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getLicenseRelationship() {
        String guid = "35e53b7f-2312-4d66-ae90-2d4cb47901ee";
        String name = "License";
        String description = "Link between an asset and its license.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("35e53b7f-2312-4d66-ae90-2d4cb47901ee", "License", null, "Link between an asset and its license.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "licensed";
        String end1AttributeDescription = "Items licensed by this type of license.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "licensed", "Items licensed by this type of license.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "LicenseType";
        String end2AttributeName = "licenses";
        String end2AttributeDescription = "The types of licenses that apply.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("LicenseType"), "licenses", "The types of licenses that apply.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "licenseGUID";
        String attribute1Description = "Unique identifier of the actual license.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "start";
        String attribute2Description = "Start date for the license.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "end";
        String attribute3Description = "End date for the license.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "conditions";
        String attribute4Description = "Any special conditions or endorsements over the basic license type.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "licensedBy";
        String attribute5Description = "Person or organization that owns the intellectual property.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "custodian";
        String attribute6Description = "The person, engine or organization tht will ensure the license is honored.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "licensee";
        String attribute7Description = "The person or organization that holds the license.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = OpenMetadataProperty.NOTES.name;
        String attribute8Description = OpenMetadataProperty.NOTES.description;
        String attribute8DescriptionGUID = OpenMetadataProperty.NOTES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("licenseGUID", "Unique identifier of the actual license.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("start", "Start date for the license.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("end", "End date for the license.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("conditions", "Any special conditions or endorsements over the basic license type.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("licensedBy", "Person or organization that owns the intellectual property.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("custodian", "The person, engine or organization tht will ensure the license is honored.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("licensee", "The person or organization that holds the license.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute8Name, attribute8Description, attribute8DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0482Certifications() {
        this.archiveBuilder.addEntityDef(this.getCertificationTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getCertificationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getRegulationCertificationTypeRelationship());
    }

    private EntityDef getCertificationTypeEntity() {
        String guid = "97f9ffc9-e2f7-4557-ac12-925257345eea";
        String name = "CertificationType";
        String description = "A specific type of certification required by a regulation.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceDefinition";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("97f9ffc9-e2f7-4557-ac12-925257345eea", "CertificationType", this.archiveBuilder.getEntityDef("GovernanceDefinition"), "A specific type of certification required by a regulation.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "details";
        String attribute1Description = "Description of the requirements associated with the certification.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("details", "Description of the requirements associated with the certification.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getCertificationRelationship() {
        String guid = "390559eb-6a0c-4dd7-bc95-b9074caffa7f";
        String name = "Certification";
        String description = "An awarded certification of a specific type.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("390559eb-6a0c-4dd7-bc95-b9074caffa7f", "Certification", null, "An awarded certification of a specific type.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "certifies";
        String end1AttributeDescription = "Items certified by this type of certification.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "certifies", "Items certified by this type of certification.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "CertificationType";
        String end2AttributeName = "certifications";
        String end2AttributeDescription = "The types of certifications that apply.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("CertificationType"), "certifications", "The types of certifications that apply.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "certificateGUID";
        String attribute1Description = "Unique identifier of the actual certificate.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "start";
        String attribute2Description = "Start date for the certification.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "end";
        String attribute3Description = "End date for the certification.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "conditions";
        String attribute4Description = "Any special conditions or endorsements over the basic certification type.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "certifiedBy";
        String attribute5Description = "Person or organization awarded the certification.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "custodian";
        String attribute6Description = "The person, engine or organization that will ensure the certification is honored.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "recipient";
        String attribute7Description = "The person or organization that received the certification.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = OpenMetadataProperty.NOTES.name;
        String attribute8Description = OpenMetadataProperty.NOTES.description;
        String attribute8DescriptionGUID = OpenMetadataProperty.NOTES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("certificateGUID", "Unique identifier of the actual certificate.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("start", "Start date for the certification.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("end", "End date for the certification.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("conditions", "Any special conditions or endorsements over the basic certification type.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("certifiedBy", "Person or organization awarded the certification.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("custodian", "The person, engine or organization that will ensure the certification is honored.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("recipient", "The person or organization that received the certification.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute8Name, attribute8Description, attribute8DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getRegulationCertificationTypeRelationship() {
        String guid = "be12ff15-0721-4a7e-8c98-334eaa884bdf";
        String name = "RegulationCertificationType";
        String description = "Identifies a certification required by a regulation.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("be12ff15-0721-4a7e-8c98-334eaa884bdf", "RegulationCertificationType", null, "Identifies a certification required by a regulation.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Regulation";
        String end1AttributeName = "relatedRegulations";
        String end1AttributeDescription = "Regulations that require this type of certification.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Regulation"), "relatedRegulations", "Regulations that require this type of certification.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "CertificationType";
        String end2AttributeName = "requiredCertifications";
        String end2AttributeDescription = "The certifications required by this regulation.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("CertificationType"), "requiredCertifications", "The certifications required by this regulation.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void addArea5Types() {
        this.add0501SchemaElements();
        this.add0503AssetSchemas();
        this.add0504ImplementationSnippets();
        this.add0505SchemaAttributes();
        this.add0507BoundedSchemaTypes();
        this.add0510SchemaLinkElements();
        this.add0511SchemaMapElements();
        this.add0512DerivedSchemaAttributes();
        this.add0530TabularSchemas();
        this.add0531DocumentSchemas();
        this.add0532ObjectSchemas();
        this.add0533GraphSchemas();
        this.add0534RelationalSchemas();
        this.add0535EventSchemas();
        this.add0536APISchemas();
        this.add0540DataClasses();
        this.add0545ReferenceData();
        this.add0565DesignModelElements();
        this.add0566DesignModelOrganization();
        this.add0568DesignModelScoping();
        this.add0569DesignModelImplementation();
        this.add0570MetaModel();
        this.add0571ConceptModels();
        this.add0595DesignPatterns();
        this.add0598LineageRelationships();
    }

    private void add0501SchemaElements() {
        this.archiveBuilder.addEntityDef(this.getSchemaElementEntity());
        this.archiveBuilder.addEntityDef(this.getSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getSchemaTypeChoiceEntity());
        this.archiveBuilder.addEntityDef(this.getLiteralSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getSimpleSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getPrimitiveSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getEnumSchemaTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getSchemaTypeOptionRelationship());
    }

    private EntityDef getSchemaElementEntity() {
        String guid = "718d4244-8559-49ed-ad5a-10e5c305a656";
        String name = "SchemaElement";
        String description = "An element that is part of a schema definition.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("718d4244-8559-49ed-ad5a-10e5c305a656", "SchemaElement", this.archiveBuilder.getEntityDef(superTypeName), "An element that is part of a schema definition.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "anchorGUID";
        String attribute1Description = "Optional identification of the referenceable that this schema element is a part of.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute2Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute3Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Optional identification of the referenceable that this schema element is a part of.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getSchemaTypeEntity() {
        String guid = "5bd4a3e7-d22d-4a3d-a115-066ee8e0754f";
        String name = "SchemaType";
        String description = "A specific type description.";
        String descriptionGUID = null;
        String superTypeName = "SchemaElement";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("5bd4a3e7-d22d-4a3d-a115-066ee8e0754f", "SchemaType", this.archiveBuilder.getEntityDef("SchemaElement"), "A specific type description.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "namespace";
        String attribute1Description = "Prefix for element names to ensure uniqueness.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "versionNumber";
        String attribute2Description = "Version of the schema type.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "author";
        String attribute3Description = "User name of the person or process that created the schema type.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.USAGE.name;
        String attribute4Description = OpenMetadataProperty.USAGE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.USAGE.descriptionGUID;
        String attribute5Name = "encodingStandard";
        String attribute5Description = "Format of the schema.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("namespace", "Prefix for element names to ensure uniqueness.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("versionNumber", "Version of the schema type.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("author", "User name of the person or process that created the schema type.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("encodingStandard", "Format of the schema.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getSchemaTypeChoiceEntity() {
        String guid = "5caf954a-3e33-4cbd-b17d-8b8613bd2db8";
        String name = "SchemaTypeChoice";
        String description = "A list of alternative schema types for attribute.";
        String descriptionGUID = null;
        String superTypeName = "SchemaType";
        return this.archiveHelper.getDefaultEntityDef("5caf954a-3e33-4cbd-b17d-8b8613bd2db8", "SchemaTypeChoice", this.archiveBuilder.getEntityDef("SchemaType"), "A list of alternative schema types for attribute.", descriptionGUID);
    }

    private EntityDef getLiteralSchemaTypeEntity() {
        String guid = "520ebb91-c4eb-4d46-a3b1-974875cdcf0d";
        String name = "LiteralSchemaType";
        String description = "A fixed simple value.";
        String descriptionGUID = null;
        String superTypeName = "SchemaType";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("520ebb91-c4eb-4d46-a3b1-974875cdcf0d", "LiteralSchemaType", this.archiveBuilder.getEntityDef("SchemaType"), "A fixed simple value.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "dataType";
        String attribute1Description = "Type name for the data stored in this schema element.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "fixedValue";
        String attribute2Description = "Fixed value for data stored in this schema element.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("dataType", "Type name for the data stored in this schema element.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("fixedValue", "Fixed value for data stored in this schema element.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getSimpleSchemaTypeEntity() {
        String guid = "b5ec6e07-6419-4225-9dc4-fb55aba255c6";
        String name = "SimpleSchemaType";
        String description = "A single valued type.";
        String descriptionGUID = null;
        String superTypeName = "SchemaType";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("b5ec6e07-6419-4225-9dc4-fb55aba255c6", "SimpleSchemaType", this.archiveBuilder.getEntityDef("SchemaType"), "A single valued type.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "dataType";
        String attribute1Description = "Type name for the data stored in this schema element.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "defaultValue";
        String attribute2Description = "Initial value for data stored in this schema element.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("dataType", "Type name for the data stored in this schema element.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("defaultValue", "Initial value for data stored in this schema element.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getPrimitiveSchemaTypeEntity() {
        String guid = "f0f75fba-9136-4082-8352-0ad74f3c36ed";
        String name = "PrimitiveSchemaType";
        String description = "A specific primitive type.";
        String descriptionGUID = null;
        String superTypeName = "SimpleSchemaType";
        return this.archiveHelper.getDefaultEntityDef("f0f75fba-9136-4082-8352-0ad74f3c36ed", "PrimitiveSchemaType", this.archiveBuilder.getEntityDef("SimpleSchemaType"), "A specific primitive type.", descriptionGUID);
    }

    private EntityDef getEnumSchemaTypeEntity() {
        String guid = "24b092ac-42e9-43dc-aeca-eb034ce307d9";
        String name = "EnumSchemaType";
        String description = "A single valued type with fixed list of valid values.";
        String descriptionGUID = null;
        String superTypeName = "SimpleSchemaType";
        return this.archiveHelper.getDefaultEntityDef("24b092ac-42e9-43dc-aeca-eb034ce307d9", "EnumSchemaType", this.archiveBuilder.getEntityDef("SimpleSchemaType"), "A single valued type with fixed list of valid values.", descriptionGUID);
    }

    private RelationshipDef getSchemaTypeOptionRelationship() {
        String guid = "eb4f1f98-c649-4560-8a46-da17c02764a9";
        String name = "SchemaTypeOption";
        String description = "The list of alternative schema types.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("eb4f1f98-c649-4560-8a46-da17c02764a9", "SchemaTypeOption", null, "The list of alternative schema types.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SchemaTypeChoice";
        String end1AttributeName = "schemaOptionalUses";
        String end1AttributeDescription = "Potential place where this schema type is used.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaTypeChoice"), "schemaOptionalUses", "Potential place where this schema type is used.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "schemaOptions";
        String end2AttributeDescription = "Possible structure of the content of this element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "schemaOptions", "Possible structure of the content of this element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0503AssetSchemas() {
        this.archiveBuilder.addRelationshipDef(this.getAssetSchemaTypeRelationship());
    }

    private RelationshipDef getAssetSchemaTypeRelationship() {
        String guid = "815b004d-73c6-4728-9dd9-536f4fe803cd";
        String name = "AssetSchemaType";
        String description = "The structure of an asset.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("815b004d-73c6-4728-9dd9-536f4fe803cd", "AssetSchemaType", null, "The structure of an asset.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.ASSET.typeName;
        String end1AttributeName = "describesAssets";
        String end1AttributeDescription = "Asset that conforms to the schema type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "describesAssets", "Asset that conforms to the schema type.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "schema";
        String end2AttributeDescription = "Structure of the content of this asset.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "schema", "Structure of the content of this asset.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0504ImplementationSnippets() {
        this.archiveBuilder.addEntityDef(this.getImplementationSnippetEntity());
        this.archiveBuilder.addRelationshipDef(this.getSchemaTypeSnippetRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSchemaTypeImplementationRelationship());
    }

    private EntityDef getImplementationSnippetEntity() {
        String guid = "49990755-2faa-4a62-a1f3-9124b9c73df4";
        String name = "ImplementationSnippet";
        String description = "A concrete implementation example for a schema element.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("49990755-2faa-4a62-a1f3-9124b9c73df4", "ImplementationSnippet", this.archiveBuilder.getEntityDef(superTypeName), "A concrete implementation example for a schema element.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "snippet";
        String attribute1Description = "Concrete implementation of the schema type.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "implementationLanguage";
        String attribute2Description = "Type of implementation.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "version";
        String attribute3Description = "Version number of the snippet.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.USAGE.name;
        String attribute4Description = OpenMetadataProperty.USAGE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.USAGE.descriptionGUID;
        String attribute5Name = "curator";
        String attribute5Description = "User name of the person or process that is maintaining the snippet.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("snippet", "Concrete implementation of the schema type.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("implementationLanguage", "Type of implementation.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("version", "Version number of the snippet.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("curator", "User name of the person or process that is maintaining the snippet.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSchemaTypeSnippetRelationship() {
        String guid = "6aab4ec6-f0c6-4c40-9f50-ac02a3483358";
        String name = "SchemaTypeSnippet";
        String description = "Link between a schema type and an implementation snippet.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("6aab4ec6-f0c6-4c40-9f50-ac02a3483358", "SchemaTypeSnippet", null, "Link between a schema type and an implementation snippet.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SchemaType";
        String end1AttributeName = "templateForSchemaTypes";
        String end1AttributeDescription = "Logical structure for data.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "templateForSchemaTypes", "Logical structure for data.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ImplementationSnippet";
        String end2AttributeName = "implementationSnippets";
        String end2AttributeDescription = "Template implementation of the schema type.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ImplementationSnippet"), "implementationSnippets", "Template implementation of the schema type.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getSchemaTypeImplementationRelationship() {
        String guid = "eed5565d-7ac2-46fe-9a26-4722fad8d993";
        String name = "SchemaTypeImplementation";
        String description = "Link between a schema type and an implementation.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("eed5565d-7ac2-46fe-9a26-4722fad8d993", "SchemaTypeImplementation", null, "Link between a schema type and an implementation.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SchemaType";
        String end1AttributeName = "implementationSchemaTypes";
        String end1AttributeDescription = "Logical structure for the data.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "implementationSchemaTypes", "Logical structure for the data.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.PROCESS.typeName;
        String end2AttributeName = "implementations";
        String end2AttributeDescription = "Concrete implementation of the schema type.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "implementations", "Concrete implementation of the schema type.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0505SchemaAttributes() {
        this.archiveBuilder.addEnumDef(this.getDataItemSortOrderEnum());
        this.archiveBuilder.addEntityDef(this.getSchemaAttributeEntity());
        this.archiveBuilder.addEntityDef(this.getComplexSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getStructSchemaTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getAttributeForSchemaRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSchemaAttributeTypeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getNestedSchemaAttributeRelationship());
        this.archiveBuilder.addClassificationDef(this.getTypeEmbeddedAttributeClassification());
    }

    private EnumDef getDataItemSortOrderEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(DataItemSortOrder.getOpenTypeGUID(), DataItemSortOrder.getOpenTypeName(), DataItemSortOrder.getOpenTypeDescription(), DataItemSortOrder.getOpenTypeDescriptionGUID(), DataItemSortOrder.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (DataItemSortOrder enumValues : DataItemSortOrder.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getSchemaAttributeEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, this.archiveBuilder.getEntityDef("SchemaElement"), OpenMetadataType.SCHEMA_ATTRIBUTE.description, OpenMetadataType.SCHEMA_ATTRIBUTE.descriptionGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "position";
        String attribute1Description = "Location of the attribute in the parent schema's list of attributes, starting at zero.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "minCardinality";
        String attribute2Description = "Minimum number of occurrences of this attribute allowed (0 = optional, 1+ = mandatory).";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "maxCardinality";
        String attribute3Description = "Maximum number of occurrences of this attribute allowed (-1 = infinite).";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "allowsDuplicateValues";
        String attribute4Description = "When multiple occurrences are allowed, indicates whether duplicates of the same value are allowed or not.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "orderedValues";
        String attribute5Description = "When multiple occurrences are allowed, indicates whether the values are ordered or not.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "defaultValueOverride";
        String attribute6Description = "Initial value for the attribute (overriding the default value of its type.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "nativeClass";
        String attribute7Description = "Native class used by the client to represent this element.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "name";
        String attribute8Description = "Name of schema attribute (deprecated).";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "aliases";
        String attribute9Description = "List of aliases for attribute.";
        String attribute9DescriptionGUID = null;
        String attribute10Name = "sortOrder";
        String attribute10Description = "Suggested ordering of values in this attribute.";
        String attribute10DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("position", "Location of the attribute in the parent schema's list of attributes, starting at zero.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("minCardinality", "Minimum number of occurrences of this attribute allowed (0 = optional, 1+ = mandatory).", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("maxCardinality", "Maximum number of occurrences of this attribute allowed (-1 = infinite).", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("allowsDuplicateValues", "When multiple occurrences are allowed, indicates whether duplicates of the same value are allowed or not.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("orderedValues", "When multiple occurrences are allowed, indicates whether the values are ordered or not.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("defaultValueOverride", "Initial value for the attribute (overriding the default value of its type.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("nativeClass", "Native class used by the client to represent this element.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("name", "Name of schema attribute (deprecated).", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("aliases", "List of aliases for attribute.", attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("DataItemSortOrder", "sortOrder", "Suggested ordering of values in this attribute.", attribute10DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getComplexSchemaTypeEntity() {
        String guid = "786a6199-0ce8-47bf-b006-9ace1c5510e4";
        String name = "ComplexSchemaType";
        String description = "A schema type that has a complex structure of nested attributes and types.";
        String descriptionGUID = null;
        String superTypeName = "SchemaType";
        return this.archiveHelper.getDefaultEntityDef("786a6199-0ce8-47bf-b006-9ace1c5510e4", "ComplexSchemaType", this.archiveBuilder.getEntityDef("SchemaType"), "A schema type that has a complex structure of nested attributes and types.", descriptionGUID);
    }

    private EntityDef getStructSchemaTypeEntity() {
        String guid = "a13b409f-fd67-4506-8d94-14dfafd250a4";
        String name = "StructSchemaType";
        String description = "A schema type that has a list of attributes, typically of different types.";
        String descriptionGUID = null;
        String superTypeName = "ComplexSchemaType";
        return this.archiveHelper.getDefaultEntityDef("a13b409f-fd67-4506-8d94-14dfafd250a4", "StructSchemaType", this.archiveBuilder.getEntityDef("ComplexSchemaType"), "A schema type that has a list of attributes, typically of different types.", descriptionGUID);
    }

    private RelationshipDef getAttributeForSchemaRelationship() {
        String guid = "86b176a2-015c-44a6-8106-54d5d69ba661";
        String name = "AttributeForSchema";
        String description = "Link between a complex schema type and its attributes.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("86b176a2-015c-44a6-8106-54d5d69ba661", "AttributeForSchema", null, "Link between a complex schema type and its attributes.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ComplexSchemaType";
        String end1AttributeName = "parentSchemas";
        String end1AttributeDescription = "Schema types using this attribute.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ComplexSchemaType"), "parentSchemas", "Schema types using this attribute.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        String end2AttributeName = "attributes";
        String end2AttributeDescription = "The attributes defining the internal structure of the schema type.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "attributes", "The attributes defining the internal structure of the schema type.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getSchemaAttributeTypeRelationship() {
        String guid = "2d955049-e59b-45dd-8e62-cde1add59f9e";
        String name = "SchemaAttributeType";
        String description = "The schema type for an attribute.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2d955049-e59b-45dd-8e62-cde1add59f9e", "SchemaAttributeType", null, "The schema type for an attribute.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        String end1AttributeName = "usedInSchemas";
        String end1AttributeDescription = "Occurrences of this schema type in other schemas.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "usedInSchemas", "Occurrences of this schema type in other schemas.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "type";
        String end2AttributeDescription = "The structure of this attribute.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "type", "The structure of this attribute.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getNestedSchemaAttributeRelationship() {
        String guid = "0ffb9d87-7074-45da-a9b0-ae0859611133";
        String name = "NestedSchemaAttribute";
        String description = "The direct parent-child relationship between attributes with an embedded type.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("0ffb9d87-7074-45da-a9b0-ae0859611133", "NestedSchemaAttribute", null, "The direct parent-child relationship between attributes with an embedded type.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        String end1AttributeName = "parentAttribute";
        String end1AttributeDescription = "Schema attribute containing this attribute.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "parentAttribute", "Schema attribute containing this attribute.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        String end2AttributeName = "nestedAttributes";
        String end2AttributeDescription = "The attributes defining the internal structure of the parent attribute.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "nestedAttributes", "The attributes defining the internal structure of the parent attribute.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private ClassificationDef getTypeEmbeddedAttributeClassification() {
        String guid = "e2bb76bb-774a-43ff-9045-3a05f663d5d9";
        String name = "TypeEmbeddedAttribute";
        String description = "Type information embedded within an attribute.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("e2bb76bb-774a-43ff-9045-3a05f663d5d9", "TypeEmbeddedAttribute", null, "Type information embedded within an attribute.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "encodingStandard";
        String attribute1Description = "Format of the schema.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "dataType";
        String attribute2Description = "Type name for the data stored in this schema element.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("encodingStandard", "Format of the schema.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("dataType", "Type name for the data stored in this schema element.", attribute2DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0507BoundedSchemaTypes() {
        this.archiveBuilder.addEntityDef(this.getBoundedSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getArraySchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getSetSchemaTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getBoundedSchemaElementTypeRelationship());
    }

    private EntityDef getBoundedSchemaTypeEntity() {
        String guid = "77133161-37a9-43f5-aaa3-fd6d7ff92fdb";
        String name = "BoundedSchemaType";
        String description = "A schema type that limits the number of values that can be stored.";
        String descriptionGUID = null;
        String superTypeName = "ComplexSchemaType";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("77133161-37a9-43f5-aaa3-fd6d7ff92fdb", "BoundedSchemaType", this.archiveBuilder.getEntityDef("ComplexSchemaType"), "A schema type that limits the number of values that can be stored.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "maximumElements";
        String attribute1Description = "Maximum number of values that can be stored - zero for no limit.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("maximumElements", "Maximum number of values that can be stored - zero for no limit.", attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getArraySchemaTypeEntity() {
        String guid = "ba8d29d2-a8a4-41f3-b29f-91ad924dd944";
        String name = "ArraySchemaType";
        String description = "A schema type that has a list of values of the same type.";
        String descriptionGUID = null;
        String superTypeName = "BoundedSchemaType";
        return this.archiveHelper.getDefaultEntityDef("ba8d29d2-a8a4-41f3-b29f-91ad924dd944", "ArraySchemaType", this.archiveBuilder.getEntityDef("BoundedSchemaType"), "A schema type that has a list of values of the same type.", descriptionGUID);
    }

    private EntityDef getSetSchemaTypeEntity() {
        String guid = "b2605d2d-10cd-443c-b3e8-abf15fb051f0";
        String name = "SetSchemaType";
        String description = "A schema type that is an unordered group of values of the same type.";
        String descriptionGUID = null;
        String superTypeName = "BoundedSchemaType";
        return this.archiveHelper.getDefaultEntityDef("b2605d2d-10cd-443c-b3e8-abf15fb051f0", "SetSchemaType", this.archiveBuilder.getEntityDef("BoundedSchemaType"), "A schema type that is an unordered group of values of the same type.", descriptionGUID);
    }

    private RelationshipDef getBoundedSchemaElementTypeRelationship() {
        String guid = "3e844049-e59b-45dd-8e62-cde1add59f9e";
        String name = "BoundedSchemaElementType";
        String description = "The type of the element within the bounded schema type.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("3e844049-e59b-45dd-8e62-cde1add59f9e", "BoundedSchemaElementType", null, "The type of the element within the bounded schema type.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "BoundedSchemaType";
        String end1AttributeName = "usedInBoundedSchemaType";
        String end1AttributeDescription = "Use of this element as part of a more complex type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("BoundedSchemaType"), "usedInBoundedSchemaType", "Use of this element as part of a more complex type.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "boundedSchemaElementType";
        String end2AttributeDescription = "The structure of the element within this type.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "boundedSchemaElementType", "The structure of the element within this type.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0510SchemaLinkElements() {
        this.archiveBuilder.addEntityDef(this.getSchemaLinkElementEntity());
        this.archiveBuilder.addRelationshipDef(this.getLinkedTypeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSchemaLinkToTypeRelationship());
    }

    private EntityDef getSchemaLinkElementEntity() {
        String guid = "67e08705-2d2a-4df6-9239-1818161a41e0";
        String name = "SchemaLinkElement";
        String description = "A link to a type in a different schema.";
        String descriptionGUID = null;
        String superTypeName = "SchemaElement";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("67e08705-2d2a-4df6-9239-1818161a41e0", "SchemaLinkElement", this.archiveBuilder.getEntityDef("SchemaElement"), "A link to a type in a different schema.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "linkName";
        String attribute1Description = "Name for the element that bridges between two schemas.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "linkProperties";
        String attribute2Description = "Any options needed to describe the link.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("linkName", "Name for the element that bridges between two schemas.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("linkProperties", "Any options needed to describe the link.", attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getLinkedTypeRelationship() {
        String guid = "292125f7-5660-4533-a48a-478c5611922e";
        String name = "LinkedType";
        String description = "Link between a link element and its type.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("292125f7-5660-4533-a48a-478c5611922e", "LinkedType", null, "Link between a link element and its type.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SchemaLinkElement";
        String end1AttributeName = "linkedBy";
        String end1AttributeDescription = "External links to this type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaLinkElement"), "linkedBy", "External links to this type.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "linkedType";
        String end2AttributeDescription = "Types for this attribute.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "linkedType", "Types for this attribute.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getSchemaLinkToTypeRelationship() {
        String guid = "db9583c5-4690-41e5-a580-b4e30a0242d3";
        String name = "SchemaLinkToType";
        String description = "Link between a schema attribute and a schema link.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("db9583c5-4690-41e5-a580-b4e30a0242d3", "SchemaLinkToType", null, "Link between a schema attribute and a schema link.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        String end1AttributeName = "usedIn";
        String end1AttributeDescription = "Attributes of this type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "usedIn", "Attributes of this type.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaLinkElement";
        String end2AttributeName = "externalType";
        String end2AttributeDescription = "External type for this attribute.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaLinkElement"), "externalType", "External type for this attribute.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0511SchemaMapElements() {
        this.archiveBuilder.addEntityDef(this.getMapSchemaTypeEntity());
        this.archiveBuilder.addRelationshipDef(this.getMapFromElementTypeRelationship());
        this.archiveBuilder.addRelationshipDef(this.getMapToElementTypeRelationship());
    }

    private EntityDef getMapSchemaTypeEntity() {
        String guid = "bd4c85d0-d471-4cd2-a193-33b0387a19fd";
        String name = "MapSchemaType";
        String description = "A schema type for a map between a key and value.";
        String descriptionGUID = null;
        String superTypeName = "SchemaType";
        return this.archiveHelper.getDefaultEntityDef("bd4c85d0-d471-4cd2-a193-33b0387a19fd", "MapSchemaType", this.archiveBuilder.getEntityDef("SchemaType"), "A schema type for a map between a key and value.", descriptionGUID);
    }

    private RelationshipDef getMapFromElementTypeRelationship() {
        String guid = "6189d444-2da4-4cd7-9332-e48a1c340b44";
        String name = "MapFromElementType";
        String description = "Defines the type of the key for a map schema type.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("6189d444-2da4-4cd7-9332-e48a1c340b44", "MapFromElementType", null, "Defines the type of the key for a map schema type.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "MapSchemaType";
        String end1AttributeName = "parentMapFrom";
        String end1AttributeDescription = "Used in map.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("MapSchemaType"), "parentMapFrom", "Used in map.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "mapFromElement";
        String end2AttributeDescription = "Key for this attribute.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "mapFromElement", "Key for this attribute.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getMapToElementTypeRelationship() {
        String guid = "8b9856b3-451e-45fc-afc7-fddefd81a73a";
        String name = "MapToElementType";
        String description = "Defines the type of value for a map schema type.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("8b9856b3-451e-45fc-afc7-fddefd81a73a", "MapToElementType", null, "Defines the type of value for a map schema type.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "MapSchemaType";
        String end1AttributeName = "parentMapTo";
        String end1AttributeDescription = "Used in map.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("MapSchemaType"), "parentMapTo", "Used in map.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "mapToElement";
        String end2AttributeDescription = "Value for this map.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "mapToElement", "Value for this map.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0512DerivedSchemaAttributes() {
        this.archiveBuilder.addEntityDef(this.getDerivedSchemaAttributeEntity());
        this.archiveBuilder.addRelationshipDef(this.getSchemaQueryImplementationRelationship());
    }

    private EntityDef getDerivedSchemaAttributeEntity() {
        String guid = "cf21abfe-655a-47ba-b9b6-f73394745c80";
        String name = "DerivedSchemaAttribute";
        String description = "An attribute that is made up of values from another attribute.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("cf21abfe-655a-47ba-b9b6-f73394745c80", "DerivedSchemaAttribute", this.archiveBuilder.getEntityDef(superTypeName), "An attribute that is made up of values from another attribute.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "formula";
        String attribute1Description = "Transformation used to create the derived data.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "comment";
        String attribute2Description = "Comment from source system (deprecated).";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "id";
        String attribute3Description = "Id of derived schema attribute (deprecated).";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "aggregatingFunction";
        String attribute4Description = "Aggregating function of derived schema attribute (deprecated).";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("formula", "Transformation used to create the derived data.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("comment", "Comment from source system (deprecated).", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("id", "Id of derived schema attribute (deprecated).", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("aggregatingFunction", "Aggregating function of derived schema attribute (deprecated).", attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSchemaQueryImplementationRelationship() {
        String guid = "e5d7025d-8b4f-43c7-bcae-1047d650b94a";
        String name = "SchemaQueryImplementation";
        String description = "Details of how a derived schema attribute is calculated.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e5d7025d-8b4f-43c7-bcae-1047d650b94a", "SchemaQueryImplementation", null, "Details of how a derived schema attribute is calculated.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DerivedSchemaAttribute";
        String end1AttributeName = "usedBy";
        String end1AttributeDescription = "Use of an attribute to derive another attribute.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DerivedSchemaAttribute"), "usedBy", "Use of an attribute to derive another attribute.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        String end2AttributeName = "queryTarget";
        String end2AttributeDescription = "Used to derive this attribute.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "queryTarget", "Used to derive this attribute.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "query";
        String attribute1Description = "Details of how the attribute is retrieved.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("query", "Details of how the attribute is retrieved.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0530TabularSchemas() {
        this.archiveBuilder.addEntityDef(this.getTabularSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getTabularColumnTypeEntity());
        this.archiveBuilder.addEntityDef(this.getTabularColumnEntity());
    }

    private EntityDef getTabularSchemaTypeEntity() {
        String guid = "248975ec-8019-4b8a-9caf-084c8b724233";
        String name = "TabularSchemaType";
        String description = "A schema type for a table oriented data structure.";
        String descriptionGUID = null;
        String superTypeName = "ComplexSchemaType";
        return this.archiveHelper.getDefaultEntityDef("248975ec-8019-4b8a-9caf-084c8b724233", "TabularSchemaType", this.archiveBuilder.getEntityDef("ComplexSchemaType"), "A schema type for a table oriented data structure.", descriptionGUID);
    }

    private EntityDef getTabularColumnTypeEntity() {
        String guid = "a7392281-348d-48a4-bad7-f9742d7696fe";
        String name = "TabularColumnType";
        String description = "A schema type for a column oriented data structure.";
        String descriptionGUID = null;
        String superTypeName = "PrimitiveSchemaType";
        return this.archiveHelper.getDefaultEntityDef("a7392281-348d-48a4-bad7-f9742d7696fe", "TabularColumnType", this.archiveBuilder.getEntityDef("PrimitiveSchemaType"), "A schema type for a column oriented data structure.", descriptionGUID);
    }

    private EntityDef getTabularColumnEntity() {
        String guid = "d81a0425-4e9b-4f31-bc1c-e18c3566da10";
        String name = "TabularColumn";
        String description = "A column attribute for a table oriented data structure.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        return this.archiveHelper.getDefaultEntityDef("d81a0425-4e9b-4f31-bc1c-e18c3566da10", "TabularColumn", this.archiveBuilder.getEntityDef(superTypeName), "A column attribute for a table oriented data structure.", descriptionGUID);
    }

    private void add0531DocumentSchemas() {
        this.archiveBuilder.addEntityDef(this.getDocumentSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getDocumentSchemaAttributeEntity());
        this.archiveBuilder.addEntityDef(this.getSimpleDocumentTypeEntity());
        this.archiveBuilder.addEntityDef(this.getStructDocumentTypeEntity());
        this.archiveBuilder.addEntityDef(this.getArrayDocumentTypeEntity());
        this.archiveBuilder.addEntityDef(this.getSetDocumentTypeEntity());
        this.archiveBuilder.addEntityDef(this.getMapDocumentTypeEntity());
    }

    private EntityDef getDocumentSchemaTypeEntity() {
        String guid = "33da99cd-8d04-490c-9457-c58908da7794";
        String name = "DocumentSchemaType";
        String description = "A schema type for a hierarchical data structure.";
        String descriptionGUID = null;
        String superTypeName = "ComplexSchemaType";
        return this.archiveHelper.getDefaultEntityDef("33da99cd-8d04-490c-9457-c58908da7794", "DocumentSchemaType", this.archiveBuilder.getEntityDef("ComplexSchemaType"), "A schema type for a hierarchical data structure.", descriptionGUID);
    }

    private EntityDef getDocumentSchemaAttributeEntity() {
        String guid = "b5cefb7e-b198-485f-a1d7-8e661012499b";
        String name = "DocumentSchemaAttribute";
        String description = "A schema attribute for a hierarchical data structure.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        return this.archiveHelper.getDefaultEntityDef("b5cefb7e-b198-485f-a1d7-8e661012499b", "DocumentSchemaAttribute", this.archiveBuilder.getEntityDef(superTypeName), "A schema attribute for a hierarchical data structure.", descriptionGUID);
    }

    private EntityDef getSimpleDocumentTypeEntity() {
        String guid = "42cfccbf-cc68-4980-8c31-0faf1ee002d3";
        String name = "SimpleDocumentType";
        String description = "A primitive attribute for a hierarchical data structure.";
        String descriptionGUID = null;
        String superTypeName = "PrimitiveSchemaType";
        return this.archiveHelper.getDefaultEntityDef("42cfccbf-cc68-4980-8c31-0faf1ee002d3", "SimpleDocumentType", this.archiveBuilder.getEntityDef("PrimitiveSchemaType"), "A primitive attribute for a hierarchical data structure.", descriptionGUID);
    }

    private EntityDef getStructDocumentTypeEntity() {
        String guid = "f6245c25-8f73-45eb-8fb5-fa17a5f27649";
        String name = "StructDocumentType";
        String description = "A structure within a hierarchical data structure.";
        String descriptionGUID = null;
        String superTypeName = "StructSchemaType";
        return this.archiveHelper.getDefaultEntityDef("f6245c25-8f73-45eb-8fb5-fa17a5f27649", "StructDocumentType", this.archiveBuilder.getEntityDef("StructSchemaType"), "A structure within a hierarchical data structure.", descriptionGUID);
    }

    private EntityDef getArrayDocumentTypeEntity() {
        String guid = "ddd29c67-db9a-45ff-92aa-6d17a12a8ee2";
        String name = "ArrayDocumentType";
        String description = "An array in a hierarchical data structure.";
        String descriptionGUID = null;
        String superTypeName = "ArraySchemaType";
        return this.archiveHelper.getDefaultEntityDef("ddd29c67-db9a-45ff-92aa-6d17a12a8ee2", "ArrayDocumentType", this.archiveBuilder.getEntityDef("ArraySchemaType"), "An array in a hierarchical data structure.", descriptionGUID);
    }

    private EntityDef getSetDocumentTypeEntity() {
        String guid = "67228a7a-9d8d-4fa7-b217-17474f1f4ac6";
        String name = "SetDocumentType";
        String description = "A set in a hierarchical data structure.";
        String descriptionGUID = null;
        String superTypeName = "SetSchemaType";
        return this.archiveHelper.getDefaultEntityDef("67228a7a-9d8d-4fa7-b217-17474f1f4ac6", "SetDocumentType", this.archiveBuilder.getEntityDef("SetSchemaType"), "A set in a hierarchical data structure.", descriptionGUID);
    }

    private EntityDef getMapDocumentTypeEntity() {
        String guid = "b0f09598-ceb6-415b-befc-563ecadd5727";
        String name = "MapDocumentType";
        String description = "A map in a hierarchical data structure.";
        String descriptionGUID = null;
        String superTypeName = "MapSchemaType";
        return this.archiveHelper.getDefaultEntityDef("b0f09598-ceb6-415b-befc-563ecadd5727", "MapDocumentType", this.archiveBuilder.getEntityDef("MapSchemaType"), "A map in a hierarchical data structure.", descriptionGUID);
    }

    private void add0532ObjectSchemas() {
        this.archiveBuilder.addEntityDef(this.getObjectSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getObjectAttributeEntity());
    }

    private EntityDef getObjectSchemaTypeEntity() {
        String guid = "6920fda1-7c07-47c7-84f1-9fb044ae153e";
        String name = "ObjectSchemaType";
        String description = "A schema attribute for an object.";
        String descriptionGUID = null;
        String superTypeName = "ComplexSchemaType";
        return this.archiveHelper.getDefaultEntityDef("6920fda1-7c07-47c7-84f1-9fb044ae153e", "ObjectSchemaType", this.archiveBuilder.getEntityDef("ComplexSchemaType"), "A schema attribute for an object.", descriptionGUID);
    }

    private EntityDef getObjectAttributeEntity() {
        String guid = "ccb408c0-582e-4a3a-a926-7082d53bb669";
        String name = "ObjectAttribute";
        String description = "An attribute in an object schema type.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        return this.archiveHelper.getDefaultEntityDef("ccb408c0-582e-4a3a-a926-7082d53bb669", "ObjectAttribute", this.archiveBuilder.getEntityDef(superTypeName), "An attribute in an object schema type.", descriptionGUID);
    }

    private void add0533GraphSchemas() {
        this.archiveBuilder.addEntityDef(this.getGraphSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getGraphVertexEntity());
        this.archiveBuilder.addEntityDef(this.getGraphEdgeEntity());
        this.archiveBuilder.addRelationshipDef(this.getGraphEdgeLinkRelationship());
    }

    private EntityDef getGraphSchemaTypeEntity() {
        String guid = OpenMetadataType.GRAPH_SCHEMA_TYPE.typeGUID;
        String name = OpenMetadataType.GRAPH_SCHEMA_TYPE.typeName;
        String description = OpenMetadataType.GRAPH_SCHEMA_TYPE.description;
        String descriptionGUID = OpenMetadataType.GRAPH_SCHEMA_TYPE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.GRAPH_SCHEMA_TYPE.wikiURL;
        String superTypeName = "SchemaType";
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef("SchemaType"), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef getGraphVertexEntity() {
        String guid = OpenMetadataType.GRAPH_VERTEX.typeGUID;
        String name = OpenMetadataType.GRAPH_VERTEX.typeName;
        String description = OpenMetadataType.GRAPH_VERTEX.description;
        String descriptionGUID = OpenMetadataType.GRAPH_VERTEX.descriptionGUID;
        String descriptionWiki = OpenMetadataType.GRAPH_VERTEX.wikiURL;
        String superTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private EntityDef getGraphEdgeEntity() {
        String guid = OpenMetadataType.GRAPH_EDGE.typeGUID;
        String name = OpenMetadataType.GRAPH_EDGE.typeName;
        String description = OpenMetadataType.GRAPH_EDGE.description;
        String descriptionGUID = OpenMetadataType.GRAPH_EDGE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.GRAPH_EDGE.wikiURL;
        String superTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private RelationshipDef getGraphEdgeLinkRelationship() {
        String guid = OpenMetadataType.GRAPH_EDGE_LINK_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.GRAPH_EDGE_LINK_RELATIONSHIP.typeName;
        String description = OpenMetadataType.GRAPH_EDGE_LINK_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.GRAPH_EDGE_LINK_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.GRAPH_EDGE_LINK_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.GRAPH_EDGE.typeName;
        String end1AttributeName = "edges";
        String end1AttributeDescription = "Edges for this vertex.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "edges", "Edges for this vertex.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.GRAPH_VERTEX.typeName;
        String end2AttributeName = "vertices";
        String end2AttributeDescription = "Vertices for this edge.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "vertices", "Vertices for this edge.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.LINK_TYPE_NAME.name;
        String attribute1Description = OpenMetadataProperty.LINK_TYPE_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.LINK_TYPE_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.RELATIONSHIP_END.name;
        String attribute2Description = OpenMetadataProperty.RELATIONSHIP_END.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.RELATIONSHIP_END.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.RELATIONSHIP_END_NAME.name;
        String attribute3Description = OpenMetadataProperty.RELATIONSHIP_END_NAME.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.RELATIONSHIP_END_NAME.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute4Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.MIN_CARDINALITY.name;
        String attribute5Description = OpenMetadataProperty.MIN_CARDINALITY.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.MIN_CARDINALITY.descriptionGUID;
        String attribute6Name = OpenMetadataProperty.MAX_CARDINALITY.name;
        String attribute6Description = OpenMetadataProperty.MAX_CARDINALITY.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.MAX_CARDINALITY.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.ADDITIONAL_PROPERTIES.name;
        String attribute7Description = OpenMetadataProperty.ADDITIONAL_PROPERTIES.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0534RelationalSchemas() {
        this.archiveBuilder.addEntityDef(this.getRelationalDBSchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getRelationalTableTypeEntity());
        this.archiveBuilder.addEntityDef(this.getRelationalTableEntity());
        this.archiveBuilder.addEntityDef(this.getRelationalColumnEntity());
        this.archiveBuilder.addEntityDef(this.getRelationalColumnTypeEntity());
        this.archiveBuilder.addEntityDef(this.getDerivedRelationalColumnEntity());
        this.archiveBuilder.addClassificationDef(this.getPrimaryKeyClassification());
        this.archiveBuilder.addClassificationDef(this.getRelationalViewClassification());
        this.archiveBuilder.addRelationshipDef(this.getForeignKeyRelationship());
    }

    private EntityDef getRelationalDBSchemaTypeEntity() {
        String guid = "f20f5f45-1afb-41c1-9a09-34d8812626a4";
        String name = "RelationalDBSchemaType";
        String description = "A schema type for a relational database.";
        String descriptionGUID = null;
        String superTypeName = "ComplexSchemaType";
        return this.archiveHelper.getDefaultEntityDef("f20f5f45-1afb-41c1-9a09-34d8812626a4", "RelationalDBSchemaType", this.archiveBuilder.getEntityDef("ComplexSchemaType"), "A schema type for a relational database.", descriptionGUID);
    }

    private EntityDef getRelationalTableTypeEntity() {
        String guid = "1321bcc0-dc6a-48ed-9ca6-0c6f934b0b98";
        String name = "RelationalTableType";
        String description = "A table type for a relational database.";
        String descriptionGUID = null;
        String superTypeName = "TabularSchemaType";
        return this.archiveHelper.getDefaultEntityDef("1321bcc0-dc6a-48ed-9ca6-0c6f934b0b98", "RelationalTableType", this.archiveBuilder.getEntityDef("TabularSchemaType"), "A table type for a relational database.", descriptionGUID);
    }

    private EntityDef getRelationalTableEntity() {
        String guid = "ce7e72b8-396a-4013-8688-f9d973067425";
        String name = "RelationalTable";
        String description = "A table within a relational database schema type.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        return this.archiveHelper.getDefaultEntityDef("ce7e72b8-396a-4013-8688-f9d973067425", "RelationalTable", this.archiveBuilder.getEntityDef(superTypeName), "A table within a relational database schema type.", descriptionGUID);
    }

    private EntityDef getRelationalColumnEntity() {
        String guid = "aa8d5470-6dbc-4648-9e2f-045e5df9d2f9";
        String name = "RelationalColumn";
        String description = "A column within a relational table.";
        String descriptionGUID = null;
        String superTypeName = "TabularColumn";
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("aa8d5470-6dbc-4648-9e2f-045e5df9d2f9", "RelationalColumn", this.archiveBuilder.getEntityDef("TabularColumn"), "A column within a relational table.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute3Name = "fraction";
        String attribute3Description = "Number of significant digits to the right of decimal point.";
        String attribute3DescriptionGUID = null;
        String attribute5Name = "isUnique";
        String attribute5Description = "Data is unique or not.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("fraction", "Number of significant digits to the right of decimal point.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("isUnique", "Data is unique or not.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getRelationalColumnTypeEntity() {
        String guid = "f0438d80-6eb9-4fac-bcc1-5efee5babcfc";
        String name = "RelationalColumnType";
        String description = "A type for a relational column.";
        String descriptionGUID = null;
        String superTypeName = "TabularColumnType";
        return this.archiveHelper.getDefaultEntityDef("f0438d80-6eb9-4fac-bcc1-5efee5babcfc", "RelationalColumnType", this.archiveBuilder.getEntityDef("TabularColumnType"), "A type for a relational column.", descriptionGUID);
    }

    private EntityDef getDerivedRelationalColumnEntity() {
        String guid = "a9f7d15d-b797-450a-8d56-1ba55490c019";
        String name = "DerivedRelationalColumn";
        String description = "A relational column that is derived from other columns.";
        String descriptionGUID = null;
        String superTypeName = "DerivedSchemaAttribute";
        return this.archiveHelper.getDefaultEntityDef("a9f7d15d-b797-450a-8d56-1ba55490c019", "DerivedRelationalColumn", this.archiveBuilder.getEntityDef("DerivedSchemaAttribute"), "A relational column that is derived from other columns.", descriptionGUID);
    }

    private ClassificationDef getPrimaryKeyClassification() {
        String guid = "b239d832-50bd-471b-b17a-15a335fc7f40";
        String name = "PrimaryKey";
        String description = "A uniquely identifying relational column.";
        String descriptionGUID = null;
        String linkedToEntity = "RelationalColumn";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("b239d832-50bd-471b-b17a-15a335fc7f40", "PrimaryKey", null, "A uniquely identifying relational column.", descriptionGUID, this.archiveBuilder.getEntityDef("RelationalColumn"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.KEY_PATTERN.name;
        String attribute1Description = OpenMetadataProperty.KEY_PATTERN.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.KEY_PATTERN.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.NAME.name;
        String attribute2Description = OpenMetadataProperty.NAME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("KeyPattern", attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef getRelationalViewClassification() {
        String guid = "4814bec8-482d-463d-8376-160b0358e129";
        String name = "RelationalView";
        String description = "A view within a relational database schema type.";
        String descriptionGUID = null;
        String linkedToEntity = "RelationalTable";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("4814bec8-482d-463d-8376-160b0358e129", "RelationalView", null, "A view within a relational database schema type.", descriptionGUID, this.archiveBuilder.getEntityDef("RelationalTable"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "expression";
        String attribute1Description = "Expression of the view.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("expression", "Expression of the view.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private RelationshipDef getForeignKeyRelationship() {
        String guid = "3cd4e0e7-fdbf-47a6-ae88-d4b3205e0c07";
        String name = "ForeignKey";
        String description = "The primary key for another column is stored in a relational column from another table to enable them to be joined.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("3cd4e0e7-fdbf-47a6-ae88-d4b3205e0c07", "ForeignKey", null, "The primary key for another column is stored in a relational column from another table to enable them to be joined.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "RelationalColumn";
        String end1AttributeName = "primaryKey";
        String end1AttributeDescription = "Relational column holding the primary key.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("RelationalColumn"), "primaryKey", "Relational column holding the primary key.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "RelationalColumn";
        String end2AttributeName = "foreignKey";
        String end2AttributeDescription = "Use of primary key from another table to enable table joins.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("RelationalColumn"), "foreignKey", "Use of primary key from another table to enable table joins.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.CONFIDENCE.name;
        String attribute2Description = OpenMetadataProperty.CONFIDENCE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.CONFIDENCE.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.STEWARD.name;
        String attribute3Description = OpenMetadataProperty.STEWARD.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.SOURCE.name;
        String attribute4Description = OpenMetadataProperty.SOURCE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.NAME.name;
        String attribute5Description = OpenMetadataProperty.NAME.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0535EventSchemas() {
        this.archiveBuilder.addEntityDef(this.getEventSetEntity());
        this.archiveBuilder.addEntityDef(this.getEventTypeEntity());
    }

    private EntityDef getEventSetEntity() {
        String guid = "bead9aa4-214a-4596-8036-aa78395bbfb1";
        String name = "EventSet";
        String description = "A collection of related event types.";
        String descriptionGUID = null;
        String superTypeName = "Collection";
        return this.archiveHelper.getDefaultEntityDef("bead9aa4-214a-4596-8036-aa78395bbfb1", "EventSet", this.archiveBuilder.getEntityDef("Collection"), "A collection of related event types.", descriptionGUID);
    }

    private EntityDef getEventTypeEntity() {
        String guid = "8bc88aba-d7e4-4334-957f-cfe8e8eadc32";
        String name = "EventType";
        String description = "A description of an event (message)";
        String descriptionGUID = null;
        String superTypeName = "ComplexSchemaType";
        return this.archiveHelper.getDefaultEntityDef("8bc88aba-d7e4-4334-957f-cfe8e8eadc32", "EventType", this.archiveBuilder.getEntityDef("ComplexSchemaType"), "A description of an event (message)", descriptionGUID);
    }

    private void add0536APISchemas() {
        this.archiveBuilder.addEntityDef(this.getAPISchemaTypeEntity());
        this.archiveBuilder.addEntityDef(this.getAPIOperationSchemaEntity());
        this.archiveBuilder.addRelationshipDef(this.getAPIOperationsRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAPIHeaderRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAPIRequestRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAPIResponseRelationship());
    }

    private EntityDef getAPISchemaTypeEntity() {
        String guid = "b46cddb3-9864-4c5d-8a49-266b3fc95cb8";
        String name = "APISchemaType";
        String description = "Description of an API.";
        String descriptionGUID = null;
        String superTypeName = "SchemaType";
        return this.archiveHelper.getDefaultEntityDef("b46cddb3-9864-4c5d-8a49-266b3fc95cb8", "APISchemaType", this.archiveBuilder.getEntityDef("SchemaType"), "Description of an API.", descriptionGUID);
    }

    private EntityDef getAPIOperationSchemaEntity() {
        String guid = "f1c0af19-2729-4fac-996e-a7badff3c21c";
        String name = "APIOperation";
        String description = "Description of an API operation.";
        String descriptionGUID = null;
        String superTypeName = "SchemaType";
        return this.archiveHelper.getDefaultEntityDef("f1c0af19-2729-4fac-996e-a7badff3c21c", "APIOperation", this.archiveBuilder.getEntityDef("SchemaType"), "Description of an API operation.", descriptionGUID);
    }

    private RelationshipDef getAPIOperationsRelationship() {
        String guid = "03737169-ceb5-45f0-84f0-21c5929945af";
        String name = "APIOperations";
        String description = "Link between an API and its operations.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("03737169-ceb5-45f0-84f0-21c5929945af", "APIOperations", null, "Link between an API and its operations.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "APISchemaType";
        String end1AttributeName = "usedInAPI";
        String end1AttributeDescription = "API that this operation belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("APISchemaType"), "usedInAPI", "API that this operation belongs to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "APIOperation";
        String end2AttributeName = "containsOperations";
        String end2AttributeDescription = "Operations for this API type.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("APIOperation"), "containsOperations", "Operations for this API type.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAPIHeaderRelationship() {
        String guid = "e8fb46d1-5f75-481b-aa66-f43ad44e2cc6";
        String name = "APIHeader";
        String description = "Link between an API operation and its header.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e8fb46d1-5f75-481b-aa66-f43ad44e2cc6", "APIHeader", null, "Link between an API operation and its header.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "APIOperation";
        String end1AttributeName = "usedAsAPIHeader";
        String end1AttributeDescription = "API operations using this structure as the header.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("APIOperation"), "usedAsAPIHeader", "API operations using this structure as the header.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "apiHeader";
        String end2AttributeDescription = "Header structure for this API operation.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "apiHeader", "Header structure for this API operation.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAPIRequestRelationship() {
        String guid = "4ab3b466-31bd-48ea-8aa2-75623476f2e2";
        String name = "APIRequest";
        String description = "Link between an API operation and its request structure.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4ab3b466-31bd-48ea-8aa2-75623476f2e2", "APIRequest", null, "Link between an API operation and its request structure.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "APIOperation";
        String end1AttributeName = "usedAsAPIRequest";
        String end1AttributeDescription = "API operations using this structure as the request body.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("APIOperation"), "usedAsAPIRequest", "API operations using this structure as the request body.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "apiRequest";
        String end2AttributeDescription = "Request structure for this API operation.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "apiRequest", "Request structure for this API operation.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAPIResponseRelationship() {
        String guid = "e8001de2-1bb1-442b-a66f-9addc3641eae";
        String name = "APIResponse";
        String description = "Link between an API operation and its response structure.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e8001de2-1bb1-442b-a66f-9addc3641eae", "APIResponse", null, "Link between an API operation and its response structure.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "APIOperation";
        String end1AttributeName = "usedAsAPIResponse";
        String end1AttributeDescription = "API operations using this structure as the response.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("APIOperation"), "usedAsAPIResponse", "API operations using this structure as the response.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "apiResponse";
        String end2AttributeDescription = "Response structure for this API operation.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "apiResponse", "Response structure for this API operation.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0540DataClasses() {
        this.archiveBuilder.addEnumDef(this.getDataClassAssignmentStatusEnum());
        this.archiveBuilder.addEntityDef(this.getDataClassEntity());
        this.archiveBuilder.addRelationshipDef(this.getDataClassHierarchyRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDataClassCompositionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDataClassAssignmentRelationship());
    }

    private EnumDef getDataClassAssignmentStatusEnum() {
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(DataClassAssignmentStatus.getOpenTypeGUID(), DataClassAssignmentStatus.getOpenTypeName(), DataClassAssignmentStatus.getOpenTypeDescription(), DataClassAssignmentStatus.getOpenTypeDescriptionGUID(), DataClassAssignmentStatus.getOpenTypeDescriptionWiki());
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (CriticalityLevel enumValues : CriticalityLevel.values()) {
            EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(enumValues.getOrdinal(), enumValues.getName(), enumValues.getDescription(), enumValues.getDescriptionGUID());
            elementDefs.add(elementDef);
            if (!enumValues.isDefault()) continue;
            enumDef.setDefaultValue(elementDef);
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getDataClassEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_CLASS.typeGUID, OpenMetadataType.DATA_CLASS.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.DATA_CLASS.description, OpenMetadataType.DATA_CLASS.descriptionGUID, OpenMetadataType.DATA_CLASS.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute2DescriptionGUID = null;
        String attribute3Name = "classCode";
        String attribute3Description = "Name of processing class that can identify the data class.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "userDefined";
        String attribute4Description = "Defined by owning organization rather than vendor.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "namespace";
        String attribute5Description = "Logical group for this data class.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "specification";
        String attribute6Description = "Parsing string used to identify values of this data class.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "specificationDetails";
        String attribute7Description = "Additional properties used in the specification.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "dataType";
        String attribute8Description = "Typical data type used to store this value.";
        String attribute8DescriptionGUID = null;
        String attribute9Name = "defaultThreshold";
        String attribute9Description = "Match threshold that a data field is expected to achieve to be assigned this data class.";
        String attribute9DescriptionGUID = null;
        String attribute10Name = "example";
        String attribute10Description = "Example of a data value that matches this data class.";
        String attribute10DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("classCode", "Name of processing class that can identify the data class.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("userDefined", "Defined by owning organization rather than vendor.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("namespace", "Logical group for this data class.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("specification", "Parsing string used to identify values of this data class.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("specificationDetails", "Additional properties used in the specification.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("dataType", "Typical data type used to store this value.", attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getFloatTypeDefAttribute("defaultThreshold", "Match threshold that a data field is expected to achieve to be assigned this data class.", attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("example", "Example of a data value that matches this data class.", attribute10DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getDataClassHierarchyRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DATA_CLASS_HIERARCHY.typeGUID, OpenMetadataType.DATA_CLASS_HIERARCHY.typeName, null, OpenMetadataType.DATA_CLASS_HIERARCHY.description, OpenMetadataType.DATA_CLASS_HIERARCHY.descriptionGUID, OpenMetadataType.DATA_CLASS_HIERARCHY.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.DATA_CLASS.typeName;
        String end1AttributeName = "superDataClass";
        String end1AttributeDescription = "Data class that is the more abstract.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "superDataClass", "Data class that is the more abstract.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.DATA_CLASS.typeName;
        String end2AttributeName = "subDataClasses";
        String end2AttributeDescription = "Data classes that are more concrete.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "subDataClasses", "Data classes that are more concrete.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDataClassCompositionRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DATA_CLASS_COMPOSITION.typeGUID, OpenMetadataType.DATA_CLASS_COMPOSITION.typeName, null, OpenMetadataType.DATA_CLASS_COMPOSITION.description, OpenMetadataType.DATA_CLASS_COMPOSITION.descriptionGUID, OpenMetadataType.DATA_CLASS_COMPOSITION.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.DATA_CLASS.typeName;
        String end1AttributeName = "partOfDataClasses";
        String end1AttributeDescription = "Data classes that includes other data classes in its definition.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "partOfDataClasses", "Data classes that includes other data classes in its definition.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.DATA_CLASS.typeName;
        String end2AttributeName = "madeOfDataClasses";
        String end2AttributeDescription = "Data classes that provide part of another data class's definitions.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "madeOfDataClasses", "Data classes that provide part of another data class's definitions.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDataClassAssignmentRelationship() {
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(OpenMetadataType.DATA_CLASS_ASSIGNMENT.typeGUID, OpenMetadataType.DATA_CLASS_ASSIGNMENT.typeName, null, OpenMetadataType.DATA_CLASS_ASSIGNMENT.description, OpenMetadataType.DATA_CLASS_ASSIGNMENT.descriptionGUID, OpenMetadataType.DATA_CLASS_ASSIGNMENT.wikiURL, ClassificationPropagationRule.NONE);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "elementsAssignedToDataClass";
        String end1AttributeDescription = "Elements identified as managing data values that match the specification of a data class.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "elementsAssignedToDataClass", "Elements identified as managing data values that match the specification of a data class.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.DATA_CLASS.typeName;
        String end2AttributeName = "dataClassesAssignedToElement";
        String end2AttributeDescription = "Logical data type for this element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "dataClassesAssignedToElement", "Logical data type for this element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "method";
        String attribute1Description = "Method used to identify data class.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "status";
        String attribute2Description = "The status of the relationship.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "partialMatch";
        String attribute3Description = "Are there data values outside of the data class specification?";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.CONFIDENCE.name;
        String attribute4Description = OpenMetadataProperty.CONFIDENCE.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.CONFIDENCE.descriptionGUID;
        String attribute5Name = "threshold";
        String attribute5Description = "What was the threshold result used to determine that the data class matched.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "valueFrequency";
        String attribute6Description = "How often does the data class specification match the data values.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = OpenMetadataProperty.STEWARD.name;
        String attribute7Description = OpenMetadataProperty.STEWARD.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute8Name = OpenMetadataProperty.SOURCE.name;
        String attribute8Description = OpenMetadataProperty.SOURCE.description;
        String attribute8DescriptionGUID = OpenMetadataProperty.SOURCE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("method", "Method used to identify data class.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("DataClassAssignmentStatus", "status", "The status of the relationship.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("partialMatch", "Are there data values outside of the data class specification?", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getFloatTypeDefAttribute("threshold", "What was the threshold result used to determine that the data class matched.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute("valueFrequency", "How often does the data class specification match the data values.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute8Name, attribute8Description, attribute8DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0545ReferenceData() {
        this.archiveBuilder.addClassificationDef(this.getReferenceDataClassification());
        this.archiveBuilder.addEntityDef(this.getValidValueDefinitionEntity());
        this.archiveBuilder.addEntityDef(this.getValidValuesSetEntity());
        this.archiveBuilder.addRelationshipDef(this.getValidValuesAssignmentRelationship());
        this.archiveBuilder.addRelationshipDef(this.getValidValuesMemberRelationship());
        this.archiveBuilder.addRelationshipDef(this.getValidValuesImplementationRelationship());
    }

    private ClassificationDef getReferenceDataClassification() {
        String guid = OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.typeName;
        String description = OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.REFERENCE_DATA_CLASSIFICATION.wikiURL;
        String linkedToEntity = OpenMetadataType.ASSET.typeName;
        return this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private EntityDef getValidValueDefinitionEntity() {
        String guid = OpenMetadataType.VALID_VALUE_DEFINITION.typeGUID;
        String name = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        String description = OpenMetadataType.VALID_VALUE_DEFINITION.description;
        String descriptionGUID = OpenMetadataType.VALID_VALUE_DEFINITION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.VALID_VALUE_DEFINITION.wikiURL;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.USAGE.name;
        String attribute3Description = OpenMetadataProperty.USAGE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.USAGE.descriptionGUID;
        String attribute4Name = "scope";
        String attribute4Description = "Situations where this value can be used.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "preferredValue";
        String attribute5Description = "Preferred implementation value.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("scope", "Situations where this value can be used.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("preferredValue", "Preferred implementation value.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getValidValuesSetEntity() {
        String guid = OpenMetadataType.VALID_VALUE_SET.typeGUID;
        String name = OpenMetadataType.VALID_VALUE_SET.typeName;
        String description = OpenMetadataType.VALID_VALUE_SET.description;
        String descriptionGUID = OpenMetadataType.VALID_VALUE_SET.descriptionGUID;
        String descriptionWiki = OpenMetadataType.VALID_VALUE_SET.wikiURL;
        String superTypeName = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private RelationshipDef getValidValuesAssignmentRelationship() {
        String guid = OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeName;
        String description = OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "validValuesConsumer";
        String end1AttributeDescription = "The valid values set that this element belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "validValuesConsumer", "The valid values set that this element belongs to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        String end2AttributeName = "validValues";
        String end2AttributeDescription = "A definition of the valid values for this element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "validValues", "A definition of the valid values for this element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "strictRequirement";
        String attribute1Description = "Only values from the ValidValues set/definition are allowed.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("strictRequirement", "Only values from the ValidValues set/definition are allowed.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getValidValuesMemberRelationship() {
        String guid = OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName;
        String description = OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.VALID_VALUE_SET.typeName;
        String end1AttributeName = "validValuesSet";
        String end1AttributeDescription = "The valid values set that this element belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "validValuesSet", "The valid values set that this element belongs to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        String end2AttributeName = "memberOfValidValuesSet";
        String end2AttributeDescription = "Description of a single valid value.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "memberOfValidValuesSet", "Description of a single valid value.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getValidValuesImplementationRelationship() {
        String guid = OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeName;
        String description = OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.VALID_VALUE_DEFINITION.typeName;
        String end1AttributeName = "validValues";
        String end1AttributeDescription = "The valid values set that this element implements.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "validValues", "The valid values set that this element implements.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ASSET.typeName;
        String end2AttributeName = "validValuesImplementation";
        String end2AttributeDescription = "The asset where the valid values are implemented.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "validValuesImplementation", "The asset where the valid values are implemented.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "implementationValue";
        String attribute1Description = "Value in the asset that maps to this valid value if different from the preferred value.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("implementationValue", "Value in the asset that maps to this valid value if different from the preferred value.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0565DesignModelElements() {
        this.archiveBuilder.addEntityDef(this.getDesignModelElementEntity());
    }

    private EntityDef getDesignModelElementEntity() {
        String guid = "492e343f-2516-43b8-94b0-5bae0760dda6";
        String name = "DesignModelElement";
        String description = "An abstract, but well-formed representation of a concept, activity, architecture or other design element.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("492e343f-2516-43b8-94b0-5bae0760dda6", "DesignModelElement", this.archiveBuilder.getEntityDef(superTypeName), "An abstract, but well-formed representation of a concept, activity, architecture or other design element.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = "technicalName";
        String attribute2Description = "Technical name (no spaces) that can be used in artifact generation.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute3Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute4Name = "versionNumber";
        String attribute4Description = "Version number of the model element.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "author";
        String attribute5Description = "Name of the creator of the model (person or organization).";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("technicalName", "Technical name (no spaces) that can be used in artifact generation.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("versionNumber", "Version number of the model element.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("author", "Name of the creator of the model (person or organization).", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0566DesignModelOrganization() {
        this.archiveBuilder.addEntityDef(this.getDesignModelEntity());
        this.archiveBuilder.addEntityDef(this.getDesignModelGroupEntity());
        this.archiveBuilder.addRelationshipDef(this.getDesignModelElementOwnershipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDesignModelGroupOwnershipRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDesignModelGroupHierarchyRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDesignModelGroupMembershipRelationship());
    }

    private EntityDef getDesignModelEntity() {
        String guid = "bf17143d-8605-48c2-ba80-64c2ac8f8379";
        String name = "DesignModel";
        String description = "A curated collection of design model elements.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.ASSET.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("bf17143d-8605-48c2-ba80-64c2ac8f8379", "DesignModel", this.archiveBuilder.getEntityDef(superTypeName), "A curated collection of design model elements.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "technicalName";
        String attribute1Description = "Technical name (no spaces) that can be used in artifact generation.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "versionNumber";
        String attribute2Description = "Version number of the model.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "author";
        String attribute3Description = "Name of the creator of the model (person or organization).";
        String attribute3DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("technicalName", "Technical name (no spaces) that can be used in artifact generation.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("versionNumber", "Version number of the model.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("author", "Name of the creator of the model (person or organization).", attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDesignModelGroupEntity() {
        String guid = "b144ee2a-fa71-4897-b51a-dd5239c26910";
        String name = "DesignModelGroup";
        String description = "A collection of related design model elements within a model.";
        String descriptionGUID = null;
        String superTypeName = "DesignModelElement";
        return this.archiveHelper.getDefaultEntityDef("b144ee2a-fa71-4897-b51a-dd5239c26910", "DesignModelGroup", this.archiveBuilder.getEntityDef("DesignModelElement"), "A collection of related design model elements within a model.", descriptionGUID);
    }

    private RelationshipDef getDesignModelElementOwnershipRelationship() {
        String guid = "f3b18ac7-3357-4a0c-8988-77a98adad5b5";
        String name = "DesignModelElementOwnership";
        String description = "Links design model elements to their owning model.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("f3b18ac7-3357-4a0c-8988-77a98adad5b5", "DesignModelElementOwnership", null, "Links design model elements to their owning model.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DesignModel";
        String end1AttributeName = "owningModel";
        String end1AttributeDescription = "Owning model.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModel"), "owningModel", "Owning model.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DesignModelElement";
        String end2AttributeName = "elementsInModel";
        String end2AttributeDescription = "List of elements that belong to this model.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModelElement"), "elementsInModel", "List of elements that belong to this model.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDesignModelGroupOwnershipRelationship() {
        String guid = "4a985162-8130-4559-b68e-6e6a5dc19c2a";
        String name = "DesignModelGroupOwnership";
        String description = "Links a model to a design model group.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4a985162-8130-4559-b68e-6e6a5dc19c2a", "DesignModelGroupOwnership", null, "Links a model to a design model group.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DesignModel";
        String end1AttributeName = "anchorModel";
        String end1AttributeDescription = "Model that owns this group.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModel"), "anchorModel", "Model that owns this group.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DesignModelGroup";
        String end2AttributeName = "groupsInModel";
        String end2AttributeDescription = "List of groups that belong to this model.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModelGroup"), "groupsInModel", "List of groups that belong to this model.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDesignModelGroupHierarchyRelationship() {
        String guid = "809b7c6c-69f9-4dbf-a5dd-085664499438";
        String name = "DesignModelGroupHierarchy";
        String description = "Links a model's groups into a hierarchy.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("809b7c6c-69f9-4dbf-a5dd-085664499438", "DesignModelGroupHierarchy", null, "Links a model's groups into a hierarchy.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DesignModelGroup";
        String end1AttributeName = "parentModelGroup";
        String end1AttributeDescription = "Link parent group.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModelGroup"), "parentModelGroup", "Link parent group.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DesignModelGroup";
        String end2AttributeName = "childModelGroups";
        String end2AttributeDescription = "The groups nested in this group.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModelGroup"), "childModelGroups", "The groups nested in this group.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDesignModelGroupMembershipRelationship() {
        String guid = "2dcfe62b-341c-4c3d-b336-a94a52c20556";
        String name = "DesignModelGroupMembership";
        String description = "Links a design model element to a group.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2dcfe62b-341c-4c3d-b336-a94a52c20556", "DesignModelGroupMembership", null, "Links a design model element to a group.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DesignModelGroup";
        String end1AttributeName = "memberOfModelGroups";
        String end1AttributeDescription = "Link to a list of groups this element is a member of.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModelGroup"), "memberOfModelGroups", "Link to a list of groups this element is a member of.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DesignModelElement";
        String end2AttributeName = "elementsInGroup";
        String end2AttributeDescription = "List of elements that belong to this group.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModelElement"), "elementsInGroup", "List of elements that belong to this group.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0568DesignModelScoping() {
        this.archiveBuilder.addEntityDef(this.getDesignModelScopeEntity());
        this.archiveBuilder.addRelationshipDef(this.getDesignModelElementsInScopeRelationship());
    }

    private EntityDef getDesignModelScopeEntity() {
        String guid = "788957f7-a203-45bd-994d-0ab018275821";
        String name = "DesignModelScope";
        String description = "A selection of design model element needed for a project.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("788957f7-a203-45bd-994d-0ab018275821", "DesignModelScope", this.archiveBuilder.getEntityDef(superTypeName), "A selection of design model element needed for a project.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = "technicalName";
        String attribute2Description = "Technical name (no spaces) that can be used in artifact generation.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute3Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute4Name = "versionNumber";
        String attribute4Description = "Version number of the model element.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "author";
        String attribute5Description = "UserId of the creator of the model element.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("technicalName", "Technical name (no spaces) that can be used in artifact generation.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("versionNumber", "Version number of the model element.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("author", "UserId of the creator of the model element.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getDesignModelElementsInScopeRelationship() {
        String guid = "4ff6d91b-3836-4ba2-9ca9-87da91081faa";
        String name = "DesignModelElementsInScope";
        String description = "Links a model to an implementation.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4ff6d91b-3836-4ba2-9ca9-87da91081faa", "DesignModelElementsInScope", null, "Links a model to an implementation.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DesignModelScope";
        String end1AttributeName = "usedInScope";
        String end1AttributeDescription = "Link to a scope where this element is used.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModelScope"), "usedInScope", "Link to a scope where this element is used.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DesignModelElement";
        String end2AttributeName = "inScopeModelElements";
        String end2AttributeDescription = "List of elements that belong to this scope.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModelElement"), "inScopeModelElements", "List of elements that belong to this scope.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0569DesignModelImplementation() {
        this.archiveBuilder.addRelationshipDef(this.geDesignModelImplementationRelationship());
    }

    private RelationshipDef geDesignModelImplementationRelationship() {
        String guid = "c5cb1362-07f6-486b-b80b-ba7922cacee9";
        String name = "DesignModelImplementation";
        String description = "Links a concept model to an implementation.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("c5cb1362-07f6-486b-b80b-ba7922cacee9", "DesignModelImplementation", null, "Links a concept model to an implementation.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "implementationFollowingModel";
        String end1AttributeDescription = "Definition of an implementation of the model.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "implementationFollowingModel", "Definition of an implementation of the model.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DesignModelElement";
        String end2AttributeName = "modelDescribingBehavior";
        String end2AttributeDescription = "Descriptive abstraction.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignModelElement"), "modelDescribingBehavior", "Descriptive abstraction.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0570MetaModel() {
        this.archiveBuilder.addClassificationDef(this.getMetamodelClassification());
    }

    private ClassificationDef getMetamodelClassification() {
        String guid = "07bd0820-6b14-43b0-a625-2c89f2beb93a";
        String name = "MetamodelInstance";
        String description = "Identifies the element from a metadata model that this element embodies.";
        String descriptionGUID = null;
        String linkedToEntity = "DesignModelElement";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("07bd0820-6b14-43b0-a625-2c89f2beb93a", "MetamodelInstance", null, "Identifies the element from a metadata model that this element embodies.", descriptionGUID, this.archiveBuilder.getEntityDef("DesignModelElement"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "metamodelElementGUID";
        String attribute1Description = "Element in the metadata model that the attached element embodies.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("metamodelElementGUID", "Element in the metadata model that the attached element embodies.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0571ConceptModels() {
        this.archiveBuilder.addEnumDef(this.getConceptModelAttributeCoverageCategoryEnum());
        this.archiveBuilder.addEnumDef(this.getConceptModelDecorationEnum());
        this.archiveBuilder.addEntityDef(this.getConceptModelElementEntity());
        this.archiveBuilder.addEntityDef(this.getConceptBeadEntity());
        this.archiveBuilder.addEntityDef(this.getConceptBeadLinkEntity());
        this.archiveBuilder.addEntityDef(this.getConceptBeadAttributeEntity());
        this.archiveBuilder.addRelationshipDef(this.getConceptBeadRelationshipEndRelationship());
        this.archiveBuilder.addRelationshipDef(this.getConceptBeadAttributeLinkRelationship());
        this.archiveBuilder.addClassificationDef(this.getConceptBeadAttributeCoverageClassification());
    }

    private EnumDef getConceptModelAttributeCoverageCategoryEnum() {
        String guid = "2c0ac237-e02e-431a-89fd-3107d94d4007";
        String name = "ConceptModelAttributeCoverageCategory";
        String description = "Describes the type of attribute - this is used in scoping the model.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("2c0ac237-e02e-431a-89fd-3107d94d4007", "ConceptModelAttributeCoverageCategory", "Describes the type of attribute - this is used in scoping the model.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Unknown";
        String element1Description = "The attribute's coverage category is unknown - this is the default.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Unknown", "The attribute's coverage category is unknown - this is the default.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setDefaultValue(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "UniqueIdentifier";
        String element2Description = "The attribute uniquely identifies the concept bead.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "UniqueIdentifier", "The attribute uniquely identifies the concept bead.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Identifier";
        String element3Description = "The attribute is a good indicator of the identity of the concept bead but not guaranteed to be unique.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Identifier", "The attribute is a good indicator of the identity of the concept bead but not guaranteed to be unique.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "CoreDetail";
        String element4Description = "The attribute provides information that is typically required by all of the consumers of the concept bead.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "CoreDetail", "The attribute provides information that is typically required by all of the consumers of the concept bead.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element5Ordinal = 4;
        String element5Value = "ExtendedDetail";
        String element5Description = "The attribute contains supplementary information that is of interest to specific consumers of the concept bead.";
        String element5DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(4, "ExtendedDetail", "The attribute contains supplementary information that is of interest to specific consumers of the concept bead.", element5DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EnumDef getConceptModelDecorationEnum() {
        String guid = "a97d9167-7dd6-4dea-a8cf-c73c57a0f470";
        String name = "ConceptModelDecoration";
        String description = "Describes the type of relationship end.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("a97d9167-7dd6-4dea-a8cf-c73c57a0f470", "ConceptModelDecoration", "Describes the type of relationship end.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "None";
        String element1Description = "The relationship links two concept beads together.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "None", "The relationship links two concept beads together.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setDefaultValue(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "Aggregation";
        String element2Description = "The relationship links an independent concept bead to a collection concept bead.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "Aggregation", "The relationship links an independent concept bead to a collection concept bead.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Composition";
        String element3Description = "The relationship links a sub-part to a composite.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Composition", "The relationship links a sub-part to a composite.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "Extension";
        String element4Description = "The relationship links an extension to a base concept bead.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "Extension", "The relationship links an extension to a base concept bead.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getConceptModelElementEntity() {
        String guid = "06659195-3111-4c91-8931-a65f655378d9";
        String name = "ConceptModelElement";
        String description = "An abstract, but well-formed representation of a concept.";
        String descriptionGUID = null;
        String superTypeName = "DesignModelElement";
        return this.archiveHelper.getDefaultEntityDef("06659195-3111-4c91-8931-a65f655378d9", "ConceptModelElement", this.archiveBuilder.getEntityDef("DesignModelElement"), "An abstract, but well-formed representation of a concept.", descriptionGUID);
    }

    private EntityDef getConceptBeadEntity() {
        String guid = "f7feb509-bce6-4989-a340-5dc7e3eec313";
        String name = "ConceptBead";
        String description = "An abstract, but well-formed representation of a person, place or object.";
        String descriptionGUID = null;
        String superTypeName = "ConceptModelElement";
        return this.archiveHelper.getDefaultEntityDef("f7feb509-bce6-4989-a340-5dc7e3eec313", "ConceptBead", this.archiveBuilder.getEntityDef("ConceptModelElement"), "An abstract, but well-formed representation of a person, place or object.", descriptionGUID);
    }

    private EntityDef getConceptBeadLinkEntity() {
        String guid = "13defd95-6452-4398-8382-e47f1a271eff";
        String name = "ConceptBeadLink";
        String description = "A relationship between concept beads.";
        String descriptionGUID = null;
        String superTypeName = "ConceptModelElement";
        return this.archiveHelper.getDefaultEntityDef("13defd95-6452-4398-8382-e47f1a271eff", "ConceptBeadLink", this.archiveBuilder.getEntityDef("ConceptModelElement"), "A relationship between concept beads.", descriptionGUID);
    }

    private EntityDef getConceptBeadAttributeEntity() {
        String guid = "d804d406-ac74-4f92-9bde-2ba0793680ea";
        String name = "ConceptBeadAttribute";
        String description = "An abstract, but well-formed fact about a concept bead.";
        String descriptionGUID = null;
        String superTypeName = "ConceptModelElement";
        return this.archiveHelper.getDefaultEntityDef("d804d406-ac74-4f92-9bde-2ba0793680ea", "ConceptBeadAttribute", this.archiveBuilder.getEntityDef("ConceptModelElement"), "An abstract, but well-formed fact about a concept bead.", descriptionGUID);
    }

    private RelationshipDef getConceptBeadRelationshipEndRelationship() {
        String guid = "1a379e55-a4c0-4289-a1a4-b89d257611d1";
        String name = "ConceptBeadRelationshipEnd";
        String description = "Links one end of a concept bead link relationship to a concept bead.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("1a379e55-a4c0-4289-a1a4-b89d257611d1", "ConceptBeadRelationshipEnd", null, "Links one end of a concept bead link relationship to a concept bead.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ConceptBeadLink";
        String end1AttributeName = "relationships";
        String end1AttributeDescription = "The relationships that the concept bead can be a part of.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ConceptBeadLink"), "relationships", "The relationships that the concept bead can be a part of.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ConceptBead";
        String end2AttributeName = "endBeads";
        String end2AttributeDescription = "The concept beads that are linked via this relationship.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ConceptBead"), "endBeads", "The concept beads that are linked via this relationship.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "attributeName";
        String attribute1Description = "Name for the relationship end.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "decoration";
        String attribute2Description = "Usage and lifecycle for this connection between the concept bead and the link.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "position";
        String attribute3Description = "Position of this relationship in the concept bead's list of relationships.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "minCardinality";
        String attribute4Description = "Minimum number of occurrences of this attribute allowed (0 = optional, 1+ = mandatory).";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "maxCardinality";
        String attribute5Description = "Maximum number of occurrences of this attribute allowed (-1 = infinite).";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "uniqueValues";
        String attribute6Description = "When multiple occurrences are allowed, indicates whether duplicates of the same value are allowed or not.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "orderedValues";
        String attribute7Description = "When multiple occurrences are allowed, indicates whether the values are ordered or not.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "navigable";
        String attribute8Description = "Is it possible to follow the link in this direction.";
        String attribute8DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("attributeName", "Name for the relationship end.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("ConceptModelDecoration", "decoration", "Usage and lifecycle for this connection between the concept bead and the link.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("position", "Position of this relationship in the concept bead's list of relationships.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("minCardinality", "Minimum number of occurrences of this attribute allowed (0 = optional, 1+ = mandatory).", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("maxCardinality", "Maximum number of occurrences of this attribute allowed (-1 = infinite).", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("uniqueValues", "When multiple occurrences are allowed, indicates whether duplicates of the same value are allowed or not.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("orderedValues", "When multiple occurrences are allowed, indicates whether the values are ordered or not.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("navigable", "Is it possible to follow the link in this direction.", attribute8DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getConceptBeadAttributeLinkRelationship() {
        String guid = "5bad1df2-664b-407b-8036-2855e2ede92f";
        String name = "ConceptBeadAttributeLink";
        String description = "Links a concept bead to its attributes.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("5bad1df2-664b-407b-8036-2855e2ede92f", "ConceptBeadAttributeLink", null, "Links a concept bead to its attributes.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ConceptBead";
        String end1AttributeName = "parentBead";
        String end1AttributeDescription = "Concept bead that this attribute belongs to.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ConceptBead"), "parentBead", "Concept bead that this attribute belongs to.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ConceptBeadAttribute";
        String end2AttributeName = "attributes";
        String end2AttributeDescription = "Attribute detail for the concept bead.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ConceptBeadAttribute"), "attributes", "Attribute detail for the concept bead.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "position";
        String attribute1Description = "Position of this relationship in the concept bead's list of relationships.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "minCardinality";
        String attribute2Description = "Minimum number of occurrences of this attribute allowed (0 = optional, 1+ = mandatory).";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "maxCardinality";
        String attribute3Description = "Maximum number of occurrences of this attribute allowed (-1 = infinite).";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "uniqueValues";
        String attribute4Description = "When multiple occurrences are allowed, indicates whether duplicates of the same value are allowed or not.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "orderedValues";
        String attribute5Description = "When multiple occurrences are allowed, indicates whether the values are ordered or not.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "navigable";
        String attribute6Description = "Is it possible to follow the link in this direction.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("position", "Position of this relationship in the concept bead's list of relationships.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("minCardinality", "Minimum number of occurrences of this attribute allowed (0 = optional, 1+ = mandatory).", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute("maxCardinality", "Maximum number of occurrences of this attribute allowed (-1 = infinite).", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("uniqueValues", "When multiple occurrences are allowed, indicates whether duplicates of the same value are allowed or not.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("orderedValues", "When multiple occurrences are allowed, indicates whether the values are ordered or not.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getBooleanTypeDefAttribute("navigable", "Is it possible to follow the link in this direction.", attribute6DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private ClassificationDef getConceptBeadAttributeCoverageClassification() {
        String guid = "f8b60afe-ddef-4b6f-9628-82ebfff34d65";
        String name = "ConceptBeadAttributeCoverage";
        String description = "Identifies the coverage category of a concept bead attribute.";
        String descriptionGUID = null;
        String linkedToEntity = "ConceptBeadAttribute";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("f8b60afe-ddef-4b6f-9628-82ebfff34d65", "ConceptBeadAttributeCoverage", null, "Identifies the coverage category of a concept bead attribute.", descriptionGUID, this.archiveBuilder.getEntityDef("ConceptBeadAttribute"), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "coverageCategory";
        String attribute1Description = "Type of role that the attribute plays as part of the concept bead.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("ConceptModelAttributeCoverageCategory", "coverageCategory", "Type of role that the attribute plays as part of the concept bead.", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0595DesignPatterns() {
        this.archiveBuilder.addEntityDef(this.getDesignPatternEntity());
        this.archiveBuilder.addRelationshipDef(this.getRelatedPatternRelationship());
    }

    private EntityDef getDesignPatternEntity() {
        String guid = "6b60a73e-47bc-4096-9073-f94cab975958";
        String name = "DesignPattern";
        String description = "A description of a common solution with details of the problems it solves and its pros and cons.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("6b60a73e-47bc-4096-9073-f94cab975958", "DesignPattern", this.archiveBuilder.getEntityDef(superTypeName), "A description of a common solution with details of the problems it solves and its pros and cons.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "context";
        String attribute1Description = "Description of the situation where this pattern may be useful.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "forces";
        String attribute2Description = "Description of the aspects of the situation that make the problem hard to solve.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "problemStatement";
        String attribute3Description = "Description of the types of problem that this design pattern provides a solution to.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "problemExample";
        String attribute4Description = "One or more examples of the problem and its consequences.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "solutionDescription";
        String attribute5Description = "Description of how the solution works.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "solutionExample";
        String attribute6Description = "Illustrations of how the solution resolves the problem examples.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "benefits";
        String attribute7Description = "The positive outcomes from using this pattern.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "liabilities";
        String attribute8Description = "The additional issues that need to be considered when using this pattern.";
        String attribute8DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("context", "Description of the situation where this pattern may be useful.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("forces", "Description of the aspects of the situation that make the problem hard to solve.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("problemStatement", "Description of the types of problem that this design pattern provides a solution to.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("problemExample", "One or more examples of the problem and its consequences.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("solutionDescription", "Description of how the solution works.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("solutionExample", "Illustrations of how the solution resolves the problem examples.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("benefits", "The positive outcomes from using this pattern.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("liabilities", "The additional issues that need to be considered when using this pattern.", attribute8DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getRelatedPatternRelationship() {
        String guid = "6447c9cd-8e5a-461b-97f9-5151bcb97a9e";
        String name = "RelatedDesignPattern";
        String description = "Links design patterns together.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("6447c9cd-8e5a-461b-97f9-5151bcb97a9e", "RelatedDesignPattern", null, "Links design patterns together.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "DesignPattern";
        String end1AttributeName = "relatedDesignPattern";
        String end1AttributeDescription = "Another design pattern that operates in similar contexts.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignPattern"), "relatedDesignPattern", "Another design pattern that operates in similar contexts.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DesignPattern";
        String end2AttributeName = "relatedDesignPattern";
        String end2AttributeDescription = "Another design pattern that operates in similar contexts.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DesignPattern"), "relatedDesignPattern", "Another design pattern that operates in similar contexts.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute1Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0598LineageRelationships() {
        this.archiveBuilder.addRelationshipDef(this.getPortSchemaRelationship());
        this.archiveBuilder.addRelationshipDef(this.getLineageMappingRelationship());
    }

    private RelationshipDef getPortSchemaRelationship() {
        String guid = "B216fA00-8281-F9CC-9911-Ae6377f2b457";
        String name = "PortSchema";
        String description = "A link between a Port and a SchemaType";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("B216fA00-8281-F9CC-9911-Ae6377f2b457", "PortSchema", null, "A link between a Port and a SchemaType", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "Port";
        String end1AttributeName = "port";
        String end1AttributeDescription = "Port";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Port"), "port", "Port", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "SchemaType";
        String end2AttributeDescription = "SchemaType";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "SchemaType", "SchemaType", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getLineageMappingRelationship() {
        String guid = "a5991bB2-660D-A3a1-2955-fAcDA2d5F4Ff";
        String name = "LineageMapping";
        String description = "A link between two schema attributes.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("a5991bB2-660D-A3a1-2955-fAcDA2d5F4Ff", "LineageMapping", null, "A link between two schema attributes.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        String end1AttributeName = "sourceElement";
        String end1AttributeDescription = "Source Attribute.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "sourceElement", "Source Attribute.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        String end2AttributeName = "targetElement";
        String end2AttributeDescription = "Target Attribute.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "targetElement", "Target Attribute.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void addArea6Types() {
        this.add0601OpenDiscoveryEngine();
        this.add0602OpenDiscoveryServices();
        this.add0603OpenDiscoveryPipelines();
        this.add0605OpenDiscoveryAnalysisReports();
        this.add0610Annotations();
        this.add0612AnnotationReviews();
        this.add0615SchemaExtraction();
        this.add0617DataFieldAnalysis();
        this.add0620DataProfiling();
        this.add0625DataClassDiscovery();
        this.add0630SemanticDiscovery();
        this.add0635ClassificationDiscovery();
        this.add0640QualityScores();
        this.add0650RelationshipDiscovery();
        this.add0660ResourceMeasures();
        this.add0690RequestForAction();
    }

    private void add0601OpenDiscoveryEngine() {
        this.archiveBuilder.addEntityDef(this.getOpenDiscoveryEngineEntity());
    }

    private EntityDef getOpenDiscoveryEngineEntity() {
        String guid = OpenMetadataType.OPEN_DISCOVERY_ENGINE.typeGUID;
        String name = OpenMetadataType.OPEN_DISCOVERY_ENGINE.typeName;
        String description = OpenMetadataType.OPEN_DISCOVERY_ENGINE.description;
        String descriptionGUID = OpenMetadataType.OPEN_DISCOVERY_ENGINE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.OPEN_DISCOVERY_ENGINE.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private void add0602OpenDiscoveryServices() {
        this.archiveBuilder.addEntityDef(this.getOpenDiscoveryServiceEntity());
    }

    private EntityDef getOpenDiscoveryServiceEntity() {
        String guid = OpenMetadataType.OPEN_DISCOVERY_SERVICE.typeGUID;
        String name = OpenMetadataType.OPEN_DISCOVERY_SERVICE.typeName;
        String description = OpenMetadataType.OPEN_DISCOVERY_SERVICE.description;
        String descriptionGUID = OpenMetadataType.OPEN_DISCOVERY_SERVICE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.OPEN_DISCOVERY_SERVICE.wikiURL;
        String superTypeName = "DeployedSoftwareComponent";
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef("DeployedSoftwareComponent"), description, descriptionGUID, descriptionWiki);
    }

    private void add0603OpenDiscoveryPipelines() {
        this.archiveBuilder.addEntityDef(this.getOpenDiscoveryPipelineEntity());
    }

    private EntityDef getOpenDiscoveryPipelineEntity() {
        String guid = OpenMetadataType.OPEN_DISCOVERY_PIPELINE.typeGUID;
        String name = OpenMetadataType.OPEN_DISCOVERY_PIPELINE.typeName;
        String description = OpenMetadataType.OPEN_DISCOVERY_PIPELINE.description;
        String descriptionGUID = OpenMetadataType.OPEN_DISCOVERY_PIPELINE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.OPEN_DISCOVERY_PIPELINE.wikiURL;
        String superTypeName = OpenMetadataType.OPEN_DISCOVERY_SERVICE.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private void add0605OpenDiscoveryAnalysisReports() {
        this.archiveBuilder.addEnumDef(this.getDiscoveryRequestStatusEnum());
        this.archiveBuilder.addEntityDef(this.getOpenDiscoveryAnalysisReportEntity());
        this.archiveBuilder.addRelationshipDef(this.getDiscoveryEngineReportRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDiscoveryInvocationReportRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAssetDiscoveryReportRelationship());
    }

    private EnumDef getDiscoveryRequestStatusEnum() {
        String guid = "ecb48ca2-4d29-4de9-99a1-bc4db9816d68";
        String name = "DiscoveryRequestStatus";
        String description = "Defines the progress or completion of a discovery request.";
        String descriptionGUID = null;
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef("ecb48ca2-4d29-4de9-99a1-bc4db9816d68", "DiscoveryRequestStatus", "Defines the progress or completion of a discovery request.", descriptionGUID);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        boolean element1Ordinal = false;
        String element1Value = "Waiting";
        String element1Description = "Discovery request is waiting to execute.";
        String element1DescriptionGUID = null;
        EnumElementDef elementDef = this.archiveHelper.getEnumElementDef(0, "Waiting", "Discovery request is waiting to execute.", element1DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setDefaultValue(elementDef);
        boolean element2Ordinal = true;
        String element2Value = "InProgress";
        String element2Description = "Discovery request is executing.";
        String element2DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(1, "InProgress", "Discovery request is executing.", element2DescriptionGUID);
        elementDefs.add(elementDef);
        int element3Ordinal = 2;
        String element3Value = "Failed";
        String element3Description = "Discovery request has failed.";
        String element3DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(2, "Failed", "Discovery request has failed.", element3DescriptionGUID);
        elementDefs.add(elementDef);
        int element4Ordinal = 3;
        String element4Value = "Completed";
        String element4Description = "Discovery request has completed successfully.";
        String element4DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(3, "Completed", "Discovery request has completed successfully.", element4DescriptionGUID);
        elementDefs.add(elementDef);
        int element99Ordinal = 99;
        String element99Value = "Unknown";
        String element99Description = "Discovery request status is unknown.";
        String element99DescriptionGUID = null;
        elementDef = this.archiveHelper.getEnumElementDef(99, "Unknown", "Discovery request status is unknown.", element99DescriptionGUID);
        elementDefs.add(elementDef);
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getOpenDiscoveryAnalysisReportEntity() {
        String guid = "acc7cbc8-09c3-472b-87dd-f78459323dcb";
        String name = "OpenDiscoveryAnalysisReport";
        String description = "A set of results from an open discovery service.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("acc7cbc8-09c3-472b-87dd-f78459323dcb", "OpenDiscoveryAnalysisReport", this.archiveBuilder.getEntityDef(superTypeName), "A set of results from an open discovery service.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute1Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = "executionDate";
        String attribute3Description = "Date that the analysis was run.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "analysisParameters";
        String attribute4Description = "Additional parameters used to drive the analysis.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "discoveryRequestStatus";
        String attribute5Description = "Status of the discovery analysis show in the report.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "anchorGUID";
        String attribute6Description = "Optional identifier of the asset that this report is connected to.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute("executionDate", "Date that the analysis was run.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute("analysisParameters", "Additional parameters used to drive the analysis.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("DiscoveryRequestStatus", "discoveryRequestStatus", "Status of the discovery analysis show in the report.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Optional identifier of the asset that this report is connected to.", attribute6DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getDiscoveryEngineReportRelationship() {
        String guid = "2c318c3a-5dc2-42cd-a933-0087d852f67f";
        String name = "DiscoveryEngineReport";
        String description = "A discovery analysis report created by a discovery engine.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("2c318c3a-5dc2-42cd-a933-0087d852f67f", "DiscoveryEngineReport", null, "A discovery analysis report created by a discovery engine.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "OpenDiscoveryEngine";
        String end1AttributeName = "sourceDiscoveryEngine";
        String end1AttributeDescription = "The discovery engine that produced the report.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OpenDiscoveryEngine"), "sourceDiscoveryEngine", "The discovery engine that produced the report.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "OpenDiscoveryAnalysisReport";
        String end2AttributeName = "discoveryEngineAnalysisReports";
        String end2AttributeDescription = "The reports produced by this discovery engine.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OpenDiscoveryAnalysisReport"), "discoveryEngineAnalysisReports", "The reports produced by this discovery engine.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDiscoveryInvocationReportRelationship() {
        String guid = "1744d72b-903d-4273-9229-de20372a17e2";
        String name = "DiscoveryInvocationReport";
        String description = "An analysis report from a discovery service.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("1744d72b-903d-4273-9229-de20372a17e2", "DiscoveryInvocationReport", null, "An analysis report from a discovery service.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "OpenDiscoveryService";
        String end1AttributeName = "sourceDiscoveryService";
        String end1AttributeDescription = "The discovery service that produced the report.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OpenDiscoveryService"), "sourceDiscoveryService", "The discovery service that produced the report.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "OpenDiscoveryAnalysisReport";
        String end2AttributeName = "serviceDiscoveryAnalysisReports";
        String end2AttributeDescription = "The reports produced by this discovery service.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OpenDiscoveryAnalysisReport"), "serviceDiscoveryAnalysisReports", "The reports produced by this discovery service.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAssetDiscoveryReportRelationship() {
        String guid = "7eded424-f176-4258-9ae6-138a46b2845f";
        String name = "AssetDiscoveryReport";
        String description = "An analysis report from a discovery service.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("7eded424-f176-4258-9ae6-138a46b2845f", "AssetDiscoveryReport", null, "An analysis report from a discovery service.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.ASSET.typeName;
        String end1AttributeName = "discoveryReportTarget";
        String end1AttributeDescription = "The asset that is analyzed in the report.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "discoveryReportTarget", "The asset that is analyzed in the report.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "OpenDiscoveryAnalysisReport";
        String end2AttributeName = "assetDiscoveryAnalysisReports";
        String end2AttributeDescription = "The reports produced about this asset.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OpenDiscoveryAnalysisReport"), "assetDiscoveryAnalysisReports", "The reports produced about this asset.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0610Annotations() {
        this.archiveBuilder.addEntityDef(this.getAnnotationEntity());
        this.archiveBuilder.addRelationshipDef(this.getDiscoveredAnnotationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getAnnotationExtensionRelationship());
    }

    private EntityDef getAnnotationEntity() {
        String guid = OpenMetadataType.ANNOTATION.typeGUID;
        String name = OpenMetadataType.ANNOTATION.typeName;
        String description = OpenMetadataType.ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ANNOTATION.wikiURL;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, null, description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.ANNOTATION_TYPE.name;
        String attribute1Description = OpenMetadataProperty.ANNOTATION_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.ANNOTATION_TYPE.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.SUMMARY.name;
        String attribute2Description = OpenMetadataProperty.SUMMARY.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.SUMMARY.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.CONFIDENCE_LEVEL.name;
        String attribute3Description = OpenMetadataProperty.CONFIDENCE_LEVEL.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.CONFIDENCE_LEVEL.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.EXPRESSION.name;
        String attribute4Description = OpenMetadataProperty.EXPRESSION.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.EXPRESSION.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.EXPLANATION.name;
        String attribute5Description = OpenMetadataProperty.EXPLANATION.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.EXPLANATION.descriptionGUID;
        String attribute6Name = OpenMetadataProperty.ANALYSIS_STEP.name;
        String attribute6Description = OpenMetadataProperty.ANALYSIS_STEP.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.ANALYSIS_STEP.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.JSON_PROPERTIES.name;
        String attribute7Description = OpenMetadataProperty.JSON_PROPERTIES.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.JSON_PROPERTIES.descriptionGUID;
        String attribute8Name = OpenMetadataProperty.ADDITIONAL_PROPERTIES.name;
        String attribute8Description = OpenMetadataProperty.ADDITIONAL_PROPERTIES.description;
        String attribute8DescriptionGUID = OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID;
        String attribute9Name = OpenMetadataProperty.ANCHOR_GUID.name;
        String attribute9Description = OpenMetadataProperty.ANCHOR_GUID.description;
        String attribute9DescriptionGUID = OpenMetadataProperty.ANCHOR_GUID.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute8Name, attribute8Description, attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute9Name, attribute9Description, attribute9DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getDiscoveredAnnotationRelationship() {
        String guid = "51d386a3-3857-42e3-a3df-14a6cad08b93";
        String name = "DiscoveredAnnotation";
        String description = "The annotations that make up a discovery analysis report.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("51d386a3-3857-42e3-a3df-14a6cad08b93", "DiscoveredAnnotation", null, "The annotations that make up a discovery analysis report.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.ANNOTATION.typeName;
        String end1AttributeName = "reportedAnnotations";
        String end1AttributeDescription = "The annotations providing the contents for the report.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "reportedAnnotations", "The annotations providing the contents for the report.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "OpenDiscoveryAnalysisReport";
        String end2AttributeName = "fromAnalysisReport";
        String end2AttributeDescription = "The report that the annotations belong to.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OpenDiscoveryAnalysisReport"), "fromAnalysisReport", "The report that the annotations belong to.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getAnnotationExtensionRelationship() {
        String guid = OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.typeName;
        String description = OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ANNOTATION_EXTENSION_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.ANNOTATION.typeName;
        String end1AttributeName = "extendedAnnotations";
        String end1AttributeDescription = "The annotations being extended.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "extendedAnnotations", "The annotations being extended.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ANNOTATION.typeName;
        String end2AttributeName = "annotationExtensions";
        String end2AttributeDescription = "The annotations providing additional information.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "annotationExtensions", "The annotations providing additional information.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0612AnnotationReviews() {
        this.archiveBuilder.addEnumDef(this.getAnnotationStatusEnum());
        this.archiveBuilder.addEntityDef(this.getAnnotationReviewEntity());
        this.archiveBuilder.addRelationshipDef(this.getAnnotationReviewLinkRelationship());
    }

    private EnumDef getAnnotationStatusEnum() {
        String guid = AnnotationStatus.getOpenTypeGUID();
        String name = AnnotationStatus.getOpenTypeName();
        String description = AnnotationStatus.getOpenTypeDescription();
        String descriptionGUID = AnnotationStatus.getOpenTypeDescriptionGUID();
        String descriptionWiki = AnnotationStatus.getOpenTypeWikiURL();
        EnumDef enumDef = this.archiveHelper.getEmptyEnumDef(guid, name, description, descriptionGUID, descriptionWiki);
        ArrayList<EnumElementDef> elementDefs = new ArrayList<EnumElementDef>();
        for (AnnotationStatus annotationStatus : AnnotationStatus.values()) {
            elementDefs.add(this.archiveHelper.getEnumElementDef(annotationStatus.getOrdinal(), annotationStatus.getName(), annotationStatus.getDescription(), annotationStatus.getDescriptionGUID()));
        }
        enumDef.setElementDefs(elementDefs);
        return enumDef;
    }

    private EntityDef getAnnotationReviewEntity() {
        String guid = OpenMetadataType.ANNOTATION_REVIEW.typeGUID;
        String name = OpenMetadataType.ANNOTATION_REVIEW.typeName;
        String description = OpenMetadataType.ANNOTATION_REVIEW.description;
        String descriptionGUID = OpenMetadataType.ANNOTATION_REVIEW.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ANNOTATION_REVIEW.wikiURL;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, null, description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.REVIEW_DATE.name;
        String attribute1Description = OpenMetadataProperty.REVIEW_DATE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.REVIEW_DATE.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.STEWARD.name;
        String attribute2Description = OpenMetadataProperty.STEWARD.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.STEWARD.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.COMMENT.name;
        String attribute3Description = OpenMetadataProperty.COMMENT.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.COMMENT.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getAnnotationReviewLinkRelationship() {
        String guid = OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeName;
        String description = OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.ANNOTATION.typeName;
        String end1AttributeName = "reviewedAnnotations";
        String end1AttributeDescription = "The annotations being reviewed.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "reviewedAnnotations", "The annotations being reviewed.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ANNOTATION_REVIEW.typeName;
        String end2AttributeName = "annotationReviews";
        String end2AttributeDescription = "The feedback about the annotations.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "annotationReviews", "The feedback about the annotations.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.ANNOTATION_STATUS.name;
        String attribute1Description = OpenMetadataProperty.ANNOTATION_STATUS.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.ANNOTATION_STATUS.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("AnnotationStatus", attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0615SchemaExtraction() {
        this.archiveBuilder.addEntityDef(this.getSchemaAnalysisAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getDataFieldEntity());
        this.archiveBuilder.addRelationshipDef(this.getSchemaTypeDefinitionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDiscoveredDataFieldRelationship());
        this.archiveBuilder.addRelationshipDef(this.getSchemaAttributeDefinitionRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDiscoveredNestedDataFieldRelationship());
        this.archiveBuilder.addRelationshipDef(this.getDataClassDefinitionRelationship());
    }

    private EntityDef getSchemaAnalysisAnnotationEntity() {
        String guid = OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.typeGUID;
        String name = OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.typeName;
        String description = OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.ANNOTATION.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.SCHEMA_NAME.name;
        String attribute1Description = OpenMetadataProperty.SCHEMA_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.SCHEMA_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.SCHEMA_TYPE.name;
        String attribute2Description = OpenMetadataProperty.SCHEMA_TYPE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.SCHEMA_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDataFieldEntity() {
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(OpenMetadataType.DATA_FIELD.typeGUID, OpenMetadataType.DATA_FIELD.typeName, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), OpenMetadataType.DATA_FIELD.description, OpenMetadataType.DATA_FIELD.descriptionGUID, OpenMetadataType.DATA_FIELD.wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "dataFieldName";
        String attribute1Description = "Display name the data field.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "dataFieldType";
        String attribute2Description = "Type name for the data field.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "defaultValue";
        String attribute3Description = "Default value that is added to the field if no value is specified.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.ADDITIONAL_PROPERTIES.name;
        String attribute4Description = "Additional properties discovered during the analysis.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "anchorGUID";
        String attribute5Description = "Optional identifier of the asset that this data field is indirectly connected to.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "dataFieldDescription";
        String attribute6Description = "Optional descriptive information about a data field.";
        String attribute6DescriptionGUID = null;
        String attribute7Name = "dataFieldAliases";
        String attribute7Description = "Optional list of aliases for the data field.";
        String attribute7DescriptionGUID = null;
        String attribute8Name = "dataFieldSortOrder";
        String attribute8Description = "Sort order for the values of the data field.";
        String attribute8DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("dataFieldName", "Display name the data field.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("dataFieldType", "Type name for the data field.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("defaultValue", "Default value that is added to the field if no value is specified.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute4Name, "Additional properties discovered during the analysis.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("anchorGUID", "Optional identifier of the asset that this data field is indirectly connected to.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("dataFieldDescription", "Optional descriptive information about a data field.", attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("dataFieldAliases", "Optional list of aliases for the data field.", attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("DataItemSortOrder", "dataFieldSortOrder", "Sort order for the values of the data field.", attribute8DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getSchemaTypeDefinitionRelationship() {
        String guid = "60f2d263-e24d-4f20-8c0d-b5e24648cd54";
        String name = "SchemaTypeDefinition";
        String description = "Link between schema analysis annotation and the identified schema type definition.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("60f2d263-e24d-4f20-8c0d-b5e24648cd54", "SchemaTypeDefinition", null, "Link between schema analysis annotation and the identified schema type definition.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SchemaAnalysisAnnotation";
        String end1AttributeName = "deployedSchemaTypes";
        String end1AttributeDescription = "The analysis of the schema type for deployed assets.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaAnalysisAnnotation"), "deployedSchemaTypes", "The analysis of the schema type for deployed assets.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "schemaTypeDefinition";
        String end2AttributeDescription = "Official schema type definition.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "schemaTypeDefinition", "Official schema type definition.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDiscoveredDataFieldRelationship() {
        String guid = "60f2d263-e24d-4f20-8c0d-b5e22222cd54";
        String name = "DiscoveredDataField";
        String description = "Data field detected in asset during schema analysis.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("60f2d263-e24d-4f20-8c0d-b5e22222cd54", "DiscoveredDataField", null, "Data field detected in asset during schema analysis.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.typeName;
        String end1AttributeName = "schemaAnalysisAnnotation";
        String end1AttributeDescription = "The annotation collecting the results of the schema analysis.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "schemaAnalysisAnnotation", "The annotation collecting the results of the schema analysis.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.DATA_FIELD.typeName;
        String end2AttributeName = "discoveredDataFields";
        String end2AttributeDescription = "The data fields discovered during schema analysis.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "discoveredDataFields", "The data fields discovered during schema analysis.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "dataFieldPosition";
        String attribute1Description = "Location of the data field in the parent annotation's list of data fields.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("dataFieldPosition", "Location of the data field in the parent annotation's list of data fields.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getSchemaAttributeDefinitionRelationship() {
        String guid = "60f1e263-e24d-4f20-8c0d-b5e21232cd54";
        String name = "SchemaAttributeDefinition";
        String description = "Link between data field analysis and the identified schema attribute definition.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("60f1e263-e24d-4f20-8c0d-b5e21232cd54", "SchemaAttributeDefinition", null, "Link between data field analysis and the identified schema attribute definition.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.DATA_FILE.typeName;
        String end1AttributeName = "deployedSchemaAttributes";
        String end1AttributeDescription = "The analysis of the equivalent data fields from deployed assets.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "deployedSchemaAttributes", "The analysis of the equivalent data fields from deployed assets.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        String end2AttributeName = "schemaAttributeDefinition";
        String end2AttributeDescription = "Official schema attribute definition.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "schemaAttributeDefinition", "Official schema attribute definition.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private RelationshipDef getDiscoveredNestedDataFieldRelationship() {
        String guid = "60f2d263-e24d-4f20-8c0d-b5e12356cd54";
        String name = "NestedDataField";
        String description = "Nested data fields under a single parent node.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("60f2d263-e24d-4f20-8c0d-b5e12356cd54", "NestedDataField", null, "Nested data fields under a single parent node.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.DATA_FIELD.typeName;
        String end1AttributeName = "parentDataField";
        String end1AttributeDescription = "Parent node.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "parentDataField", "Parent node.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.DATA_FIELD.typeName;
        String end2AttributeName = "nestedDataFields";
        String end2AttributeDescription = "Nested data fields.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "nestedDataFields", "Nested data fields.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "dataFieldPosition";
        String attribute1Description = "Positional order of the data field with its parent data field.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("dataFieldPosition", "Positional order of the data field with its parent data field.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getDataClassDefinitionRelationship() {
        String guid = "51a2d263-e24d-4f20-8c0d-b5e12356cd54";
        String name = "DataClassDefinition";
        String description = "Link between schema analysis and the identified data class for a data field.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("51a2d263-e24d-4f20-8c0d-b5e12356cd54", "DataClassDefinition", null, "Link between schema analysis and the identified data class for a data field.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.DATA_FIELD.typeName;
        String end1AttributeName = "deployedDataClasses";
        String end1AttributeDescription = "The mapped data fields from deployed assets.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "deployedDataClasses", "The mapped data fields from deployed assets.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "DataClass";
        String end2AttributeName = "dataClassDefinition";
        String end2AttributeDescription = "Official data class definition.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("DataClass"), "dataClassDefinition", "Official data class definition.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "assetGUID";
        String attribute1Description = "Unique identifier for the analyzed asset.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("assetGUID", "Unique identifier for the analyzed asset.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0617DataFieldAnalysis() {
        this.archiveBuilder.addEntityDef(this.getDataFieldAnnotationEntity());
        this.archiveBuilder.addRelationshipDef(this.getDataFieldAnalysisRelationship());
    }

    private EntityDef getDataFieldAnnotationEntity() {
        String guid = OpenMetadataType.DATA_FIELD_ANNOTATION.typeGUID;
        String name = OpenMetadataType.DATA_FIELD_ANNOTATION.typeName;
        String description = OpenMetadataType.DATA_FIELD_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.DATA_FIELD_ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_FIELD_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.ANNOTATION.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private RelationshipDef getDataFieldAnalysisRelationship() {
        String guid = OpenMetadataType.DATA_FIELD_ANALYSIS_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.DATA_FIELD_ANALYSIS_RELATIONSHIP.typeName;
        String description = OpenMetadataType.DATA_FIELD_ANALYSIS_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.DATA_FIELD_ANALYSIS_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_FIELD_ANALYSIS_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.DATA_FIELD_ANNOTATION.typeName;
        String end1AttributeName = "dataFieldAnnotations";
        String end1AttributeDescription = "The annotations for this data field.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "dataFieldAnnotations", "The annotations for this data field.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.DATA_FIELD.typeName;
        String end2AttributeName = "annotatedDataFields";
        String end2AttributeDescription = "Data fields with addition properties attached.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "annotatedDataFields", "Data fields with addition properties attached.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0620DataProfiling() {
        this.archiveBuilder.addEntityDef(this.getDataProfileAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getResourceProfileLogAnnotationEntity());
        this.archiveBuilder.addRelationshipDef(this.getResourceProfileLogFileRelationship());
    }

    private EntityDef getDataProfileAnnotationEntity() {
        String guid = OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeGUID;
        String name = OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName;
        String description = OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.DATA_FIELD_ANNOTATION.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.LENGTH.name;
        String attribute1Description = OpenMetadataProperty.LENGTH.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.LENGTH.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.INFERRED_DATA_TYPE.name;
        String attribute2Description = OpenMetadataProperty.INFERRED_DATA_TYPE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.INFERRED_DATA_TYPE.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.INFERRED_FORMAT.name;
        String attribute3Description = OpenMetadataProperty.INFERRED_FORMAT.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.INFERRED_FORMAT.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.INFERRED_LENGTH.name;
        String attribute4Description = OpenMetadataProperty.INFERRED_LENGTH.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.INFERRED_LENGTH.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.INFERRED_PRECISION.name;
        String attribute5Description = OpenMetadataProperty.INFERRED_PRECISION.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.INFERRED_PRECISION.descriptionGUID;
        String attribute6Name = OpenMetadataProperty.INFERRED_SCALE.name;
        String attribute6Description = OpenMetadataProperty.INFERRED_SCALE.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.INFERRED_SCALE.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.PROFILE_PROPERTIES.name;
        String attribute7Description = OpenMetadataProperty.PROFILE_PROPERTIES.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.PROFILE_PROPERTIES.descriptionGUID;
        String attribute8Name = OpenMetadataProperty.PROFILE_FLAGS.name;
        String attribute8Description = OpenMetadataProperty.PROFILE_FLAGS.description;
        String attribute8DescriptionGUID = OpenMetadataProperty.PROFILE_FLAGS.descriptionGUID;
        String attribute9Name = OpenMetadataProperty.PROFILE_COUNTS.name;
        String attribute9Description = OpenMetadataProperty.PROFILE_COUNTS.description;
        String attribute9DescriptionGUID = OpenMetadataProperty.PROFILE_COUNTS.descriptionGUID;
        String attribute10Name = OpenMetadataProperty.VALUE_LIST.name;
        String attribute10Description = OpenMetadataProperty.VALUE_LIST.description;
        String attribute10DescriptionGUID = OpenMetadataProperty.VALUE_LIST.descriptionGUID;
        String attribute11Name = OpenMetadataProperty.VALUE_COUNT.name;
        String attribute11Description = OpenMetadataProperty.VALUE_COUNT.description;
        String attribute11DescriptionGUID = OpenMetadataProperty.VALUE_COUNT.descriptionGUID;
        String attribute12Name = OpenMetadataProperty.VALUE_RANGE_FROM.name;
        String attribute12Description = OpenMetadataProperty.VALUE_RANGE_FROM.description;
        String attribute12DescriptionGUID = OpenMetadataProperty.VALUE_RANGE_FROM.descriptionGUID;
        String attribute13Name = OpenMetadataProperty.VALUE_RANGE_TO.name;
        String attribute13Description = OpenMetadataProperty.VALUE_RANGE_TO.description;
        String attribute13DescriptionGUID = OpenMetadataProperty.VALUE_RANGE_TO.descriptionGUID;
        String attribute14Name = OpenMetadataProperty.AVERAGE_VALUE.name;
        String attribute14Description = OpenMetadataProperty.AVERAGE_VALUE.description;
        String attribute14DescriptionGUID = OpenMetadataProperty.AVERAGE_VALUE.descriptionGUID;
        String attribute15Name = OpenMetadataProperty.PROFILE_DOUBLES.name;
        String attribute15Description = OpenMetadataProperty.PROFILE_DOUBLES.description;
        String attribute15DescriptionGUID = OpenMetadataProperty.PROFILE_DOUBLES.descriptionGUID;
        String attribute16Name = OpenMetadataProperty.PROFILE_START_DATE.name;
        String attribute16Description = OpenMetadataProperty.PROFILE_START_DATE.description;
        String attribute16DescriptionGUID = OpenMetadataProperty.PROFILE_START_DATE.descriptionGUID;
        String attribute17Name = OpenMetadataProperty.PROFILE_END_DATE.name;
        String attribute17Description = OpenMetadataProperty.PROFILE_END_DATE.description;
        String attribute17DescriptionGUID = OpenMetadataProperty.PROFILE_END_DATE.descriptionGUID;
        String attribute18Name = OpenMetadataProperty.PROFILE_DATES.name;
        String attribute18Description = OpenMetadataProperty.PROFILE_DATES.description;
        String attribute18DescriptionGUID = OpenMetadataProperty.PROFILE_DATES.descriptionGUID;
        String attribute19Name = OpenMetadataProperty.PROFILE_PROPERTY_NAMES.name;
        String attribute19Description = OpenMetadataProperty.PROFILE_PROPERTY_NAMES.description;
        String attribute19DescriptionGUID = OpenMetadataProperty.PROFILE_PROPERTY_NAMES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringBooleanTypeDefAttribute(attribute8Name, attribute8Description, attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringLongTypeDefAttribute(attribute9Name, attribute9Description, attribute9DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute(attribute10Name, attribute10Description, attribute10DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringIntTypeDefAttribute(attribute11Name, attribute11Description, attribute11DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute12Name, attribute12Description, attribute12DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute13Name, attribute13Description, attribute13DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute14Name, attribute14Description, attribute14DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringDoubleTypeDefAttribute(attribute15Name, attribute15Description, attribute15DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute16Name, attribute16Description, attribute16DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute17Name, attribute17Description, attribute17DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringDateTypeDefAttribute(attribute18Name, attribute18Description, attribute18DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute(attribute19Name, attribute19Description, attribute19DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getResourceProfileLogAnnotationEntity() {
        String guid = OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.typeGUID;
        String name = OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.typeName;
        String description = OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.DATA_FIELD_ANNOTATION.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private RelationshipDef getResourceProfileLogFileRelationship() {
        String guid = OpenMetadataType.RESOURCE_PROFILE_DATA_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.RESOURCE_PROFILE_DATA_RELATIONSHIP.typeName;
        String description = OpenMetadataType.RESOURCE_PROFILE_DATA_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.RESOURCE_PROFILE_DATA_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.RESOURCE_PROFILE_DATA_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.typeName;
        String end1AttributeName = "resourceProfileAnnotations";
        String end1AttributeDescription = "The annotations that refer to this log file.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "resourceProfileAnnotations", "The annotations that refer to this log file.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ASSET.typeName;
        String end2AttributeName = "resourceProfileLogs";
        String end2AttributeDescription = "Location of the profile information.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "resourceProfileLogs", "Location of the profile information.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private void add0625DataClassDiscovery() {
        this.archiveBuilder.addEntityDef(this.getDataClassAnnotationEntity());
    }

    private EntityDef getDataClassAnnotationEntity() {
        String guid = OpenMetadataType.DATA_CLASS_ANNOTATION.typeGUID;
        String name = OpenMetadataType.DATA_CLASS_ANNOTATION.typeName;
        String description = OpenMetadataType.DATA_CLASS_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.DATA_CLASS_ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATA_CLASS_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.DATA_FIELD_ANNOTATION.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.CANDIDATE_DATA_CLASS_GUIDS.name;
        String attribute1Description = OpenMetadataProperty.CANDIDATE_DATA_CLASS_GUIDS.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.CANDIDATE_DATA_CLASS_GUIDS.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.MATCHING_VALUES.name;
        String attribute2Description = OpenMetadataProperty.MATCHING_VALUES.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.MATCHING_VALUES.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.NON_MATCHING_VALUES.name;
        String attribute3Description = OpenMetadataProperty.NON_MATCHING_VALUES.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.NON_MATCHING_VALUES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getArrayStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0630SemanticDiscovery() {
        this.archiveBuilder.addEntityDef(this.getSemanticAnnotationEntity());
    }

    private EntityDef getSemanticAnnotationEntity() {
        String guid = OpenMetadataType.SEMANTIC_ANNOTATION.typeGUID;
        String name = OpenMetadataType.SEMANTIC_ANNOTATION.typeName;
        String description = OpenMetadataType.SEMANTIC_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.SEMANTIC_ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.SEMANTIC_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.DATA_FIELD_ANNOTATION.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.INFORMAL_TERM.name;
        String attribute1Description = OpenMetadataProperty.INFORMAL_TERM.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.INFORMAL_TERM.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.CANDIDATE_GLOSSARY_TERM_GUIDS.name;
        String attribute2Description = OpenMetadataProperty.CANDIDATE_GLOSSARY_TERM_GUIDS.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.CANDIDATE_GLOSSARY_TERM_GUIDS.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.INFORMAL_CATEGORY.name;
        String attribute3Description = OpenMetadataProperty.INFORMAL_CATEGORY.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.INFORMAL_CATEGORY.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.CANDIDATE_GLOSSARY_CATEGORY_GUIDS.name;
        String attribute4Description = OpenMetadataProperty.CANDIDATE_GLOSSARY_CATEGORY_GUIDS.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.CANDIDATE_GLOSSARY_CATEGORY_GUIDS.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0635ClassificationDiscovery() {
        this.archiveBuilder.addEntityDef(this.getClassificationAnnotationEntity());
    }

    private EntityDef getClassificationAnnotationEntity() {
        String guid = OpenMetadataType.CLASSIFICATION_ANNOTATION.typeGUID;
        String name = OpenMetadataType.CLASSIFICATION_ANNOTATION.typeName;
        String description = OpenMetadataType.CLASSIFICATION_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.CLASSIFICATION_ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.CLASSIFICATION_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.DATA_FIELD_ANNOTATION.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.CANDIDATE_CLASSIFICATIONS.name;
        String attribute1Description = OpenMetadataProperty.CANDIDATE_CLASSIFICATIONS.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.CANDIDATE_CLASSIFICATIONS.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0640QualityScores() {
        this.archiveBuilder.addEntityDef(this.getQualityAnnotationEntity());
    }

    private EntityDef getQualityAnnotationEntity() {
        String guid = OpenMetadataType.QUALITY_ANNOTATION.typeGUID;
        String name = OpenMetadataType.QUALITY_ANNOTATION.typeName;
        String description = OpenMetadataType.QUALITY_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.QUALITY_ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.QUALITY_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.DATA_FIELD_ANNOTATION.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.QUALITY_DIMENSION.name;
        String attribute1Description = OpenMetadataProperty.QUALITY_DIMENSION.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.QUALITY_DIMENSION.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.QUALITY_SCORE.name;
        String attribute2Description = OpenMetadataProperty.QUALITY_SCORE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.QUALITY_SCORE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0650RelationshipDiscovery() {
        this.archiveBuilder.addEntityDef(this.getRelationshipAdviceAnnotationEntity());
        this.archiveBuilder.addRelationshipDef(this.getRelationshipAnnotationRelationship());
    }

    private EntityDef getRelationshipAdviceAnnotationEntity() {
        String guid = OpenMetadataType.RELATIONSHIP_ADVICE_ANNOTATION.typeGUID;
        String name = OpenMetadataType.RELATIONSHIP_ADVICE_ANNOTATION.typeName;
        String description = OpenMetadataType.RELATIONSHIP_ADVICE_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.RELATIONSHIP_ADVICE_ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.RELATIONSHIP_ADVICE_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.DATA_FIELD_ANNOTATION.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.RELATIONSHIP_TYPE_NAME.name;
        String attribute1Description = OpenMetadataProperty.RELATIONSHIP_TYPE_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.RELATIONSHIP_TYPE_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.RELATIONSHIP_PROPERTIES.name;
        String attribute2Description = OpenMetadataProperty.RELATIONSHIP_PROPERTIES.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.RELATIONSHIP_PROPERTIES.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.RELATED_ENTITY_GUID.name;
        String attribute3Description = OpenMetadataProperty.RELATED_ENTITY_GUID.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.RELATED_ENTITY_GUID.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private RelationshipDef getRelationshipAnnotationRelationship() {
        String guid = OpenMetadataType.RELATIONSHIP_ANNOTATION_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.RELATIONSHIP_ANNOTATION_RELATIONSHIP.typeName;
        String description = OpenMetadataType.RELATIONSHIP_ANNOTATION_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.RELATIONSHIP_ANNOTATION_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.RELATIONSHIP_ANNOTATION_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "relatedFromObjectAnnotations";
        String end1AttributeDescription = "The referenceables linked from.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "relatedFromObjectAnnotations", "The referenceables linked from.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "relatedToObjectAnnotations";
        String end2AttributeDescription = "The referenceables linked to.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "relatedToObjectAnnotations", "The referenceables linked to.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.ANNOTATION_TYPE.name;
        String attribute1Description = OpenMetadataProperty.ANNOTATION_TYPE.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.ANNOTATION_TYPE.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.SUMMARY.name;
        String attribute2Description = OpenMetadataProperty.SUMMARY.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.SUMMARY.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.CONFIDENCE_LEVEL.name;
        String attribute3Description = OpenMetadataProperty.CONFIDENCE_LEVEL.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.CONFIDENCE_LEVEL.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.EXPRESSION.name;
        String attribute4Description = OpenMetadataProperty.EXPRESSION.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.EXPRESSION.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.EXPLANATION.name;
        String attribute5Description = OpenMetadataProperty.EXPLANATION.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.EXPLANATION.descriptionGUID;
        String attribute6Name = OpenMetadataProperty.ANALYSIS_STEP.name;
        String attribute6Description = OpenMetadataProperty.ANALYSIS_STEP.description;
        String attribute6DescriptionGUID = OpenMetadataProperty.ANALYSIS_STEP.descriptionGUID;
        String attribute7Name = OpenMetadataProperty.JSON_PROPERTIES.name;
        String attribute7Description = OpenMetadataProperty.JSON_PROPERTIES.description;
        String attribute7DescriptionGUID = OpenMetadataProperty.JSON_PROPERTIES.descriptionGUID;
        String attribute8Name = OpenMetadataProperty.ADDITIONAL_PROPERTIES.name;
        String attribute8Description = OpenMetadataProperty.ADDITIONAL_PROPERTIES.description;
        String attribute8DescriptionGUID = OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID;
        String attribute9Name = OpenMetadataProperty.ANNOTATION_STATUS.name;
        String attribute9Description = OpenMetadataProperty.ANNOTATION_STATUS.description;
        String attribute9DescriptionGUID = OpenMetadataProperty.ANNOTATION_STATUS.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getIntTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute6Name, attribute6Description, attribute6DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute7Name, attribute7Description, attribute7DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute8Name, attribute8Description, attribute8DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("AnnotationStatus", attribute9Name, attribute9Description, attribute9DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void add0660ResourceMeasures() {
        this.archiveBuilder.addEntityDef(this.getResourceMeasureAnnotationEntity());
        this.archiveBuilder.addEntityDef(this.getDataSourcePhysicalStatusAnnotationEntity());
    }

    private EntityDef getResourceMeasureAnnotationEntity() {
        String guid = OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeGUID;
        String name = OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName;
        String description = OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.ANNOTATION.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.RESOURCE_PROPERTIES.name;
        String attribute1Description = OpenMetadataProperty.RESOURCE_PROPERTIES.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.RESOURCE_PROPERTIES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private EntityDef getDataSourcePhysicalStatusAnnotationEntity() {
        String guid = OpenMetadataType.RESOURCE_PHYSICAL_STATUS_ANNOTATION.typeGUID;
        String name = OpenMetadataType.RESOURCE_PHYSICAL_STATUS_ANNOTATION.typeName;
        String description = OpenMetadataType.RESOURCE_PHYSICAL_STATUS_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.RESOURCE_PHYSICAL_STATUS_ANNOTATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.RESOURCE_PHYSICAL_STATUS_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.RESOURCE_CREATE_TIME.name;
        String attribute1Description = OpenMetadataProperty.RESOURCE_CREATE_TIME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.RESOURCE_CREATE_TIME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.RESOURCE_UPDATE_TIME.name;
        String attribute2Description = OpenMetadataProperty.RESOURCE_UPDATE_TIME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.RESOURCE_UPDATE_TIME.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.SIZE.name;
        String attribute3Description = OpenMetadataProperty.SIZE.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.SIZE.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.ENCODING.name;
        String attribute4Description = OpenMetadataProperty.ENCODING.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.ENCODING.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getDateTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getLongTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void add0690RequestForAction() {
        this.archiveBuilder.addEntityDef(this.getRequestForActionAnnotationEntity());
    }

    private EntityDef getRequestForActionAnnotationEntity() {
        String guid = OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeGUID;
        String name = OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName;
        String description = OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.description;
        String descriptionGUID = OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.descriptionGUID;
        String wikiURL = OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.wikiURL;
        String superTypeName = OpenMetadataType.DATA_FIELD_ANNOTATION.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, wikiURL);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.ACTION_SOURCE_NAME.name;
        String attribute1Description = OpenMetadataProperty.ACTION_SOURCE_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.ACTION_SOURCE_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.ACTION_REQUESTED.name;
        String attribute2Description = OpenMetadataProperty.ACTION_REQUESTED.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.ACTION_REQUESTED.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.ACTION_PROPERTIES.name;
        String attribute3Description = OpenMetadataProperty.ACTION_PROPERTIES.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.ACTION_PROPERTIES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }
}

