/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive1_7;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_0 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.0";
    private static final String originatorName = "ODPi Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private OMRSArchiveBuilder archiveBuilder;
    private OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_0() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_0(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive1_7 previousTypes = new OpenMetadataTypesArchive1_7(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.add0011ManagingReferenceables();
        this.update0130Projects();
        this.update0220FilesAndFolders();
        this.update0221DocumentStores();
        this.update0224Databases();
        this.update0512DerivedSchemaAttributes();
    }

    private void add0011ManagingReferenceables() {
        this.archiveBuilder.addClassificationDef(this.addTemplateClassification());
    }

    private ClassificationDef addTemplateClassification() {
        String guid = OpenMetadataType.TEMPLATE_CLASSIFICATION.typeGUID;
        String name = OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName;
        String description = OpenMetadataType.TEMPLATE_CLASSIFICATION.description;
        String descriptionGUID = OpenMetadataType.TEMPLATE_CLASSIFICATION.descriptionGUID;
        String descriptionWiki = OpenMetadataType.TEMPLATE_CLASSIFICATION.wikiURL;
        String linkedToEntity = OpenMetadataType.REFERENCEABLE.typeName;
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(guid, name, null, description, descriptionGUID, descriptionWiki, this.archiveBuilder.getEntityDef(linkedToEntity), false);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.ADDITIONAL_PROPERTIES.name;
        String attribute3Description = OpenMetadataProperty.ADDITIONAL_PROPERTIES.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.ADDITIONAL_PROPERTIES.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getMapStringStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void update0130Projects() {
        this.archiveBuilder.addTypeDefPatch(this.updateProjectScopeRelationship());
    }

    private TypeDefPatch updateProjectScopeRelationship() {
        String typeName = "ProjectScope";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProjectScope");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "scopeDescription";
        String attribute1Description = "Deprecated attribute. Use the description attribute to describe the scope.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("scopeDescription", "Deprecated attribute. Use the description attribute to describe the scope.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute(attribute2Name);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0220FilesAndFolders() {
        this.archiveBuilder.addClassificationDef(this.getFileManagerClassification());
    }

    private ClassificationDef getFileManagerClassification() {
        String guid = "eadec807-02f0-4d6f-911c-261eddd0c2f5";
        String name = "FileManager";
        String description = "Identifies a software server capability as a manager of a collection of files and folders.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getClassificationDef("eadec807-02f0-4d6f-911c-261eddd0c2f5", "FileManager", null, "Identifies a software server capability as a manager of a collection of files and folders.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private void update0221DocumentStores() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateConnectManagerClassification());
        this.archiveBuilder.addClassificationDef(this.getContentCollectionManagerClassification());
    }

    private TypeDefPatch deprecateConnectManagerClassification() {
        String typeName = "ContentManager";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ContentManager");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private ClassificationDef getContentCollectionManagerClassification() {
        String guid = "dbde6a5b-fc89-4b04-969a-9dc09a60ebd7";
        String name = "ContentCollectionManager";
        String description = "Identifies a software server capability as a manager of controlled documents and related media.";
        String descriptionGUID = null;
        String linkedToEntity = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getClassificationDef("dbde6a5b-fc89-4b04-969a-9dc09a60ebd7", "ContentCollectionManager", null, "Identifies a software server capability as a manager of controlled documents and related media.", descriptionGUID, this.archiveBuilder.getEntityDef(linkedToEntity), false);
    }

    private void update0224Databases() {
        this.archiveBuilder.addEntityDef(this.addDatabaseManagerEntity());
    }

    private EntityDef addDatabaseManagerEntity() {
        String guid = OpenMetadataType.DATABASE_MANAGER.typeGUID;
        String name = OpenMetadataType.DATABASE_MANAGER.typeName;
        String description = OpenMetadataType.DATABASE_MANAGER.description;
        String descriptionGUID = OpenMetadataType.DATABASE_MANAGER.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DATABASE_MANAGER.wikiURL;
        String superTypeName = OpenMetadataType.SOFTWARE_SERVER_CAPABILITY.typeName;
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef(superTypeName), description, descriptionGUID, descriptionWiki);
    }

    private void update0512DerivedSchemaAttributes() {
        this.archiveBuilder.addTypeDefPatch(this.updateSchemaQueryImplementationRelationship());
    }

    private TypeDefPatch updateSchemaQueryImplementationRelationship() {
        String typeName = "SchemaQueryImplementation";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SchemaQueryImplementation");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "queryId";
        String attribute1Description = "Identifier for placeholder in derived schema attribute's formula.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("queryId", "Identifier for placeholder in derived schema attribute's formula.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0217AutomatedProcesses() {
    }

    private void add0260Transformations() {
    }

    private void add0265AnalyticsAssets() {
    }

    private void add0270IoTAssets() {
    }

    private void add0280ModelAssets() {
    }

    private void add0435GovernanceRules() {
    }

    private void add0447GovernanceProcesses() {
    }

    private void add0452GovernanceDaemons() {
    }

    private void add0480RightsManagement() {
    }

    private void add0550LogicSpecificationModel() {
    }

    private void add0560MappingModel() {
    }
}

