/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive2_9;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive2_10 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "2.10";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive2_10() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive2_10(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive2_9 previousTypes = new OpenMetadataTypesArchive2_9(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0130Projects();
        this.update0360Contexts();
        this.update04xxGovernanceDefinitions();
    }

    private void update0130Projects() {
        this.archiveBuilder.addTypeDefPatch(this.updateCampaignClassification());
    }

    private TypeDefPatch updateCampaignClassification() {
        String typeName = "Campaign";
        String typeLinkName = OpenMetadataType.REFERENCEABLE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Campaign");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefLink> validEntityDefs = new ArrayList<TypeDefLink>();
        validEntityDefs.add(new TypeDefLink(this.archiveBuilder.getTypeDefByName(typeLinkName)));
        typeDefPatch.setValidEntityDefs(validEntityDefs);
        return typeDefPatch;
    }

    private void update0360Contexts() {
        this.archiveBuilder.addTypeDefPatch(this.updateUsedInContextRelationship());
    }

    private TypeDefPatch updateUsedInContextRelationship() {
        String typeName = "UsedInContext";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("UsedInContext");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "usedInContexts";
        String end2AttributeDescription = "Elements describing the contexts where this term is used.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "usedInContexts", "Elements describing the contexts where this term is used.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void update04xxGovernanceDefinitions() {
        this.archiveBuilder.addClassificationDef(this.addOwnershipClassification());
        this.archiveBuilder.addClassificationDef(this.addIncidentClassifierSetClassification());
        this.archiveBuilder.addEntityDef(this.addComponentOwnerEntity());
        this.archiveBuilder.addEntityDef(this.addDataItemOwnerEntity());
        this.archiveBuilder.addEntityDef(this.addRegulationArticleEntity());
        this.archiveBuilder.addEntityDef(this.addBusinessImperativeEntity());
        this.archiveBuilder.addRelationshipDef(this.addGovernanceDriverLinkRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceResponsibilityAssignmentRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceDefinitionEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceZoneEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateSubjectAreaDefinitionEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceMetricEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceRoleEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceOfficer());
        this.archiveBuilder.addTypeDefPatch(this.updateIncidentClassifier());
        this.archiveBuilder.addTypeDefPatch(this.updateIncidentReport());
        this.archiveBuilder.addTypeDefPatch(this.updateAssetOrigin());
        this.archiveBuilder.addTypeDefPatch(this.updateCertification());
        this.archiveBuilder.addTypeDefPatch(this.updateLicense());
        this.archiveBuilder.addTypeDefPatch(this.deprecateAssetOwnershipClassification());
        this.archiveBuilder.addTypeDefPatch(this.deprecateResponsibilityStaffContact());
    }

    private ClassificationDef addOwnershipClassification() {
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef(OpenMetadataType.OWNERSHIP_CLASSIFICATION.typeGUID, OpenMetadataType.OWNERSHIP_CLASSIFICATION.typeName, null, OpenMetadataType.OWNERSHIP_CLASSIFICATION.description, OpenMetadataType.OWNERSHIP_CLASSIFICATION.descriptionGUID, OpenMetadataType.OWNERSHIP_CLASSIFICATION.wikiURL, this.archiveBuilder.getEntityDef(OpenMetadataType.REFERENCEABLE.typeName), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.OWNER.name;
        String attribute1Description = OpenMetadataProperty.OWNER.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.OWNER.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.OWNER_TYPE_NAME.name;
        String attribute2Description = OpenMetadataProperty.OWNER_TYPE_NAME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.OWNER_TYPE_NAME.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.OWNER_PROPERTY_NAME.name;
        String attribute3Description = OpenMetadataProperty.OWNER_PROPERTY_NAME.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.OWNER_PROPERTY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private ClassificationDef addIncidentClassifierSetClassification() {
        String guid = "361158c0-ade1-4c92-a6a7-64f7ac39b87d";
        String name = "IncidentClassifierSet";
        String description = "A collection of incident classifiers.";
        String descriptionGUID = null;
        String linkedToEntity = "Collection";
        return this.archiveHelper.getClassificationDef("361158c0-ade1-4c92-a6a7-64f7ac39b87d", "IncidentClassifierSet", null, "A collection of incident classifiers.", descriptionGUID, this.archiveBuilder.getEntityDef("Collection"), false);
    }

    private TypeDefPatch updateIncidentClassifier() {
        String typeName = "IncidentClassifier";
        String superTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("IncidentClassifier");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceDefinitionEntity() {
        String typeName = "GovernanceDefinition";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceDefinition");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute5Name = "domain";
        String attribute5Description = "Deprecated. Governance domain for this governance definition.";
        String attribute5DescriptionGUID = null;
        String attribute5ReplacedBy = "domainIdentifier";
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Deprecated. Governance domain for this governance definition.", attribute5DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("domainIdentifier");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceZoneEntity() {
        String typeName = "GovernanceZone";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceZone");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute5Name = "domain";
        String attribute5Description = "Deprecated. Governance domain for this governance definition.";
        String attribute5DescriptionGUID = null;
        String attribute5ReplacedBy = "domainIdentifier";
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Deprecated. Governance domain for this governance definition.", attribute5DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("domainIdentifier");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateSubjectAreaDefinitionEntity() {
        String typeName = "SubjectAreaDefinition";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SubjectAreaDefinition");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute5Name = "domain";
        String attribute5Description = "Deprecated. Governance domain for this governance definition.";
        String attribute5DescriptionGUID = null;
        String attribute5ReplacedBy = "domainIdentifier";
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Deprecated. Governance domain for this governance definition.", attribute5DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("domainIdentifier");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceMetricEntity() {
        String typeName = "GovernanceMetric";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceMetric");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute5Name = "domain";
        String attribute5Description = "Deprecated. Governance domain for this governance definition.";
        String attribute5DescriptionGUID = null;
        String attribute5ReplacedBy = "domainIdentifier";
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Deprecated. Governance domain for this governance definition.", attribute5DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("domainIdentifier");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceRoleEntity() {
        String typeName = "GovernanceRole";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceRole");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute5Name = "domain";
        String attribute5Description = "Deprecated. Governance domain for this governance definition.";
        String attribute5DescriptionGUID = null;
        String attribute5ReplacedBy = "domainIdentifier";
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Deprecated. Governance domain for this governance definition.", attribute5DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("domainIdentifier");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateGovernanceOfficer() {
        String typeName = "GovernanceOfficer";
        String superTypeName = "GovernanceRole";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceOfficer");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef("GovernanceRole"));
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute5Name = "domain";
        String attribute5Description = "Deprecated. Governance domain for this governance definition.";
        String attribute5DescriptionGUID = null;
        String attribute5ReplacedBy = "domainIdentifier";
        TypeDefAttribute property = this.archiveHelper.getEnumTypeDefAttribute("GovernanceDomain", "domain", "Deprecated. Governance domain for this governance definition.", attribute5DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute("domainIdentifier");
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private EntityDef addComponentOwnerEntity() {
        String guid = "21756af1-06c9-4b06-87d2-3ef911f0a58a";
        String name = "ComponentOwner";
        String description = "An ownership role for a component - typically part of an asset.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceRole";
        return this.archiveHelper.getDefaultEntityDef("21756af1-06c9-4b06-87d2-3ef911f0a58a", "ComponentOwner", this.archiveBuilder.getEntityDef("GovernanceRole"), "An ownership role for a component - typically part of an asset.", descriptionGUID);
    }

    private EntityDef addDataItemOwnerEntity() {
        String guid = "69836cfd-39b8-460b-8727-b04e19210069";
        String name = "DataItemOwner";
        String description = "An ownership role for a particular type of data.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceRole";
        return this.archiveHelper.getDefaultEntityDef("69836cfd-39b8-460b-8727-b04e19210069", "DataItemOwner", this.archiveBuilder.getEntityDef("GovernanceRole"), "An ownership role for a particular type of data.", descriptionGUID);
    }

    private EntityDef addRegulationArticleEntity() {
        String guid = "829a648d-f249-455d-8127-aeafa021f832";
        String name = "RegulationArticle";
        String description = "An specific requirement in a regulation.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceDriver";
        return this.archiveHelper.getDefaultEntityDef("829a648d-f249-455d-8127-aeafa021f832", "RegulationArticle", this.archiveBuilder.getEntityDef("GovernanceDriver"), "An specific requirement in a regulation.", descriptionGUID);
    }

    private EntityDef addBusinessImperativeEntity() {
        String guid = "bb094b5e-0934-4d8b-8727-48eb5d241a46";
        String name = "BusinessImperative";
        String description = "A mandatory goal that must be met by the business for it to be successful.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceDriver";
        return this.archiveHelper.getDefaultEntityDef("bb094b5e-0934-4d8b-8727-48eb5d241a46", "BusinessImperative", this.archiveBuilder.getEntityDef("GovernanceDriver"), "A mandatory goal that must be met by the business for it to be successful.", descriptionGUID);
    }

    private RelationshipDef addGovernanceDriverLinkRelationship() {
        String guid = "c5e6fada-2c12-46ee-afa9-b71dd1bd8179";
        String name = "GovernanceDriverLink";
        String description = "Link between a two governance drivers.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("c5e6fada-2c12-46ee-afa9-b71dd1bd8179", "GovernanceDriverLink", null, "Link between a two governance drivers.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "GovernanceDriver";
        String end1AttributeName = "linkingDrivers";
        String end1AttributeDescription = "Governance driver that makes use of another governance driver's requirements.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceDriver"), "linkingDrivers", "Governance driver that makes use of another governance driver's requirements.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "GovernanceDriver";
        String end2AttributeName = "linkedDrivers";
        String end2AttributeDescription = "Governance driver that defines requirements that support another governance driver.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("GovernanceDriver"), "linkedDrivers", "Governance driver that defines requirements that support another governance driver.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private TypeDefPatch updateGovernanceResponsibilityAssignmentRelationship() {
        String typeName = "GovernanceResponsibilityAssignment";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceResponsibilityAssignment");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end1EntityType = "PersonRole";
        String end1AttributeName = "performedByRoles";
        String end1AttributeDescription = "The roles assigned to this responsibility.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("PersonRole"), "performedByRoles", "The roles assigned to this responsibility.", end1AttributeDescriptionGUID, end1Cardinality);
        typeDefPatch.setEndDef1(relationshipEndDef);
        return typeDefPatch;
    }

    private TypeDefPatch updateAssetOrigin() {
        String typeName = "AssetOrigin";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("AssetOrigin");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "organizationPropertyName";
        String attribute1Description = "Name of the property from the element used to identify the organization property.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "businessCapabilityPropertyName";
        String attribute2Description = "Name of the property from the element used to identify the businessCapability property.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("organizationPropertyName", "Name of the property from the element used to identify the organization property.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("businessCapabilityPropertyName", "Name of the property from the element used to identify the businessCapability property.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateCertification() {
        String typeName = "Certification";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Certification");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "certifiedByTypeName";
        String attribute1Description = "Type of element referenced in the certifiedBy property.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "certifiedByPropertyName";
        String attribute2Description = "Name of the property from the element used to identify the certifiedBy property.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "custodianTypeName";
        String attribute3Description = "Type of element referenced in the custodian property.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "custodianPropertyName";
        String attribute4Description = "Name of the property from the element used to identify the custodian property.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "recipientTypeName";
        String attribute5Description = "Type of element referenced in the recipient property.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "recipientPropertyName";
        String attribute6Description = "Name of the property from the element used to identify the recipient property.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("certifiedByTypeName", "Type of element referenced in the certifiedBy property.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("certifiedByPropertyName", "Name of the property from the element used to identify the certifiedBy property.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("custodianTypeName", "Type of element referenced in the custodian property.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("custodianPropertyName", "Name of the property from the element used to identify the custodian property.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("recipientTypeName", "Type of element referenced in the recipient property.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("recipientPropertyName", "Name of the property from the element used to identify the recipient property.", attribute6DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateLicense() {
        String typeName = "License";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("License");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "licensedByTypeName";
        String attribute1Description = "Type of element referenced in the licensedBy property.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "licensedByPropertyName";
        String attribute2Description = "Name of the property from the element used to identify the licensedBy property.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "custodianTypeName";
        String attribute3Description = "Type of element referenced in the custodian property.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "custodianPropertyName";
        String attribute4Description = "Name of the property from the element used to identify the custodian property.";
        String attribute4DescriptionGUID = null;
        String attribute5Name = "licenseeTypeName";
        String attribute5Description = "Type of element referenced in the licensee property.";
        String attribute5DescriptionGUID = null;
        String attribute6Name = "licenseePropertyName";
        String attribute6Description = "Name of the property from the element used to identify the licensee property.";
        String attribute6DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("licensedByTypeName", "Type of element referenced in the licensedBy property.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("licensedByPropertyName", "Name of the property from the element used to identify the licensedBy property.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("custodianTypeName", "Type of element referenced in the custodian property.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("custodianPropertyName", "Name of the property from the element used to identify the custodian property.", attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("licenseeTypeName", "Type of element referenced in the licensee property.", attribute5DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("licenseePropertyName", "Name of the property from the element used to identify the licensee property.", attribute6DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateResponsibilityStaffContact() {
        String typeName = "ResponsibilityStaffContact";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ResponsibilityStaffContact");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateAssetOwnershipClassification() {
        String typeName = "AssetOwnership";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("AssetOwnership");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch updateIncidentReport() {
        String typeName = "IncidentReport";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("IncidentReport");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "owner";
        String attribute1Description = "Deprecated Attribute. Person, team or engine responsible for this type of action.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "ownerType";
        String attribute2Description = "Deprecated Attribute. Type of element representing the owner.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("owner", "Deprecated Attribute. Person, team or engine responsible for this type of action.", attribute1DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("AssetOwnerType", "ownerType", "Deprecated Attribute. Type of element representing the owner.", attribute2DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }
}

