/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_9;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttributeStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_11 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.11";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_11() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_11(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_9 previousTypes = new OpenMetadataTypesArchive3_9(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update0010BaseModel();
        this.add0022Translations();
        this.update0025Locations();
        this.update0110ActorProfile();
        this.update0130Projects();
        this.updateResponsibilityAssignments();
        this.update04xxExplicitNames();
        this.update04xxNewGovernanceRoles();
        this.update04xxMultiLinkGovernanceImplementationTypes();
        this.update0545ValidValues();
        this.update07xxImplementationRelationships();
        this.add0735SolutionPortSchemaRelationship();
    }

    private void update0010BaseModel() {
        this.archiveBuilder.addTypeDefPatch(this.updateDataSet());
        this.archiveBuilder.addTypeDefPatch(this.updateDataContentForDataSet());
    }

    private TypeDefPatch updateDataSet() {
        String typeName = OpenMetadataType.DATA_SET.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "formula";
        String attribute1Description = "Formula used to create the data set - can reference query identifiers located in DataContentForDataSet relationships.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("formula", "Formula used to create the data set - can reference query identifiers located in DataContentForDataSet relationships.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateDataContentForDataSet() {
        String typeName = OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "queryId";
        String attribute1Description = "Identifier for placeholder in data set's formula.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "query";
        String attribute2Description = "Details of how the value(s) is/are retrieved.";
        String attribute2DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("queryId", "Identifier for placeholder in data set's formula.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("query", "Details of how the value(s) is/are retrieved.", attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void add0022Translations() {
        this.archiveBuilder.addEntityDef(this.getTranslationDetailEntity());
        this.archiveBuilder.addRelationshipDef(this.getTranslationLinkRelationship());
    }

    private RelationshipDef getTranslationLinkRelationship() {
        String guid = "576228af-33ec-4588-ba4e-6a864a097e10";
        String name = "TranslationLink";
        String description = "Links an entity to a collection of translated properties.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("576228af-33ec-4588-ba4e-6a864a097e10", "TranslationLink", null, "Links an entity to a collection of translated properties.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        String end1AttributeName = "translates";
        String end1AttributeDescription = "Entity that is translated.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "translates", "Entity that is translated.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "TranslationDetail";
        String end2AttributeName = "translation";
        String end2AttributeDescription = "Translation of entity for a single language.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("TranslationDetail"), "translation", "Translation of entity for a single language.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }

    private EntityDef getTranslationDetailEntity() {
        String guid = "d7df0579-8671-48f0-a8aa-38a487d418c8";
        String name = "TranslationDetail";
        String description = "A collection of translated properties.";
        String descriptionGUID = null;
        String superTypeName = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        EntityDef entityDef = this.archiveHelper.getDefaultEntityDef("d7df0579-8671-48f0-a8aa-38a487d418c8", "TranslationDetail", this.archiveBuilder.getEntityDef(superTypeName), "A collection of translated properties.", descriptionGUID);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "language";
        String attribute1Description = "Language for the translation.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "locale";
        String attribute2Description = "Locale for the translation.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute3Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute4Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.DESCRIPTION.description;
        String attribute5Name = "additionalTranslations";
        String attribute5Description = "Translations of other string properties found in the linked entity.";
        String attribute5DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("language", "Language for the translation.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("locale", "Locale for the translation.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getArrayStringTypeDefAttribute("additionalTranslations", "Translations of other string properties found in the linked entity.", attribute5DescriptionGUID);
        properties.add(property);
        entityDef.setPropertiesDefinition(properties);
        return entityDef;
    }

    private void update0025Locations() {
        this.archiveBuilder.addTypeDefPatch(this.updateLocation());
    }

    private TypeDefPatch updateLocation() {
        String typeName = "Location";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Location");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "identifier";
        String attribute1Description = "Code value or symbol used to identify the location - typically unique.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("identifier", "Code value or symbol used to identify the location - typically unique.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0110ActorProfile() {
        this.archiveBuilder.addTypeDefPatch(this.updateUserIdentity());
        this.archiveBuilder.addTypeDefPatch(this.updatePerson());
        this.archiveBuilder.addTypeDefPatch(this.updatePersonRole());
        this.archiveBuilder.addTypeDefPatch(this.updateTeam());
        this.archiveBuilder.addTypeDefPatch(this.updateContactDetails());
        this.archiveBuilder.addRelationshipDef(this.getProfileLocationRelationship());
    }

    private TypeDefPatch updateUserIdentity() {
        String typeName = "UserIdentity";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("UserIdentity");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "userId";
        String attribute1Description = "Identifier of the user account - if null use qualifiedName.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("userId", "Identifier of the user account - if null use qualifiedName.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePerson() {
        String typeName = "Person";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Person");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "pronouns";
        String attribute1Description = "Preferred pronouns to use when addressing this person.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("pronouns", "Preferred pronouns to use when addressing this person.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updatePersonRole() {
        String typeName = "PersonRole";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("PersonRole");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "identifier";
        String attribute1Description = "Code value or symbol used to identify the role - typically unique.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("identifier", "Code value or symbol used to identify the role - typically unique.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateTeam() {
        String typeName = "Team";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Team");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "identifier";
        String attribute1Description = "Code value or symbol used to identify the team - typically unique.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("identifier", "Code value or symbol used to identify the team - typically unique.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateContactDetails() {
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(OpenMetadataType.CONTACT_DETAILS.typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.NAME.name;
        String attribute1Description = OpenMetadataProperty.NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.CONTACT_TYPE.name;
        String attribute2Description = OpenMetadataProperty.CONTACT_TYPE.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.CONTACT_TYPE.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private RelationshipDef getProfileLocationRelationship() {
        String guid = "4d652ef7-99c7-4ec3-a2fd-b10c0a1ab4b4";
        String name = "ProfileLocation";
        String description = "Identifies an association between an Actor Profile and a Location, such as a person's primary work location.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("4d652ef7-99c7-4ec3-a2fd-b10c0a1ab4b4", "ProfileLocation", null, "Identifies an association between an Actor Profile and a Location, such as a person's primary work location.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "ActorProfile";
        String end1AttributeName = "associatedProfiles";
        String end1AttributeDescription = "Profiles of actors associated with the location.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ActorProfile"), "associatedProfiles", "Profiles of actors associated with the location.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "Location";
        String end2AttributeName = "associatedLocations";
        String end2AttributeDescription = "Locations that the actor is associated with.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("Location"), "associatedLocations", "Locations that the actor is associated with.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "associationType";
        String attribute1Description = "Identifier that describes the purpose of the association.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("associationType", "Identifier that describes the purpose of the association.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update0130Projects() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateProjectStatusAttribute());
        this.archiveBuilder.addRelationshipDef(this.getStakeholderRelationship());
    }

    private TypeDefPatch deprecateProjectStatusAttribute() {
        String typeName = OpenMetadataType.PROJECT.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.PROJECT_STATUS.name;
        String attribute1Description = OpenMetadataProperty.PROJECT_STATUS.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.PROJECT_STATUS.descriptionGUID;
        String attribute2Name = "status";
        String attribute2Description = "(Deprecated) Short description on current status of the project.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = OpenMetadataProperty.IDENTIFIER.name;
        String attribute3Description = OpenMetadataProperty.IDENTIFIER.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.IDENTIFIER.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("status", "(Deprecated) Short description on current status of the project.", attribute2DescriptionGUID);
        property.setAttributeStatus(TypeDefAttributeStatus.DEPRECATED_ATTRIBUTE);
        property.setReplacedByAttribute(attribute1Name);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private RelationshipDef getStakeholderRelationship() {
        String guid = "efd8a136-0aea-4668-b91a-30f947e38b82";
        String name = "Stakeholder";
        String description = "Identifies the Actor Profiles that commissioned work (such as a project or a community) or a capability, service or assets.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("efd8a136-0aea-4668-b91a-30f947e38b82", "Stakeholder", null, "Identifies the Actor Profiles that commissioned work (such as a project or a community) or a capability, service or assets.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "commissioned";
        String end1AttributeDescription = "Team, project, community, asset, service, ... that was commissioned by the stakeholders.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "commissioned", "Team, project, community, asset, service, ... that was commissioned by the stakeholders.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "commissionedBy";
        String end2AttributeDescription = "Profiles of actors or roles that are stakeholders.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "commissionedBy", "Profiles of actors or roles that are stakeholders.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "stakeholderRole";
        String attribute1Description = "Identifier that describes the role that the stakeholders will play in the operation of the Referenceable.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("stakeholderRole", "Identifier that describes the role that the stakeholders will play in the operation of the Referenceable.", attribute1DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void updateResponsibilityAssignments() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateProjectScope());
        this.archiveBuilder.addTypeDefPatch(this.deprecateGovernanceRoleAssignment());
        this.archiveBuilder.addRelationshipDef(this.getAssignmentScopeRelationship());
    }

    private TypeDefPatch deprecateProjectScope() {
        String typeName = "ProjectScope";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProjectScope");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateGovernanceRoleAssignment() {
        String typeName = "GovernanceRoleAssignment";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceRoleAssignment");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private RelationshipDef getAssignmentScopeRelationship() {
        String guid = "e3fdafe3-692a-46c6-a595-c538cc189dd9";
        String name = "AssignmentScope";
        String description = "Links a profile, role or project to the elements that they are responsible for managing.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("e3fdafe3-692a-46c6-a595-c538cc189dd9", "AssignmentScope", null, "Links a profile, role or project to the elements that they are responsible for managing.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "assignedActors";
        String end1AttributeDescription = "Person, team, project or other type of actor that has been assigned.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "assignedActors", "Person, team, project or other type of actor that has been assigned.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "assignedScope";
        String end2AttributeDescription = "Elements describing the resources or action the the actors are responsible for.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "assignedScope", "Elements describing the resources or action the the actors are responsible for.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "assignmentType";
        String attribute1Description = "What is the scope or nature of the assignment.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("assignmentType", "What is the scope or nature of the assignment.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private void update04xxExplicitNames() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceZoneDefinition());
        this.archiveBuilder.addTypeDefPatch(this.updateSubjectAreaDefinition());
        this.archiveBuilder.addTypeDefPatch(this.updateBusinessCapability());
        this.archiveBuilder.addTypeDefPatch(this.deprecateBusinessCapabilityControls());
    }

    private TypeDefPatch updateGovernanceZoneDefinition() {
        String typeName = "GovernanceZone";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceZone");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "zoneName";
        String attribute1Description = "Identifier of the zone - if null use qualifiedName.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("zoneName", "Identifier of the zone - if null use qualifiedName.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateSubjectAreaDefinition() {
        String typeName = "SubjectAreaDefinition";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SubjectAreaDefinition");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "subjectAreaName";
        String attribute1Description = "Identifier of the subject area - if null use qualifiedName.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("subjectAreaName", "Identifier of the subject area - if null use qualifiedName.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateBusinessCapability() {
        String typeName = "BusinessCapability";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("BusinessCapability");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "identifier";
        String attribute1Description = "Identifier of the business capability - if null use qualifiedName.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = OpenMetadataProperty.DISPLAY_NAME.name;
        String attribute2Description = OpenMetadataProperty.DISPLAY_NAME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DISPLAY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("identifier", "Identifier of the business capability - if null use qualifiedName.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateBusinessCapabilityControls() {
        String typeName = "BusinessCapabilityControls";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("BusinessCapabilityControls");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private void update04xxNewGovernanceRoles() {
        this.archiveBuilder.addEntityDef(this.getGovernanceRepresentativeEntity());
        this.archiveBuilder.addEntityDef(this.getLocationOwnerEntity());
        this.archiveBuilder.addEntityDef(this.getBusinessOwnerEntity());
        this.archiveBuilder.addEntityDef(this.getSolutionOwnerEntity());
    }

    private EntityDef getGovernanceRepresentativeEntity() {
        String guid = "6046bdf8-a37e-4bc4-b51d-325d8c31a96c";
        String name = "GovernanceRepresentative";
        String description = "A role defining a responsibility to contribute to the operation of a governance activity.  Often represents the views of one or more interested parties.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceRole";
        return this.archiveHelper.getDefaultEntityDef("6046bdf8-a37e-4bc4-b51d-325d8c31a96c", "GovernanceRepresentative", this.archiveBuilder.getEntityDef("GovernanceRole"), "A role defining a responsibility to contribute to the operation of a governance activity.  Often represents the views of one or more interested parties.", descriptionGUID);
    }

    private EntityDef getLocationOwnerEntity() {
        String guid = "3437fd1d-5098-426c-9b55-c94d1fc5dc0e";
        String name = "LocationOwner";
        String description = "A role defining a responsibility for activity at a particular location.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceRole";
        return this.archiveHelper.getDefaultEntityDef("3437fd1d-5098-426c-9b55-c94d1fc5dc0e", "LocationOwner", this.archiveBuilder.getEntityDef("GovernanceRole"), "A role defining a responsibility for activity at a particular location.", descriptionGUID);
    }

    private EntityDef getBusinessOwnerEntity() {
        String guid = "0e83bb5f-f2f5-4a85-92eb-f71e92a181f5";
        String name = "BusinessOwner";
        String description = "A role defining a responsibility to manage a part of the organization's business.  Often responsible for profit and loss";
        String descriptionGUID = null;
        String superTypeName = "GovernanceRole";
        return this.archiveHelper.getDefaultEntityDef("0e83bb5f-f2f5-4a85-92eb-f71e92a181f5", "BusinessOwner", this.archiveBuilder.getEntityDef("GovernanceRole"), "A role defining a responsibility to manage a part of the organization's business.  Often responsible for profit and loss", descriptionGUID);
    }

    private EntityDef getSolutionOwnerEntity() {
        String guid = "e44d5019-37e5-4965-8b89-2bef412833bf";
        String name = "SolutionOwner";
        String description = "A role defining a responsibility for an IT solution.";
        String descriptionGUID = null;
        String superTypeName = "GovernanceRole";
        return this.archiveHelper.getDefaultEntityDef("e44d5019-37e5-4965-8b89-2bef412833bf", "SolutionOwner", this.archiveBuilder.getEntityDef("GovernanceRole"), "A role defining a responsibility for an IT solution.", descriptionGUID);
    }

    private void update04xxMultiLinkGovernanceImplementationTypes() {
        this.archiveBuilder.addTypeDefPatch(this.updateGovernanceActionProcess());
        this.archiveBuilder.addTypeDefPatch(this.updateNextGovernanceActionProcessStepRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateNextEngineActionRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateLicenseRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateCertificationRelationship());
    }

    private TypeDefPatch updateGovernanceActionProcess() {
        String typeName = "GovernanceActionProcess";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("GovernanceActionProcess");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "domainIdentifier";
        String attribute1Description = "Identifier of the governance domain that recognizes this process.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getIntTypeDefAttribute("domainIdentifier", "Identifier of the governance domain that recognizes this process.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateNextGovernanceActionProcessStepRelationship() {
        String typeName = "NextGovernanceActionProcessStep";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("NextGovernanceActionProcessStep");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private TypeDefPatch updateNextEngineActionRelationship() {
        String typeName = "NextEngineAction";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("NextEngineAction");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private TypeDefPatch updateLicenseRelationship() {
        String typeName = "License";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("License");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private TypeDefPatch updateCertificationRelationship() {
        String typeName = "Certification";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("Certification");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private void update0545ValidValues() {
        this.archiveBuilder.addTypeDefPatch(this.updateReferenceValueAssignment());
        this.archiveBuilder.addTypeDefPatch(this.updateValidValuesMapping());
        this.archiveBuilder.addTypeDefPatch(this.updateValidValuesImplementation());
        this.archiveBuilder.addTypeDefPatch(this.updateValidValueMember());
    }

    private TypeDefPatch updateReferenceValueAssignment() {
        String typeName = OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.STEWARD_TYPE_NAME.name;
        String attribute1Description = OpenMetadataProperty.STEWARD_TYPE_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.STEWARD_TYPE_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.STEWARD_PROPERTY_NAME.name;
        String attribute2Description = OpenMetadataProperty.STEWARD_PROPERTY_NAME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.STEWARD_PROPERTY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateValidValuesMapping() {
        String typeName = OpenMetadataType.VALID_VALUES_MAPPING_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.STEWARD_TYPE_NAME.name;
        String attribute1Description = OpenMetadataProperty.STEWARD_TYPE_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.STEWARD_TYPE_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.STEWARD_PROPERTY_NAME.name;
        String attribute2Description = OpenMetadataProperty.STEWARD_PROPERTY_NAME.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.STEWARD_PROPERTY_NAME.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch updateValidValuesImplementation() {
        String typeName = OpenMetadataType.VALID_VALUES_IMPL_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private TypeDefPatch updateValidValueMember() {
        String typeName = OpenMetadataType.VALID_VALUE_MEMBER_RELATIONSHIP.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "isDefaultValue";
        String attribute1Description = "Is the member the default value in the set?";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getBooleanTypeDefAttribute("isDefaultValue", "Is the member the default value in the set?", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update07xxImplementationRelationships() {
        this.archiveBuilder.addTypeDefPatch(this.deprecateDigitalServiceImplementationRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateInformationSupplyChainImplementationRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSolutionComponentImplementationRelationship());
        this.archiveBuilder.addRelationshipDef(this.getImplementedByRelationship());
        this.archiveBuilder.addTypeDefPatch(this.updateDigitalServiceManagementRelationship());
    }

    private TypeDefPatch deprecateDigitalServiceImplementationRelationship() {
        String typeName = "DigitalServiceImplementation";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DigitalServiceImplementation");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateInformationSupplyChainImplementationRelationship() {
        String typeName = "InformationSupplyChainImplementation";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("InformationSupplyChainImplementation");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateSolutionComponentImplementationRelationship() {
        String typeName = "SolutionComponentImplementation";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SolutionComponentImplementation");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private RelationshipDef getImplementedByRelationship() {
        String guid = "28f63c94-aaef-4c84-98f7-d77aa605272e";
        String name = "ImplementedBy";
        String description = "Identifies a step in the refinement of digital components and artifacts from design to concrete implementation.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("28f63c94-aaef-4c84-98f7-d77aa605272e", "ImplementedBy", null, "Identifies a step in the refinement of digital components and artifacts from design to concrete implementation.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "derivedFrom";
        String end1AttributeDescription = "Abstract representation.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "derivedFrom", "Abstract representation.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end2AttributeName = "implementedBy";
        String end2AttributeDescription = "Resulting refined element.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "implementedBy", "Resulting refined element.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "designStep";
        String attribute1Description = "Process that created the refinement.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "role";
        String attribute2Description = "Role that this artifact plays in implementing the abstract representation.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "transformation";
        String attribute3Description = "Transformation process used to create the refinement.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute4Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("designStep", "Process that created the refinement.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("role", "Role that this artifact plays in implementing the abstract representation.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("transformation", "Transformation process used to create the refinement.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch updateDigitalServiceManagementRelationship() {
        String typeName = "DigitalServiceManagement";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DigitalServiceManagement");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        String end2EntityType = "PersonRole";
        String end2AttributeName = "digitalServiceManagers";
        String end2AttributeDescription = "The roles for managing this digital service.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("PersonRole"), "digitalServiceManagers", "The roles for managing this digital service.", end2AttributeDescriptionGUID, end2Cardinality);
        typeDefPatch.setEndDef2(relationshipEndDef);
        return typeDefPatch;
    }

    private void add0735SolutionPortSchemaRelationship() {
        this.archiveBuilder.addRelationshipDef(this.getSolutionPortSchemaRelationship());
    }

    private RelationshipDef getSolutionPortSchemaRelationship() {
        String guid = "bf02c703-57a2-4ab7-b6db-f49b57b05985";
        String name = "SolutionPortSchema";
        String description = "Identifies the structure of data passed through a solution port.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("bf02c703-57a2-4ab7-b6db-f49b57b05985", "SolutionPortSchema", null, "Identifies the structure of data passed through a solution port.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "SolutionPort";
        String end1AttributeName = "describesSolutionPortData";
        String end1AttributeDescription = "Port that uses the schema type.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SolutionPort"), "describesSolutionPortData", "Port that uses the schema type.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "SchemaType";
        String end2AttributeName = "solutionPortSchema";
        String end2AttributeDescription = "Structure of the solution port's data.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.AT_MOST_ONE;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("SchemaType"), "solutionPortSchema", "Structure of the solution port's data.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }
}

