/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_11;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.EntityDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_12 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.12";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_12() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_12(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_11 previousTypes = new OpenMetadataTypesArchive3_11(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.add0053XRootSchemaType();
        this.add0042ProcessingStateClassification();
    }

    private void add0042ProcessingStateClassification() {
        this.archiveBuilder.addClassificationDef(this.addProcessingStateClassification());
    }

    private ClassificationDef addProcessingStateClassification() {
        String guid = "261fb0aa-b884-4ee8-87ea-a60510e9751d";
        String name = "ProcessingState";
        String description = "Stores processing state information used by various SoftwareCapabilities.";
        String descriptionGUID = null;
        String linkedToEntity = "SoftwareCapability";
        ClassificationDef classificationDef = this.archiveHelper.getClassificationDef("261fb0aa-b884-4ee8-87ea-a60510e9751d", "ProcessingState", null, "Stores processing state information used by various SoftwareCapabilities.", descriptionGUID, this.archiveBuilder.getEntityDef("SoftwareCapability"), true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "syncDatesByKey";
        String attribute1Description = "Collection of synchronization dates identified by a key";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getMapStringLongTypeDefAttribute("syncDatesByKey", "Collection of synchronization dates identified by a key", attribute1DescriptionGUID);
        properties.add(property);
        classificationDef.setPropertiesDefinition(properties);
        return classificationDef;
    }

    private void add0053XRootSchemaType() {
        this.archiveBuilder.addEntityDef(this.getRootSchemaTypeEntity());
        this.archiveBuilder.addTypeDefPatch(this.updateTabularSchemaType());
        this.archiveBuilder.addTypeDefPatch(this.updateDocumentSchemaType());
        this.archiveBuilder.addTypeDefPatch(this.updateObjectSchemaType());
        this.archiveBuilder.addTypeDefPatch(this.updateEventType());
        this.archiveBuilder.addTypeDefPatch(this.updateRelationalDBSchemaType());
        this.archiveBuilder.addTypeDefPatch(this.updateAPISchemaType());
        this.archiveBuilder.addTypeDefPatch(this.updateDisplayDataSchemaType());
        this.archiveBuilder.addTypeDefPatch(this.updateQuerySchemaType());
        this.archiveBuilder.addTypeDefPatch(this.updateGraphSchemaType());
    }

    private EntityDef getRootSchemaTypeEntity() {
        String guid = OpenMetadataType.ROOT_SCHEMA_TYPE.typeGUID;
        String name = OpenMetadataType.ROOT_SCHEMA_TYPE.typeName;
        String description = OpenMetadataType.ROOT_SCHEMA_TYPE.description;
        String descriptionGUID = OpenMetadataType.ROOT_SCHEMA_TYPE.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ROOT_SCHEMA_TYPE.wikiURL;
        String superTypeName = "ComplexSchemaType";
        return this.archiveHelper.getDefaultEntityDef(guid, name, this.archiveBuilder.getEntityDef("ComplexSchemaType"), description, descriptionGUID, descriptionWiki);
    }

    private TypeDefPatch updateTabularSchemaType() {
        String typeName = "TabularSchemaType";
        String superTypeName = OpenMetadataType.ROOT_SCHEMA_TYPE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("TabularSchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateDocumentSchemaType() {
        String typeName = "DocumentSchemaType";
        String superTypeName = OpenMetadataType.ROOT_SCHEMA_TYPE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DocumentSchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateObjectSchemaType() {
        String typeName = "ObjectSchemaType";
        String superTypeName = OpenMetadataType.ROOT_SCHEMA_TYPE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ObjectSchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateEventType() {
        String typeName = "EventType";
        String superTypeName = OpenMetadataType.ROOT_SCHEMA_TYPE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("EventType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateRelationalDBSchemaType() {
        String typeName = "RelationalDBSchemaType";
        String superTypeName = OpenMetadataType.ROOT_SCHEMA_TYPE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("RelationalDBSchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateAPISchemaType() {
        String typeName = "APISchemaType";
        String superTypeName = OpenMetadataType.ROOT_SCHEMA_TYPE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("APISchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateDisplayDataSchemaType() {
        String typeName = "DisplayDataSchemaType";
        String superTypeName = OpenMetadataType.ROOT_SCHEMA_TYPE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DisplayDataSchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateQuerySchemaType() {
        String typeName = "QuerySchemaType";
        String superTypeName = OpenMetadataType.ROOT_SCHEMA_TYPE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("QuerySchemaType");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }

    private TypeDefPatch updateGraphSchemaType() {
        String typeName = OpenMetadataType.GRAPH_SCHEMA_TYPE.typeName;
        String superTypeName = OpenMetadataType.ROOT_SCHEMA_TYPE.typeName;
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType(typeName);
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setSuperType(this.archiveBuilder.getEntityDef(superTypeName));
        return typeDefPatch;
    }
}

