/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.opentypes;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive3_5;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveBuilder;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveHelper;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchiveType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.ClassificationPropagationRule;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndCardinality;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipEndDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefAttribute;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefPatch;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.OMRSLogicErrorException;

public class OpenMetadataTypesArchive3_7 {
    private static final String archiveGUID = "bce3b0a0-662a-4f87-b8dc-844078a11a6e";
    private static final String archiveName = "Open Metadata Types";
    private static final String archiveDescription = "Standard types for open metadata repositories.";
    private static final OpenMetadataArchiveType archiveType = OpenMetadataArchiveType.CONTENT_PACK;
    private static final String archiveVersion = "3.7";
    private static final String originatorName = "Egeria";
    private static final String originatorLicense = "Apache-2.0";
    private static final Date creationDate = new Date(1588261366992L);
    private static final long versionNumber = 1L;
    private static final String versionName = "1.0";
    private final OMRSArchiveBuilder archiveBuilder;
    private final OMRSArchiveHelper archiveHelper;

    public OpenMetadataTypesArchive3_7() {
        this.archiveBuilder = new OMRSArchiveBuilder(archiveGUID, archiveName, archiveDescription, archiveType, archiveVersion, originatorName, originatorLicense, creationDate, null);
        this.archiveHelper = new OMRSArchiveHelper(this.archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public OpenMetadataTypesArchive3_7(OMRSArchiveBuilder archiveBuilder) {
        this.archiveBuilder = archiveBuilder;
        this.archiveHelper = new OMRSArchiveHelper(archiveBuilder, archiveGUID, originatorName, creationDate, 1L, versionName);
    }

    public String getArchiveGUID() {
        return archiveGUID;
    }

    public OpenMetadataArchive getOpenMetadataArchive() {
        String methodName = "getOpenMetadataArchive";
        if (this.archiveBuilder != null) {
            this.getOriginalTypes();
            return this.archiveBuilder.getOpenMetadataArchive();
        }
        throw new OMRSLogicErrorException(OMRSErrorCode.ARCHIVE_UNAVAILABLE.getMessageDefinition(), this.getClass().getName(), "getOpenMetadataArchive");
    }

    public void getOriginalTypes() {
        OpenMetadataTypesArchive3_5 previousTypes = new OpenMetadataTypesArchive3_5(this.archiveBuilder);
        previousTypes.getOriginalTypes();
        this.update003040ITAssetDeployments();
        this.update0233EventsAndLogs();
        this.updateArea7LineageRelationships();
    }

    private void update003040ITAssetDeployments() {
        this.archiveBuilder.addRelationshipDef(this.getDeployedOnRelationship());
        this.archiveBuilder.addRelationshipDef(this.getOperatingPlatformUseRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSoftwareServerPlatformDeploymentRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateSoftwareServerDeploymentRelationship());
        this.archiveBuilder.addTypeDefPatch(this.deprecateHostOperatingPlatformRelationship());
    }

    private RelationshipDef getDeployedOnRelationship() {
        String guid = OpenMetadataType.DEPLOYED_ON.typeGUID;
        String name = OpenMetadataType.DEPLOYED_ON.typeName;
        String description = OpenMetadataType.DEPLOYED_ON.description;
        String descriptionGUID = OpenMetadataType.DEPLOYED_ON.descriptionGUID;
        String descriptionWiki = OpenMetadataType.DEPLOYED_ON.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.IT_INFRASTRUCTURE.typeName;
        String end1AttributeName = "deployedElement";
        String end1AttributeDescription = "IT infrastructure deployed to this asset.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "deployedElement", "IT infrastructure deployed to this asset.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ASSET.typeName;
        String end2AttributeName = "deployedTo";
        String end2AttributeDescription = "Deployment destination.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "deployedTo", "Deployment destination.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.DEPLOYMENT_TIME.name;
        String attribute1Description = OpenMetadataProperty.DEPLOYMENT_TIME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.DEPLOYMENT_TIME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DEPLOYER.name;
        String attribute2Description = OpenMetadataProperty.DEPLOYER.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DEPLOYER.descriptionGUID;
        String attribute3Name = OpenMetadataProperty.DEPLOYER_TYPE_NAME.name;
        String attribute3Description = OpenMetadataProperty.DEPLOYER_TYPE_NAME.description;
        String attribute3DescriptionGUID = OpenMetadataProperty.DEPLOYER_TYPE_NAME.descriptionGUID;
        String attribute4Name = OpenMetadataProperty.DEPLOYER_PROPERTY_NAME.name;
        String attribute4Description = OpenMetadataProperty.DEPLOYER_PROPERTY_NAME.description;
        String attribute4DescriptionGUID = OpenMetadataProperty.DEPLOYER_PROPERTY_NAME.descriptionGUID;
        String attribute5Name = OpenMetadataProperty.OPERATIONAL_STATUS.name;
        String attribute5Description = OpenMetadataProperty.OPERATIONAL_STATUS.description;
        String attribute5DescriptionGUID = OpenMetadataProperty.OPERATIONAL_STATUS.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute3Name, attribute3Description, attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute4Name, attribute4Description, attribute4DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getEnumTypeDefAttribute("OperationalStatus", attribute5Name, attribute5Description, attribute5DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private RelationshipDef getOperatingPlatformUseRelationship() {
        String guid = "0943e0ba-73ac-476b-8ebe-2ef30ba44976";
        String name = "OperatingPlatformUse";
        String description = "Identifies the operating platform installed on the IT Infrastructure asset.";
        String descriptionGUID = null;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef("0943e0ba-73ac-476b-8ebe-2ef30ba44976", "OperatingPlatformUse", null, "Identifies the operating platform installed on the IT Infrastructure asset.", descriptionGUID, classificationPropagationRule);
        String end1EntityType = "OperatingPlatform";
        String end1AttributeName = "operatingPlatforms";
        String end1AttributeDescription = "Software installed.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("OperatingPlatform"), "operatingPlatforms", "Software installed.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = "ITInfrastructure";
        String end2AttributeName = "installedOn";
        String end2AttributeDescription = "Where the operating platform is running.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef("ITInfrastructure"), "installedOn", "Where the operating platform is running.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "installTime";
        String attribute1Description = "Time that the software was installed on the IT Infrastructure.";
        String attribute1DescriptionGUID = null;
        String attribute2Name = "deployer";
        String attribute2Description = "Person, organization or engine that installed the software.";
        String attribute2DescriptionGUID = null;
        String attribute3Name = "deployerTypeName";
        String attribute3Description = "Type name of deployer.";
        String attribute3DescriptionGUID = null;
        String attribute4Name = "deployerPropertyName";
        String attribute4Description = "Identifying property name of deployer.";
        String attribute4DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getDateTypeDefAttribute("installTime", "Time that the software was installed on the IT Infrastructure.", attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("deployer", "Person, organization or engine that installed the software.", attribute2DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("deployerTypeName", "Type name of deployer.", attribute3DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute("deployerPropertyName", "Identifying property name of deployer.", attribute4DescriptionGUID);
        properties.add(property);
        relationshipDef.setPropertiesDefinition(properties);
        return relationshipDef;
    }

    private TypeDefPatch deprecateSoftwareServerPlatformDeploymentRelationship() {
        String typeName = "SoftwareServerPlatformDeployment";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SoftwareServerPlatformDeployment");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateSoftwareServerDeploymentRelationship() {
        String typeName = "SoftwareServerDeployment";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("SoftwareServerDeployment");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private TypeDefPatch deprecateHostOperatingPlatformRelationship() {
        String typeName = "HostOperatingPlatform";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("HostOperatingPlatform");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setTypeDefStatus(TypeDefStatus.DEPRECATED_TYPEDEF);
        return typeDefPatch;
    }

    private void updateArea7LineageRelationships() {
        this.archiveBuilder.addTypeDefPatch(this.enableMultiLinkOnLineageMappingRelationship());
        this.archiveBuilder.addTypeDefPatch(this.enableMultiLinkOnDataFlowRelationship());
        this.archiveBuilder.addTypeDefPatch(this.enableMultiLinkOnControlFlowRelationship());
        this.archiveBuilder.addTypeDefPatch(this.enableMultiLinkOnProcessCallRelationship());
    }

    private TypeDefPatch enableMultiLinkOnLineageMappingRelationship() {
        String typeName = "LineageMapping";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("LineageMapping");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = OpenMetadataProperty.QUALIFIED_NAME.name;
        String attribute1Description = OpenMetadataProperty.QUALIFIED_NAME.description;
        String attribute1DescriptionGUID = OpenMetadataProperty.QUALIFIED_NAME.descriptionGUID;
        String attribute2Name = OpenMetadataProperty.DESCRIPTION.name;
        String attribute2Description = OpenMetadataProperty.DESCRIPTION.description;
        String attribute2DescriptionGUID = OpenMetadataProperty.DESCRIPTION.descriptionGUID;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute(attribute1Name, attribute1Description, attribute1DescriptionGUID);
        properties.add(property);
        property = this.archiveHelper.getStringTypeDefAttribute(attribute2Name, attribute2Description, attribute2DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private TypeDefPatch enableMultiLinkOnDataFlowRelationship() {
        String typeName = "DataFlow";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("DataFlow");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private TypeDefPatch enableMultiLinkOnControlFlowRelationship() {
        String typeName = "ControlFlow";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ControlFlow");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        return typeDefPatch;
    }

    private TypeDefPatch enableMultiLinkOnProcessCallRelationship() {
        String typeName = "ProcessCall";
        TypeDefPatch typeDefPatch = this.archiveBuilder.getPatchForType("ProcessCall");
        typeDefPatch.setUpdatedBy(originatorName);
        typeDefPatch.setUpdateTime(creationDate);
        typeDefPatch.setUpdateMultiLink(true);
        typeDefPatch.setMultiLink(true);
        ArrayList<TypeDefAttribute> properties = new ArrayList<TypeDefAttribute>();
        String attribute1Name = "lineNumber";
        String attribute1Description = "Location of the call in the implementation.";
        String attribute1DescriptionGUID = null;
        TypeDefAttribute property = this.archiveHelper.getStringTypeDefAttribute("lineNumber", "Location of the call in the implementation.", attribute1DescriptionGUID);
        properties.add(property);
        typeDefPatch.setPropertyDefinitions(properties);
        return typeDefPatch;
    }

    private void update0233EventsAndLogs() {
        this.archiveBuilder.addRelationshipDef(this.addAssociatedLogRelationship());
    }

    private RelationshipDef addAssociatedLogRelationship() {
        String guid = OpenMetadataType.ASSOCIATED_LOG_RELATIONSHIP.typeGUID;
        String name = OpenMetadataType.ASSOCIATED_LOG_RELATIONSHIP.typeName;
        String description = OpenMetadataType.ASSOCIATED_LOG_RELATIONSHIP.description;
        String descriptionGUID = OpenMetadataType.ASSOCIATED_LOG_RELATIONSHIP.descriptionGUID;
        String descriptionWiki = OpenMetadataType.ASSOCIATED_LOG_RELATIONSHIP.wikiURL;
        ClassificationPropagationRule classificationPropagationRule = ClassificationPropagationRule.NONE;
        RelationshipDef relationshipDef = this.archiveHelper.getBasicRelationshipDef(guid, name, null, description, descriptionGUID, descriptionWiki, classificationPropagationRule);
        String end1EntityType = OpenMetadataType.REFERENCEABLE.typeName;
        String end1AttributeName = "logSubjects";
        String end1AttributeDescription = "Elements that the log records describe.";
        String end1AttributeDescriptionGUID = null;
        RelationshipEndCardinality end1Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        RelationshipEndDef relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end1EntityType), "logSubjects", "Elements that the log records describe.", end1AttributeDescriptionGUID, end1Cardinality);
        relationshipDef.setEndDef1(relationshipEndDef);
        String end2EntityType = OpenMetadataType.ASSET.typeName;
        String end2AttributeName = "associatedLogs";
        String end2AttributeDescription = "Destinations for log records.";
        String end2AttributeDescriptionGUID = null;
        RelationshipEndCardinality end2Cardinality = RelationshipEndCardinality.ANY_NUMBER;
        relationshipEndDef = this.archiveHelper.getRelationshipEndDef(this.archiveBuilder.getEntityDef(end2EntityType), "associatedLogs", "Destinations for log records.", end2AttributeDescriptionGUID, end2Cardinality);
        relationshipDef.setEndDef2(relationshipEndDef);
        return relationshipDef;
    }
}

