/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConnector;
import org.odpi.openmetadata.repositoryservices.connectors.openmetadatatopic.OpenMetadataTopicConsumerBase;
import org.odpi.openmetadata.repositoryservices.ffdc.OMRSErrorCode;

public class OpenMetadataTopicSenderConnectorBase
extends OpenMetadataTopicConsumerBase {
    protected CompletableFuture<Void> sendEvent(String event) throws InvalidParameterException, ConnectorCheckedException {
        String methodName = "sendEvent";
        this.validateEventBusConnectors("sendEvent");
        if (event == null) {
            String parameterName = "event";
            throw new InvalidParameterException(OMRSErrorCode.NULL_OUTBOUND_EVENT.getMessageDefinition(this.connectionName), this.getClass().getName(), "sendEvent", "event");
        }
        return CompletableFuture.runAsync(() -> {
            for (OpenMetadataTopicConnector eventBusConnector : this.eventBusConnectors) {
                try {
                    eventBusConnector.sendEvent(event);
                }
                catch (ConnectorCheckedException e) {
                    throw new CompletionException(e);
                }
            }
        });
    }
}

