/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.archiveutilities.simplecatalogs;

import java.util.ArrayList;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleAPICatalogArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleComboCatalogArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleDataCatalogArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleEventCatalogArchiveBuilder;
import org.odpi.openmetadata.archiveutilities.simplecatalogs.catalogcontent.SimpleGovernanceCatalogArchiveBuilder;
import org.odpi.openmetadata.opentypes.OpenMetadataTypesArchive;
import org.odpi.openmetadata.repositoryservices.archiveutilities.OMRSArchiveWriter;
import org.odpi.openmetadata.repositoryservices.connectors.stores.archivestore.properties.OpenMetadataArchive;

public class SimpleCatalogsArchiveWriter
extends OMRSArchiveWriter {
    private static final String openMetadataArchiveRootName = "SimpleCatalog";
    private static final String eventOpenMetadataArchiveFileName = "SimpleEventCatalog.omarchive";
    private static final String eventOpenMetadataArchiveName = "SimpleEventCatalog";
    private static final String apiOpenMetadataArchiveFileName = "SimpleAPICatalog.omarchive";
    private static final String apiOpenMetadataArchiveName = "SimpleAPICatalog";
    private static final String dataOpenMetadataArchiveFileName = "SimpleDataCatalog.omarchive";
    private static final String dataOpenMetadataArchiveName = "SimpleDataCatalog";
    private static final String governanceOpenMetadataArchiveFileName = "SimpleGovernanceCatalog.omarchive";
    private static final String governanceOpenMetadataArchiveName = "SimpleGovernanceCatalog";
    private static final String comboOpenMetadataArchiveFileName = "SimpleCatalog.omarchive";
    private static final String comboOpenMetadataArchiveName = "SimpleComboCatalog";

    private SimpleCatalogsArchiveWriter() {
    }

    public void writeOpenMetadataArchives(String folderName) {
        try {
            Object pathName = "";
            if (folderName != null) {
                pathName = folderName + "/";
            }
            ArrayList<OpenMetadataArchive> dependentArchives = new ArrayList<OpenMetadataArchive>();
            dependentArchives.add(new OpenMetadataTypesArchive().getOpenMetadataArchive());
            SimpleEventCatalogArchiveBuilder eventArchiveBuilder = new SimpleEventCatalogArchiveBuilder(eventOpenMetadataArchiveName, openMetadataArchiveRootName);
            OpenMetadataArchive newArchive = eventArchiveBuilder.getOpenMetadataArchive();
            dependentArchives.add(newArchive);
            super.writeOpenMetadataArchive((String)pathName + eventOpenMetadataArchiveFileName, newArchive);
            SimpleAPICatalogArchiveBuilder apiArchiveBuilder = new SimpleAPICatalogArchiveBuilder(apiOpenMetadataArchiveName, openMetadataArchiveRootName);
            newArchive = apiArchiveBuilder.getOpenMetadataArchive();
            dependentArchives.add(newArchive);
            super.writeOpenMetadataArchive((String)pathName + apiOpenMetadataArchiveFileName, newArchive);
            SimpleDataCatalogArchiveBuilder dataArchiveBuilder = new SimpleDataCatalogArchiveBuilder(dataOpenMetadataArchiveName, openMetadataArchiveRootName);
            newArchive = dataArchiveBuilder.getOpenMetadataArchive();
            dependentArchives.add(newArchive);
            super.writeOpenMetadataArchive((String)pathName + dataOpenMetadataArchiveFileName, newArchive);
            SimpleGovernanceCatalogArchiveBuilder governanceArchiveBuilder = new SimpleGovernanceCatalogArchiveBuilder(governanceOpenMetadataArchiveName, openMetadataArchiveRootName, dependentArchives);
            super.writeOpenMetadataArchive((String)pathName + governanceOpenMetadataArchiveFileName, governanceArchiveBuilder.getOpenMetadataArchive());
            SimpleComboCatalogArchiveBuilder comboCatalogArchiveBuilder = new SimpleComboCatalogArchiveBuilder(comboOpenMetadataArchiveName, openMetadataArchiveRootName);
            super.writeOpenMetadataArchive((String)pathName + comboOpenMetadataArchiveFileName, comboCatalogArchiveBuilder.getOpenMetadataArchive());
        }
        catch (Exception error) {
            System.out.println("error is " + error);
        }
    }

    public static void main(String[] args) {
        try {
            SimpleCatalogsArchiveWriter archiveWriter = new SimpleCatalogsArchiveWriter();
            archiveWriter.writeOpenMetadataArchives("content-packs");
        }
        catch (Exception error) {
            System.err.println("Exception: " + error);
            System.exit(-1);
        }
    }
}

