/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.softwaredeveloper.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum SoftwareDeveloperAuditCode implements AuditLogMessageSet
{
    SERVICE_INITIALIZING("OMAS-SOFTWARE-DEVELOPER-0001", AuditLogRecordSeverityLevel.STARTUP, "The Software Developer Open Metadata Access Service (OMAS) is initializing a new server instance", "The local server has started up a new instance of the Software Developer OMAS.", "No action is needed if this service is required.  This is part of the configured operation of the server."),
    SERVICE_INITIALIZED("OMAS-SOFTWARE-DEVELOPER-0003", AuditLogRecordSeverityLevel.STARTUP, "The Software Developer Open Metadata Access Service (OMAS) has initialized a new instance for server {0}", "The access service has completed initialization of a new instance.", "Verify that there were no errors reported as the service started."),
    SERVICE_SHUTDOWN("OMAS-SOFTWARE-DEVELOPER-0004", AuditLogRecordSeverityLevel.SHUTDOWN, "The Software Developer Open Metadata Access Service (OMAS) is shutting down its instance for server {0}", "The local administrator has requested shut down of an Software Developer OMAS instance.", "Verify that all resources have been released."),
    SERVICE_INSTANCE_FAILURE("OMAS-SOFTWARE-DEVELOPER-0005", AuditLogRecordSeverityLevel.EXCEPTION, "The Software Developer Open Metadata Access Service (OMAS) is unable to initialize a new instance; error message is {0}", "The access service detected an error during the start up of a specific server instance.  Its services are not available for the server.", "Review the error message and any other reported failures to determine the cause of the problem.  Once this is resolved, restart the server.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private SoftwareDeveloperAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "SoftwareDeveloperAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

