/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.softwaredeveloper.server;

import org.odpi.openmetadata.accessservices.softwaredeveloper.server.SoftwareDeveloperInstanceHandler;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.RegisteredOMAGServiceResponse;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class SoftwareDeveloperRESTServices {
    private static final SoftwareDeveloperInstanceHandler instanceHandler = new SoftwareDeveloperInstanceHandler();
    private static final RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(SoftwareDeveloperRESTServices.class), instanceHandler.getServiceName());
    private final RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public RegisteredOMAGServiceResponse getServiceDescription(String serverName, String userId) {
        String methodName = "getServiceDescription";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getServiceDescription");
        RegisteredOMAGServiceResponse response = new RegisteredOMAGServiceResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getServiceDescription");
            response.setService(instanceHandler.getRegisteredOMAGService(userId, serverName, AccessServiceDescription.SOFTWARE_DEVELOPER_OMAS.getAccessServiceCode(), "getServiceDescription"));
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureRuntimeExceptions((FFDCResponse)response, error, "getServiceDescription", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

