/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.solutionarchitect.server.spring;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.odpi.openmetadata.commonservices.ffdc.rest.FilterRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.GUIDResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.InformationSupplyChainLinkRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.InformationSupplyChainResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.InformationSupplyChainSegmentRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.InformationSupplyChainsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.MetadataSourceRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.NewInformationSupplyChainRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResultsRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.SolutionBlueprintsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SolutionComponentsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.SolutionRolesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.TemplateRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.UpdateInformationSupplyChainRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.VoidResponse;
import org.odpi.openmetadata.frameworkservices.omf.rest.AnyTimeRequestBody;
import org.odpi.openmetadata.frameworkservices.omf.rest.RelatedMetadataElementsResponse;
import org.odpi.openmetadata.viewservices.solutionarchitect.server.SolutionArchitectRESTServices;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/servers/{serverName}/api/open-metadata/solution-architect"})
@Tag(name="API: Solution Architect OMVS", description="The Solution Architect OMVS is a REST API designed to support user interfaces (UIs) relating to the definition and display of solution blueprints and their supporting solution components along with the relevant information supply chains.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/services/omvs/solution-architect/overview/"))
public class SolutionArchitectResource {
    private final SolutionArchitectRESTServices restAPI = new SolutionArchitectRESTServices();

    @PostMapping(path={"/information-supply-chains"})
    @Operation(summary="createInformationSupplyChain", description="Create an information supply chain.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public GUIDResponse createInformationSupplyChain(@PathVariable String serverName, @RequestBody(required=false) NewInformationSupplyChainRequestBody requestBody) {
        return this.restAPI.createInformationSupplyChain(serverName, requestBody);
    }

    @PostMapping(path={"/information-supply-chains/from-template"})
    @Operation(summary="createInformationSupplyChainFromTemplate", description="Create a new metadata element to represent an information supply chain using an existing metadata element as a template.  The template defines additional classifications and relationships that should be added to the new element.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public GUIDResponse createInformationSupplyChainFromTemplate(@PathVariable String serverName, @RequestBody(required=false) TemplateRequestBody requestBody) {
        return this.restAPI.createInformationSupplyChainFromTemplate(serverName, requestBody);
    }

    @PostMapping(path={"/information-supply-chains/{informationSupplyChainGUID}/update"})
    @Operation(summary="updateInformationSupplyChain", description="Update the properties of an information supply chain.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public VoidResponse updateInformationSupplyChain(@PathVariable String serverName, @PathVariable String informationSupplyChainGUID, @RequestParam(required=false, defaultValue="false") boolean replaceAllProperties, @RequestBody(required=false) UpdateInformationSupplyChainRequestBody requestBody) {
        return this.restAPI.updateInformationSupplyChain(serverName, informationSupplyChainGUID, replaceAllProperties, requestBody);
    }

    @PostMapping(path={"/information-supply-chains/{informationSupplyChainGUID}/segments"})
    @Operation(summary="createInformationSupplyChainSegment", description="Create an information supply chain segment and link it to its owning information supply chain.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public GUIDResponse createInformationSupplyChainSegment(@PathVariable String serverName, @PathVariable String informationSupplyChainGUID, @RequestBody(required=false) InformationSupplyChainSegmentRequestBody requestBody) {
        return this.restAPI.createInformationSupplyChainSegment(serverName, informationSupplyChainGUID, requestBody);
    }

    @PostMapping(path={"/information-supply-chains/segments/{segmentGUID}/update"})
    @Operation(summary="updateInformationSupplyChainSegment", description="Update the properties of an information supply chain segment.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public VoidResponse updateInformationSupplyChainSegment(@PathVariable String serverName, @PathVariable String segmentGUID, @RequestParam(required=false, defaultValue="false") boolean replaceAllProperties, @RequestBody(required=false) InformationSupplyChainSegmentRequestBody requestBody) {
        return this.restAPI.updateInformationSupplyChainSegment(serverName, segmentGUID, replaceAllProperties, requestBody);
    }

    @PostMapping(path={"/information-supply-chains/segments/{segment1GUID}/link-to/{segment2GUID}/attach"})
    @Operation(summary="linkSegments", description="Connect two information supply chain segments.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public VoidResponse linkSegments(@PathVariable String serverName, @PathVariable String segment1GUID, @PathVariable String segment2GUID, @RequestBody(required=false) InformationSupplyChainLinkRequestBody requestBody) {
        return this.restAPI.linkSegments(serverName, segment1GUID, segment2GUID, requestBody);
    }

    @PostMapping(path={"/information-supply-chains/segments/{segment1GUID}/link-to/{segment2GUID}/detach"})
    @Operation(summary="detachSegments", description="Detach two information supply chain segments from one another.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public VoidResponse detachSegments(@PathVariable String serverName, @PathVariable String segment1GUID, @PathVariable String segment2GUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.detachSegments(serverName, segment1GUID, segment2GUID, requestBody);
    }

    @PostMapping(path={"/information-supply-chains/segments/{segmentGUID}/delete"})
    @Operation(summary="deleteInformationSupplyChainSegment", description="Delete an information supply chain segment.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public VoidResponse deleteInformationSupplyChainSegment(@PathVariable String serverName, @PathVariable String segmentGUID, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.deleteInformationSupplyChainSegment(serverName, segmentGUID, requestBody);
    }

    @PostMapping(path={"/information-supply-chains/{informationSupplyChainGUID}/delete"})
    @Operation(summary="deleteInformationSupplyChain", description="Delete an information supply chain.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public VoidResponse deleteInformationSupplyChain(@PathVariable String serverName, @PathVariable String informationSupplyChainGUID, @RequestParam(required=false, defaultValue="false") boolean cascadedDelete, @RequestBody(required=false) MetadataSourceRequestBody requestBody) {
        return this.restAPI.deleteInformationSupplyChain(serverName, informationSupplyChainGUID, cascadedDelete, requestBody);
    }

    @PostMapping(path={"/information-supply-chains/by-name"})
    @Operation(summary="getInformationSupplyChainsByName", description="Returns the list of information supply chains with a particular name.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public InformationSupplyChainsResponse getInformationSupplyChainsByName(@PathVariable String serverName, @RequestParam(required=false, defaultValue="true") boolean addImplementation, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.getInformationSupplyChainsByName(serverName, addImplementation, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/information-supply-chains/by-search-string"})
    @Operation(summary="findInformationSupplyChains", description="Retrieve the list of information supply chain metadata elements that contain the search string.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public InformationSupplyChainsResponse findInformationSupplyChains(@PathVariable String serverName, @RequestParam(required=false, defaultValue="true") boolean addImplementation, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findInformationSupplyChains(serverName, addImplementation, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/information-supply-chains/{informationSupplyChainGUID}/retrieve"})
    @Operation(summary="getInformationSupplyChainByGUID", description="Return the properties of a specific information supply chain.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/information-supply-chain"))
    public InformationSupplyChainResponse getInformationSupplyChainByGUID(@PathVariable String serverName, @PathVariable String informationSupplyChainGUID, @RequestParam(required=false, defaultValue="true") boolean addImplementation, @RequestBody(required=false) AnyTimeRequestBody requestBody) {
        return this.restAPI.getInformationSupplyChainByGUID(serverName, informationSupplyChainGUID, addImplementation, requestBody);
    }

    @PostMapping(path={"/solution-blueprints/by-search-string"})
    @Operation(summary="findSolutionBlueprints", description="Retrieve the list of solution blueprint metadata elements that contain the search string.  The returned blueprints include a list of the components that are associated with it.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/solution-blueprint"))
    public SolutionBlueprintsResponse findSolutionBlueprints(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findSolutionBlueprints(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/solution-roles/by-search-string"})
    @Operation(summary="findSolutionRoles", description="Retrieve the list of actor roles metadata elements that contain the search string and show which solution components (if any) are attached to it.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/actor"))
    public SolutionRolesResponse findSolutionRoles(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findSolutionRoles(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/solution-components/by-search-string"})
    @Operation(summary="findSolutionComponents", description="Retrieve the list of solution metadata elements that contain the search string.  The solutions components returned include information about the consumers, actors and other solution components that are associated with them.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/solution-component"))
    public SolutionComponentsResponse findSolutionComponents(@PathVariable String serverName, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestParam(required=false, defaultValue="false") boolean startsWith, @RequestParam(required=false, defaultValue="false") boolean endsWith, @RequestParam(required=false, defaultValue="false") boolean ignoreCase, @RequestBody(required=false) FilterRequestBody requestBody) {
        return this.restAPI.findSolutionComponents(serverName, startsWith, endsWith, ignoreCase, startFrom, pageSize, requestBody);
    }

    @PostMapping(path={"/solution-components/{solutionComponentGUID}/implementations"})
    @Operation(summary="getSolutionComponentImplementations", description="Retrieve the list of  metadata elements that are associated with the solution component via the ImplementedBy relationship.", externalDocs=@ExternalDocumentation(description="Further Information", url="https://egeria-project.org/concepts/solution-component"))
    public RelatedMetadataElementsResponse getSolutionComponentImplementations(@PathVariable String serverName, @PathVariable String solutionComponentGUID, @RequestParam(required=false, defaultValue="0") int startFrom, @RequestParam(required=false, defaultValue="0") int pageSize, @RequestBody(required=false) ResultsRequestBody requestBody) {
        return this.restAPI.getSolutionComponentImplementations(serverName, solutionComponentGUID, startFrom, pageSize, requestBody);
    }
}

