/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.restclients.spring;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.Base64;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.RESTClientConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.exceptions.RESTServerException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class SpringRESTClientConnector
extends RESTClientConnector {
    private RestTemplate restTemplate = new RestTemplate();
    private String serverName = null;
    private String serverPlatformURLRoot = null;
    private HttpHeaders basicAuthorizationHeader = null;
    private static final Logger log = LoggerFactory.getLogger(SpringRESTClientConnector.class);

    public SpringRESTClientConnector() {
        List converters = this.restTemplate.getMessageConverters();
        converters.removeIf(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter);
        converters.add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.serverPlatformURLRoot = endpoint.getAddress();
            this.serverName = endpoint.getDisplayName();
        } else {
            log.error("No endpoint for connector.");
            this.serverPlatformURLRoot = null;
            this.serverName = null;
        }
        String userId = connectionProperties.getUserId();
        String password = connectionProperties.getClearPassword();
        if (userId != null && password != null) {
            log.debug("Using basic authentication to call server " + this.serverName + " on platform " + this.serverPlatformURLRoot + ".");
            this.basicAuthorizationHeader = this.createHeaders(userId, password);
        } else {
            log.debug("Using no authentication to call server " + this.serverName + " on platform " + this.serverPlatformURLRoot + ".");
        }
    }

    private HttpHeaders createHeaders(String username, String password) {
        String authorizationString = username + ":" + password;
        byte[] encodedAuthorizationString = Base64.encodeBase64((byte[])authorizationString.getBytes(StandardCharsets.US_ASCII));
        String authHeader = "Basic " + new String(encodedAuthorizationString);
        HttpHeaders header = new HttpHeaders();
        header.set("Authorization", authHeader);
        return header;
    }

    public <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws RESTServerException {
        try {
            Object responseObject;
            log.debug("Calling " + methodName + " with URL template " + urlTemplate + " and no parameters.");
            if (this.basicAuthorizationHeader == null) {
                responseObject = this.restTemplate.getForObject(urlTemplate, returnClass, new Object[0]);
            } else {
                HttpEntity request = new HttpEntity((MultiValueMap)this.basicAuthorizationHeader);
                ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from " + methodName + " with response object " + responseObject.toString() + ".");
            } else {
                log.debug("Returning from " + methodName + " with no response object.");
            }
            return (T)responseObject;
        }
        catch (Throwable error) {
            log.debug("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            throw new RESTServerException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws RESTServerException {
        try {
            Object responseObject;
            log.debug("Calling " + methodName + " with URL template " + urlTemplate + " and parameters " + Arrays.toString(params) + ".");
            if (this.basicAuthorizationHeader == null) {
                responseObject = this.restTemplate.getForObject(urlTemplate, returnClass, params);
            } else {
                HttpEntity request = new HttpEntity((MultiValueMap)this.basicAuthorizationHeader);
                ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, request, returnClass, params);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from " + methodName + " with response object " + responseObject.toString() + ".");
            } else {
                log.debug("Returning from " + methodName + " with no response object.");
            }
            return (T)responseObject;
        }
        catch (Throwable error) {
            log.debug("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            throw new RESTServerException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws RESTServerException {
        try {
            Object responseObject;
            log.debug("Calling " + methodName + " with URL template " + urlTemplate + " and no parameters.");
            if (this.basicAuthorizationHeader == null) {
                responseObject = this.restTemplate.postForObject(urlTemplate, requestBody, returnClass, new Object[0]);
            } else {
                HttpEntity request;
                if (requestBody != null) {
                    request = new HttpEntity(requestBody, (MultiValueMap)this.basicAuthorizationHeader);
                } else {
                    log.warn("Poorly formed POST call made by " + methodName);
                    request = new HttpEntity((MultiValueMap)this.basicAuthorizationHeader);
                }
                ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.POST, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from " + methodName + " with response object " + responseObject.toString() + ".");
            } else {
                log.debug("Returning from " + methodName + " with no response object.");
            }
            return (T)responseObject;
        }
        catch (Throwable error) {
            log.debug("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            throw new RESTServerException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            Object responseObject;
            log.debug("Calling " + methodName + " with URL template " + urlTemplate + " and parameters " + Arrays.toString(params) + ".");
            if (this.basicAuthorizationHeader == null) {
                responseObject = this.restTemplate.postForObject(urlTemplate, requestBody, returnClass, params);
            } else {
                HttpEntity request;
                if (requestBody != null) {
                    request = new HttpEntity(requestBody, (MultiValueMap)this.basicAuthorizationHeader);
                } else {
                    log.warn("Poorly formed POST call made by " + methodName);
                    request = new HttpEntity((MultiValueMap)this.basicAuthorizationHeader);
                }
                ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.POST, request, returnClass, params);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from " + methodName + " with response object " + responseObject.toString() + ".");
            } else {
                log.debug("Returning from " + methodName + " with no response object.");
            }
            return (T)responseObject;
        }
        catch (Throwable error) {
            log.debug("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            throw new RESTServerException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public <T> T callDeleteRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws RESTServerException {
        try {
            log.debug("Calling " + methodName + " with URL template " + urlTemplate + " and no parameters.");
            Object responseObject = null;
            if (this.basicAuthorizationHeader == null) {
                this.restTemplate.delete(urlTemplate, new Object[0]);
            } else {
                HttpEntity request;
                if (requestBody != null) {
                    request = new HttpEntity(requestBody, (MultiValueMap)this.basicAuthorizationHeader);
                } else {
                    log.warn("Poorly formed POST call made by " + methodName);
                    request = new HttpEntity((MultiValueMap)this.basicAuthorizationHeader);
                }
                ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from " + methodName + " with response object " + responseObject.toString() + ".");
            } else {
                log.debug("Returning from " + methodName + " with no response object.");
            }
            return (T)responseObject;
        }
        catch (Throwable error) {
            log.error("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            throw new RESTServerException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }

    public <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            log.debug("Calling " + methodName + " with URL template " + urlTemplate + " and parameters " + Arrays.toString(params) + ".");
            Object responseObject = null;
            if (this.basicAuthorizationHeader == null) {
                this.restTemplate.delete(urlTemplate, params);
            } else {
                HttpEntity request = requestBody != null ? new HttpEntity(requestBody, (MultiValueMap)this.basicAuthorizationHeader) : new HttpEntity((MultiValueMap)this.basicAuthorizationHeader);
                ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, request, returnClass, params);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from " + methodName + " with response object " + responseObject.toString() + ".");
            } else {
                log.debug("Returning from " + methodName + " with no response object.");
            }
            return (T)responseObject;
        }
        catch (Throwable error) {
            log.error("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            throw new RESTServerException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction(), error);
        }
    }
}

