/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.restclients.spring;

import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.Base64;
import org.odpi.openmetadata.adapters.connectors.restclients.RESTClientConnector;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.RESTClientConnectorErrorCode;
import org.odpi.openmetadata.adapters.connectors.restclients.ffdc.exceptions.RESTServerException;
import org.odpi.openmetadata.frameworks.auditlog.MessageFormatter;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.MessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.tokenmanager.http.HTTPHeadersThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

public class SpringRESTClientConnector
extends RESTClientConnector {
    private final RestTemplate restTemplate;
    private String serverName = null;
    private String serverPlatformURLRoot = null;
    private HttpHeaders basicAuthorizationHeader = null;
    private final MessageFormatter messageFormatter = new MessageFormatter();
    private static final Logger log = LoggerFactory.getLogger(SpringRESTClientConnector.class);

    public SpringRESTClientConnector() throws NoSuchAlgorithmException, KeyManagementException {
        DefaultUriBuilderFactory builderFactory = new DefaultUriBuilderFactory();
        builderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.VALUES_ONLY);
        this.restTemplate = new RestTemplate();
        this.restTemplate.setUriTemplateHandler((UriTemplateHandler)builderFactory);
        List converters = this.restTemplate.getMessageConverters();
        converters.removeIf(httpMessageConverter -> httpMessageConverter instanceof StringHttpMessageConverter);
        converters.add(0, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    public void initialize(String connectorInstanceId, ConnectionProperties connectionProperties) {
        super.initialize(connectorInstanceId, connectionProperties);
        EndpointProperties endpoint = connectionProperties.getEndpoint();
        if (endpoint != null) {
            this.serverPlatformURLRoot = endpoint.getAddress();
            this.serverName = endpoint.getDisplayName();
        } else {
            log.error("No endpoint for connector.");
            this.serverPlatformURLRoot = null;
            this.serverName = null;
        }
        String userId = connectionProperties.getUserId();
        String password = connectionProperties.getClearPassword();
        if (userId != null && password != null) {
            log.debug("Using basic authentication to call server {}  on platform {} .", (Object)this.serverName, (Object)this.serverPlatformURLRoot);
            this.basicAuthorizationHeader = this.createHeaders(userId, password);
        } else {
            log.debug("Using no authentication to call server {} on platform {} .", (Object)this.serverName, (Object)this.serverPlatformURLRoot);
        }
    }

    private HttpHeaders createHeaders(String username, String password) {
        String authorizationString = username + ":" + password;
        byte[] encodedAuthorizationString = Base64.encodeBase64((byte[])authorizationString.getBytes(StandardCharsets.US_ASCII));
        String authHeader = "Basic " + new String(encodedAuthorizationString);
        HttpHeaders header = new HttpHeaders();
        header.set("Authorization", authHeader);
        return header;
    }

    public <T> T callGetRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate) throws RESTServerException {
        try {
            Object responseObject;
            log.debug("Calling {} with URL template {} and no parameters.", (Object)methodName, (Object)urlTemplate);
            HttpHeaders headers = this.getHttpHeaders();
            if (headers.isEmpty()) {
                responseObject = this.restTemplate.getForObject(urlTemplate, returnClass, new Object[0]);
            } else {
                HttpEntity request = new HttpEntity((MultiValueMap)headers);
                ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", new Object[]{error.getClass().getName(), error.getMessage(), methodName});
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callGetRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object ... params) throws RESTServerException {
        try {
            Object responseObject;
            HttpHeaders headers;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", new Object[]{methodName, urlTemplate, Arrays.toString(params)});
            }
            if ((headers = this.getHttpHeaders()).isEmpty()) {
                responseObject = this.restTemplate.getForObject(urlTemplate, returnClass, params);
            } else {
                HttpEntity request = new HttpEntity((MultiValueMap)headers);
                ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, request, returnClass, params);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", new Object[]{error.getClass().getName(), error.getMessage(), methodName});
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callPostRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws RESTServerException {
        try {
            Object responseObject;
            log.debug("Calling {} with URL template {} and no parameters.", (Object)methodName, (Object)urlTemplate);
            HttpHeaders headers = this.getHttpHeaders();
            if (headers.isEmpty()) {
                responseObject = this.restTemplate.postForObject(urlTemplate, requestBody, returnClass, new Object[0]);
            } else {
                HttpEntity request;
                if (requestBody != null) {
                    request = new HttpEntity(requestBody, (MultiValueMap)headers);
                } else {
                    log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                    request = new HttpEntity((MultiValueMap)headers);
                }
                ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.POST, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", new Object[]{error.getClass().getName(), error.getMessage(), methodName});
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callPostRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            Object responseObject;
            HttpHeaders headers;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", new Object[]{methodName, urlTemplate, Arrays.toString(params)});
            }
            if ((headers = this.getHttpHeaders()).isEmpty()) {
                responseObject = this.restTemplate.postForObject(urlTemplate, requestBody, returnClass, params);
            } else {
                HttpEntity request;
                if (requestBody != null) {
                    request = new HttpEntity(requestBody, (MultiValueMap)headers);
                } else {
                    log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                    request = new HttpEntity((MultiValueMap)headers);
                }
                ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.POST, request, returnClass, params);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", new Object[]{error.getClass().getName(), error.getMessage(), methodName});
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callPutRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            ResponseEntity responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", new Object[]{methodName, urlTemplate, Arrays.toString(params)});
            }
            HttpEntity request = new HttpEntity(requestBody);
            if (requestBody == null) {
                log.warn("Poorly formed PUT call made by {}.", (Object)methodName);
            }
            if (this.basicAuthorizationHeader != null) {
                request = new HttpEntity(requestBody, (MultiValueMap)this.basicAuthorizationHeader);
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.PUT, request, returnClass, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", new Object[]{error.getClass().getName(), error.getMessage(), methodName});
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callPutRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws RESTServerException {
        try {
            ResponseEntity responseEntity;
            Object responseObject;
            HttpEntity request = new HttpEntity(requestBody);
            if (requestBody == null) {
                log.warn("Poorly formed PUT call made by {}.", (Object)methodName);
            }
            if (this.basicAuthorizationHeader != null) {
                request = new HttpEntity(requestBody, (MultiValueMap)this.basicAuthorizationHeader);
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.PUT, request, returnClass, new Object[0])).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", new Object[]{error.getClass().getName(), error.getMessage(), methodName});
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callDeleteRESTCallNoParams(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody) throws RESTServerException {
        try {
            log.debug("Calling {} with URL template {} and no parameters.", (Object)methodName, (Object)urlTemplate);
            Object responseObject = null;
            HttpHeaders headers = this.getHttpHeaders();
            if (headers.isEmpty()) {
                this.restTemplate.delete(urlTemplate, new Object[0]);
            } else {
                HttpEntity request;
                if (requestBody != null) {
                    request = new HttpEntity(requestBody, (MultiValueMap)headers);
                } else {
                    log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                    request = new HttpEntity((MultiValueMap)headers);
                }
                ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, request, returnClass, new Object[0]);
                responseObject = responseEntity.getBody();
            }
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", new Object[]{error.getClass().getName(), error.getMessage(), methodName});
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callDeleteRESTCall(String methodName, Class<T> returnClass, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            ResponseEntity responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", new Object[]{methodName, urlTemplate, Arrays.toString(params)});
            }
            HttpEntity request = new HttpEntity(requestBody);
            if (this.basicAuthorizationHeader != null) {
                request = new HttpEntity(requestBody, (MultiValueMap)this.basicAuthorizationHeader);
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, request, returnClass, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.error("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callPostRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            HttpEntity request;
            HttpHeaders headers;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", new Object[]{methodName, urlTemplate, Arrays.toString(params)});
            }
            if ((headers = this.getHttpHeaders()).isEmpty()) {
                request = new HttpEntity(requestBody);
            } else if (requestBody != null) {
                request = new HttpEntity(requestBody, (MultiValueMap)headers);
            } else {
                log.warn("Poorly formed POST call made by {}.", (Object)methodName);
                request = new HttpEntity((MultiValueMap)headers);
            }
            ResponseEntity responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.POST, request, responseType, params);
            Object responseObject = responseEntity.getBody();
            if (responseObject != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", new Object[]{error.getClass().getName(), error.getMessage(), methodName});
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callGetRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object ... params) throws RESTServerException {
        try {
            HttpHeaders headers;
            HttpEntity request;
            ResponseEntity responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", new Object[]{methodName, urlTemplate, Arrays.toString(params)});
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.GET, request = (headers = this.getHttpHeaders()).isEmpty() ? HttpEntity.EMPTY : new HttpEntity((MultiValueMap)headers), responseType, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", new Object[]{error.getClass().getName(), error.getMessage(), methodName});
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callDeleteRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            ResponseEntity responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", new Object[]{methodName, urlTemplate, Arrays.toString(params)});
            }
            HttpEntity request = new HttpEntity(requestBody);
            if (this.basicAuthorizationHeader != null) {
                request = new HttpEntity(requestBody, (MultiValueMap)this.basicAuthorizationHeader);
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.DELETE, request, responseType, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.error("Exception " + error.getClass().getName() + " with message " + error.getMessage() + " occurred during REST call for " + methodName + ".");
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    public <T> T callPutRESTCall(String methodName, ParameterizedTypeReference<T> responseType, String urlTemplate, Object requestBody, Object ... params) throws RESTServerException {
        try {
            ResponseEntity responseEntity;
            Object responseObject;
            if (log.isDebugEnabled()) {
                log.debug("Calling {} with URL template {} and parameters {}.", new Object[]{methodName, urlTemplate, Arrays.toString(params)});
            }
            HttpEntity request = new HttpEntity(requestBody);
            if (requestBody == null) {
                log.warn("Poorly formed PUT call made by {}", (Object)methodName);
            }
            if (this.basicAuthorizationHeader != null) {
                request = new HttpEntity(requestBody, (MultiValueMap)this.basicAuthorizationHeader);
            }
            if ((responseObject = (responseEntity = this.restTemplate.exchange(urlTemplate, HttpMethod.PUT, request, responseType, params)).getBody()) != null) {
                log.debug("Returning from {} with response object {}", (Object)methodName, responseObject);
            } else {
                log.debug("Returning from {} with no response object.", (Object)methodName);
            }
            return (T)responseObject;
        }
        catch (Exception error) {
            log.debug("Exception {} with message {} occurred during REST call for {}.", new Object[]{error.getClass().getName(), error.getMessage(), methodName});
            RESTClientConnectorErrorCode errorCode = RESTClientConnectorErrorCode.CLIENT_SIDE_REST_API_ERROR;
            ExceptionMessageDefinition messageDefinition = errorCode.getMessageDefinition(new String[]{error.getClass().getName(), methodName, urlTemplate, this.serverName, this.serverPlatformURLRoot, error.getMessage()});
            String errorMessage = this.messageFormatter.getFormattedMessage((MessageDefinition)messageDefinition);
            throw new RESTServerException(messageDefinition.getHttpErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, messageDefinition.getSystemAction(), messageDefinition.getUserAction(), error);
        }
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        Map threadLocalHeaders = (Map)HTTPHeadersThreadLocal.getHeadersThreadLocal().get();
        if (threadLocalHeaders != null) {
            for (Map.Entry entry : threadLocalHeaders.entrySet()) {
                headers.set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.basicAuthorizationHeader != null) {
            headers.addAll((MultiValueMap)this.basicAuthorizationHeader);
        }
        return headers;
    }
}

