/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.stewardshipaction.properties.SupplementaryProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AssetProperties
extends SupplementaryProperties {
    private static final long serialVersionUID = 1L;
    private String resourceName = null;
    private String versionIdentifier = null;
    private String resourceDescription = null;

    public AssetProperties() {
    }

    public AssetProperties(AssetProperties template) {
        super(template);
        if (template != null) {
            this.resourceName = template.getDisplayName();
            this.versionIdentifier = template.getVersionIdentifier();
            this.resourceDescription = template.getResourceDescription();
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    public void setVersionIdentifier(String versionIdentifier) {
        this.versionIdentifier = versionIdentifier;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void setResourceDescription(String resourceDescription) {
        this.resourceDescription = resourceDescription;
    }

    @Override
    public String toString() {
        return "AssetProperties{resourceName='" + this.resourceName + "', versionIdentifier='" + this.versionIdentifier + "', resourceDescription='" + this.resourceDescription + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", effectiveFrom=" + this.getEffectiveFrom() + ", effectiveTo=" + this.getEffectiveTo() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + ", displayName='" + this.getDisplayName() + "', summary='" + this.getSummary() + "', description='" + this.getDescription() + "', abbreviation='" + this.getAbbreviation() + "', usage='" + this.getUsage() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof AssetProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetProperties that = (AssetProperties)objectToCompare;
        if (this.resourceName != null ? !this.resourceName.equals(that.resourceName) : that.resourceName != null) {
            return false;
        }
        if (this.versionIdentifier != null ? !this.versionIdentifier.equals(that.versionIdentifier) : that.versionIdentifier != null) {
            return false;
        }
        return this.resourceDescription != null ? this.resourceDescription.equals(that.resourceDescription) : that.resourceDescription == null;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resourceName, this.versionIdentifier, this.resourceDescription);
    }
}

