/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.accessservices.stewardshipaction.properties.AssetProperties;
import org.odpi.openmetadata.accessservices.stewardshipaction.properties.FileProperties;
import org.odpi.openmetadata.accessservices.stewardshipaction.properties.FolderProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=FileProperties.class, name="FileProperties"), @JsonSubTypes.Type(value=FolderProperties.class, name="FolderProperties")})
public class DataStoreProperties
extends AssetProperties {
    private static final long serialVersionUID = 1L;
    private String pathName = null;
    private Date createTime = null;
    private Date modifiedTime = null;
    private String encodingType = null;
    private String encodingLanguage = null;
    private String encodingDescription = null;
    private Map<String, String> encodingProperties = null;

    public DataStoreProperties() {
    }

    public DataStoreProperties(DataStoreProperties template) {
        super(template);
        if (template != null) {
            this.pathName = template.getPathName();
            this.createTime = template.getCreateTime();
            this.modifiedTime = template.getModifiedTime();
            this.encodingType = template.getEncodingType();
            this.encodingLanguage = template.getEncodingLanguage();
            this.encodingDescription = template.getEncodingDescription();
            this.encodingProperties = template.getEncodingProperties();
        }
    }

    public DataStoreProperties(AssetProperties template) {
        super(template);
    }

    public String getPathName() {
        return this.pathName;
    }

    public void setPathName(String pathName) {
        this.pathName = pathName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingLanguage() {
        return this.encodingLanguage;
    }

    public void setEncodingLanguage(String encodingLanguage) {
        this.encodingLanguage = encodingLanguage;
    }

    public String getEncodingDescription() {
        return this.encodingDescription;
    }

    public void setEncodingDescription(String encodingDescription) {
        this.encodingDescription = encodingDescription;
    }

    public Map<String, String> getEncodingProperties() {
        if (this.encodingProperties == null) {
            return null;
        }
        if (this.encodingProperties.isEmpty()) {
            return null;
        }
        return this.encodingProperties;
    }

    public void setEncodingProperties(Map<String, String> encodingProperties) {
        this.encodingProperties = encodingProperties;
    }

    @Override
    public String toString() {
        return "DataStoreProperties{pathName=" + this.pathName + ", createTime=" + this.createTime + ", modifiedTime=" + this.modifiedTime + ", encodingType='" + this.encodingType + "', encodingLanguage='" + this.encodingLanguage + "', encodingDescription='" + this.encodingDescription + "', encodingProperties='" + this.encodingProperties + "', displayName='" + this.getDisplayName() + "', description='" + this.getDescription() + "', owner='" + this.getOwner() + "', zoneMembership=" + this.getZoneMembership() + ", origin=" + this.getOtherOriginValues() + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataStoreProperties that = (DataStoreProperties)objectToCompare;
        return Objects.equals(this.pathName, that.pathName) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.modifiedTime, that.modifiedTime) && Objects.equals(this.encodingType, that.encodingType) && Objects.equals(this.encodingLanguage, that.encodingLanguage) && Objects.equals(this.encodingDescription, that.encodingDescription) && Objects.equals(this.encodingProperties, that.encodingProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pathName, this.createTime, this.modifiedTime, this.encodingType, this.encodingLanguage, this.encodingDescription, this.encodingProperties);
    }
}

