/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction;

import java.util.List;
import org.odpi.openmetadata.accessservices.stewardshipaction.api.DuplicateManagementInterface;
import org.odpi.openmetadata.accessservices.stewardshipaction.metadataelements.DuplicateElement;
import org.odpi.openmetadata.accessservices.stewardshipaction.metadataelements.ElementStub;
import org.odpi.openmetadata.accessservices.stewardshipaction.rest.DuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.stewardshipaction.rest.StewardshipActionRESTClient;
import org.odpi.openmetadata.commonservices.ocf.metadatamanagement.client.ConnectedAssetClientBase;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class StewardshipAction
extends ConnectedAssetClientBase
implements DuplicateManagementInterface {
    protected StewardshipActionRESTClient restClient;
    private static final String serviceURLName = "stewardship-action";

    public StewardshipAction(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot);
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot, StewardshipActionRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        super(serverName, serverPlatformURLRoot, auditLog);
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    public void linkElementsAsDuplicates(String userId, String element1GUID, String element2GUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkElementsAsDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/duplicate-of/{3}";
        this.invalidParameterHandler.validateUserId(userId, "linkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element1GUID, "element1GUID", "linkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element2GUID, "element2GUID", "linkElementsAsDuplicates");
        DuplicatesRequestBody requestBody = new DuplicatesRequestBody();
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        this.restClient.callVoidPostRESTCall("linkElementsAsDuplicates", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/duplicate-of/{3}", requestBody, new Object[]{this.serverName, userId, element1GUID, element2GUID});
    }

    public void unlinkElementsAsDuplicates(String userId, String element1GUID, String element2GUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkElementsAsDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/duplicate-of/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unlinkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element1GUID, "element1GUID", "unlinkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element2GUID, "element2GUID", "unlinkElementsAsDuplicates");
        this.restClient.callVoidPostRESTCall("unlinkElementsAsDuplicates", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/asset-owner/users/{1}/elements/{2}/duplicate-of/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, element1GUID, element2GUID});
    }

    public List<DuplicateElement> getPeerDuplicates(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void markAsConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> contributingElementGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void updateConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void linkElementToConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, String contributingElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public void unlinkElementFromConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID, String contributingElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }

    public List<ElementStub> getContributingDuplicates(String userId, String consolidatedDuplicateGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public ElementStub getContributingDuplicates(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return null;
    }

    public void removeConsolidatedDuplicate(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
    }
}

