/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction.client;

import java.util.List;
import org.odpi.openmetadata.accessservices.stewardshipaction.api.DuplicateManagementInterface;
import org.odpi.openmetadata.accessservices.stewardshipaction.client.rest.StewardshipActionRESTClient;
import org.odpi.openmetadata.accessservices.stewardshipaction.metadataelements.DuplicateElement;
import org.odpi.openmetadata.accessservices.stewardshipaction.metadataelements.ElementStub;
import org.odpi.openmetadata.accessservices.stewardshipaction.rest.DuplicatesRequestBody;
import org.odpi.openmetadata.accessservices.stewardshipaction.rest.DuplicatesResponse;
import org.odpi.openmetadata.accessservices.stewardshipaction.rest.ElementStubResponse;
import org.odpi.openmetadata.accessservices.stewardshipaction.rest.ElementStubsResponse;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;

public class StewardshipAction
implements DuplicateManagementInterface {
    private String serverName;
    private String serverPlatformURLRoot;
    private AuditLog auditLog;
    private static NullRequestBody nullRequestBody = new NullRequestBody();
    private InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private StewardshipActionRESTClient restClient;

    public StewardshipAction(String serverName, String serverPlatformURLRoot, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot, String userId, String password) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot, StewardshipActionRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.restClient = restClient;
    }

    public void linkElementsAsDuplicates(String userId, String element1GUID, String element2GUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkElementsAsDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/peer-duplicate-of/{3}";
        this.invalidParameterHandler.validateUserId(userId, "linkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element1GUID, "element1GUID", "linkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element2GUID, "element2GUID", "linkElementsAsDuplicates");
        DuplicatesRequestBody requestBody = new DuplicatesRequestBody();
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        this.restClient.callVoidPostRESTCall("linkElementsAsDuplicates", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/peer-duplicate-of/{3}", requestBody, new Object[]{this.serverName, userId, element1GUID, element2GUID});
    }

    public void unlinkElementsAsDuplicates(String userId, String element1GUID, String element2GUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkElementsAsDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/peer-duplicate-of/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unlinkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element1GUID, "element1GUID", "unlinkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element2GUID, "element2GUID", "unlinkElementsAsDuplicates");
        this.restClient.callVoidPostRESTCall("unlinkElementsAsDuplicates", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/peer-duplicate-of/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, element1GUID, element2GUID});
    }

    public void markElementAsKnownDuplicate(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "markElementAsKnownDuplicate";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/known-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "markElementAsKnownDuplicate");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "markElementAsKnownDuplicate");
        this.restClient.callVoidPostRESTCall("markElementAsKnownDuplicate", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/known-duplicate", nullRequestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    public void unmarkElementAsKnownDuplicate(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unmarkElementAsKnownDuplicate";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/known-duplicate/delete";
        this.invalidParameterHandler.validateUserId(userId, "unmarkElementAsKnownDuplicate");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "unmarkElementAsKnownDuplicate");
        this.restClient.callVoidPostRESTCall("unmarkElementAsKnownDuplicate", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/known-duplicate/delete", nullRequestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    public List<DuplicateElement> getPeerDuplicates(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPeerDuplicates";
        String guidParameterName = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/peer-duplicates?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getPeerDuplicates");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getPeerDuplicates");
        DuplicatesResponse restResult = this.restClient.callDuplicatesGetRESTCall("getPeerDuplicates", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/peer-duplicates?startFrom={3}&pageSize={4}", this.serverName, userId, elementGUID, startFrom, pageSize);
        return restResult.getElementList();
    }

    public void markAsConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "markAsConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/consolidated-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "markAsConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "markAsConsolidatedDuplicate");
        DuplicatesRequestBody requestBody = new DuplicatesRequestBody();
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        this.restClient.callVoidPostRESTCall("markAsConsolidatedDuplicate", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/consolidated-duplicate", requestBody, new Object[]{this.serverName, userId, consolidatedDuplicateGUID});
    }

    public void linkElementToConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID, String contributingElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkElementToConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String element2GUIDParameter = "contributingElementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/consolidated-duplicate/{2}/contributing-element/{3}";
        this.invalidParameterHandler.validateUserId(userId, "linkElementToConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "linkElementToConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(contributingElementGUID, "contributingElementGUID", "linkElementToConsolidatedDuplicate");
        this.restClient.callVoidPostRESTCall("linkElementToConsolidatedDuplicate", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/consolidated-duplicate/{2}/contributing-element/{3}", nullRequestBody, new Object[]{this.serverName, userId, consolidatedDuplicateGUID, contributingElementGUID});
    }

    public void unlinkElementFromConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID, String contributingElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkElementFromConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String element2GUIDParameter = "contributingElementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/consolidated-duplicate/{2}/contributing-elements/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unlinkElementFromConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "unlinkElementFromConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(contributingElementGUID, "contributingElementGUID", "unlinkElementFromConsolidatedDuplicate");
        this.restClient.callVoidPostRESTCall("unlinkElementFromConsolidatedDuplicate", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/consolidated-duplicate/{2}/contributing-elements/{3}/delete", nullRequestBody, new Object[]{this.serverName, userId, consolidatedDuplicateGUID, contributingElementGUID});
    }

    public List<ElementStub> getContributingDuplicates(String userId, String consolidatedDuplicateGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getContributingDuplicates";
        String guidParameterName = "consolidatedDuplicateGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/consolidated-duplicate/{2}/contributing-elements?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getContributingDuplicates");
        this.invalidParameterHandler.validateGUID(consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "getContributingDuplicates");
        ElementStubsResponse restResult = this.restClient.callElementStubsGetRESTCall("getContributingDuplicates", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/consolidated-duplicate/{2}/contributing-elements?startFrom={3}&pageSize={4}", this.serverName, userId, consolidatedDuplicateGUID, startFrom, pageSize);
        return restResult.getElements();
    }

    public ElementStub getConsolidatedDuplicate(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConsolidatedDuplicate";
        String guidParameterName = "elementGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/consolidated-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "getConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getConsolidatedDuplicate");
        ElementStubResponse restResult = this.restClient.callElementStubGetRESTCall("getConsolidatedDuplicate", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/consolidated-duplicate", this.serverName, userId, elementGUID);
        return restResult.getElement();
    }

    public void removeConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String urlTemplate = "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/consolidated-duplicate/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "removeConsolidatedDuplicate");
        this.restClient.callVoidPostRESTCall("removeConsolidatedDuplicate", this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/consolidated-duplicate/delete", nullRequestBody, new Object[]{this.serverName, userId, consolidatedDuplicateGUID});
    }
}

