/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction.client;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.accessservices.stewardshipaction.api.DuplicateManagementInterface;
import org.odpi.openmetadata.accessservices.stewardshipaction.api.SurveyReportInterface;
import org.odpi.openmetadata.accessservices.stewardshipaction.client.OpenMetadataStoreClient;
import org.odpi.openmetadata.accessservices.stewardshipaction.client.rest.StewardshipActionRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.DuplicatesRequestBody;
import org.odpi.openmetadata.commonservices.ffdc.rest.DuplicatesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ElementStubsResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.NullRequestBody;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.enums.SequencingOrder;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.DuplicateElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.converters.SurveyReportConverter;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SurveyReport;

public class StewardshipAction
implements SurveyReportInterface,
DuplicateManagementInterface {
    private final String serverName;
    private final String serverPlatformURLRoot;
    private AuditLog auditLog;
    private static final NullRequestBody nullRequestBody = new NullRequestBody();
    private final InvalidParameterHandler invalidParameterHandler = new InvalidParameterHandler();
    private final StewardshipActionRESTClient restClient;
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private final SurveyReportConverter<SurveyReport> surveyReportConverter;
    private final OpenMetadataStoreClient openMetadataStoreClient;

    public StewardshipAction(String serverName, String serverPlatformURLRoot, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, maxPageSize);
        this.surveyReportConverter = new SurveyReportConverter(this.propertyHelper, AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceFullName(), serverName);
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot, auditLog);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = null;
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, maxPageSize);
        this.surveyReportConverter = new SurveyReportConverter(this.propertyHelper, AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceFullName(), serverName);
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot, String userId, String password, AuditLog auditLog, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
        this.surveyReportConverter = new SurveyReportConverter(this.propertyHelper, AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceFullName(), serverName);
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot, userId, password, auditLog);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot, String userId, String password, int maxPageSize) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = null;
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, userId, password, maxPageSize);
        this.surveyReportConverter = new SurveyReportConverter(this.propertyHelper, AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceFullName(), serverName);
        this.restClient = new StewardshipActionRESTClient(serverName, serverPlatformURLRoot, userId, password);
    }

    public StewardshipAction(String serverName, String serverPlatformURLRoot, StewardshipActionRESTClient restClient, int maxPageSize, AuditLog auditLog) throws InvalidParameterException {
        String methodName = "Client Constructor";
        this.invalidParameterHandler.setMaxPagingSize(maxPageSize);
        this.invalidParameterHandler.validateOMAGServerPlatformURL(serverPlatformURLRoot, serverName, "Client Constructor");
        this.serverName = serverName;
        this.serverPlatformURLRoot = serverPlatformURLRoot;
        this.auditLog = auditLog;
        this.openMetadataStoreClient = new OpenMetadataStoreClient(serverName, serverPlatformURLRoot, maxPageSize);
        this.surveyReportConverter = new SurveyReportConverter(this.propertyHelper, AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceFullName(), serverName);
        this.restClient = restClient;
    }

    public List<SurveyReport> getSurveyReports(String userId, String assetGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSurveyReports";
        String elementGUIDParameter = "assetGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSurveyReports");
        this.invalidParameterHandler.validateGUID(assetGUID, "assetGUID", "getSurveyReports");
        RelatedMetadataElementList reportElements = this.openMetadataStoreClient.getRelatedMetadataElements(userId, assetGUID, 1, OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), startFrom, pageSize);
        if (reportElements != null && reportElements.getElementList() != null) {
            ArrayList<SurveyReport> surveyReports = new ArrayList<SurveyReport>();
            for (RelatedMetadataElement reportElement : reportElements.getElementList()) {
                if (reportElement == null) continue;
                RelatedMetadataElementList engineActionElements = this.openMetadataStoreClient.getRelatedMetadataElements(userId, reportElement.getElement().getElementGUID(), 2, OpenMetadataType.ENGINE_ACTION_SURVEY_REPORT_RELATIONSHIP.typeName, null, null, null, SequencingOrder.CREATION_DATE_RECENT, false, false, new Date(), 0, 0);
                surveyReports.add(this.surveyReportConverter.getSurveyReport(SurveyReport.class, reportElement.getElement(), engineActionElements, "getSurveyReports"));
            }
            if (!surveyReports.isEmpty()) {
                return surveyReports;
            }
        }
        return null;
    }

    public List<Annotation> getSurveyReportAnnotations(String userId, String reportGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getSurveyReportAnnotations";
        String elementGUIDParameter = "reportGUID";
        this.invalidParameterHandler.validateUserId(userId, "getSurveyReportAnnotations");
        this.invalidParameterHandler.validateGUID(reportGUID, "reportGUID", "getSurveyReportAnnotations");
        AnnotationStore annotationStore = new AnnotationStore(userId, (OpenMetadataClient)this.openMetadataStoreClient, reportGUID, null, null);
        return annotationStore.getNewAnnotations(startFrom, pageSize);
    }

    public List<Annotation> getExtendedAnnotations(String userId, String annotationGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AnnotationStore annotationStore = new AnnotationStore(userId, (OpenMetadataClient)this.openMetadataStoreClient, null, null, null);
        return annotationStore.getExtendedAnnotations(annotationGUID, startFrom, pageSize);
    }

    public void linkElementsAsDuplicates(String userId, String element1GUID, String element2GUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkElementsAsDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/peer-duplicate-of/{3}";
        this.invalidParameterHandler.validateUserId(userId, "linkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element1GUID, "element1GUID", "linkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element2GUID, "element2GUID", "linkElementsAsDuplicates");
        DuplicatesRequestBody requestBody = new DuplicatesRequestBody();
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        this.restClient.callVoidPostRESTCall("linkElementsAsDuplicates", urlTemplate, requestBody, new Object[]{this.serverName, userId, element1GUID, element2GUID});
    }

    public void unlinkElementsAsDuplicates(String userId, String element1GUID, String element2GUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkElementsAsDuplicates";
        String element1GUIDParameter = "element1GUID";
        String element2GUIDParameter = "element2GUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/peer-duplicate-of/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unlinkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element1GUID, "element1GUID", "unlinkElementsAsDuplicates");
        this.invalidParameterHandler.validateGUID(element2GUID, "element2GUID", "unlinkElementsAsDuplicates");
        this.restClient.callVoidPostRESTCall("unlinkElementsAsDuplicates", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, element1GUID, element2GUID});
    }

    public void markElementAsKnownDuplicate(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "markElementAsKnownDuplicate";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/known-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "markElementAsKnownDuplicate");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "markElementAsKnownDuplicate");
        this.restClient.callVoidPostRESTCall("markElementAsKnownDuplicate", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    public void unmarkElementAsKnownDuplicate(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unmarkElementAsKnownDuplicate";
        String elementGUIDParameter = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/known-duplicate/delete";
        this.invalidParameterHandler.validateUserId(userId, "unmarkElementAsKnownDuplicate");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "unmarkElementAsKnownDuplicate");
        this.restClient.callVoidPostRESTCall("unmarkElementAsKnownDuplicate", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, elementGUID});
    }

    public List<DuplicateElement> getPeerDuplicates(String userId, String elementGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getPeerDuplicates";
        String guidParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/peer-duplicates?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getPeerDuplicates");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getPeerDuplicates");
        DuplicatesResponse restResult = this.restClient.callDuplicatesGetRESTCall("getPeerDuplicates", urlTemplate, this.serverName, userId, elementGUID, startFrom, pageSize);
        return restResult.getElements();
    }

    public void markAsConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "markAsConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/consolidated-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "markAsConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "markAsConsolidatedDuplicate");
        DuplicatesRequestBody requestBody = new DuplicatesRequestBody();
        requestBody.setStatusIdentifier(statusIdentifier);
        requestBody.setSteward(steward);
        requestBody.setStewardTypeName(stewardTypeName);
        requestBody.setStewardPropertyName(stewardPropertyName);
        requestBody.setSource(source);
        requestBody.setNotes(notes);
        this.restClient.callVoidPostRESTCall("markAsConsolidatedDuplicate", urlTemplate, requestBody, new Object[]{this.serverName, userId, consolidatedDuplicateGUID});
    }

    public void linkElementToConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID, String contributingElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "linkElementToConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String element2GUIDParameter = "contributingElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/consolidated-duplicate/{2}/contributing-element/{3}";
        this.invalidParameterHandler.validateUserId(userId, "linkElementToConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "linkElementToConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(contributingElementGUID, "contributingElementGUID", "linkElementToConsolidatedDuplicate");
        this.restClient.callVoidPostRESTCall("linkElementToConsolidatedDuplicate", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, consolidatedDuplicateGUID, contributingElementGUID});
    }

    public void unlinkElementFromConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID, String contributingElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "unlinkElementFromConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String element2GUIDParameter = "contributingElementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/consolidated-duplicate/{2}/contributing-elements/{3}/delete";
        this.invalidParameterHandler.validateUserId(userId, "unlinkElementFromConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "unlinkElementFromConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(contributingElementGUID, "contributingElementGUID", "unlinkElementFromConsolidatedDuplicate");
        this.restClient.callVoidPostRESTCall("unlinkElementFromConsolidatedDuplicate", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, consolidatedDuplicateGUID, contributingElementGUID});
    }

    public List<ElementStub> getContributingDuplicates(String userId, String consolidatedDuplicateGUID, int startFrom, int pageSize) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getContributingDuplicates";
        String guidParameterName = "consolidatedDuplicateGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/consolidated-duplicate/{2}/contributing-elements?startFrom={3}&pageSize={4}";
        this.invalidParameterHandler.validateUserId(userId, "getContributingDuplicates");
        this.invalidParameterHandler.validateGUID(consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "getContributingDuplicates");
        ElementStubsResponse restResult = this.restClient.callElementStubsGetRESTCall("getContributingDuplicates", urlTemplate, new Object[]{this.serverName, userId, consolidatedDuplicateGUID, startFrom, pageSize});
        return restResult.getElements();
    }

    public ElementStub getConsolidatedDuplicate(String userId, String elementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getConsolidatedDuplicate";
        String guidParameterName = "elementGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/consolidated-duplicate";
        this.invalidParameterHandler.validateUserId(userId, "getConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(elementGUID, "elementGUID", "getConsolidatedDuplicate");
        ElementStubResponse restResult = this.restClient.callElementStubGetRESTCall("getConsolidatedDuplicate", urlTemplate, new Object[]{this.serverName, userId, elementGUID});
        return restResult.getElement();
    }

    public void removeConsolidatedDuplicate(String userId, String consolidatedDuplicateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "removeConsolidatedDuplicate";
        String element1GUIDParameter = "consolidatedDuplicateGUID";
        String urlTemplate = this.serverPlatformURLRoot + "/servers/{0}/open-metadata/access-services/stewardship-action/users/{1}/elements/{2}/consolidated-duplicate/delete";
        this.invalidParameterHandler.validateUserId(userId, "removeConsolidatedDuplicate");
        this.invalidParameterHandler.validateGUID(consolidatedDuplicateGUID, "consolidatedDuplicateGUID", "removeConsolidatedDuplicate");
        this.restClient.callVoidPostRESTCall("removeConsolidatedDuplicate", urlTemplate, nullRequestBody, new Object[]{this.serverName, userId, consolidatedDuplicateGUID});
    }
}

