/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.accessservices.stewardshipaction.fvt.duplicateprocessing;

import org.odpi.openmetadata.accessservices.assetconsumer.client.AssetConsumer;
import org.odpi.openmetadata.accessservices.assetconsumer.client.rest.AssetConsumerRESTClient;
import org.odpi.openmetadata.accessservices.assetowner.client.AssetOwner;
import org.odpi.openmetadata.accessservices.assetowner.client.rest.AssetOwnerRESTClient;
import org.odpi.openmetadata.accessservices.stewardshipaction.client.StewardshipAction;
import org.odpi.openmetadata.accessservices.stewardshipaction.client.rest.StewardshipActionRESTClient;
import org.odpi.openmetadata.adminservices.configuration.registration.AccessServiceDescription;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.FVTResults;
import org.odpi.openmetadata.fvt.utilities.auditlog.FVTAuditLogDestination;
import org.odpi.openmetadata.fvt.utilities.exceptions.FVTUnexpectedCondition;

public class DuplicateAssetTest {
    private static final String testCaseName = "CreateAssetTest";
    private static final int maxPageSize = 100;
    private static final String assetName = "TestAsset qualifiedName";
    private static final String assetDisplayName = "Asset displayName";
    private static final String assetDescription = "Asset description";
    private static final String assetAdditionalPropertyName = "TestAsset additionalPropertyName";
    private static final String assetAdditionalPropertyValue = "TestAsset additionalPropertyValue";
    private static final String schemaTypeName = "SchemaType qualifiedNAme";
    private static final String schemaTypeDisplayName = "SchemaType displayName";
    private static final String schemaTypeDescription = "SchemaType description";
    private static final String schemaTypeType = "SchemaType type";
    private static final String schemaTypeDefaultValue = "SchemaType defaultValue";

    public static FVTResults performFVT(String serverName, String serverPlatformRootURL, String userId) {
        FVTResults results = new FVTResults(testCaseName);
        results.incrementNumberOfTests();
        try {
            DuplicateAssetTest.runIt(serverPlatformRootURL, serverName, userId, results.getAuditLogDestination());
            results.incrementNumberOfSuccesses();
        }
        catch (Exception error) {
            results.addCapturedError(error);
        }
        return results;
    }

    private static void runIt(String serverPlatformRootURL, String serverName, String userId, FVTAuditLogDestination auditLogDestination) throws FVTUnexpectedCondition {
        DuplicateAssetTest thisTest = new DuplicateAssetTest();
        AuditLog auditLog = new AuditLog((AuditLogDestination)auditLogDestination, AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceCode(), AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceDevelopmentStatus(), AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceName(), AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceDescription(), AccessServiceDescription.STEWARDSHIP_ACTION_OMAS.getAccessServiceWiki());
        StewardshipAction client = thisTest.getStewardshipActionClient(serverName, serverPlatformRootURL, auditLog);
        String assetGUID = thisTest.getAsset(client, userId);
    }

    private StewardshipAction getStewardshipActionClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getStewardshipActionClient";
        try {
            StewardshipActionRESTClient restClient = new StewardshipActionRESTClient(serverName, serverPlatformRootURL);
            return new StewardshipAction(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getStewardshipActionClient", (Throwable)unexpectedError);
        }
    }

    private AssetConsumer getAssetConsumerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getAssetConsumerClient";
        try {
            AssetConsumerRESTClient restClient = new AssetConsumerRESTClient(serverName, serverPlatformRootURL);
            Object likeProperties = null;
            return new AssetConsumer(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAssetConsumerClient", (Throwable)unexpectedError);
        }
    }

    private AssetOwner getAssetOwnerClient(String serverName, String serverPlatformRootURL, AuditLog auditLog) throws FVTUnexpectedCondition {
        String activityName = "getAssetOwnerClient";
        try {
            AssetOwnerRESTClient restClient = new AssetOwnerRESTClient(serverName, serverPlatformRootURL);
            Object assetProperties = null;
            return new AssetOwner(serverName, serverPlatformRootURL, restClient, 100, auditLog);
        }
        catch (Exception unexpectedError) {
            throw new FVTUnexpectedCondition(testCaseName, "getAssetOwnerClient", (Throwable)unexpectedError);
        }
    }

    private String getAsset(StewardshipAction client, String userId) throws FVTUnexpectedCondition {
        String activityName = "getAsset";
        Object assetElement = null;
        return null;
    }
}

